/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r5.model.Location;

public class LocationResourceProvider
extends BaseJpaResourceProvider<Location> {
    public Class<Location> getResourceType() {
        return Location.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="A (part of the) address of the location") @OptionalParam(name="address") StringAndListParam theAddress, @Description(shortDefinition="A city specified in an address") @OptionalParam(name="address-city") StringAndListParam theAddress_city, @Description(shortDefinition="A country specified in an address") @OptionalParam(name="address-country") StringAndListParam theAddress_country, @Description(shortDefinition="A postal code specified in an address") @OptionalParam(name="address-postalcode") StringAndListParam theAddress_postalcode, @Description(shortDefinition="A state specified in an address") @OptionalParam(name="address-state") StringAndListParam theAddress_state, @Description(shortDefinition="A use code specified in an address") @OptionalParam(name="address-use") TokenAndListParam theAddress_use, @Description(shortDefinition="One of the Location's characteristics") @OptionalParam(name="characteristic") TokenAndListParam theCharacteristic, @Description(shortDefinition="Select locations that contain the specified co-ordinates") @OptionalParam(name="contains") SpecialAndListParam theContains, @Description(shortDefinition="Technical endpoints providing access to services operated for the location") @OptionalParam(name="endpoint", targetTypes={}) ReferenceAndListParam theEndpoint, @Description(shortDefinition="An identifier for the location") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="A portion of the location's name or alias") @OptionalParam(name="name") StringAndListParam theName, @Description(shortDefinition="Search for locations where the location.position is near to, or within a specified distance of, the provided coordinates expressed as [latitude]|[longitude]|[distance]|[units] (using the WGS84 datum, see notes).Servers which support the near parameter SHALL support the unit string 'km' for kilometers and SHOULD support '[mi_us]' for miles, support for other units is optional. If the units are omitted, then kms should be assumed. If the distance is omitted, then the server can use its own discretion as to what distances should be considered near (and units are irrelevant).If the server is unable to understand the units (and does support the near search parameter), it MIGHT return an OperationOutcome and fail the search with a http status 400 BadRequest. If the server does not support the near parameter, the parameter MIGHT report the unused parameter in a bundled OperationOutcome and still perform the search ignoring the near parameter.Note: The algorithm to determine the distance is not defined by the specification, and systems might have different engines that calculate things differently. They could consider geographic point to point, or path via road, or including current traffic conditions, or just simple neighboring postcodes/localities if that's all it had access to.") @OptionalParam(name="near") SpecialAndListParam theNear, @Description(shortDefinition="Searches for locations (typically bed/room) that have an operational status (e.g. contaminated, housekeeping)") @OptionalParam(name="operational-status") TokenAndListParam theOperational_status, @Description(shortDefinition="Searches for locations that are managed by the provided organization") @OptionalParam(name="organization", targetTypes={}) ReferenceAndListParam theOrganization, @Description(shortDefinition="A location of which this location is a part") @OptionalParam(name="partof", targetTypes={}) ReferenceAndListParam thePartof, @Description(shortDefinition="Searches for locations with a specific kind of status") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="A code for the type of location") @OptionalParam(name="type") TokenAndListParam theType, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        LocationResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("address", (IQueryParameterAnd)theAddress);
            paramMap.add("address-city", (IQueryParameterAnd)theAddress_city);
            paramMap.add("address-country", (IQueryParameterAnd)theAddress_country);
            paramMap.add("address-postalcode", (IQueryParameterAnd)theAddress_postalcode);
            paramMap.add("address-state", (IQueryParameterAnd)theAddress_state);
            paramMap.add("address-use", (IQueryParameterAnd)theAddress_use);
            paramMap.add("characteristic", (IQueryParameterAnd)theCharacteristic);
            paramMap.add("contains", (IQueryParameterAnd)theContains);
            paramMap.add("endpoint", (IQueryParameterAnd)theEndpoint);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("name", (IQueryParameterAnd)theName);
            paramMap.add("near", (IQueryParameterAnd)theNear);
            paramMap.add("operational-status", (IQueryParameterAnd)theOperational_status);
            paramMap.add("organization", (IQueryParameterAnd)theOrganization);
            paramMap.add("partof", (IQueryParameterAnd)thePartof);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("type", (IQueryParameterAnd)theType);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            LocationResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

