/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r5.model.MedicationKnowledge;

public class MedicationKnowledgeResourceProvider
extends BaseJpaResourceProvider<MedicationKnowledge> {
    public Class<MedicationKnowledge> getResourceType() {
        return MedicationKnowledge.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="Specific category assigned to the medication") @OptionalParam(name="classification") TokenAndListParam theClassification, @Description(shortDefinition="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification)") @OptionalParam(name="classification-type") TokenAndListParam theClassification_type, @Description(shortDefinition="Code that identifies this medication") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="powder | tablets | capsule +") @OptionalParam(name="doseform") TokenAndListParam theDoseform, @Description(shortDefinition="Multiple Resources: * [ActivityDefinition](activitydefinition.html): External identifier for the activity definition* [ActorDefinition](actordefinition.html): External identifier for the Actor Definition* [CapabilityStatement](capabilitystatement.html): External identifier for the capability statement* [ChargeItemDefinition](chargeitemdefinition.html): External identifier for the charge item definition* [Citation](citation.html): External identifier for the citation* [CodeSystem](codesystem.html): External identifier for the code system* [ConceptMap](conceptmap.html): External identifier for the concept map* [ConditionDefinition](conditiondefinition.html): External identifier for the condition definition* [EventDefinition](eventdefinition.html): External identifier for the event definition* [Evidence](evidence.html): External identifier for the evidence* [EvidenceReport](evidencereport.html): External identifier for the evidence report* [EvidenceVariable](evidencevariable.html): External identifier for the evidence variable* [ExampleScenario](examplescenario.html): External identifier for the example scenario* [GraphDefinition](graphdefinition.html): External identifier for the graph definition* [ImplementationGuide](implementationguide.html): External identifier for the implementation guide* [Library](library.html): External identifier for the library* [Measure](measure.html): External identifier for the measure* [MedicationKnowledge](medicationknowledge.html): Business identifier for this medication* [MessageDefinition](messagedefinition.html): External identifier for the message definition* [NamingSystem](namingsystem.html): External identifier for the naming system* [ObservationDefinition](observationdefinition.html): The unique identifier associated with the specimen definition* [OperationDefinition](operationdefinition.html): External identifier for the search parameter* [PlanDefinition](plandefinition.html): External identifier for the plan definition* [Questionnaire](questionnaire.html): External identifier for the questionnaire* [Requirements](requirements.html): External identifier for the requirements* [SearchParameter](searchparameter.html): External identifier for the search parameter* [SpecimenDefinition](specimendefinition.html): The unique identifier associated with the SpecimenDefinition* [StructureDefinition](structuredefinition.html): External identifier for the structure definition* [StructureMap](structuremap.html): External identifier for the structure map* [SubscriptionTopic](subscriptiontopic.html): Business Identifier for SubscriptionTopic* [TerminologyCapabilities](terminologycapabilities.html): External identifier for the terminology capabilities* [TestPlan](testplan.html): An identifier for the test plan* [TestScript](testscript.html): External identifier for the test script* [ValueSet](valueset.html): External identifier for the value set") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Reference to a resource (by instance)") @OptionalParam(name="ingredient", targetTypes={}) ReferenceAndListParam theIngredient, @Description(shortDefinition="Reference to a concept (by class)") @OptionalParam(name="ingredient-code") TokenAndListParam theIngredient_code, @Description(shortDefinition="Name of the reviewing program") @OptionalParam(name="monitoring-program-name") TokenAndListParam theMonitoring_program_name, @Description(shortDefinition="Type of program under which the medication is monitored") @OptionalParam(name="monitoring-program-type") TokenAndListParam theMonitoring_program_type, @Description(shortDefinition="Associated documentation about the medication") @OptionalParam(name="monograph", targetTypes={}) ReferenceAndListParam theMonograph, @Description(shortDefinition="The category of medication document") @OptionalParam(name="monograph-type") TokenAndListParam theMonograph_type, @Description(shortDefinition="The cost of the packaged medication, if the cost is Money") @OptionalParam(name="packaging-cost") QuantityAndListParam thePackaging_cost, @Description(shortDefinition="The cost of the packaged medication, if the cost is a CodeableConcept") @OptionalParam(name="packaging-cost-concept") TokenAndListParam thePackaging_cost_concept, @Description(shortDefinition="Category of the medication or product") @OptionalParam(name="product-type") TokenAndListParam theProduct_type, @Description(shortDefinition="The source or owner for the price information") @OptionalParam(name="source-cost") TokenAndListParam theSource_cost, @Description(shortDefinition="Multiple Resources: * [ActivityDefinition](activitydefinition.html): The current status of the activity definition* [ActorDefinition](actordefinition.html): The current status of the Actor Definition* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition* [Citation](citation.html): The current status of the citation* [CodeSystem](codesystem.html): The current status of the code system* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition* [ConceptMap](conceptmap.html): The current status of the concept map* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition* [EventDefinition](eventdefinition.html): The current status of the event definition* [Evidence](evidence.html): The current status of the evidence* [EvidenceReport](evidencereport.html): The current status of the evidence report* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable* [ExampleScenario](examplescenario.html): The current status of the example scenario* [GraphDefinition](graphdefinition.html): The current status of the graph definition* [ImplementationGuide](implementationguide.html): The current status of the implementation guide* [Library](library.html): The current status of the library* [Measure](measure.html): The current status of the measure* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error* [MessageDefinition](messagedefinition.html): The current status of the message definition* [NamingSystem](namingsystem.html): The current status of the naming system* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown* [OperationDefinition](operationdefinition.html): The current status of the operation definition* [PlanDefinition](plandefinition.html): The current status of the plan definition* [Questionnaire](questionnaire.html): The current status of the questionnaire* [Requirements](requirements.html): The current status of the requirements* [SearchParameter](searchparameter.html): The current status of the search parameter* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown* [StructureDefinition](structuredefinition.html): The current status of the structure definition* [StructureMap](structuremap.html): The current status of the structure map* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities* [TestPlan](testplan.html): The current status of the test plan* [TestScript](testscript.html): The current status of the test script* [ValueSet](valueset.html): The current status of the value set") @OptionalParam(name="status") TokenAndListParam theStatus, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        MedicationKnowledgeResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("classification", (IQueryParameterAnd)theClassification);
            paramMap.add("classification-type", (IQueryParameterAnd)theClassification_type);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("doseform", (IQueryParameterAnd)theDoseform);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("ingredient", (IQueryParameterAnd)theIngredient);
            paramMap.add("ingredient-code", (IQueryParameterAnd)theIngredient_code);
            paramMap.add("monitoring-program-name", (IQueryParameterAnd)theMonitoring_program_name);
            paramMap.add("monitoring-program-type", (IQueryParameterAnd)theMonitoring_program_type);
            paramMap.add("monograph", (IQueryParameterAnd)theMonograph);
            paramMap.add("monograph-type", (IQueryParameterAnd)theMonograph_type);
            paramMap.add("packaging-cost", (IQueryParameterAnd)thePackaging_cost);
            paramMap.add("packaging-cost-concept", (IQueryParameterAnd)thePackaging_cost_concept);
            paramMap.add("product-type", (IQueryParameterAnd)theProduct_type);
            paramMap.add("source-cost", (IQueryParameterAnd)theSource_cost);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            MedicationKnowledgeResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

