/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r5.model.Medication;

public class MedicationResourceProvider
extends BaseJpaResourceProvider<Medication> {
    public Class<Medication> getResourceType() {
        return Medication.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="Multiple Resources: * [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance* [AuditEvent](auditevent.html): More specific code for the event* [Basic](basic.html): Kind of Resource* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code* [Condition](condition.html): Code for the condition* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code* [ImagingSelection](imagingselection.html): The imaging selection status* [List](list.html): What the purpose of this list is* [Medication](medication.html): Returns medications for a specific code* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code* [MedicationStatement](medicationstatement.html): Return statements of this medication code* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake* [Observation](observation.html): The code of the observation type* [Procedure](procedure.html): A code to identify a  procedure* [RequestOrchestration](requestorchestration.html): The code of the request orchestration* [Task](task.html): Search by task code") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="Returns medications in a batch with this expiration date") @OptionalParam(name="expiration-date") DateRangeParam theExpiration_date, @Description(shortDefinition="Returns medications for a specific dose form") @OptionalParam(name="form") TokenAndListParam theForm, @Description(shortDefinition="Multiple Resources: * [Account](account.html): Account number* [AdverseEvent](adverseevent.html): Business identifier for the event* [AllergyIntolerance](allergyintolerance.html): External ids for this item* [Appointment](appointment.html): An Identifier of the Appointment* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response* [Basic](basic.html): Business identifier* [BodyStructure](bodystructure.html): Bodystructure identifier* [CarePlan](careplan.html): External Ids for this plan* [CareTeam](careteam.html): External Ids for this team* [ChargeItem](chargeitem.html): Business Identifier for item* [Claim](claim.html): The primary identifier of the financial resource* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse* [ClinicalImpression](clinicalimpression.html): Business identifier* [Communication](communication.html): Unique identifier* [CommunicationRequest](communicationrequest.html): Unique identifier* [Composition](composition.html): Version-independent identifier for the Composition* [Condition](condition.html): A unique identifier of the condition record* [Consent](consent.html): Identifier for this record (external references)* [Contract](contract.html): The identity of the contract* [Coverage](coverage.html): The primary identifier of the insured and the coverage* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier* [DetectedIssue](detectedissue.html): Unique id for the detected issue* [DeviceRequest](devicerequest.html): Business identifier for request/order* [DeviceUsage](deviceusage.html): Search by identifier* [DiagnosticReport](diagnosticreport.html): An identifier for the report* [DocumentReference](documentreference.html): Identifier of the attachment binary* [Encounter](encounter.html): Identifier(s) by which this encounter is known* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier* [Flag](flag.html): Business identifier* [Goal](goal.html): External Ids for this goal* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID* [Immunization](immunization.html): Business identifier* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier* [Invoice](invoice.html): Business Identifier for item* [List](list.html): Business identifier* [MeasureReport](measurereport.html): External identifier of the measure report to be returned* [Medication](medication.html): Returns medications with this external identifier* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier* [MedicationStatement](medicationstatement.html): Return statements with this external identifier* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence* [NutritionIntake](nutritionintake.html): Return statements with this external identifier* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier* [Observation](observation.html): The unique id for a particular observation* [Person](person.html): A person Identifier* [Procedure](procedure.html): A unique identifier for a procedure* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study* [RiskAssessment](riskassessment.html): Unique identifier for the assessment* [ServiceRequest](servicerequest.html): Identifiers assigned to this order* [Specimen](specimen.html): The unique identifier associated with the specimen* [SupplyDelivery](supplydelivery.html): External identifier* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest* [Task](task.html): Search for a task instance by its business identifier* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Returns medications for this ingredient reference") @OptionalParam(name="ingredient", targetTypes={}) ReferenceAndListParam theIngredient, @Description(shortDefinition="Returns medications for this ingredient code") @OptionalParam(name="ingredient-code") TokenAndListParam theIngredient_code, @Description(shortDefinition="Returns medications in a batch with this lot number") @OptionalParam(name="lot-number") TokenAndListParam theLot_number, @Description(shortDefinition="Returns medications made or sold for this marketing authorization holder") @OptionalParam(name="marketingauthorizationholder", targetTypes={}) ReferenceAndListParam theMarketingauthorizationholder, @Description(shortDefinition="Returns medications in a batch with this lot number") @OptionalParam(name="serial-number") TokenAndListParam theSerial_number, @Description(shortDefinition="Returns medications for this status") @OptionalParam(name="status") TokenAndListParam theStatus, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        MedicationResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("expiration-date", (IQueryParameterAnd)theExpiration_date);
            paramMap.add("form", (IQueryParameterAnd)theForm);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("ingredient", (IQueryParameterAnd)theIngredient);
            paramMap.add("ingredient-code", (IQueryParameterAnd)theIngredient_code);
            paramMap.add("lot-number", (IQueryParameterAnd)theLot_number);
            paramMap.add("marketingauthorizationholder", (IQueryParameterAnd)theMarketingauthorizationholder);
            paramMap.add("serial-number", (IQueryParameterAnd)theSerial_number);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            MedicationResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

