/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r5.model.MedicationStatement;

public class MedicationStatementResourceProvider
extends BaseJpaResourceProvider<MedicationStatement> {
    public Class<MedicationStatement> getResourceType() {
        return MedicationStatement.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="Returns statements based on adherence or compliance") @OptionalParam(name="adherence") TokenAndListParam theAdherence, @Description(shortDefinition="Returns statements of this category of MedicationStatement") @OptionalParam(name="category") TokenAndListParam theCategory, @Description(shortDefinition="Multiple Resources: * [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance* [AuditEvent](auditevent.html): More specific code for the event* [Basic](basic.html): Kind of Resource* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code* [Condition](condition.html): Code for the condition* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code* [ImagingSelection](imagingselection.html): The imaging selection status* [List](list.html): What the purpose of this list is* [Medication](medication.html): Returns medications for a specific code* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code* [MedicationStatement](medicationstatement.html): Return statements of this medication code* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake* [Observation](observation.html): The code of the observation type* [Procedure](procedure.html): A code to identify a  procedure* [RequestOrchestration](requestorchestration.html): The code of the request orchestration* [Task](task.html): Search by task code") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="Date when patient was taking (or not taking) the medication") @OptionalParam(name="effective") DateRangeParam theEffective, @Description(shortDefinition="Multiple Resources: * [AuditEvent](auditevent.html): Encounter related to the activity recorded in the AuditEvent* [CarePlan](careplan.html): The Encounter during which this CarePlan was created* [ChargeItem](chargeitem.html): Encounter associated with event* [Claim](claim.html): Encounters associated with a billed line item* [ClinicalImpression](clinicalimpression.html): The Encounter during which this ClinicalImpression was created* [Communication](communication.html): The Encounter during which this Communication was created* [CommunicationRequest](communicationrequest.html): The Encounter during which this CommunicationRequest was created* [Composition](composition.html): Context of the Composition* [Condition](condition.html): The Encounter during which this Condition was created* [DeviceRequest](devicerequest.html): Encounter during which request was created* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made* [EncounterHistory](encounterhistory.html): The Encounter associated with this set of history values* [ExplanationOfBenefit](explanationofbenefit.html): Encounters associated with a billed line item* [Flag](flag.html): Alert relevant during encounter* [ImagingStudy](imagingstudy.html): The context of the study* [List](list.html): Context in which list created* [MedicationDispense](medicationdispense.html): Returns dispenses with a specific encounter* [MedicationStatement](medicationstatement.html): Returns statements for a specific encounter* [NutritionIntake](nutritionintake.html): Returns statements for a specific encounter* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier* [Observation](observation.html): Encounter related to the observation* [Procedure](procedure.html): The Encounter during which this Procedure was created* [Provenance](provenance.html): Encounter related to the Provenance* [QuestionnaireResponse](questionnaireresponse.html): Encounter associated with the questionnaire response* [RequestOrchestration](requestorchestration.html): The encounter the request orchestration applies to* [RiskAssessment](riskassessment.html): Where was assessment performed?* [ServiceRequest](servicerequest.html): An encounter in which this request is made* [Task](task.html): Search by encounter* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier") @OptionalParam(name="encounter", targetTypes={}) ReferenceAndListParam theEncounter, @Description(shortDefinition="Multiple Resources: * [Account](account.html): Account number* [AdverseEvent](adverseevent.html): Business identifier for the event* [AllergyIntolerance](allergyintolerance.html): External ids for this item* [Appointment](appointment.html): An Identifier of the Appointment* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response* [Basic](basic.html): Business identifier* [BodyStructure](bodystructure.html): Bodystructure identifier* [CarePlan](careplan.html): External Ids for this plan* [CareTeam](careteam.html): External Ids for this team* [ChargeItem](chargeitem.html): Business Identifier for item* [Claim](claim.html): The primary identifier of the financial resource* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse* [ClinicalImpression](clinicalimpression.html): Business identifier* [Communication](communication.html): Unique identifier* [CommunicationRequest](communicationrequest.html): Unique identifier* [Composition](composition.html): Version-independent identifier for the Composition* [Condition](condition.html): A unique identifier of the condition record* [Consent](consent.html): Identifier for this record (external references)* [Contract](contract.html): The identity of the contract* [Coverage](coverage.html): The primary identifier of the insured and the coverage* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier* [DetectedIssue](detectedissue.html): Unique id for the detected issue* [DeviceRequest](devicerequest.html): Business identifier for request/order* [DeviceUsage](deviceusage.html): Search by identifier* [DiagnosticReport](diagnosticreport.html): An identifier for the report* [DocumentReference](documentreference.html): Identifier of the attachment binary* [Encounter](encounter.html): Identifier(s) by which this encounter is known* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier* [Flag](flag.html): Business identifier* [Goal](goal.html): External Ids for this goal* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID* [Immunization](immunization.html): Business identifier* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier* [Invoice](invoice.html): Business Identifier for item* [List](list.html): Business identifier* [MeasureReport](measurereport.html): External identifier of the measure report to be returned* [Medication](medication.html): Returns medications with this external identifier* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier* [MedicationStatement](medicationstatement.html): Return statements with this external identifier* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence* [NutritionIntake](nutritionintake.html): Return statements with this external identifier* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier* [Observation](observation.html): The unique id for a particular observation* [Person](person.html): A person Identifier* [Procedure](procedure.html): A unique identifier for a procedure* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study* [RiskAssessment](riskassessment.html): Unique identifier for the assessment* [ServiceRequest](servicerequest.html): Identifiers assigned to this order* [Specimen](specimen.html): The unique identifier associated with the specimen* [SupplyDelivery](supplydelivery.html): External identifier* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest* [Task](task.html): Search for a task instance by its business identifier* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Multiple Resources: * [MedicationAdministration](medicationadministration.html): Return administrations of this medication reference* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine resource* [MedicationRequest](medicationrequest.html): Return prescriptions for this medication reference* [MedicationStatement](medicationstatement.html): Return statements of this medication reference") @OptionalParam(name="medication", targetTypes={}) ReferenceAndListParam theMedication, @Description(shortDefinition="Multiple Resources: * [Account](account.html): The entity that caused the expenses* [AdverseEvent](adverseevent.html): Subject impacted by event* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for* [Appointment](appointment.html): One of the individuals of the appointment is this patient* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient* [AuditEvent](auditevent.html): Where the activity involved patient data* [Basic](basic.html): Identifies the focus of this resource* [BodyStructure](bodystructure.html): Who this is about* [CarePlan](careplan.html): Who the care plan is for* [CareTeam](careteam.html): Who care team is for* [ChargeItem](chargeitem.html): Individual service was done for/to* [Claim](claim.html): Patient receiving the products or services* [ClaimResponse](claimresponse.html): The subject of care* [ClinicalImpression](clinicalimpression.html): Patient assessed* [Communication](communication.html): Focus of message* [CommunicationRequest](communicationrequest.html): Focus of message* [Composition](composition.html): Who and/or what the composition is about* [Condition](condition.html): Who has the condition?* [Consent](consent.html): Who the consent applies to* [Contract](contract.html): The identity of the subject of the contract (if a patient)* [Coverage](coverage.html): Retrieve coverages for a patient* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient* [DetectedIssue](detectedissue.html): Associated patient* [DeviceRequest](devicerequest.html): Individual the service is ordered for* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient* [DocumentReference](documentreference.html): Who/what is the subject of the document* [Encounter](encounter.html): The patient present at the encounter* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for* [Flag](flag.html): The identity of a subject to list flags for* [Goal](goal.html): Who this goal is intended for* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results* [ImagingSelection](imagingselection.html): Who the study is about* [ImagingStudy](imagingstudy.html): Who the study is about* [Immunization](immunization.html): The patient for the vaccination record* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for* [Invoice](invoice.html): Recipient(s) of goods and services* [List](list.html): If all resources have the same subject* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.* [MolecularSequence](molecularsequence.html): The subject that the sequence is about* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement* [Observation](observation.html): The subject that the observation is about (if patient)* [Person](person.html): The Person links to this Patient* [Procedure](procedure.html): Search by subject - a patient* [Provenance](provenance.html): Where the activity involved patient data* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response* [RelatedPerson](relatedperson.html): The patient this related person is related to* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations* [ResearchSubject](researchsubject.html): Who or what is part of study* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?* [ServiceRequest](servicerequest.html): Search by subject - a patient* [Specimen](specimen.html): The patient the specimen comes from* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined* [Task](task.html): Search by patient* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="Who or where the information in the statement came from") @OptionalParam(name="source", targetTypes={}) ReferenceAndListParam theSource, @Description(shortDefinition="Multiple Resources: * [MedicationAdministration](medicationadministration.html): MedicationAdministration event status (for example one of active/paused/completed/nullified)* [MedicationDispense](medicationdispense.html): Returns dispenses with a specified dispense status* [MedicationRequest](medicationrequest.html): Status of the prescription* [MedicationStatement](medicationstatement.html): Return statements that match the given status") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="The identity of a patient, animal or group to list statements for") @OptionalParam(name="subject", targetTypes={}) ReferenceAndListParam theSubject, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        MedicationStatementResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("adherence", (IQueryParameterAnd)theAdherence);
            paramMap.add("category", (IQueryParameterAnd)theCategory);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("effective", (IQueryParameterAnd)theEffective);
            paramMap.add("encounter", (IQueryParameterAnd)theEncounter);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("medication", (IQueryParameterAnd)theMedication);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("source", (IQueryParameterAnd)theSource);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("subject", (IQueryParameterAnd)theSubject);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            MedicationStatementResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

