/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.NumberAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r5.model.ResearchStudy;

public class ResearchStudyResourceProvider
extends BaseJpaResourceProvider<ResearchStudy> {
    public Class<ResearchStudy> getResourceType() {
        return ResearchStudy.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="Classification for the study") @OptionalParam(name="classifier") TokenAndListParam theClassifier, @Description(shortDefinition="Condition being studied") @OptionalParam(name="condition") TokenAndListParam theCondition, @Description(shortDefinition="When the study began and ended") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="Detailed narrative of the study") @OptionalParam(name="description") StringAndListParam theDescription, @Description(shortDefinition="Inclusion and exclusion criteria") @OptionalParam(name="eligibility", targetTypes={}) ReferenceAndListParam theEligibility, @Description(shortDefinition="Drugs, devices, etc. under study, as a code") @OptionalParam(name="focus-code") TokenAndListParam theFocus_code, @Description(shortDefinition="Drugs, devices, etc. under study, as a reference") @OptionalParam(name="focus-reference", targetTypes={}) ReferenceAndListParam theFocus_reference, @Description(shortDefinition="Business Identifier for study") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Used to search for the study") @OptionalParam(name="keyword") TokenAndListParam theKeyword, @Description(shortDefinition="Name for this study") @OptionalParam(name="name") StringAndListParam theName, @Description(shortDefinition="Free text description of the objective of the study") @OptionalParam(name="objective-description") StringAndListParam theObjective_description, @Description(shortDefinition="The kind of study objective") @OptionalParam(name="objective-type") TokenAndListParam theObjective_type, @Description(shortDefinition="Part of larger study") @OptionalParam(name="part-of", targetTypes={}) ReferenceAndListParam thePart_of, @Description(shortDefinition="The stage in the progression of a study") @OptionalParam(name="phase") TokenAndListParam thePhase, @Description(shortDefinition="Steps followed in executing study") @OptionalParam(name="protocol", targetTypes={}) ReferenceAndListParam theProtocol, @Description(shortDefinition="Actual number of participants enrolled in study across all groups") @OptionalParam(name="recruitment-actual") NumberAndListParam theRecruitment_actual, @Description(shortDefinition="Target number of participants enrolled in study across all groups") @OptionalParam(name="recruitment-target") NumberAndListParam theRecruitment_target, @Description(shortDefinition="Geographic area for the study") @OptionalParam(name="region") TokenAndListParam theRegion, @Description(shortDefinition="Facility where study activities are conducted") @OptionalParam(name="site", targetTypes={}) ReferenceAndListParam theSite, @Description(shortDefinition="active | active-but-not-recruiting | administratively-completed | approved | closed-to-accrual | closed-to-accrual-and-intervention | completed | disapproved | enrolling-by-invitation | in-review | not-yet-recruiting | recruiting | temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | terminated | withdrawn") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="Classifications of the study design characteristics") @OptionalParam(name="study-design") TokenAndListParam theStudy_design, @Description(shortDefinition="The human readable name of the research study") @OptionalParam(name="title") StringAndListParam theTitle, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        ResearchStudyResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("classifier", (IQueryParameterAnd)theClassifier);
            paramMap.add("condition", (IQueryParameterAnd)theCondition);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("description", (IQueryParameterAnd)theDescription);
            paramMap.add("eligibility", (IQueryParameterAnd)theEligibility);
            paramMap.add("focus-code", (IQueryParameterAnd)theFocus_code);
            paramMap.add("focus-reference", (IQueryParameterAnd)theFocus_reference);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("keyword", (IQueryParameterAnd)theKeyword);
            paramMap.add("name", (IQueryParameterAnd)theName);
            paramMap.add("objective-description", (IQueryParameterAnd)theObjective_description);
            paramMap.add("objective-type", (IQueryParameterAnd)theObjective_type);
            paramMap.add("part-of", (IQueryParameterAnd)thePart_of);
            paramMap.add("phase", (IQueryParameterAnd)thePhase);
            paramMap.add("protocol", (IQueryParameterAnd)theProtocol);
            paramMap.add("recruitment-actual", (IQueryParameterAnd)theRecruitment_actual);
            paramMap.add("recruitment-target", (IQueryParameterAnd)theRecruitment_target);
            paramMap.add("region", (IQueryParameterAnd)theRegion);
            paramMap.add("site", (IQueryParameterAnd)theSite);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("study-design", (IQueryParameterAnd)theStudy_design);
            paramMap.add("title", (IQueryParameterAnd)theTitle);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            ResearchStudyResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

