/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.search.SearchCoordinatorSvcImpl;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.method.PageMethodBinding;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionService {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchCoordinatorSvcImpl.class);
    private final FhirContext myContext;

    public ExceptionService(FhirContext theContext) {
        this.myContext = theContext;
    }

    @Nonnull
    public ResourceGoneException newUnknownSearchException(String theUuid) {
        ourLog.trace("Client requested unknown paging ID[{}]", (Object)theUuid);
        String msg = this.myContext.getLocalizer().getMessage(PageMethodBinding.class, "unknownSearchId", new Object[]{theUuid});
        return new ResourceGoneException(msg);
    }
}

