/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchTypeEnum;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProvider;
import ca.uhn.fhir.jpa.search.PersistedJpaSearchFirstPageBundleProvider;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchTask;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.HistorySearchStyleEnum;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class PersistedJpaBundleProviderFactory {
    @Autowired
    private ApplicationContext myApplicationContext;

    public PersistedJpaBundleProvider newInstance(RequestDetails theRequest, String theUuid) {
        Object retVal = this.myApplicationContext.getBean("PersistedJpaBundleProvider", new Object[]{theRequest, theUuid});
        return (PersistedJpaBundleProvider)retVal;
    }

    public PersistedJpaBundleProvider newInstance(RequestDetails theRequest, Search theSearch) {
        Object retVal = this.myApplicationContext.getBean("PersistedJpaBundleProvider_BySearch", new Object[]{theRequest, theSearch});
        return (PersistedJpaBundleProvider)retVal;
    }

    public PersistedJpaSearchFirstPageBundleProvider newInstanceFirstPage(RequestDetails theRequestDetails, Search theSearch, SearchTask theTask, ISearchBuilder theSearchBuilder, RequestPartitionId theRequestPartitionId) {
        return (PersistedJpaSearchFirstPageBundleProvider)this.myApplicationContext.getBean("PersistedJpaSearchFirstPageBundleProvider", new Object[]{theRequestDetails, theSearch, theTask, theSearchBuilder, theRequestPartitionId});
    }

    public IBundleProvider history(RequestDetails theRequest, String theResourceType, Long theResourcePid, Date theRangeStartInclusive, Date theRangeEndInclusive, Integer theOffset, RequestPartitionId theRequestPartitionId) {
        return this.history(theRequest, theResourceType, theResourcePid, theRangeStartInclusive, theRangeEndInclusive, theOffset, null, theRequestPartitionId);
    }

    public IBundleProvider history(RequestDetails theRequest, String theResourceType, Long theResourcePid, Date theRangeStartInclusive, Date theRangeEndInclusive, Integer theOffset, HistorySearchStyleEnum searchParameterType, RequestPartitionId theRequestPartitionId) {
        String resourceName = (String)StringUtils.defaultIfBlank((CharSequence)theResourceType, null);
        Search search = new Search();
        search.setOffset(theOffset);
        search.setDeleted(false);
        search.setCreated(new Date());
        search.setLastUpdated(theRangeStartInclusive, theRangeEndInclusive);
        search.setUuid(UUID.randomUUID().toString());
        search.setResourceType(resourceName);
        search.setResourceId(theResourcePid);
        search.setSearchType(SearchTypeEnum.HISTORY);
        search.setStatus(SearchStatusEnum.FINISHED);
        search.setHistorySearchStyle(searchParameterType);
        PersistedJpaBundleProvider provider = this.newInstance(theRequest, search);
        provider.setRequestPartitionId(theRequestPartitionId);
        return provider;
    }
}

