/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.ISearchCoordinatorSvc;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.search.ResourceNotFoundInIndexException;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.search.ExceptionService;
import ca.uhn.fhir.jpa.search.ISynchronousSearchSvc;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProvider;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProviderFactory;
import ca.uhn.fhir.jpa.search.PersistedJpaSearchFirstPageBundleProvider;
import ca.uhn.fhir.jpa.search.SearchStrategyFactory;
import ca.uhn.fhir.jpa.search.builder.StorageInterceptorHooksFacade;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchContinuationTask;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchTask;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchTaskParameters;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import ca.uhn.fhir.jpa.search.cache.ISearchResultCacheSvc;
import ca.uhn.fhir.jpa.search.cache.SearchCacheStatusEnum;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.AsyncUtil;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component(value="mySearchCoordinatorSvc")
public class SearchCoordinatorSvcImpl
implements ISearchCoordinatorSvc<JpaPid> {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchCoordinatorSvcImpl.class);
    private final FhirContext myContext;
    private final JpaStorageSettings myStorageSettings;
    private final IInterceptorBroadcaster myInterceptorBroadcaster;
    private final HapiTransactionService myTxService;
    private final ISearchCacheSvc mySearchCacheSvc;
    private final ISearchResultCacheSvc mySearchResultCacheSvc;
    private final DaoRegistry myDaoRegistry;
    private final SearchBuilderFactory<JpaPid> mySearchBuilderFactory;
    private final ISynchronousSearchSvc mySynchronousSearchSvc;
    private final PersistedJpaBundleProviderFactory myPersistedJpaBundleProviderFactory;
    private final ISearchParamRegistry mySearchParamRegistry;
    private final SearchStrategyFactory mySearchStrategyFactory;
    private final ExceptionService myExceptionSvc;
    private final BeanFactory myBeanFactory;
    private final ConcurrentHashMap<String, SearchTask> myIdToSearchTask = new ConcurrentHashMap();
    private final Consumer<String> myOnRemoveSearchTask = this.myIdToSearchTask::remove;
    private final StorageInterceptorHooksFacade myStorageInterceptorHooks;
    private Integer myLoadingThrottleForUnitTests = null;
    private long myMaxMillisToWaitForRemoteResults = 60000L;
    private boolean myNeverUseLocalSearchForUnitTests;
    private int mySyncSize = 250;

    public SearchCoordinatorSvcImpl(FhirContext theContext, JpaStorageSettings theStorageSettings, IInterceptorBroadcaster theInterceptorBroadcaster, HapiTransactionService theTxService, ISearchCacheSvc theSearchCacheSvc, ISearchResultCacheSvc theSearchResultCacheSvc, DaoRegistry theDaoRegistry, SearchBuilderFactory<JpaPid> theSearchBuilderFactory, ISynchronousSearchSvc theSynchronousSearchSvc, PersistedJpaBundleProviderFactory thePersistedJpaBundleProviderFactory, ISearchParamRegistry theSearchParamRegistry, SearchStrategyFactory theSearchStrategyFactory, ExceptionService theExceptionSvc, BeanFactory theBeanFactory) {
        this.myContext = theContext;
        this.myStorageSettings = theStorageSettings;
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
        this.myTxService = theTxService;
        this.mySearchCacheSvc = theSearchCacheSvc;
        this.mySearchResultCacheSvc = theSearchResultCacheSvc;
        this.myDaoRegistry = theDaoRegistry;
        this.mySearchBuilderFactory = theSearchBuilderFactory;
        this.mySynchronousSearchSvc = theSynchronousSearchSvc;
        this.myPersistedJpaBundleProviderFactory = thePersistedJpaBundleProviderFactory;
        this.mySearchParamRegistry = theSearchParamRegistry;
        this.mySearchStrategyFactory = theSearchStrategyFactory;
        this.myExceptionSvc = theExceptionSvc;
        this.myBeanFactory = theBeanFactory;
        this.myStorageInterceptorHooks = new StorageInterceptorHooksFacade(this.myInterceptorBroadcaster);
    }

    @VisibleForTesting
    Set<String> getActiveSearchIds() {
        return this.myIdToSearchTask.keySet();
    }

    @VisibleForTesting
    public void setLoadingThrottleForUnitTests(Integer theLoadingThrottleForUnitTests) {
        this.myLoadingThrottleForUnitTests = theLoadingThrottleForUnitTests;
    }

    @VisibleForTesting
    public void setNeverUseLocalSearchForUnitTests(boolean theNeverUseLocalSearchForUnitTests) {
        this.myNeverUseLocalSearchForUnitTests = theNeverUseLocalSearchForUnitTests;
    }

    @VisibleForTesting
    public void setSyncSizeForUnitTests(int theSyncSize) {
        this.mySyncSize = theSyncSize;
    }

    public void cancelAllActiveSearches() {
        for (SearchTask next : this.myIdToSearchTask.values()) {
            ourLog.info("Requesting immediate abort of search: {}", (Object)next.getSearch().getUuid());
            next.requestImmediateAbort();
            AsyncUtil.awaitLatchAndIgnoreInterrupt((CountDownLatch)next.getCompletionLatch(), (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @VisibleForTesting
    void setMaxMillisToWaitForRemoteResultsForUnitTest(long theMaxMillisToWaitForRemoteResults) {
        this.myMaxMillisToWaitForRemoteResults = theMaxMillisToWaitForRemoteResults;
    }

    public List<JpaPid> getResources(String theUuid, int theFrom, int theTo, @Nullable RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        Search search;
        assert (!TransactionSynchronizationManager.isActualTransactionActive());
        SearchTask searchTask = this.myIdToSearchTask.get(theUuid);
        if (searchTask != null) {
            searchTask.awaitInitialSync();
        }
        ourLog.trace("About to start looking for resources {}-{}", (Object)theFrom, (Object)theTo);
        StopWatch sw = new StopWatch();
        while (true) {
            if (!this.myNeverUseLocalSearchForUnitTests && searchTask != null) {
                ourLog.trace("Local search found");
                List<JpaPid> resourcePids = searchTask.getResourcePids(theFrom, theTo);
                ourLog.trace("Local search returned {} pids, wanted {}-{} - Search: {}", new Object[]{resourcePids.size(), theFrom, theTo, searchTask.getSearch()});
                if (searchTask.getSearch().getNumFound() - searchTask.getSearch().getNumBlocked() >= theTo || resourcePids.size() == theTo - theFrom) {
                    return resourcePids;
                }
            }
            Callable<Search> searchCallback = () -> this.mySearchCacheSvc.fetchByUuid(theUuid, theRequestPartitionId).orElseThrow(() -> this.myExceptionSvc.newUnknownSearchException(theUuid));
            search = (Search)this.myTxService.withRequest(theRequestDetails).withRequestPartitionId(theRequestPartitionId).execute(searchCallback);
            QueryParameterUtils.verifySearchHasntFailedOrThrowInternalErrorException(search);
            if (search.getStatus() == SearchStatusEnum.FINISHED) {
                ourLog.trace("Search entity marked as finished with {} results", (Object)search.getNumFound());
                break;
            }
            if (search.getNumFound() - search.getNumBlocked() >= theTo) {
                ourLog.trace("Search entity has {} results so far", (Object)search.getNumFound());
                break;
            }
            if (sw.getMillis() > this.myMaxMillisToWaitForRemoteResults) {
                ourLog.error("Search {} of type {} for {}{} timed out after {}ms", new Object[]{search.getId(), search.getSearchType(), search.getResourceType(), search.getSearchQueryString(), sw.getMillis()});
                throw new InternalErrorException(Msg.code((int)1163) + "Request timed out after " + sw.getMillis() + "ms");
            }
            if (search.getStatus() == SearchStatusEnum.PASSCMPLET) {
                ourLog.trace("Going to try to start next search");
                Optional<Search> newSearch = this.mySearchCacheSvc.tryToMarkSearchAsInProgress(search, theRequestPartitionId);
                if (newSearch.isPresent()) {
                    ourLog.trace("Launching new search");
                    search = newSearch.get();
                    String resourceType = search.getResourceType();
                    SearchParameterMap params = search.getSearchParameterMap().orElseThrow(() -> new IllegalStateException("No map in PASSCOMPLET search"));
                    IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(resourceType);
                    SearchTaskParameters parameters = new SearchTaskParameters(search, (IDao)resourceDao, params, resourceType, theRequestDetails, theRequestPartitionId, this.myOnRemoveSearchTask, this.mySyncSize);
                    parameters.setLoadingThrottleForUnitTests(this.myLoadingThrottleForUnitTests);
                    SearchContinuationTask task = (SearchContinuationTask)this.myBeanFactory.getBean("continueTask", new Object[]{parameters});
                    this.myIdToSearchTask.put(search.getUuid(), task);
                    task.call();
                }
            }
            if (search.getStatus().isDone()) continue;
            AsyncUtil.sleep((long)500L);
        }
        ourLog.trace("Finished looping");
        List<JpaPid> pids = this.fetchResultPids(theUuid, theFrom, theTo, theRequestDetails, search, theRequestPartitionId);
        ourLog.trace("Fetched {} results", (Object)pids.size());
        return pids;
    }

    @Nonnull
    private List<JpaPid> fetchResultPids(String theUuid, int theFrom, int theTo, @Nullable RequestDetails theRequestDetails, Search theSearch, RequestPartitionId theRequestPartitionId) {
        List<JpaPid> pids = this.mySearchResultCacheSvc.fetchResultPids(theSearch, theFrom, theTo, theRequestDetails, theRequestPartitionId);
        if (pids == null) {
            throw this.myExceptionSvc.newUnknownSearchException(theUuid);
        }
        return pids;
    }

    public IBundleProvider registerSearch(IFhirResourceDao<?> theCallingDao, SearchParameterMap theParams, String theResourceType, CacheControlDirective theCacheControlDirective, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        PersistedJpaBundleProvider foundSearchProvider;
        String searchUuid = UUID.randomUUID().toString();
        String queryString = theParams.toNormalizedQueryString(this.myContext);
        ourLog.debug("Registering new search {}", (Object)searchUuid);
        Search search = new Search();
        QueryParameterUtils.populateSearchEntity(theParams, theResourceType, searchUuid, queryString, search, theRequestPartitionId);
        this.myStorageInterceptorHooks.callStoragePresearchRegistered(theRequestDetails, theParams, search, theRequestPartitionId);
        this.validateSearch(theParams);
        Class resourceTypeClass = this.myContext.getResourceDefinition(theResourceType).getImplementingClass();
        ISearchBuilder sb = this.mySearchBuilderFactory.newSearchBuilder(theCallingDao, theResourceType, resourceTypeClass);
        sb.setFetchSize(this.mySyncSize);
        Integer loadSynchronousUpTo = this.getLoadSynchronousUpToOrNull(theCacheControlDirective);
        boolean isOffsetQuery = theParams.isOffsetQuery();
        if (theParams.isLoadSynchronous() || loadSynchronousUpTo != null || isOffsetQuery) {
            if (this.mySearchStrategyFactory.isSupportsHSearchDirect(theResourceType, theParams, theRequestDetails)) {
                ourLog.info("Search {} is using direct load strategy", (Object)searchUuid);
                SearchStrategyFactory.ISearchStrategy direct = this.mySearchStrategyFactory.makeDirectStrategy(searchUuid, theResourceType, theParams, theRequestDetails);
                try {
                    return (IBundleProvider)direct.get();
                }
                catch (ResourceNotFoundInIndexException theE) {
                    ourLog.warn("Some resources were not found in index. Make sure all resources were indexed. Resorting to database search.");
                }
            }
            ourLog.debug("Search {} is loading in synchronous mode", (Object)searchUuid);
            return this.mySynchronousSearchSvc.executeQuery(theParams, theRequestDetails, searchUuid, sb, loadSynchronousUpTo, theRequestPartitionId);
        }
        SearchCacheStatusEnum cacheStatus = SearchCacheStatusEnum.MISS;
        if (theCacheControlDirective != null && theCacheControlDirective.isNoCache()) {
            cacheStatus = SearchCacheStatusEnum.NOT_TRIED;
        }
        if (cacheStatus != SearchCacheStatusEnum.NOT_TRIED && theParams.getEverythingMode() == null && this.myStorageSettings.getReuseCachedSearchResultsForMillis() != null && (foundSearchProvider = this.findCachedQuery(theParams, theResourceType, theRequestDetails, queryString, theRequestPartitionId)) != null) {
            foundSearchProvider.setCacheStatus(SearchCacheStatusEnum.HIT);
            return foundSearchProvider;
        }
        PersistedJpaSearchFirstPageBundleProvider retVal = this.submitSearch((IDao)theCallingDao, theParams, theResourceType, theRequestDetails, (ISearchBuilder<JpaPid>)sb, theRequestPartitionId, search);
        retVal.setCacheStatus(cacheStatus);
        return retVal;
    }

    private void validateSearch(SearchParameterMap theParams) {
        this.validateIncludes(theParams.getIncludes(), "_include");
        this.validateIncludes(theParams.getRevIncludes(), "_revinclude");
    }

    private void validateIncludes(Set<Include> includes, String name) {
        for (Include next : includes) {
            String value = next.getValue();
            if (value.equals("*") || StringUtils.isBlank((CharSequence)value)) continue;
            String paramType = next.getParamType();
            String paramName = next.getParamName();
            String paramTargetType = next.getParamTargetType();
            if (StringUtils.isBlank((CharSequence)paramType) || StringUtils.isBlank((CharSequence)paramName)) {
                String msg = this.myContext.getLocalizer().getMessageSanitized(SearchCoordinatorSvcImpl.class, "invalidInclude", new Object[]{name, value, ""});
                throw new InvalidRequestException(Msg.code((int)2018) + msg);
            }
            if (!this.myDaoRegistry.isResourceTypeSupported(paramType)) {
                String resourceTypeMsg = this.myContext.getLocalizer().getMessageSanitized(SearchCoordinatorSvcImpl.class, "invalidResourceType", new Object[]{paramType});
                String msg = this.myContext.getLocalizer().getMessage(SearchCoordinatorSvcImpl.class, "invalidInclude", new Object[]{UrlUtil.sanitizeUrlPart((CharSequence)name), UrlUtil.sanitizeUrlPart((CharSequence)value), resourceTypeMsg});
                throw new InvalidRequestException(Msg.code((int)2017) + msg);
            }
            if (StringUtils.isNotBlank((CharSequence)paramTargetType) && !this.myDaoRegistry.isResourceTypeSupported(paramTargetType)) {
                String resourceTypeMsg = this.myContext.getLocalizer().getMessageSanitized(SearchCoordinatorSvcImpl.class, "invalidResourceType", new Object[]{paramTargetType});
                String msg = this.myContext.getLocalizer().getMessage(SearchCoordinatorSvcImpl.class, "invalidInclude", new Object[]{UrlUtil.sanitizeUrlPart((CharSequence)name), UrlUtil.sanitizeUrlPart((CharSequence)value), resourceTypeMsg});
                throw new InvalidRequestException(Msg.code((int)2016) + msg);
            }
            if ("*".equals(paramName) || this.mySearchParamRegistry.getActiveSearchParam(paramType, paramName) != null) continue;
            List validNames = this.mySearchParamRegistry.getActiveSearchParams(paramType).values().stream().filter(t -> t.getParamType() == RestSearchParameterTypeEnum.REFERENCE).map(t -> UrlUtil.sanitizeUrlPart((CharSequence)t.getName())).sorted().collect(Collectors.toList());
            String searchParamMessage = this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "invalidSearchParameter", new Object[]{UrlUtil.sanitizeUrlPart((CharSequence)paramName), UrlUtil.sanitizeUrlPart((CharSequence)paramType), validNames});
            String msg = this.myContext.getLocalizer().getMessage(SearchCoordinatorSvcImpl.class, "invalidInclude", new Object[]{UrlUtil.sanitizeUrlPart((CharSequence)name), UrlUtil.sanitizeUrlPart((CharSequence)value), searchParamMessage});
            throw new InvalidRequestException(Msg.code((int)2015) + msg);
        }
    }

    public Optional<Integer> getSearchTotal(String theUuid, @Nullable RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        Optional<SearchParameterMap> searchParameterMap;
        SearchTask task = this.myIdToSearchTask.get(theUuid);
        if (task != null) {
            return Optional.ofNullable(task.awaitInitialSync());
        }
        Optional<Search> search = (Optional<Search>)this.myTxService.withRequest(theRequestDetails).execute(() -> this.mySearchCacheSvc.fetchByUuid(theUuid, theRequestPartitionId));
        if (search.isPresent() && (searchParameterMap = ((Search)search.get()).getSearchParameterMap()).isPresent() && searchParameterMap.get().getSearchTotalMode() == SearchTotalModeEnum.ACCURATE) {
            for (int i = 0; i < 10; ++i) {
                if (search.isPresent()) {
                    QueryParameterUtils.verifySearchHasntFailedOrThrowInternalErrorException((Search)search.get());
                    if (((Search)search.get()).getTotalCount() != null) {
                        return Optional.of(search.get().getTotalCount());
                    }
                }
                search = this.mySearchCacheSvc.fetchByUuid(theUuid, theRequestPartitionId);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    private PersistedJpaSearchFirstPageBundleProvider submitSearch(IDao theCallingDao, SearchParameterMap theParams, String theResourceType, RequestDetails theRequestDetails, ISearchBuilder<JpaPid> theSb, RequestPartitionId theRequestPartitionId, Search theSearch) {
        StopWatch w = new StopWatch();
        SearchTaskParameters stp = new SearchTaskParameters(theSearch, theCallingDao, theParams, theResourceType, theRequestDetails, theRequestPartitionId, this.myOnRemoveSearchTask, this.mySyncSize);
        stp.setLoadingThrottleForUnitTests(this.myLoadingThrottleForUnitTests);
        SearchTask task = (SearchTask)this.myBeanFactory.getBean("searchTask", new Object[]{stp});
        this.myIdToSearchTask.put(theSearch.getUuid(), task);
        task.call();
        PersistedJpaSearchFirstPageBundleProvider retVal = this.myPersistedJpaBundleProviderFactory.newInstanceFirstPage(theRequestDetails, theSearch, task, theSb, theRequestPartitionId);
        ourLog.debug("Search initial phase completed in {}ms", (Object)w.getMillis());
        return retVal;
    }

    @Nullable
    private PersistedJpaBundleProvider findCachedQuery(SearchParameterMap theParams, String theResourceType, RequestDetails theRequestDetails, String theQueryString, RequestPartitionId theRequestPartitionId) {
        return (PersistedJpaBundleProvider)this.myTxService.withRequest(theRequestDetails).withRequestPartitionId(theRequestPartitionId).execute(() -> {
            HookParams params = new HookParams().add(SearchParameterMap.class, (Object)theParams).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
            Object outcome = CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_PRECHECK_FOR_CACHED_SEARCH, (HookParams)params);
            if (Boolean.FALSE.equals(outcome)) {
                return null;
            }
            Search searchToUse = this.findSearchToUseOrNull(theQueryString, theResourceType, theRequestPartitionId);
            if (searchToUse == null) {
                return null;
            }
            ourLog.debug("Reusing search {} from cache", (Object)searchToUse.getUuid());
            params = new HookParams().add(SearchParameterMap.class, (Object)theParams).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_REUSING_CACHED, (HookParams)params);
            return this.myPersistedJpaBundleProviderFactory.newInstance(theRequestDetails, searchToUse.getUuid());
        });
    }

    @Nullable
    private Search findSearchToUseOrNull(String theQueryString, String theResourceType, RequestPartitionId theRequestPartitionId) {
        Instant createdCutoff = Instant.now().minus(this.myStorageSettings.getReuseCachedSearchResultsForMillis(), ChronoUnit.MILLIS);
        Optional<Search> candidate = this.mySearchCacheSvc.findCandidatesForReuse(theResourceType, theQueryString, createdCutoff, theRequestPartitionId);
        return candidate.orElse(null);
    }

    @Nullable
    private Integer getLoadSynchronousUpToOrNull(CacheControlDirective theCacheControlDirective) {
        Integer loadSynchronousUpTo;
        if (theCacheControlDirective != null && theCacheControlDirective.isNoStore()) {
            if (theCacheControlDirective.getMaxResults() != null) {
                loadSynchronousUpTo = theCacheControlDirective.getMaxResults();
                if (loadSynchronousUpTo > this.myStorageSettings.getCacheControlNoStoreMaxResultsUpperLimit()) {
                    throw new InvalidRequestException(Msg.code((int)1165) + "Cache-Control header max-results value must not exceed " + this.myStorageSettings.getCacheControlNoStoreMaxResultsUpperLimit());
                }
            } else {
                loadSynchronousUpTo = 100;
            }
        } else {
            loadSynchronousUpTo = null;
        }
        return loadSynchronousUpTo;
    }

    @Nullable
    public static Pageable toPage(final int theFromIndex, int theToIndex) {
        int pageSize = theToIndex - theFromIndex;
        if (pageSize < 1) {
            return null;
        }
        int pageIndex = theFromIndex / pageSize;
        return new PageRequest(pageIndex, pageSize, Sort.unsorted()){
            private static final long serialVersionUID = 1L;

            public long getOffset() {
                return theFromIndex;
            }
        };
    }
}

