/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.SimpleBundleProvider;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SearchStrategyFactory {
    private final JpaStorageSettings myStorageSettings;
    @Nullable
    private final IFulltextSearchSvc myFulltextSearchSvc;

    public SearchStrategyFactory(JpaStorageSettings theStorageSettings, @Nullable IFulltextSearchSvc theFulltextSearchSvc) {
        this.myStorageSettings = theStorageSettings;
        this.myFulltextSearchSvc = theFulltextSearchSvc;
    }

    public boolean isSupportsHSearchDirect(String theResourceType, SearchParameterMap theParams, RequestDetails theRequestDetails) {
        return this.myFulltextSearchSvc != null && this.myStorageSettings.isStoreResourceInHSearchIndex() && this.myStorageSettings.isAdvancedHSearchIndexing() && this.myFulltextSearchSvc.supportsAllOf(theParams) && theParams.getSummaryMode() == null && theParams.getSearchTotalMode() == null;
    }

    public ISearchStrategy makeDirectStrategy(String theSearchUUID, String theResourceType, SearchParameterMap theParams, RequestDetails theRequestDetails) {
        return () -> {
            if (this.myFulltextSearchSvc == null) {
                return new SimpleBundleProvider(Collections.emptyList(), theSearchUUID);
            }
            List<IBaseResource> resources = this.myFulltextSearchSvc.searchForResources(theResourceType, theParams, theRequestDetails);
            SimpleBundleProvider result = new SimpleBundleProvider(resources, theSearchUUID);
            result.setSize(Integer.valueOf(resources.size()));
            return result;
        };
    }

    public static interface ISearchStrategy
    extends Supplier<IBundleProvider> {
    }
}

