/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.search.IStaleSearchDeletingSvc;
import ca.uhn.fhir.jpa.search.cache.DatabaseSearchCacheSvcImpl;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class StaleSearchDeletingSvcImpl
implements IStaleSearchDeletingSvc,
IHasScheduledJobs {
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private ISearchCacheSvc mySearchCacheSvc;

    @Override
    @Transactional(propagation=Propagation.NEVER)
    public void pollForStaleSearchesAndDeleteThem() {
        this.mySearchCacheSvc.pollForStaleSearchesAndDeleteThem(RequestPartitionId.allPartitions(), this.getDeadline());
    }

    protected Instant getDeadline() {
        return Instant.ofEpochMilli(DatabaseSearchCacheSvcImpl.now()).plus(54000L, ChronoUnit.MILLIS);
    }

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(this.getClass().getName());
        jobDetail.setJobClass(Job.class);
        theSchedulerService.scheduleClusteredJob(60000L, jobDetail);
    }

    @Override
    @Transactional(propagation=Propagation.NEVER)
    public synchronized void schedulePollForStaleSearches() {
        if (!this.myStorageSettings.isSchedulingDisabled() && this.myStorageSettings.isEnableTaskStaleSearchCleanup()) {
            this.pollForStaleSearchesAndDeleteThem();
        }
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private IStaleSearchDeletingSvc myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.schedulePollForStaleSearches();
        }
    }
}

