/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.interceptor.JpaPreResourceAccessDetails;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.search.ISynchronousSearchSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.SearchParameterMapCalculator;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.SimpleBundleProvider;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.ServerInterceptorUtil;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.ICallable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SynchronousSearchSvcImpl
implements ISynchronousSearchSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(SynchronousSearchSvcImpl.class);
    private FhirContext myContext;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private SearchBuilderFactory mySearchBuilderFactory;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private HapiTransactionService myTxService;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private EntityManager myEntityManager;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    private int mySyncSize = 250;

    @Override
    public IBundleProvider executeQuery(SearchParameterMap theParams, RequestDetails theRequestDetails, String theSearchUuid, ISearchBuilder theSb, Integer theLoadSynchronousUpTo, RequestPartitionId theRequestPartitionId) {
        SearchRuntimeDetails searchRuntimeDetails = new SearchRuntimeDetails(theRequestDetails, theSearchUuid);
        searchRuntimeDetails.setLoadSynchronous(true);
        boolean theParamWantOnlyCount = SearchParameterMapCalculator.isWantOnlyCount(theParams);
        boolean theParamOrConfigWantCount = Objects.nonNull(theParams.getSearchTotalMode()) ? SearchParameterMapCalculator.isWantCount(theParams) : SearchParameterMapCalculator.isWantCount(this.myStorageSettings.getDefaultTotalMode());
        boolean wantCount = theParamWantOnlyCount || theParamOrConfigWantCount;
        return (IBundleProvider)this.myTxService.withRequest(theRequestDetails).withRequestPartitionId(theRequestPartitionId).readOnly().execute(() -> {
            ArrayList<JpaPid> pids = new ArrayList<JpaPid>();
            Long count = 0L;
            if (wantCount) {
                ourLog.trace("Performing count");
                List contentAndTerms = theParams.get("_content");
                List textAndTerms = theParams.get("_text");
                count = theSb.createCountQuery(theParams, theSearchUuid, theRequestDetails, theRequestPartitionId);
                if (contentAndTerms != null) {
                    theParams.put("_content", contentAndTerms);
                }
                if (textAndTerms != null) {
                    theParams.put("_text", textAndTerms);
                }
                ourLog.trace("Got count {}", (Object)count);
            }
            if (theParamWantOnlyCount) {
                SimpleBundleProvider bundleProvider = new SimpleBundleProvider();
                bundleProvider.setSize(Integer.valueOf(count.intValue()));
                return bundleProvider;
            }
            try (IResultIterator resultIter = theSb.createQuery(theParams, searchRuntimeDetails, theRequestDetails, theRequestPartitionId);){
                while (resultIter.hasNext()) {
                    pids.add((JpaPid)resultIter.next());
                    if (theLoadSynchronousUpTo != null && pids.size() >= theLoadSynchronousUpTo) {
                    } else if (theParams.getLoadSynchronousUpTo() == null || pids.size() < theParams.getLoadSynchronousUpTo()) continue;
                    break;
                }
            }
            catch (IOException e) {
                ourLog.error("IO failure during database access", (Throwable)e);
                throw new InternalErrorException(Msg.code((int)1164) + e);
            }
            JpaPreResourceAccessDetails accessDetails = new JpaPreResourceAccessDetails(pids, (ICallable<ISearchBuilder>)((ICallable)() -> theSb));
            HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
            for (int i = pids.size() - 1; i >= 0; --i) {
                if (!accessDetails.isDontReturnResourceAtIndex(i)) continue;
                pids.remove(i);
            }
            Integer maxIncludes = this.myStorageSettings.getMaximumIncludesToLoadPerPage();
            Set includedPids = theSb.loadIncludes(this.myContext, this.myEntityManager, pids, (Collection)theParams.getRevIncludes(), true, theParams.getLastUpdated(), "(synchronous)", theRequestDetails, maxIncludes);
            if (maxIncludes != null) {
                maxIncludes = maxIncludes - includedPids.size();
            }
            pids.addAll(includedPids);
            ArrayList includedPidsList = new ArrayList(includedPids);
            if (theParams.getEverythingMode() == null && (maxIncludes == null || maxIncludes > 0)) {
                Set revIncludedPids = theSb.loadIncludes(this.myContext, this.myEntityManager, pids, (Collection)theParams.getIncludes(), false, theParams.getLastUpdated(), "(synchronous)", theRequestDetails, maxIncludes);
                includedPids.addAll(revIncludedPids);
                pids.addAll(revIncludedPids);
                includedPidsList.addAll(revIncludedPids);
            }
            List resources = new ArrayList();
            theSb.loadResourcesByPid(pids, includedPidsList, resources, false, theRequestDetails);
            resources = ServerInterceptorUtil.fireStoragePreshowResource(resources, (RequestDetails)theRequestDetails, (IInterceptorBroadcaster)this.myInterceptorBroadcaster);
            SimpleBundleProvider bundleProvider = new SimpleBundleProvider(resources);
            if (theParams.isOffsetQuery()) {
                bundleProvider.setCurrentPageOffset(theParams.getOffset());
                bundleProvider.setCurrentPageSize(theParams.getCount());
            }
            if (wantCount) {
                bundleProvider.setSize(Integer.valueOf(count.intValue()));
            } else {
                Integer queryCount = this.getQueryCount(theLoadSynchronousUpTo, theParams);
                if (queryCount == null || queryCount > resources.size()) {
                    bundleProvider.setSize(Integer.valueOf(this.getTotalCount(queryCount, theParams.getOffset(), resources.size())));
                } else {
                    bundleProvider.setSize(null);
                }
            }
            bundleProvider.setPreferredPageSize(theParams.getCount());
            return bundleProvider;
        });
    }

    public IBundleProvider executeQuery(String theResourceType, SearchParameterMap theSearchParameterMap, RequestPartitionId theRequestPartitionId) {
        String searchUuid = UUID.randomUUID().toString();
        IFhirResourceDao callingDao = this.myDaoRegistry.getResourceDao(theResourceType);
        Class resourceTypeClass = this.myContext.getResourceDefinition(theResourceType).getImplementingClass();
        ISearchBuilder sb = this.mySearchBuilderFactory.newSearchBuilder((IDao)callingDao, theResourceType, resourceTypeClass);
        sb.setFetchSize(this.mySyncSize);
        return this.executeQuery(theSearchParameterMap, null, searchUuid, sb, theSearchParameterMap.getLoadSynchronousUpTo(), theRequestPartitionId);
    }

    @Autowired
    public void setContext(FhirContext theContext) {
        this.myContext = theContext;
    }

    private int getTotalCount(Integer queryCount, Integer offset, int queryResultCount) {
        if (queryCount != null) {
            if (offset != null) {
                return offset + queryResultCount;
            }
            return queryResultCount;
        }
        return queryResultCount;
    }

    private Integer getQueryCount(Integer theLoadSynchronousUpTo, SearchParameterMap theParams) {
        if (theLoadSynchronousUpTo != null) {
            return theLoadSynchronousUpTo;
        }
        if (theParams.getCount() != null) {
            return theParams.getCount();
        }
        if (this.myStorageSettings.getFetchSizeDefaultMaximum() != null) {
            return this.myStorageSettings.getFetchSizeDefaultMaximum();
        }
        return null;
    }
}

