/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.config.HapiFhirLocalContainerEntityManagerFactoryBean;
import ca.uhn.fhir.jpa.config.HibernatePropertiesProvider;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.IJpaStorageResourceParser;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.data.IResourceSearchViewDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTagDao;
import ca.uhn.fhir.jpa.dao.search.ResourceNotFoundInIndexException;
import ca.uhn.fhir.jpa.entity.ResourceSearchView;
import ca.uhn.fhir.jpa.interceptor.JpaPreResourceAccessDetails;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.search.SearchBuilderLoadIncludesParameters;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.model.util.JpaConstants;
import ca.uhn.fhir.jpa.search.builder.ISearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.search.builder.SearchQueryExecutors;
import ca.uhn.fhir.jpa.search.builder.models.ResolvedSearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.sql.GeneratedSql;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.sql.SqlObjectFactory;
import ca.uhn.fhir.jpa.search.lastn.IElasticsearchSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.Dstu3DistanceHelper;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.jpa.searchparam.util.LastNParameterHelper;
import ca.uhn.fhir.jpa.util.BaseIterator;
import ca.uhn.fhir.jpa.util.CurrentThreadCaptureQueriesListener;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.jpa.util.SqlQueryList;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.ICallable;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.StringUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.collect.Streams;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SearchBuilder
implements ISearchBuilder<JpaPid> {
    @Deprecated
    public static final int MAXIMUM_PAGE_SIZE = 800;
    public static final int MAXIMUM_PAGE_SIZE_FOR_TESTING = 50;
    public static final String RESOURCE_ID_ALIAS = "resource_id";
    public static final String RESOURCE_VERSION_ALIAS = "resource_version";
    private static final Logger ourLog = LoggerFactory.getLogger(SearchBuilder.class);
    private static final JpaPid NO_MORE = JpaPid.fromId((Long)-1L);
    private static final String MY_TARGET_RESOURCE_PID = "myTargetResourcePid";
    private static final String MY_SOURCE_RESOURCE_PID = "mySourceResourcePid";
    private static final String MY_TARGET_RESOURCE_TYPE = "myTargetResourceType";
    private static final String MY_SOURCE_RESOURCE_TYPE = "mySourceResourceType";
    private static final String MY_TARGET_RESOURCE_VERSION = "myTargetResourceVersion";
    public static boolean myUseMaxPageSize50ForTest = false;
    protected final IInterceptorBroadcaster myInterceptorBroadcaster;
    protected final IResourceTagDao myResourceTagDao;
    private final String myResourceName;
    private final Class<? extends IBaseResource> myResourceType;
    private final HapiFhirLocalContainerEntityManagerFactoryBean myEntityManagerFactory;
    private final SqlObjectFactory mySqlBuilderFactory;
    private final HibernatePropertiesProvider myDialectProvider;
    private final ISearchParamRegistry mySearchParamRegistry;
    private final PartitionSettings myPartitionSettings;
    private final DaoRegistry myDaoRegistry;
    private final IResourceSearchViewDao myResourceSearchViewDao;
    private final FhirContext myContext;
    private final IIdHelperService<JpaPid> myIdHelperService;
    private final JpaStorageSettings myStorageSettings;
    private final IDao myCallingDao;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    private CriteriaBuilder myCriteriaBuilder;
    private SearchParameterMap myParams;
    private String mySearchUuid;
    private int myFetchSize;
    private Integer myMaxResultsToFetch;
    private Set<JpaPid> myPidSet;
    private boolean myHasNextIteratorQuery = false;
    private RequestPartitionId myRequestPartitionId;
    @Autowired(required=false)
    private IFulltextSearchSvc myFulltextSearchSvc;
    @Autowired(required=false)
    private IElasticsearchSvc myIElasticsearchSvc;
    @Autowired
    private IJpaStorageResourceParser myJpaStorageResourceParser;

    public SearchBuilder(IDao theDao, String theResourceName, JpaStorageSettings theStorageSettings, HapiFhirLocalContainerEntityManagerFactoryBean theEntityManagerFactory, SqlObjectFactory theSqlBuilderFactory, HibernatePropertiesProvider theDialectProvider, ISearchParamRegistry theSearchParamRegistry, PartitionSettings thePartitionSettings, IInterceptorBroadcaster theInterceptorBroadcaster, IResourceTagDao theResourceTagDao, DaoRegistry theDaoRegistry, IResourceSearchViewDao theResourceSearchViewDao, FhirContext theContext, IIdHelperService theIdHelperService, Class<? extends IBaseResource> theResourceType) {
        this.myCallingDao = theDao;
        this.myResourceName = theResourceName;
        this.myResourceType = theResourceType;
        this.myStorageSettings = theStorageSettings;
        this.myEntityManagerFactory = theEntityManagerFactory;
        this.mySqlBuilderFactory = theSqlBuilderFactory;
        this.myDialectProvider = theDialectProvider;
        this.mySearchParamRegistry = theSearchParamRegistry;
        this.myPartitionSettings = thePartitionSettings;
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
        this.myResourceTagDao = theResourceTagDao;
        this.myDaoRegistry = theDaoRegistry;
        this.myResourceSearchViewDao = theResourceSearchViewDao;
        this.myContext = theContext;
        this.myIdHelperService = theIdHelperService;
    }

    public void setMaxResultsToFetch(Integer theMaxResultsToFetch) {
        this.myMaxResultsToFetch = theMaxResultsToFetch;
    }

    private void searchForIdsWithAndOr(SearchQueryBuilder theSearchSqlBuilder, QueryStack theQueryStack, @Nonnull SearchParameterMap theParams, RequestDetails theRequest) {
        this.myParams = theParams;
        theParams.clean();
        if (this.myContext.getVersion().getVersion() == FhirVersionEnum.DSTU3) {
            Dstu3DistanceHelper.setNearDistance(this.myResourceType, (SearchParameterMap)theParams);
        }
        if (this.isCompositeUniqueSpCandidate()) {
            this.attemptComboUniqueSpProcessing(theQueryStack, theParams, theRequest);
        }
        SearchContainedModeEnum searchContainedMode = theParams.getSearchContainedMode();
        List paramNames = this.myParams.keySet().stream().filter(t -> !t.equals("_id")).filter(t -> !t.equals("_tag")).collect(Collectors.toList());
        if (this.myParams.containsKey("_id")) {
            paramNames.add("_id");
        }
        if (this.myParams.containsKey("_tag")) {
            paramNames.add("_tag");
        }
        for (String nextParamName : paramNames) {
            if (this.myParams.isLastN() && LastNParameterHelper.isLastNParameter((String)nextParamName, (FhirContext)this.myContext)) continue;
            List andOrParams = this.myParams.get(nextParamName);
            Condition predicate = theQueryStack.searchForIdsWithAndOr(QueryStack.SearchForIdsParams.with().setResourceName(this.myResourceName).setParamName(nextParamName).setAndOrParams(andOrParams).setRequest(theRequest).setRequestPartitionId(this.myRequestPartitionId));
            if (predicate == null) continue;
            theSearchSqlBuilder.addPredicate(predicate);
        }
    }

    private boolean isCompositeUniqueSpCandidate() {
        return this.myStorageSettings.isUniqueIndexesEnabled() && this.myParams.getEverythingMode() == null && this.myParams.isAllParametersHaveNoModifier();
    }

    public Long createCountQuery(SearchParameterMap theParams, String theSearchUuid, RequestDetails theRequest, @Nonnull RequestPartitionId theRequestPartitionId) {
        assert (theRequestPartitionId != null);
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        this.init(theParams, theSearchUuid, theRequestPartitionId);
        if (this.checkUseHibernateSearch()) {
            long count = this.myFulltextSearchSvc.count(this.myResourceName, theParams.clone());
            return count;
        }
        List<ISearchQueryExecutor> queries = this.createQuery(theParams.clone(), null, null, null, true, theRequest, null);
        if (queries.isEmpty()) {
            return 0L;
        }
        return (Long)queries.get(0).next();
    }

    public void setPreviouslyAddedResourcePids(@Nonnull List<JpaPid> thePidSet) {
        this.myPidSet = new HashSet<JpaPid>(thePidSet);
    }

    public IResultIterator createQuery(SearchParameterMap theParams, SearchRuntimeDetails theSearchRuntimeDetails, RequestDetails theRequest, @Nonnull RequestPartitionId theRequestPartitionId) {
        assert (theRequestPartitionId != null);
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        this.init(theParams, theSearchRuntimeDetails.getSearchUuid(), theRequestPartitionId);
        if (this.myPidSet == null) {
            this.myPidSet = new HashSet<JpaPid>();
        }
        return new QueryIterator(theSearchRuntimeDetails, theRequest);
    }

    private void init(SearchParameterMap theParams, String theSearchUuid, RequestPartitionId theRequestPartitionId) {
        this.myCriteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        this.myParams = theParams.clone();
        this.mySearchUuid = theSearchUuid;
        this.myRequestPartitionId = theRequestPartitionId;
    }

    private List<ISearchQueryExecutor> createQuery(SearchParameterMap theParams, SortSpec sort, Integer theOffset, Integer theMaximumResults, boolean theCountOnlyFlag, RequestDetails theRequest, SearchRuntimeDetails theSearchRuntimeDetails) {
        ArrayList<ISearchQueryExecutor> queries = new ArrayList<ISearchQueryExecutor>();
        if (this.checkUseHibernateSearch()) {
            boolean canSkipDatabase;
            ISearchQueryExecutor fulltextExecutor = null;
            List<JpaPid> fulltextMatchIds = null;
            int resultCount = 0;
            if (this.myParams.isLastN()) {
                fulltextMatchIds = this.executeLastNAgainstIndex(theMaximumResults);
                resultCount = fulltextMatchIds.size();
            } else if (this.myParams.getEverythingMode() != null) {
                fulltextMatchIds = this.queryHibernateSearchForEverythingPids(theRequest);
                resultCount = fulltextMatchIds.size();
            } else {
                fulltextExecutor = this.myFulltextSearchSvc.searchNotScrolled(this.myResourceName, this.myParams, this.myMaxResultsToFetch, theRequest);
            }
            if (fulltextExecutor == null) {
                fulltextExecutor = SearchQueryExecutors.from(fulltextMatchIds);
            }
            if (theSearchRuntimeDetails != null) {
                theSearchRuntimeDetails.setFoundIndexMatchesCount(resultCount);
                HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(SearchRuntimeDetails.class, (Object)theSearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INDEXSEARCH_QUERY_COMPLETE, (HookParams)params);
            }
            boolean bl = canSkipDatabase = !fulltextExecutor.hasNext() || !this.myPartitionSettings.isPartitioningEnabled() && theParams.isEmpty() && theParams.getNearDistanceParam() == null && theParams.getLastUpdated() == null && theParams.getEverythingMode() == null && theParams.getOffset() == null;
            if (canSkipDatabase) {
                ourLog.trace("Query finished after HSearch.  Skip db query phase");
                if (theMaximumResults != null) {
                    fulltextExecutor = SearchQueryExecutors.limited(fulltextExecutor, theMaximumResults.intValue());
                }
                queries.add(fulltextExecutor);
            } else {
                ourLog.trace("Query needs db after HSearch.  Chunking.");
                new QueryChunker().chunk(Streams.stream((Iterator)fulltextExecutor).collect(Collectors.toList()), t -> this.doCreateChunkedQueries(theParams, (List<Long>)t, theOffset, sort, theCountOnlyFlag, theRequest, queries));
            }
        } else {
            this.createChunkedQuery(theParams, sort, theOffset, theMaximumResults, theCountOnlyFlag, theRequest, null, queries);
        }
        return queries;
    }

    private boolean checkUseHibernateSearch() {
        boolean fulltextEnabled;
        boolean bl = fulltextEnabled = this.myFulltextSearchSvc != null && !this.myFulltextSearchSvc.isDisabled();
        if (!fulltextEnabled) {
            this.failIfUsed("_text");
            this.failIfUsed("_content");
        }
        return fulltextEnabled && this.myParams != null && this.myParams.getSearchContainedMode() == SearchContainedModeEnum.FALSE && this.myFulltextSearchSvc.supportsSomeOf(this.myParams);
    }

    private void failIfUsed(String theParamName) {
        if (this.myParams.containsKey(theParamName)) {
            throw new InvalidRequestException(Msg.code((int)1192) + "Fulltext search is not enabled on this service, can not process parameter: " + theParamName);
        }
    }

    private List<JpaPid> executeLastNAgainstIndex(Integer theMaximumResults) {
        if (this.myStorageSettings.isAdvancedHSearchIndexing()) {
            if (this.myFulltextSearchSvc == null) {
                throw new InvalidRequestException(Msg.code((int)2027) + "LastN operation is not enabled on this service, can not process this request");
            }
            return this.myFulltextSearchSvc.lastN(this.myParams, theMaximumResults).stream().map(lastNResourceId -> (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, String.valueOf(lastNResourceId))).collect(Collectors.toList());
        }
        if (this.myIElasticsearchSvc == null) {
            throw new InvalidRequestException(Msg.code((int)2033) + "LastN operation is not enabled on this service, can not process this request");
        }
        return this.myIElasticsearchSvc.executeLastN(this.myParams, this.myContext, theMaximumResults).stream().map(lastnResourceId -> (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, lastnResourceId)).collect(Collectors.toList());
    }

    private List<JpaPid> queryHibernateSearchForEverythingPids(RequestDetails theRequestDetails) {
        JpaPid pid = null;
        if (this.myParams.get("_id") != null) {
            String idParamValue;
            IQueryParameterType idParam = (IQueryParameterType)((List)this.myParams.get("_id").get(0)).get(0);
            if (idParam instanceof TokenParam) {
                TokenParam idParm = (TokenParam)idParam;
                idParamValue = idParm.getValue();
            } else {
                StringParam idParm = (StringParam)idParam;
                idParamValue = idParm.getValue();
            }
            pid = (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, idParamValue);
        }
        List<Object> pids = this.myFulltextSearchSvc.everything(this.myResourceName, this.myParams, pid, theRequestDetails);
        return pids;
    }

    private void doCreateChunkedQueries(SearchParameterMap theParams, List<Long> thePids, Integer theOffset, SortSpec sort, boolean theCount, RequestDetails theRequest, ArrayList<ISearchQueryExecutor> theQueries) {
        if (thePids.size() < SearchBuilder.getMaximumPageSize()) {
            this.normalizeIdListForLastNInClause(thePids);
        }
        this.createChunkedQuery(theParams, sort, theOffset, thePids.size(), theCount, theRequest, thePids, theQueries);
    }

    private void extractTargetPidsFromIdParams(HashSet<Long> theTargetPids, List<ISearchQueryExecutor> theSearchQueryExecutors) {
        HashSet<String> ids = new HashSet<String>();
        List params = this.myParams.get("_id");
        for (List paramList : params) {
            for (IQueryParameterType param : paramList) {
                if (param instanceof StringParam) {
                    ids.add(((StringParam)param).getValue());
                    continue;
                }
                if (param instanceof TokenParam) {
                    ids.add(((TokenParam)param).getValue());
                    continue;
                }
                throw new IllegalArgumentException(Msg.code((int)1193) + "_id parameter must be a StringParam or TokenParam");
            }
        }
        Map idToPid = this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, new ArrayList(ids));
        for (JpaPid pid : idToPid.values()) {
            theTargetPids.add(pid.getId());
        }
        theSearchQueryExecutors.add(new ResolvedSearchQueryExecutor(new ArrayList<Long>(theTargetPids)));
    }

    private void createChunkedQuery(SearchParameterMap theParams, SortSpec sort, Integer theOffset, Integer theMaximumResults, boolean theCountOnlyFlag, RequestDetails theRequest, List<Long> thePidList, List<ISearchQueryExecutor> theSearchQueryExecutors) {
        GeneratedSql generatedSql;
        DateRangeParam lu;
        Condition partitionIdPredicate;
        List activeComboParams;
        String sqlBuilderResourceName = this.myParams.getEverythingMode() == null ? this.myResourceName : null;
        SearchQueryBuilder sqlBuilder = new SearchQueryBuilder(this.myContext, (StorageSettings)this.myStorageSettings, this.myPartitionSettings, this.myRequestPartitionId, sqlBuilderResourceName, this.mySqlBuilderFactory, this.myDialectProvider, theCountOnlyFlag);
        QueryStack queryStack3 = new QueryStack(theParams, this.myStorageSettings, this.myContext, sqlBuilder, this.mySearchParamRegistry, this.myPartitionSettings);
        if ((theParams.keySet().size() > 1 || theParams.getSort() != null || theParams.keySet().contains("_has") || this.isPotentiallyContainedReferenceParameterExistsAtRoot(theParams)) && (activeComboParams = this.mySearchParamRegistry.getActiveComboSearchParams(this.myResourceName, theParams.keySet())).isEmpty()) {
            sqlBuilder.setNeedResourceTableRoot(true);
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.myEntityManagerFactory.getDataSource());
        jdbcTemplate.setFetchSize(this.myFetchSize);
        if (theMaximumResults != null) {
            jdbcTemplate.setMaxRows(theMaximumResults.intValue());
        }
        if (this.myParams.getEverythingMode() != null) {
            HashSet<Long> targetPids = new HashSet<Long>();
            if (this.myParams.get("_id") != null) {
                this.extractTargetPidsFromIdParams(targetPids, theSearchQueryExecutors);
            } else {
                SearchQueryBuilder fetchPidsSqlBuilder = new SearchQueryBuilder(this.myContext, (StorageSettings)this.myStorageSettings, this.myPartitionSettings, this.myRequestPartitionId, this.myResourceName, this.mySqlBuilderFactory, this.myDialectProvider, theCountOnlyFlag);
                GeneratedSql allTargetsSql = fetchPidsSqlBuilder.generate(theOffset, this.myMaxResultsToFetch);
                String sql = allTargetsSql.getSql();
                Object[] args = allTargetsSql.getBindVariables().toArray(new Object[0]);
                List output = jdbcTemplate.query(sql, args, (RowMapper)new SingleColumnRowMapper(Long.class));
                theSearchQueryExecutors.add(new ResolvedSearchQueryExecutor(output));
            }
            ArrayList<String> typeSourceResources = new ArrayList<String>();
            if (this.myParams.get("_type") != null) {
                typeSourceResources.addAll(this.extractTypeSourceResourcesFromParams());
            }
            queryStack3.addPredicateEverythingOperation(this.myResourceName, typeSourceResources, targetPids.toArray(new Long[0]));
        } else {
            if (theParams.containsKey("_filter") && (partitionIdPredicate = sqlBuilder.getOrCreateResourceTablePredicateBuilder().createPartitionIdPredicate(this.myRequestPartitionId)) != null) {
                sqlBuilder.addPredicate(partitionIdPredicate);
            }
            this.searchForIdsWithAndOr(sqlBuilder, queryStack3, this.myParams, theRequest);
        }
        if (!sqlBuilder.haveAtLeastOnePredicate() && (partitionIdPredicate = sqlBuilder.getOrCreateResourceTablePredicateBuilder().createPartitionIdPredicate(this.myRequestPartitionId)) != null) {
            sqlBuilder.addPredicate(partitionIdPredicate);
        }
        if (thePidList != null && thePidList.size() > 0) {
            sqlBuilder.addResourceIdsPredicate(thePidList);
        }
        if ((lu = this.myParams.getLastUpdated()) != null && !lu.isEmpty()) {
            ComboCondition lastUpdatedPredicates = sqlBuilder.addPredicateLastUpdated(lu);
            sqlBuilder.addPredicate((Condition)lastUpdatedPredicates);
        }
        if (this.myHasNextIteratorQuery && this.myPidSet.size() + sqlBuilder.countBindVariables() < 900) {
            sqlBuilder.excludeResourceIdsPredicate(this.myPidSet);
        }
        if (theOffset != null) {
            queryStack3.addGrouping();
            queryStack3.setUseAggregate(true);
        }
        if (sort != null) {
            assert (!theCountOnlyFlag);
            this.createSort(queryStack3, sort, theParams);
        }
        if (!(generatedSql = sqlBuilder.generate(theOffset, this.myMaxResultsToFetch)).isMatchNothing()) {
            SearchQueryExecutor executor = this.mySqlBuilderFactory.newSearchQueryExecutor(generatedSql, this.myMaxResultsToFetch);
            theSearchQueryExecutors.add(executor);
        }
    }

    private Collection<String> extractTypeSourceResourcesFromParams() {
        List listOfList = this.myParams.get("_type");
        List iQueryParameterTypesList = listOfList.stream().flatMap(Collection::stream).collect(Collectors.toList());
        List resourceTypes = iQueryParameterTypesList.stream().map(param -> ((StringParam)param).getValue()).map(csvString -> List.of(csvString.split(","))).flatMap(Collection::stream).collect(Collectors.toList());
        Set knownResourceTypes = this.myContext.getResourceTypes();
        HashSet<String> retVal = new HashSet<String>();
        for (String type : resourceTypes) {
            String trimmed = type.trim();
            if (!knownResourceTypes.contains(trimmed)) {
                throw new ResourceNotFoundException(Msg.code((int)2197) + "Unknown resource type '" + trimmed + "' in _type parameter.");
            }
            retVal.add(trimmed);
        }
        return retVal;
    }

    private boolean isPotentiallyContainedReferenceParameterExistsAtRoot(SearchParameterMap theParams) {
        return this.myStorageSettings.isIndexOnContainedResources() && theParams.values().stream().flatMap(Collection::stream).flatMap(Collection::stream).anyMatch(t -> t instanceof ReferenceParam);
    }

    private List<Long> normalizeIdListForLastNInClause(List<Long> lastnResourceIds) {
        int listSize = lastnResourceIds.size();
        if (listSize > 1 && listSize < 10) {
            this.padIdListWithPlaceholders(lastnResourceIds, 10);
        } else if (listSize > 10 && listSize < 50) {
            this.padIdListWithPlaceholders(lastnResourceIds, 50);
        } else if (listSize > 50 && listSize < 100) {
            this.padIdListWithPlaceholders(lastnResourceIds, 100);
        } else if (listSize > 100 && listSize < 200) {
            this.padIdListWithPlaceholders(lastnResourceIds, 200);
        } else if (listSize > 200 && listSize < 500) {
            this.padIdListWithPlaceholders(lastnResourceIds, 500);
        } else if (listSize > 500 && listSize < 800) {
            this.padIdListWithPlaceholders(lastnResourceIds, 800);
        }
        return lastnResourceIds;
    }

    private void padIdListWithPlaceholders(List<Long> theIdList, int preferredListSize) {
        while (theIdList.size() < preferredListSize) {
            theIdList.add(-1L);
        }
    }

    private void createSort(QueryStack theQueryStack, SortSpec theSort, SearchParameterMap theParams) {
        boolean ascending;
        if (theSort == null || StringUtils.isBlank((CharSequence)theSort.getParamName())) {
            return;
        }
        boolean bl = ascending = theSort.getOrder() == null || theSort.getOrder() == SortOrderEnum.ASC;
        if ("_id".equals(theSort.getParamName())) {
            theQueryStack.addSortOnResourceId(ascending);
        } else if ("_pid".equals(theSort.getParamName())) {
            theQueryStack.addSortOnResourcePID(ascending);
        } else if ("_lastUpdated".equals(theSort.getParamName())) {
            theQueryStack.addSortOnLastUpdated(ascending);
        } else {
            String[] chains;
            RuntimeSearchParam param = null;
            String paramName = theSort.getParamName();
            if (this.myStorageSettings.isIndexOnUpliftedRefchains() && (chains = StringUtils.split((String)paramName, (char)'.')).length == 2) {
                RuntimeSearchParam outerParam;
                String referenceParam = chains[0];
                String referenceParamTargetType = null;
                String targetParam = chains[1];
                int colonIdx = referenceParam.indexOf(58);
                if (colonIdx > -1) {
                    referenceParamTargetType = referenceParam.substring(0, colonIdx);
                    referenceParam = referenceParam.substring(colonIdx + 1);
                }
                if ((outerParam = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, referenceParam)) == null) {
                    this.throwInvalidRequestExceptionForUnknownSortParameter(this.myResourceName, referenceParam);
                }
                if (outerParam.hasUpliftRefchain(targetParam)) {
                    for (String nextTargetType : outerParam.getTargets()) {
                        RuntimeSearchParam innerParam;
                        if (referenceParamTargetType != null && !referenceParamTargetType.equals(nextTargetType) || (innerParam = this.mySearchParamRegistry.getActiveSearchParam(nextTargetType, targetParam)) == null) continue;
                        param = innerParam;
                        break;
                    }
                }
            }
            int colonIdx = paramName.indexOf(58);
            String referenceTargetType = null;
            if (colonIdx > -1) {
                referenceTargetType = paramName.substring(0, colonIdx);
                paramName = paramName.substring(colonIdx + 1);
            }
            int dotIdx = paramName.indexOf(46);
            String chainName = null;
            if (param == null && dotIdx > -1) {
                chainName = paramName.substring(dotIdx + 1);
                paramName = paramName.substring(0, dotIdx);
                if (chainName.contains(".")) {
                    String msg = this.myContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSortParameterTooManyChains", new Object[]{paramName + "." + chainName});
                    throw new InvalidRequestException(Msg.code((int)2286) + msg);
                }
            }
            if (param == null) {
                param = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, paramName);
            }
            if (param == null) {
                this.throwInvalidRequestExceptionForUnknownSortParameter(this.getResourceName(), paramName);
            }
            if (StringUtils.isNotBlank(chainName) && param.getParamType() != RestSearchParameterTypeEnum.REFERENCE) {
                throw new InvalidRequestException(Msg.code((int)2285) + "Invalid chain, " + paramName + " is not a reference SearchParameter");
            }
            switch (param.getParamType()) {
                case STRING: {
                    theQueryStack.addSortOnString(this.myResourceName, paramName, ascending);
                    break;
                }
                case DATE: {
                    theQueryStack.addSortOnDate(this.myResourceName, paramName, ascending);
                    break;
                }
                case REFERENCE: {
                    theQueryStack.addSortOnResourceLink(this.myResourceName, referenceTargetType, paramName, chainName, ascending);
                    break;
                }
                case TOKEN: {
                    theQueryStack.addSortOnToken(this.myResourceName, paramName, ascending);
                    break;
                }
                case NUMBER: {
                    theQueryStack.addSortOnNumber(this.myResourceName, paramName, ascending);
                    break;
                }
                case URI: {
                    theQueryStack.addSortOnUri(this.myResourceName, paramName, ascending);
                    break;
                }
                case QUANTITY: {
                    theQueryStack.addSortOnQuantity(this.myResourceName, paramName, ascending);
                    break;
                }
                case COMPOSITE: {
                    List compositeList = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)param);
                    if (compositeList == null) {
                        throw new InvalidRequestException(Msg.code((int)1195) + "The composite _sort parameter " + paramName + " is not defined by the resource " + this.myResourceName);
                    }
                    if (compositeList.size() != 2) {
                        throw new InvalidRequestException(Msg.code((int)1196) + "The composite _sort parameter " + paramName + " must have 2 composite types declared in parameter annotation, found " + compositeList.size());
                    }
                    RuntimeSearchParam left = (RuntimeSearchParam)compositeList.get(0);
                    RuntimeSearchParam right = (RuntimeSearchParam)compositeList.get(1);
                    this.createCompositeSort(theQueryStack, left.getParamType(), left.getName(), ascending);
                    this.createCompositeSort(theQueryStack, right.getParamType(), right.getName(), ascending);
                    break;
                }
                case SPECIAL: {
                    if ("Location.position".equals(param.getPath())) {
                        theQueryStack.addSortOnCoordsNear(paramName, ascending, theParams);
                        break;
                    }
                    throw new InvalidRequestException(Msg.code((int)2306) + "This server does not support _sort specifications of type " + param.getParamType() + " - Can't serve _sort=" + paramName);
                }
                default: {
                    throw new InvalidRequestException(Msg.code((int)1197) + "This server does not support _sort specifications of type " + param.getParamType() + " - Can't serve _sort=" + paramName);
                }
            }
        }
        this.createSort(theQueryStack, theSort.getChain(), theParams);
    }

    private void throwInvalidRequestExceptionForUnknownSortParameter(String theResourceName, String theParamName) {
        Collection validSearchParameterNames = this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(theResourceName);
        String msg = this.myContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSortParameter", new Object[]{theParamName, theResourceName, validSearchParameterNames});
        throw new InvalidRequestException(Msg.code((int)1194) + msg);
    }

    private void createCompositeSort(QueryStack theQueryStack, RestSearchParameterTypeEnum theParamType, String theParamName, boolean theAscending) {
        switch (theParamType) {
            case STRING: {
                theQueryStack.addSortOnString(this.myResourceName, theParamName, theAscending);
                break;
            }
            case DATE: {
                theQueryStack.addSortOnDate(this.myResourceName, theParamName, theAscending);
                break;
            }
            case TOKEN: {
                theQueryStack.addSortOnToken(this.myResourceName, theParamName, theAscending);
                break;
            }
            case QUANTITY: {
                theQueryStack.addSortOnQuantity(this.myResourceName, theParamName, theAscending);
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)1198) + "Don't know how to handle composite parameter with type of " + theParamType + " on _sort=" + theParamName);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doLoadPids(Collection<JpaPid> thePids, Collection<JpaPid> theIncludedPids, List<IBaseResource> theResourceListToPopulate, boolean theForHistoryOperation, Map<JpaPid, Integer> thePosition) {
        HashMap<Long, Long> resourcePidToVersion = null;
        for (JpaPid next : thePids) {
            if (next.getVersion() == null || !this.myStorageSettings.isRespectVersionsForSearchIncludes()) continue;
            if (resourcePidToVersion == null) {
                resourcePidToVersion = new HashMap<Long, Long>();
            }
            resourcePidToVersion.put(next.getId(), next.getVersion());
        }
        List<Long> versionlessPids = JpaPid.toLongList(thePids);
        if (versionlessPids.size() < SearchBuilder.getMaximumPageSize()) {
            versionlessPids = this.normalizeIdListForLastNInClause(versionlessPids);
        }
        Collection<ResourceSearchView> resourceSearchViewList = this.myResourceSearchViewDao.findByResourceIds(versionlessPids);
        Map<Long, Collection<ResourceTag>> tagMap = this.getResourceTagMap(resourceSearchViewList);
        for (IBaseResourceEntity iBaseResourceEntity : resourceSearchViewList) {
            void var11_11;
            if (iBaseResourceEntity.getDeleted() != null) continue;
            Class resourceType = this.myContext.getResourceDefinition(iBaseResourceEntity.getResourceType()).getImplementingClass();
            JpaPid resourceId = JpaPid.fromId((Long)iBaseResourceEntity.getResourceId());
            if (resourcePidToVersion != null) {
                Long version = (Long)resourcePidToVersion.get(iBaseResourceEntity.getResourceId());
                resourceId.setVersion(version);
                if (version != null && !version.equals(iBaseResourceEntity.getVersion())) {
                    IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
                    IBaseResourceEntity iBaseResourceEntity2 = (IBaseResourceEntity)dao.readEntity((IIdType)iBaseResourceEntity.getIdDt().withVersion(Long.toString(version)), null);
                }
            }
            Object resource = null;
            if (var11_11 != null) {
                resource = this.myJpaStorageResourceParser.toResource(resourceType, (IBaseResourceEntity)var11_11, tagMap.get(var11_11.getId()), theForHistoryOperation);
            }
            if (resource == null) {
                ourLog.warn("Unable to find resource {}/{}/_history/{} in database", new Object[]{var11_11.getResourceType(), var11_11.getIdDt().getIdPart(), var11_11.getVersion()});
                continue;
            }
            Integer index = thePosition.get(resourceId);
            if (index == null) {
                ourLog.warn("Got back unexpected resource PID {}", (Object)resourceId);
                continue;
            }
            if (theIncludedPids.contains(resourceId)) {
                ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put(resource, (Object)BundleEntrySearchModeEnum.INCLUDE);
            } else {
                ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put(resource, (Object)BundleEntrySearchModeEnum.MATCH);
            }
            theResourceListToPopulate.set(index, (IBaseResource)resource);
        }
    }

    private Map<Long, Collection<ResourceTag>> getResourceTagMap(Collection<? extends IBaseResourceEntity> theResourceSearchViewList) {
        ArrayList<Long> idList = new ArrayList<Long>(theResourceSearchViewList.size());
        for (IBaseResourceEntity iBaseResourceEntity : theResourceSearchViewList) {
            if (!iBaseResourceEntity.isHasTags()) continue;
            idList.add(iBaseResourceEntity.getId());
        }
        return this.getPidToTagMap(idList);
    }

    @Nonnull
    private Map<Long, Collection<ResourceTag>> getPidToTagMap(List<Long> thePidList) {
        HashMap<Long, Collection<ResourceTag>> tagMap = new HashMap<Long, Collection<ResourceTag>>();
        if (thePidList.size() == 0) {
            return tagMap;
        }
        Collection<ResourceTag> tagList = this.myResourceTagDao.findByResourceIds(thePidList);
        for (ResourceTag tag : tagList) {
            JpaPid resourceId = JpaPid.fromId((Long)tag.getResourceId());
            ArrayList<ResourceTag> tagCol = (ArrayList<ResourceTag>)tagMap.get(resourceId.getId());
            if (tagCol == null) {
                tagCol = new ArrayList<ResourceTag>();
                tagCol.add(tag);
                tagMap.put(resourceId.getId(), tagCol);
                continue;
            }
            tagCol.add(tag);
        }
        return tagMap;
    }

    public void loadResourcesByPid(Collection<JpaPid> thePids, Collection<JpaPid> theIncludedPids, List<IBaseResource> theResourceListToPopulate, boolean theForHistoryOperation, RequestDetails theDetails) {
        if (thePids.isEmpty()) {
            ourLog.debug("The include pids are empty");
        }
        assert (new HashSet<JpaPid>(thePids).size() == thePids.size()) : "PID list contains duplicates: " + thePids;
        HashMap<JpaPid, Integer> position = new HashMap<JpaPid, Integer>();
        for (JpaPid next : thePids) {
            position.put(next, theResourceListToPopulate.size());
            theResourceListToPopulate.add(null);
        }
        if (this.isLoadingFromElasticSearchSupported(thePids)) {
            try {
                theResourceListToPopulate.addAll(this.loadResourcesFromElasticSearch(thePids));
                return;
            }
            catch (ResourceNotFoundInIndexException theE) {
                ourLog.warn("Some resources were not found in index. Make sure all resources were indexed. Resorting to database search.");
            }
        }
        new QueryChunker<JpaPid>().chunk(thePids, t -> this.doLoadPids((Collection<JpaPid>)t, theIncludedPids, theResourceListToPopulate, theForHistoryOperation, (Map<JpaPid, Integer>)position));
    }

    private boolean isLoadingFromElasticSearchSupported(Collection<JpaPid> thePids) {
        return this.myStorageSettings.isStoreResourceInHSearchIndex() && this.myStorageSettings.isAdvancedHSearchIndexing() && thePids.stream().noneMatch(p -> p.getVersion() != null) && this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3);
    }

    private List<IBaseResource> loadResourcesFromElasticSearch(Collection<JpaPid> thePids) {
        if (this.myStorageSettings.isAdvancedHSearchIndexing() && this.myStorageSettings.isStoreResourceInHSearchIndex()) {
            List<Long> pidList = thePids.stream().map(pid -> pid.getId()).collect(Collectors.toList());
            List<IBaseResource> resources = this.myFulltextSearchSvc.getResources(pidList);
            return resources;
        }
        if (!Objects.isNull(this.myParams) && this.myParams.isLastN()) {
            return this.myIElasticsearchSvc.getObservationResources(thePids);
        }
        return Collections.emptyList();
    }

    public Set<JpaPid> loadIncludes(FhirContext theContext, EntityManager theEntityManager, Collection<JpaPid> theMatches, Collection<Include> theIncludes, boolean theReverseMode, DateRangeParam theLastUpdated, String theSearchIdOrDescription, RequestDetails theRequest, Integer theMaxCount) {
        SearchBuilderLoadIncludesParameters parameters = new SearchBuilderLoadIncludesParameters();
        parameters.setFhirContext(theContext);
        parameters.setEntityManager(theEntityManager);
        parameters.setMatches(theMatches);
        parameters.setIncludeFilters(theIncludes);
        parameters.setReverseMode(theReverseMode);
        parameters.setLastUpdated(theLastUpdated);
        parameters.setSearchIdOrDescription(theSearchIdOrDescription);
        parameters.setRequestDetails(theRequest);
        parameters.setMaxCount(theMaxCount);
        return this.loadIncludes((SearchBuilderLoadIncludesParameters<JpaPid>)parameters);
    }

    public Set<JpaPid> loadIncludes(SearchBuilderLoadIncludesParameters<JpaPid> theParameters) {
        boolean addedSomeThisRound;
        boolean hasDesiredResourceTypes;
        Collection matches = theParameters.getMatches();
        Collection currentIncludes = theParameters.getIncludeFilters();
        boolean reverseMode = theParameters.isReverseMode();
        EntityManager entityManager = theParameters.getEntityManager();
        Integer maxCount = theParameters.getMaxCount();
        FhirContext fhirContext = theParameters.getFhirContext();
        DateRangeParam lastUpdated = theParameters.getLastUpdated();
        RequestDetails request = theParameters.getRequestDetails();
        String searchIdOrDescription = theParameters.getSearchIdOrDescription();
        List desiredResourceTypes = theParameters.getDesiredResourceTypes();
        boolean bl = hasDesiredResourceTypes = desiredResourceTypes != null && !desiredResourceTypes.isEmpty();
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theParameters.getRequestDetails())) {
            CurrentThreadCaptureQueriesListener.startCapturing();
        }
        if (matches.size() == 0) {
            return new HashSet<JpaPid>();
        }
        if (currentIncludes == null || currentIncludes.isEmpty()) {
            return new HashSet<JpaPid>();
        }
        String searchPidFieldName = reverseMode ? MY_TARGET_RESOURCE_PID : MY_SOURCE_RESOURCE_PID;
        String findPidFieldName = reverseMode ? MY_SOURCE_RESOURCE_PID : MY_TARGET_RESOURCE_PID;
        String findResourceTypeFieldName = reverseMode ? MY_SOURCE_RESOURCE_TYPE : MY_TARGET_RESOURCE_TYPE;
        String findVersionFieldName = null;
        if (!reverseMode && this.myStorageSettings.isRespectVersionsForSearchIncludes()) {
            findVersionFieldName = MY_TARGET_RESOURCE_VERSION;
        }
        ArrayList<JpaPid> nextRoundMatches = new ArrayList<JpaPid>(matches);
        HashSet<JpaPid> allAdded = new HashSet<JpaPid>();
        HashSet original = new HashSet(matches);
        ArrayList includes = new ArrayList(currentIncludes);
        int roundCounts = 0;
        StopWatch w = new StopWatch();
        do {
            ++roundCounts;
            HashSet<JpaPid> pidsToInclude = new HashSet<JpaPid>();
            Iterator iter = includes.iterator();
            while (iter.hasNext()) {
                Include nextInclude = (Include)iter.next();
                if (!nextInclude.isRecurse()) {
                    iter.remove();
                }
                boolean matchAll = "*".equals(nextInclude.getValue());
                String wantResourceType = null;
                if (!matchAll && "*".equals(nextInclude.getParamName())) {
                    wantResourceType = nextInclude.getParamType();
                    matchAll = true;
                }
                if (matchAll) {
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("SELECT r.").append(findPidFieldName);
                    sqlBuilder.append(", r.").append(findResourceTypeFieldName);
                    if (findVersionFieldName != null) {
                        sqlBuilder.append(", r.").append(findVersionFieldName);
                    }
                    sqlBuilder.append(" FROM ResourceLink r WHERE ");
                    sqlBuilder.append("r.");
                    sqlBuilder.append(searchPidFieldName);
                    sqlBuilder.append(" IN (:target_pids)");
                    if (wantResourceType != null && (reverseMode || this.myParams != null && this.myParams.getEverythingMode() != null)) {
                        sqlBuilder.append(" AND r.mySourceResourceType = :want_resource_type");
                    } else {
                        wantResourceType = null;
                    }
                    if (this.myParams != null && this.myParams.getEverythingMode() == SearchParameterMap.EverythingModeEnum.PATIENT_INSTANCE) {
                        sqlBuilder.append(" AND r.myTargetResourceType != 'Patient'");
                        sqlBuilder.append(JpaConstants.UNDESIRED_RESOURCE_LINKAGES_FOR_EVERYTHING_ON_PATIENT_INSTANCE.stream().collect(Collectors.joining("', '", " AND r.mySourceResourceType NOT IN ('", "')")));
                    }
                    if (hasDesiredResourceTypes) {
                        sqlBuilder.append(" AND r.myTargetResourceType IN (:desired_target_resource_types)");
                    }
                    String sql = sqlBuilder.toString();
                    List<Collection<JpaPid>> partitions = this.partition(nextRoundMatches, SearchBuilder.getMaximumPageSize());
                    for (Collection<JpaPid> nextPartition : partitions) {
                        TypedQuery q = entityManager.createQuery(sql, Object[].class);
                        q.setParameter("target_pids", (Object)JpaPid.toLongList(nextPartition));
                        if (wantResourceType != null) {
                            q.setParameter("want_resource_type", (Object)wantResourceType);
                        }
                        if (maxCount != null) {
                            q.setMaxResults(maxCount.intValue());
                        }
                        if (hasDesiredResourceTypes) {
                            q.setParameter("desired_target_resource_types", (Object)desiredResourceTypes);
                        }
                        List results = q.getResultList();
                        for (Object nextRow : results) {
                            if (nextRow == null) continue;
                            Long version = null;
                            Long resourceLink = (Long)((Object[])nextRow)[0];
                            String resourceType = (String)((Object[])nextRow)[1];
                            if (findVersionFieldName != null) {
                                version = (Long)((Object[])nextRow)[2];
                            }
                            if (resourceLink == null) continue;
                            JpaPid pid = JpaPid.fromIdAndVersionAndResourceType((Long)resourceLink, (Long)version, (String)resourceType);
                            pidsToInclude.add(pid);
                        }
                    }
                    continue;
                }
                String resType = nextInclude.getParamType();
                if (StringUtils.isBlank((CharSequence)resType)) continue;
                RuntimeResourceDefinition def = fhirContext.getResourceDefinition(resType);
                if (def == null) {
                    ourLog.warn("Unknown resource type in include/revinclude=" + nextInclude.getValue());
                    continue;
                }
                String paramName = nextInclude.getParamName();
                RuntimeSearchParam param = StringUtils.isNotBlank((CharSequence)paramName) ? this.mySearchParamRegistry.getActiveSearchParam(resType, paramName) : null;
                if (param == null) {
                    ourLog.warn("Unknown param name in include/revinclude=" + nextInclude.getValue());
                    continue;
                }
                List paths = param.getPathsSplitForResourceType(resType);
                Set<String> targetResourceTypes = SearchBuilder.computeTargetResourceTypes(nextInclude, param);
                for (String nextPath : paths) {
                    String findPidFieldSqlColumn = findPidFieldName.equals(MY_SOURCE_RESOURCE_PID) ? "src_resource_id" : "target_resource_id";
                    String fieldsToLoad = "r." + findPidFieldSqlColumn + " AS resource_id";
                    if (findVersionFieldName != null) {
                        fieldsToLoad = fieldsToLoad + ", r.target_resource_version AS resource_version";
                    }
                    HashMap<String, Object> localReferenceQueryParams = new HashMap<String, Object>();
                    String searchPidFieldSqlColumn = searchPidFieldName.equals(MY_TARGET_RESOURCE_PID) ? "target_resource_id" : "src_resource_id";
                    StringBuilder localReferenceQuery = new StringBuilder("SELECT " + fieldsToLoad + " FROM hfj_res_link r  WHERE r.src_path = :src_path AND  r.target_resource_id IS NOT NULL AND  r." + searchPidFieldSqlColumn + " IN (:target_pids) ");
                    localReferenceQueryParams.put("src_path", nextPath);
                    if (targetResourceTypes != null) {
                        if (targetResourceTypes.size() == 1) {
                            localReferenceQuery.append(" AND r.target_resource_type = :target_resource_type ");
                            localReferenceQueryParams.put("target_resource_type", targetResourceTypes.iterator().next());
                        } else {
                            localReferenceQuery.append(" AND r.target_resource_type in (:target_resource_types) ");
                            localReferenceQueryParams.put("target_resource_types", targetResourceTypes);
                        }
                    }
                    Pair<String, Map<String, Object>> canonicalQuery = this.buildCanonicalUrlQuery(findVersionFieldName, searchPidFieldSqlColumn, targetResourceTypes);
                    String sql = localReferenceQuery + " UNION " + (String)canonicalQuery.getLeft();
                    List<Collection<JpaPid>> partitions = this.partition(nextRoundMatches, SearchBuilder.getMaximumPageSize());
                    for (Collection<JpaPid> nextPartition : partitions) {
                        Query q = entityManager.createNativeQuery(sql, Tuple.class);
                        q.setParameter("target_pids", (Object)JpaPid.toLongList(nextPartition));
                        localReferenceQueryParams.forEach((arg_0, arg_1) -> ((Query)q).setParameter(arg_0, arg_1));
                        ((Map)canonicalQuery.getRight()).forEach((arg_0, arg_1) -> ((Query)q).setParameter(arg_0, arg_1));
                        if (maxCount != null) {
                            q.setMaxResults(maxCount.intValue());
                        }
                        List results = q.getResultList();
                        for (Tuple result : results) {
                            if (result == null) continue;
                            Long resourceId = NumberUtils.createLong((String)String.valueOf(result.get(RESOURCE_ID_ALIAS)));
                            Long resourceVersion = null;
                            if (findVersionFieldName != null && result.get(RESOURCE_VERSION_ALIAS) != null) {
                                resourceVersion = NumberUtils.createLong((String)String.valueOf(result.get(RESOURCE_VERSION_ALIAS)));
                            }
                            pidsToInclude.add(JpaPid.fromIdAndVersion((Long)resourceId, resourceVersion));
                        }
                    }
                }
            }
            nextRoundMatches.clear();
            for (JpaPid next : pidsToInclude) {
                if (original.contains(next) || allAdded.contains(next)) continue;
                nextRoundMatches.add(next);
            }
            addedSomeThisRound = allAdded.addAll(pidsToInclude);
        } while ((maxCount == null || allAdded.size() < maxCount) && !includes.isEmpty() && !nextRoundMatches.isEmpty() && addedSomeThisRound);
        allAdded.removeAll(original);
        ourLog.info("Loaded {} {} in {} rounds and {} ms for search {}", new Object[]{allAdded.size(), reverseMode ? "_revincludes" : "_includes", roundCounts, w.getMillisAndRestart(), searchIdOrDescription});
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)request)) {
            this.callRawSqlHookWithCurrentThreadQueries(request);
        }
        if (!allAdded.isEmpty() && CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)request)) {
            ArrayList<JpaPid> includedPidList = new ArrayList<JpaPid>(allAdded);
            JpaPreResourceAccessDetails accessDetails = new JpaPreResourceAccessDetails(includedPidList, (ICallable<ISearchBuilder>)((ICallable)() -> this));
            HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)request).addIfMatchesType(ServletRequestDetails.class, (Object)request);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)request, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
            for (int i = includedPidList.size() - 1; i >= 0; --i) {
                JpaPid value;
                if (!accessDetails.isDontReturnResourceAtIndex(i) || (value = (JpaPid)includedPidList.remove(i)) == null) continue;
                allAdded.remove(value);
            }
        }
        return allAdded;
    }

    private void callRawSqlHookWithCurrentThreadQueries(RequestDetails request) {
        SqlQueryList capturedQueries = CurrentThreadCaptureQueriesListener.getCurrentQueueAndStopCapturing();
        HookParams params = new HookParams().add(RequestDetails.class, (Object)request).addIfMatchesType(ServletRequestDetails.class, (Object)request).add(SqlQueryList.class, (Object)capturedQueries);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)request, (Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (HookParams)params);
    }

    @Nullable
    private static Set<String> computeTargetResourceTypes(Include nextInclude, RuntimeSearchParam param) {
        String targetResourceType = StringUtils.defaultString((String)nextInclude.getParamTargetType(), null);
        boolean haveTargetTypesDefinedByParam = param.hasTargets();
        Set targetResourceTypes = targetResourceType != null ? Set.of(targetResourceType) : (haveTargetTypesDefinedByParam ? param.getTargets() : null);
        return targetResourceTypes;
    }

    @Nonnull
    private Pair<String, Map<String, Object>> buildCanonicalUrlQuery(String theVersionFieldName, String thePidFieldSqlColumn, Set<String> theTargetResourceTypes) {
        Object fieldsToLoadFromSpidxUriTable = "rUri.res_id";
        if (theVersionFieldName != null) {
            fieldsToLoadFromSpidxUriTable = (String)fieldsToLoadFromSpidxUriTable + ", NULL";
        }
        if (theTargetResourceTypes == null) {
            theTargetResourceTypes = this.myDaoRegistry.getRegisteredDaoTypes();
        }
        assert (!theTargetResourceTypes.isEmpty());
        Set identityHashesForTypes = theTargetResourceTypes.stream().map(type -> BaseResourceIndexedSearchParam.calculateHashIdentity((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)this.myRequestPartitionId, (String)type, (String)"url")).collect(Collectors.toSet());
        HashMap<String, Object> canonicalUriQueryParams = new HashMap<String, Object>();
        StringBuilder canonicalUrlQuery = new StringBuilder("SELECT " + (String)fieldsToLoadFromSpidxUriTable + " FROM hfj_res_link r  JOIN hfj_spidx_uri rUri ON ( ");
        if (theTargetResourceTypes.size() == 1) {
            canonicalUrlQuery.append("   rUri.hash_identity = :uri_identity_hash ");
            canonicalUriQueryParams.put("uri_identity_hash", identityHashesForTypes.iterator().next());
        } else {
            canonicalUrlQuery.append("   rUri.hash_identity in (:uri_identity_hashes) ");
            canonicalUriQueryParams.put("uri_identity_hashes", identityHashesForTypes);
        }
        canonicalUrlQuery.append("  AND r.target_resource_url = rUri.sp_uri  ) WHERE r.src_path = :src_path AND  r.target_resource_id IS NULL AND  r." + thePidFieldSqlColumn + " IN (:target_pids) ");
        return Pair.of((Object)canonicalUrlQuery.toString(), canonicalUriQueryParams);
    }

    private List<Collection<JpaPid>> partition(Collection<JpaPid> theNextRoundMatches, int theMaxLoad) {
        if (theNextRoundMatches.size() <= theMaxLoad) {
            return Collections.singletonList(theNextRoundMatches);
        }
        ArrayList<Collection<JpaPid>> retVal = new ArrayList<Collection<JpaPid>>();
        ArrayList<JpaPid> current = null;
        for (JpaPid next : theNextRoundMatches) {
            if (current == null) {
                current = new ArrayList<JpaPid>(theMaxLoad);
                retVal.add(current);
            }
            current.add(next);
            if (current.size() < theMaxLoad) continue;
            current = null;
        }
        return retVal;
    }

    private void attemptComboUniqueSpProcessing(QueryStack theQueryStack3, @Nonnull SearchParameterMap theParams, RequestDetails theRequest) {
        Object comboParam = null;
        List<Object> comboParamNames = null;
        List exactMatchParams = this.mySearchParamRegistry.getActiveComboSearchParams(this.myResourceName, theParams.keySet());
        if (exactMatchParams.size() > 0) {
            comboParam = (RuntimeSearchParam)exactMatchParams.get(0);
            comboParamNames = new ArrayList(theParams.keySet());
        }
        if (comboParam == null) {
            List candidateComboParams = this.mySearchParamRegistry.getActiveComboSearchParams(this.myResourceName);
            for (Object nextCandidate : candidateComboParams) {
                List nextCandidateParamNames = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)nextCandidate).stream().map(t -> t.getName()).collect(Collectors.toList());
                if (!theParams.keySet().containsAll(nextCandidateParamNames)) continue;
                comboParam = nextCandidate;
                comboParamNames = nextCandidateParamNames;
                break;
            }
        }
        if (comboParam != null) {
            theParams.values().forEach(nextAndList -> this.ensureSubListsAreWritable((List)nextAndList));
            StringBuilder sb = new StringBuilder();
            sb.append(this.myResourceName);
            sb.append("?");
            boolean first = true;
            Collections.sort(comboParamNames);
            for (String nextParamName : comboParamNames) {
                ReferenceParam param;
                List nextValues = theParams.get(nextParamName);
                if (nextValues.isEmpty()) {
                    ourLog.error("query parameter {} is unexpectedly empty. Encountered while considering {} index for {}", new Object[]{nextParamName, comboParam.getName(), theRequest.getCompleteUrl()});
                    sb = null;
                    break;
                }
                if (((List)nextValues.get(0)).size() != 1) {
                    sb = null;
                    break;
                }
                RuntimeSearchParam nextParamDef = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, nextParamName);
                if (nextParamDef.getParamType() == RestSearchParameterTypeEnum.REFERENCE && StringUtils.isBlank((CharSequence)(param = (ReferenceParam)((List)nextValues.get(0)).get(0)).getResourceType())) {
                    sb = null;
                    break;
                }
                List nextAnd = (List)nextValues.remove(0);
                IQueryParameterType nextOr = (IQueryParameterType)nextAnd.remove(0);
                String nextOrValue = nextOr.getValueAsQueryToken(this.myContext);
                if (comboParam.getComboSearchParamType() == ComboSearchParamType.NON_UNIQUE && nextParamDef.getParamType() == RestSearchParameterTypeEnum.STRING) {
                    nextOrValue = StringUtil.normalizeStringForSearchIndexing((String)nextOrValue);
                }
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                nextParamName = UrlUtil.escapeUrlParam((String)nextParamName);
                nextOrValue = UrlUtil.escapeUrlParam((String)nextOrValue);
                sb.append(nextParamName).append('=').append(nextOrValue);
            }
            if (sb != null) {
                String indexString = sb.toString();
                ourLog.debug("Checking for {} combo index for query: {}", (Object)comboParam.getComboSearchParamType(), (Object)indexString);
                StorageProcessingMessage msg = new StorageProcessingMessage().setMessage("Using " + comboParam.getComboSearchParamType() + " index for query for search: " + indexString);
                HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)msg);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
                switch (comboParam.getComboSearchParamType()) {
                    case UNIQUE: {
                        theQueryStack3.addPredicateCompositeUnique(indexString, this.myRequestPartitionId);
                        break;
                    }
                    case NON_UNIQUE: {
                        theQueryStack3.addPredicateCompositeNonUnique(indexString, this.myRequestPartitionId);
                    }
                }
                theParams.clean();
            }
        }
    }

    private <T> void ensureSubListsAreWritable(List<List<T>> theListOfLists) {
        for (int i = 0; i < theListOfLists.size(); ++i) {
            List<T> oldSubList = theListOfLists.get(i);
            if (oldSubList instanceof ArrayList) continue;
            ArrayList<T> newSubList = new ArrayList<T>(oldSubList);
            theListOfLists.set(i, newSubList);
        }
    }

    public void setFetchSize(int theFetchSize) {
        this.myFetchSize = theFetchSize;
    }

    public SearchParameterMap getParams() {
        return this.myParams;
    }

    public CriteriaBuilder getBuilder() {
        return this.myCriteriaBuilder;
    }

    public Class<? extends IBaseResource> getResourceType() {
        return this.myResourceType;
    }

    public String getResourceName() {
        return this.myResourceName;
    }

    public static int getMaximumPageSize() {
        if (myUseMaxPageSize50ForTest) {
            return 50;
        }
        return 800;
    }

    public static void setMaxPageSize50ForTest(boolean theIsTest) {
        myUseMaxPageSize50ForTest = theIsTest;
    }

    private final class QueryIterator
    extends BaseIterator<JpaPid>
    implements IResultIterator<JpaPid> {
        private final SearchRuntimeDetails mySearchRuntimeDetails;
        private final RequestDetails myRequest;
        private final boolean myHaveRawSqlHooks;
        private final boolean myHavePerfTraceFoundIdHook;
        private final SortSpec mySort;
        private final Integer myOffset;
        private boolean myFirst = true;
        private IncludesIterator myIncludesIterator;
        private JpaPid myNext;
        private ISearchQueryExecutor myResultsIterator;
        private boolean myFetchIncludesForEverythingOperation;
        private int mySkipCount = 0;
        private int myNonSkipCount = 0;
        private List<ISearchQueryExecutor> myQueryList = new ArrayList<ISearchQueryExecutor>();

        private QueryIterator(SearchRuntimeDetails theSearchRuntimeDetails, RequestDetails theRequest) {
            this.mySearchRuntimeDetails = theSearchRuntimeDetails;
            this.mySort = SearchBuilder.this.myParams.getSort();
            this.myOffset = SearchBuilder.this.myParams.getOffset();
            this.myRequest = theRequest;
            if (SearchBuilder.this.myParams.getEverythingMode() != null) {
                this.myFetchIncludesForEverythingOperation = true;
            }
            this.myHavePerfTraceFoundIdHook = CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FOUND_ID, (IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest);
            this.myHaveRawSqlHooks = CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest);
        }

        private void fetchNext() {
            HookParams params;
            try {
                if (this.myHaveRawSqlHooks) {
                    CurrentThreadCaptureQueriesListener.startCapturing();
                }
                if (this.myResultsIterator == null) {
                    if (SearchBuilder.this.myMaxResultsToFetch == null) {
                        SearchBuilder.this.myMaxResultsToFetch = SearchBuilder.this.myParams.getLoadSynchronousUpTo() != null ? SearchBuilder.this.myParams.getLoadSynchronousUpTo() : (SearchBuilder.this.myParams.getOffset() != null && SearchBuilder.this.myParams.getCount() != null ? SearchBuilder.this.myParams.getCount() : SearchBuilder.this.myStorageSettings.getFetchSizeDefaultMaximum());
                    }
                    this.initializeIteratorQuery(this.myOffset, SearchBuilder.this.myMaxResultsToFetch);
                }
                if (this.myNext == null) {
                    while (this.myResultsIterator.hasNext() || !this.myQueryList.isEmpty()) {
                        if (!this.myResultsIterator.hasNext()) {
                            this.retrieveNextIteratorQuery();
                            if (!this.myResultsIterator.hasNext()) break;
                        }
                        Long nextLong = (Long)this.myResultsIterator.next();
                        if (this.myHavePerfTraceFoundIdHook) {
                            HookParams params2 = new HookParams().add(Integer.class, (Object)System.identityHashCode(this)).add(Object.class, (Object)nextLong);
                            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FOUND_ID, (HookParams)params2);
                        }
                        if (nextLong != null) {
                            JpaPid next = JpaPid.fromId((Long)nextLong);
                            if (SearchBuilder.this.myPidSet.add(next)) {
                                this.myNext = next;
                                ++this.myNonSkipCount;
                                break;
                            }
                            ++this.mySkipCount;
                        }
                        if (this.myResultsIterator.hasNext() || SearchBuilder.this.myMaxResultsToFetch == null || this.mySkipCount + this.myNonSkipCount != SearchBuilder.this.myMaxResultsToFetch || this.mySkipCount <= 0 || this.myNonSkipCount != 0) continue;
                        this.sendProcessingMsgAndFirePerformanceHook();
                        SearchBuilder.this.myMaxResultsToFetch = SearchBuilder.this.myMaxResultsToFetch + 1000;
                        this.initializeIteratorQuery(this.myOffset, SearchBuilder.this.myMaxResultsToFetch);
                    }
                }
                if (this.myNext == null) {
                    if (this.myFetchIncludesForEverythingOperation) {
                        this.myIncludesIterator = new IncludesIterator(SearchBuilder.this.myPidSet, this.myRequest);
                        this.myFetchIncludesForEverythingOperation = false;
                    }
                    if (this.myIncludesIterator != null) {
                        while (this.myIncludesIterator.hasNext()) {
                            JpaPid next = this.myIncludesIterator.next();
                            if (next == null || !SearchBuilder.this.myPidSet.add(next)) continue;
                            this.myNext = next;
                            break;
                        }
                        if (this.myNext == null) {
                            this.myNext = NO_MORE;
                        }
                    } else {
                        this.myNext = NO_MORE;
                    }
                }
                this.mySearchRuntimeDetails.setFoundMatchesCount(SearchBuilder.this.myPidSet.size());
            }
            finally {
                if (this.myHaveRawSqlHooks) {
                    SearchBuilder.this.callRawSqlHookWithCurrentThreadQueries(this.myRequest);
                }
            }
            if (this.myFirst) {
                params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FIRST_RESULT_LOADED, (HookParams)params);
                this.myFirst = false;
            }
            if (NO_MORE.equals((Object)this.myNext)) {
                params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_SELECT_COMPLETE, (HookParams)params);
            }
        }

        private void sendProcessingMsgAndFirePerformanceHook() {
            StorageProcessingMessage message = new StorageProcessingMessage();
            String msg = "Pass completed with no matching results seeking rows " + SearchBuilder.this.myPidSet.size() + "-" + this.mySkipCount + ". This indicates an inefficient query! Retrying with new max count of " + SearchBuilder.this.myMaxResultsToFetch;
            ourLog.warn(msg);
            message.setMessage(msg);
            HookParams params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(StorageProcessingMessage.class, (Object)message);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_WARNING, (HookParams)params);
        }

        private void initializeIteratorQuery(Integer theOffset, Integer theMaxResultsToFetch) {
            if (this.myQueryList.isEmpty()) {
                this.mySearchRuntimeDetails.setQueryStopwatch(new StopWatch());
                this.myQueryList = SearchBuilder.this.createQuery(SearchBuilder.this.myParams, this.mySort, theOffset, theMaxResultsToFetch, false, this.myRequest, this.mySearchRuntimeDetails);
            }
            this.mySearchRuntimeDetails.setQueryStopwatch(new StopWatch());
            this.retrieveNextIteratorQuery();
            this.mySkipCount = 0;
            this.myNonSkipCount = 0;
        }

        private void retrieveNextIteratorQuery() {
            this.close();
            if (this.myQueryList != null && this.myQueryList.size() > 0) {
                this.myResultsIterator = this.myQueryList.remove(0);
                SearchBuilder.this.myHasNextIteratorQuery = true;
            } else {
                this.myResultsIterator = SearchQueryExecutor.emptyExecutor();
                SearchBuilder.this.myHasNextIteratorQuery = false;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.myNext == null) {
                this.fetchNext();
            }
            return !NO_MORE.equals((Object)this.myNext);
        }

        @Override
        public JpaPid next() {
            this.fetchNext();
            JpaPid retVal = this.myNext;
            this.myNext = null;
            Validate.isTrue((!NO_MORE.equals((Object)retVal) ? 1 : 0) != 0, (String)"No more elements", (Object[])new Object[0]);
            return retVal;
        }

        public int getSkippedCount() {
            return this.mySkipCount;
        }

        public int getNonSkippedCount() {
            return this.myNonSkipCount;
        }

        public Collection<JpaPid> getNextResultBatch(long theBatchSize) {
            ArrayList<JpaPid> batch = new ArrayList<JpaPid>();
            while (this.hasNext() && (long)batch.size() < theBatchSize) {
                batch.add(this.next());
            }
            return batch;
        }

        public void close() {
            if (this.myResultsIterator != null) {
                this.myResultsIterator.close();
            }
            this.myResultsIterator = null;
        }
    }

    public class IncludesIterator
    extends BaseIterator<JpaPid>
    implements Iterator<JpaPid> {
        private final RequestDetails myRequest;
        private final Set<JpaPid> myCurrentPids;
        private Iterator<JpaPid> myCurrentIterator;
        private JpaPid myNext;

        IncludesIterator(Set<JpaPid> thePidSet, RequestDetails theRequest) {
            this.myCurrentPids = new HashSet<JpaPid>(thePidSet);
            this.myCurrentIterator = null;
            this.myRequest = theRequest;
        }

        private void fetchNext() {
            while (this.myNext == null) {
                if (this.myCurrentIterator == null) {
                    HashSet<Include> includes = new HashSet<Include>();
                    if (SearchBuilder.this.myParams.containsKey("_type")) {
                        for (List typeList : SearchBuilder.this.myParams.get("_type")) {
                            for (IQueryParameterType type : typeList) {
                                String queryString = ParameterUtil.unescape((String)type.getValueAsQueryToken(SearchBuilder.this.myContext));
                                for (String resourceType : queryString.split(",")) {
                                    String rt = resourceType.trim();
                                    if (!StringUtils.isNotBlank((CharSequence)rt)) continue;
                                    includes.add(new Include(rt + ":*", true));
                                }
                            }
                        }
                    }
                    if (includes.isEmpty()) {
                        includes.add(new Include("*", true));
                    }
                    Set<JpaPid> newPids = SearchBuilder.this.loadIncludes(SearchBuilder.this.myContext, SearchBuilder.this.myEntityManager, this.myCurrentPids, includes, false, SearchBuilder.this.getParams().getLastUpdated(), SearchBuilder.this.mySearchUuid, this.myRequest, null);
                    this.myCurrentIterator = newPids.iterator();
                }
                if (this.myCurrentIterator.hasNext()) {
                    this.myNext = this.myCurrentIterator.next();
                    continue;
                }
                this.myNext = NO_MORE;
            }
        }

        @Override
        public boolean hasNext() {
            this.fetchNext();
            return !NO_MORE.equals((Object)this.myNext);
        }

        @Override
        public JpaPid next() {
            this.fetchNext();
            JpaPid retVal = this.myNext;
            this.myNext = null;
            return retVal;
        }
    }
}

