/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.DateUtils;
import com.google.common.annotations.VisibleForTesting;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DatePredicateBuilder
extends BaseSearchParamPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(DatePredicateBuilder.class);
    private final DbColumn myColumnValueHigh;
    private final DbColumn myColumnValueLow = this.getTable().addColumn("SP_VALUE_LOW");
    private final DbColumn myColumnValueLowDateOrdinal;
    private final DbColumn myColumnValueHighDateOrdinal;
    @Autowired
    private JpaStorageSettings myStorageSettings;

    public DatePredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_SPIDX_DATE"));
        this.myColumnValueHigh = this.getTable().addColumn("SP_VALUE_HIGH");
        this.myColumnValueLowDateOrdinal = this.getTable().addColumn("SP_VALUE_LOW_DATE_ORDINAL");
        this.myColumnValueHighDateOrdinal = this.getTable().addColumn("SP_VALUE_HIGH_DATE_ORDINAL");
    }

    @VisibleForTesting
    public void setStorageSettingsForUnitTest(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    public Condition createPredicateDateWithoutIdentityPredicate(IQueryParameterType theParam, SearchFilterParser.CompareOperation theOperation) {
        Condition p;
        if (theParam instanceof DateParam) {
            DateParam date = (DateParam)theParam;
            if (!date.isEmpty()) {
                if (theOperation == SearchFilterParser.CompareOperation.ne) {
                    date = new DateParam(ParamPrefixEnum.EQUAL, date.getValueAsString());
                }
                DateRangeParam range = new DateRangeParam(date);
                p = this.createPredicateDateFromRange(range, theOperation);
            } else {
                p = null;
            }
        } else if (theParam instanceof DateRangeParam) {
            DateRangeParam range = (DateRangeParam)theParam;
            p = this.createPredicateDateFromRange(range, theOperation);
        } else {
            throw new IllegalArgumentException(Msg.code((int)1251) + "Invalid token type: " + theParam.getClass());
        }
        return p;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Condition createPredicateDateFromRange(DateRangeParam theRange, SearchFilterParser.CompareOperation theOperation) {
        void var15_27;
        void var14_19;
        void var10_37;
        void var9_32;
        ColumnEnum highValueField;
        ColumnEnum lowValueField;
        Date lowerBoundInstant = theRange.getLowerBoundAsInstant();
        Date upperBoundInstant = theRange.getUpperBoundAsInstant();
        DateParam lowerBound = theRange.getLowerBound();
        DateParam upperBound = theRange.getUpperBound();
        Integer lowerBoundAsOrdinal = theRange.getLowerBoundAsDateInteger();
        Integer upperBoundAsOrdinal = theRange.getUpperBoundAsDateInteger();
        boolean isOrdinalComparison = this.isNullOrDatePrecision(lowerBound) && this.isNullOrDatePrecision(upperBound) && this.myStorageSettings.getUseOrdinalDatesForDayPrecisionSearches();
        Object var14_10 = null;
        Object var15_20 = null;
        if (isOrdinalComparison) {
            lowValueField = ColumnEnum.LOW_DATE_ORDINAL;
            highValueField = ColumnEnum.HIGH_DATE_ORDINAL;
            Integer n = lowerBoundAsOrdinal;
            Integer n2 = upperBoundAsOrdinal;
            if (upperBound != null && upperBound.getPrecision().ordinal() <= TemporalPrecisionEnum.MONTH.ordinal()) {
                Integer n3 = Integer.parseInt(((String)DateUtils.getCompletedDate((String)upperBound.getValueAsString()).getRight()).replace("-", ""));
            }
        } else {
            lowValueField = ColumnEnum.LOW;
            highValueField = ColumnEnum.HIGH;
            Date date = lowerBoundInstant;
            Date date2 = upperBoundInstant;
            if (upperBound != null && upperBound.getPrecision().ordinal() <= TemporalPrecisionEnum.MONTH.ordinal()) {
                String theCompleteDateStr = ((String)DateUtils.getCompletedDate((String)upperBound.getValueAsString()).getRight()).replace("-", "");
                Date date3 = DateUtils.parseDate((String)theCompleteDateStr);
            }
        }
        if (theOperation == SearchFilterParser.CompareOperation.lt || theOperation == SearchFilterParser.CompareOperation.le) {
            if (lowerBoundInstant != null) {
                Condition condition = this.createPredicate(lowValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, var9_32);
                if (this.myStorageSettings.isAccountForDateIndexNulls()) {
                    ComboCondition comboCondition = ComboCondition.or((Condition[])new Condition[]{condition, this.createPredicate(highValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, var9_32)});
                }
            } else {
                if (upperBoundInstant == null) throw new InvalidRequestException(Msg.code((int)1252) + "lowerBound and upperBound value not correctly specified for comparing " + theOperation);
                Condition condition = this.createPredicate(lowValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, var10_37);
                if (this.myStorageSettings.isAccountForDateIndexNulls()) {
                    ComboCondition comboCondition = ComboCondition.or((Condition[])new Condition[]{condition, this.createPredicate(highValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, var10_37)});
                }
            }
        } else if (theOperation == SearchFilterParser.CompareOperation.gt || theOperation == SearchFilterParser.CompareOperation.ge) {
            if (upperBoundInstant != null) {
                Condition condition = this.createPredicate(highValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, var10_37);
                if (this.myStorageSettings.isAccountForDateIndexNulls()) {
                    ComboCondition comboCondition = ComboCondition.or((Condition[])new Condition[]{condition, this.createPredicate(lowValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, var10_37)});
                }
            } else {
                if (lowerBoundInstant == null) throw new InvalidRequestException(Msg.code((int)1253) + "upperBound and lowerBound value not correctly specified for compare theOperation");
                Condition condition = this.createPredicate(highValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, var9_32);
                if (this.myStorageSettings.isAccountForDateIndexNulls()) {
                    ComboCondition comboCondition = ComboCondition.or((Condition[])new Condition[]{condition, this.createPredicate(lowValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, var9_32)});
                }
            }
        } else if (theOperation == SearchFilterParser.CompareOperation.ne) {
            if (lowerBoundInstant == null || upperBoundInstant == null) {
                throw new InvalidRequestException(Msg.code((int)1254) + "lowerBound and/or upperBound value not correctly specified for compare theOperation");
            }
            Condition lt = this.createPredicate(lowValueField, ParamPrefixEnum.LESSTHAN, var9_32);
            Condition gt = this.createPredicate(highValueField, ParamPrefixEnum.GREATERTHAN, var10_37);
            ComboCondition comboCondition = ComboCondition.or((Condition[])new Condition[]{lt, gt});
        } else {
            Condition lt;
            Condition gt;
            if (theOperation != SearchFilterParser.CompareOperation.eq && theOperation != SearchFilterParser.CompareOperation.sa && theOperation != SearchFilterParser.CompareOperation.eb && theOperation != null) throw new InvalidRequestException(Msg.code((int)1255) + String.format("Unsupported operator specified, operator=%s", theOperation.name()));
            if (lowerBoundInstant != null) {
                gt = this.createPredicate(lowValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, var9_32);
                lt = this.createPredicate(highValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, var9_32);
                if (lowerBound.getPrefix() == ParamPrefixEnum.STARTS_AFTER || lowerBound.getPrefix() == ParamPrefixEnum.EQUAL) {
                    Condition condition = gt;
                } else {
                    ComboCondition comboCondition = ComboCondition.or((Condition[])new Condition[]{gt, lt});
                }
            }
            if (upperBoundInstant != null) {
                gt = this.createPredicate(lowValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, var10_37);
                lt = this.createPredicate(highValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, var10_37);
                if (theRange.getUpperBound().getPrefix() == ParamPrefixEnum.ENDS_BEFORE || theRange.getUpperBound().getPrefix() == ParamPrefixEnum.EQUAL) {
                    Condition condition = lt;
                } else {
                    ComboCondition comboCondition = ComboCondition.or((Condition[])new Condition[]{gt, lt});
                }
            }
        }
        if (isOrdinalComparison) {
            ourLog.trace("Ordinal date range is {} - {} ", (Object)lowerBoundAsOrdinal, (Object)upperBoundAsOrdinal);
        } else {
            ourLog.trace("Date range is {} - {}", (Object)lowerBoundInstant, (Object)upperBoundInstant);
        }
        if (var14_19 != null && var15_27 != null) {
            return ComboCondition.and((Condition[])new Condition[]{var14_19, var15_27});
        }
        if (var14_19 == null) return var15_27;
        return var14_19;
    }

    public DbColumn getColumnValueLow() {
        return this.myColumnValueLow;
    }

    private boolean isNullOrDatePrecision(DateParam theDateParam) {
        return theDateParam == null || theDateParam.getPrecision().ordinal() <= TemporalPrecisionEnum.DAY.ordinal();
    }

    private Condition createPredicate(ColumnEnum theColumn, ParamPrefixEnum theComparator, Object theValue) {
        DbColumn column;
        switch (theColumn) {
            case LOW: {
                column = this.myColumnValueLow;
                break;
            }
            case LOW_DATE_ORDINAL: {
                column = this.myColumnValueLowDateOrdinal;
                break;
            }
            case HIGH: {
                column = this.myColumnValueHigh;
                break;
            }
            case HIGH_DATE_ORDINAL: {
                column = this.myColumnValueHighDateOrdinal;
                break;
            }
            default: {
                throw new IllegalArgumentException(Msg.code((int)1256));
            }
        }
        return this.createConditionForValueWithComparator(theComparator, column, theValue);
    }

    public static enum ColumnEnum {
        LOW,
        LOW_DATE_ORDINAL,
        HIGH,
        HIGH_DATE_ORDINAL;

    }
}

