/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.tasks;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.interceptor.JpaPreResourceAccessDetails;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchTaskParameters;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import ca.uhn.fhir.jpa.search.cache.ISearchResultCacheSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.jpa.util.SearchParameterMapCalculator;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.system.HapiSystemProperties;
import ca.uhn.fhir.util.AsyncUtil;
import ca.uhn.fhir.util.ICallable;
import ca.uhn.fhir.util.StopWatch;
import co.elastic.apm.api.ElasticApm;
import co.elastic.apm.api.Span;
import co.elastic.apm.api.Transaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;

public class SearchTask
implements Callable<Void> {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchTask.class);
    protected final HapiTransactionService myTxService;
    protected final FhirContext myContext;
    protected final ISearchResultCacheSvc mySearchResultCacheSvc;
    private final SearchParameterMap myParams;
    private final IDao myCallingDao;
    private final String myResourceType;
    private final ArrayList<JpaPid> mySyncedPids = new ArrayList();
    private final CountDownLatch myInitialCollectionLatch = new CountDownLatch(1);
    private final CountDownLatch myCompletionLatch;
    private final ArrayList<JpaPid> myUnsyncedPids = new ArrayList();
    private final RequestDetails myRequest;
    private final RequestPartitionId myRequestPartitionId;
    private final SearchRuntimeDetails mySearchRuntimeDetails;
    private final Transaction myParentTransaction;
    private final Consumer<String> myOnRemove;
    private final int mySyncSize;
    private final Integer myLoadingThrottleForUnitTests;
    private final IInterceptorBroadcaster myInterceptorBroadcaster;
    private final SearchBuilderFactory<JpaPid> mySearchBuilderFactory;
    private final JpaStorageSettings myStorageSettings;
    private final ISearchCacheSvc mySearchCacheSvc;
    private final IPagingProvider myPagingProvider;
    private Search mySearch;
    private boolean myAbortRequested;
    private int myCountSavedTotal = 0;
    private int myCountSavedThisPass = 0;
    private int myCountBlockedThisPass = 0;
    private boolean myAdditionalPrefetchThresholdsRemaining;
    private List<JpaPid> myPreviouslyAddedResourcePids;
    private Integer myMaxResultsToFetch;

    public SearchTask(SearchTaskParameters theCreationParams, HapiTransactionService theManagedTxManager, FhirContext theContext, IInterceptorBroadcaster theInterceptorBroadcaster, SearchBuilderFactory theSearchBuilderFactory, ISearchResultCacheSvc theSearchResultCacheSvc, JpaStorageSettings theStorageSettings, ISearchCacheSvc theSearchCacheSvc, IPagingProvider thePagingProvider) {
        this.myTxService = theManagedTxManager;
        this.myContext = theContext;
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
        this.mySearchBuilderFactory = theSearchBuilderFactory;
        this.mySearchResultCacheSvc = theSearchResultCacheSvc;
        this.myStorageSettings = theStorageSettings;
        this.mySearchCacheSvc = theSearchCacheSvc;
        this.myPagingProvider = thePagingProvider;
        this.myOnRemove = theCreationParams.OnRemove;
        this.mySearch = theCreationParams.Search;
        this.myCallingDao = theCreationParams.CallingDao;
        this.myParams = theCreationParams.Params;
        this.myResourceType = theCreationParams.ResourceType;
        this.myRequest = theCreationParams.Request;
        this.myCompletionLatch = new CountDownLatch(1);
        this.mySyncSize = theCreationParams.SyncSize;
        this.myLoadingThrottleForUnitTests = theCreationParams.getLoadingThrottleForUnitTests();
        this.mySearchRuntimeDetails = new SearchRuntimeDetails(this.myRequest, this.mySearch.getUuid());
        this.mySearchRuntimeDetails.setQueryString(this.myParams.toNormalizedQueryString(this.myCallingDao.getContext()));
        this.myRequestPartitionId = theCreationParams.RequestPartitionId;
        this.myParentTransaction = ElasticApm.currentTransaction();
    }

    protected RequestPartitionId getRequestPartitionId() {
        return this.myRequestPartitionId;
    }

    public Integer awaitInitialSync() {
        ourLog.trace("Awaiting initial sync");
        do {
            ourLog.trace("Search {} aborted: {}", (Object)this.getSearch().getUuid(), (Object)(!this.isNotAborted() ? 1 : 0));
        } while (!AsyncUtil.awaitLatchAndThrowInternalErrorExceptionOnInterrupt((CountDownLatch)this.getInitialCollectionLatch(), (long)250L, (TimeUnit)TimeUnit.MILLISECONDS) && this.getSearch().getStatus() == SearchStatusEnum.LOADING);
        ourLog.trace("Initial sync completed");
        return this.getSearch().getTotalCount();
    }

    public Search getSearch() {
        return this.mySearch;
    }

    public CountDownLatch getInitialCollectionLatch() {
        return this.myInitialCollectionLatch;
    }

    public void setPreviouslyAddedResourcePids(List<JpaPid> thePreviouslyAddedResourcePids) {
        this.myPreviouslyAddedResourcePids = thePreviouslyAddedResourcePids;
        this.myCountSavedTotal = this.myPreviouslyAddedResourcePids.size();
    }

    private ISearchBuilder newSearchBuilder() {
        Class resourceTypeClass = this.myContext.getResourceDefinition(this.myResourceType).getImplementingClass();
        return this.mySearchBuilderFactory.newSearchBuilder(this.myCallingDao, this.myResourceType, resourceTypeClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<JpaPid> getResourcePids(int theFromIndex, int theToIndex) {
        boolean keepWaiting;
        ourLog.debug("Requesting search PIDs from {}-{}", (Object)theFromIndex, (Object)theToIndex);
        do {
            ArrayList<JpaPid> arrayList = this.mySyncedPids;
            synchronized (arrayList) {
                boolean haveEnoughResults;
                ourLog.trace("Search status is {}", (Object)this.mySearch.getStatus());
                boolean bl = haveEnoughResults = this.mySyncedPids.size() >= theToIndex;
                if (!haveEnoughResults) {
                    switch (this.mySearch.getStatus()) {
                        case LOADING: {
                            keepWaiting = true;
                            break;
                        }
                        case PASSCMPLET: {
                            keepWaiting = false;
                            break;
                        }
                        default: {
                            keepWaiting = false;
                            break;
                        }
                    }
                } else {
                    keepWaiting = false;
                }
            }
            if (!keepWaiting) continue;
            ourLog.info("Waiting as we only have {} results - Search status: {}", (Object)this.mySyncedPids.size(), (Object)this.mySearch.getStatus());
            AsyncUtil.sleep((long)500L);
        } while (keepWaiting);
        ourLog.debug("Proceeding, as we have {} results", (Object)this.mySyncedPids.size());
        ArrayList<JpaPid> retVal = new ArrayList<JpaPid>();
        ArrayList<JpaPid> arrayList = this.mySyncedPids;
        synchronized (arrayList) {
            QueryParameterUtils.verifySearchHasntFailedOrThrowInternalErrorException(this.mySearch);
            int toIndex = theToIndex;
            if (this.mySyncedPids.size() < toIndex) {
                toIndex = this.mySyncedPids.size();
            }
            for (int i = theFromIndex; i < toIndex; ++i) {
                retVal.add(this.mySyncedPids.get(i));
            }
        }
        ourLog.trace("Done syncing results - Wanted {}-{} and returning {} of {}", new Object[]{theFromIndex, theToIndex, retVal.size(), this.mySyncedPids.size()});
        return retVal;
    }

    public void saveSearch() {
        this.myTxService.withRequest(this.myRequest).withRequestPartitionId(this.myRequestPartitionId).withPropagation(Propagation.REQUIRES_NEW).execute(() -> this.doSaveSearch());
    }

    private void saveUnsynced(IResultIterator theResultIter) {
        this.myTxService.withRequest(this.myRequest).withRequestPartitionId(this.myRequestPartitionId).execute(() -> {
            int numSynced;
            Object accessDetails;
            if (this.mySearch.getId() == null) {
                this.doSaveSearch();
            }
            ArrayList<JpaPid> unsyncedPids = this.myUnsyncedPids;
            int countBlocked = 0;
            if (this.mySearchRuntimeDetails.getRequestDetails() != null && !unsyncedPids.isEmpty()) {
                accessDetails = new JpaPreResourceAccessDetails(unsyncedPids, (ICallable<ISearchBuilder>)((ICallable)() -> this.newSearchBuilder()));
                HookParams params = new HookParams().add(IPreResourceAccessDetails.class, accessDetails).add(RequestDetails.class, (Object)this.mySearchRuntimeDetails.getRequestDetails()).addIfMatchesType(ServletRequestDetails.class, (Object)this.mySearchRuntimeDetails.getRequestDetails());
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
                for (int i = unsyncedPids.size() - 1; i >= 0; --i) {
                    if (!((JpaPreResourceAccessDetails)accessDetails).isDontReturnResourceAtIndex(i)) continue;
                    unsyncedPids.remove(i);
                    ++this.myCountBlockedThisPass;
                    ++this.myCountSavedTotal;
                    ++countBlocked;
                }
            }
            this.myCountSavedTotal += unsyncedPids.size();
            this.myCountSavedThisPass += unsyncedPids.size();
            this.mySearchResultCacheSvc.storeResults(this.mySearch, this.mySyncedPids, unsyncedPids, this.myRequest, this.getRequestPartitionId());
            accessDetails = this.mySyncedPids;
            synchronized (accessDetails) {
                int numSyncedThisPass = unsyncedPids.size();
                ourLog.trace("Syncing {} search results - Have more: {}", (Object)numSyncedThisPass, (Object)theResultIter.hasNext());
                this.mySyncedPids.addAll(unsyncedPids);
                unsyncedPids.clear();
                if (!theResultIter.hasNext()) {
                    int skippedCount = theResultIter.getSkippedCount();
                    ourLog.trace("MaxToFetch[{}] SkippedCount[{}] CountSavedThisPass[{}] CountSavedThisTotal[{}] AdditionalPrefetchRemaining[{}]", new Object[]{this.myMaxResultsToFetch, skippedCount, this.myCountSavedThisPass, this.myCountSavedTotal, this.myAdditionalPrefetchThresholdsRemaining});
                    if (this.isFinished(theResultIter)) {
                        ourLog.trace("Setting search status to FINISHED");
                        this.mySearch.setStatus(SearchStatusEnum.FINISHED);
                        this.mySearch.setTotalCount(this.myCountSavedTotal - countBlocked);
                    } else if (this.myAdditionalPrefetchThresholdsRemaining) {
                        ourLog.trace("Setting search status to PASSCMPLET");
                        this.mySearch.setStatus(SearchStatusEnum.PASSCMPLET);
                        this.mySearch.setSearchParameterMap(this.myParams);
                    } else {
                        ourLog.trace("Setting search status to FINISHED");
                        this.mySearch.setStatus(SearchStatusEnum.FINISHED);
                        this.mySearch.setTotalCount(this.myCountSavedTotal - countBlocked);
                    }
                }
            }
            this.mySearch.setNumFound(this.myCountSavedTotal);
            this.mySearch.setNumBlocked(this.mySearch.getNumBlocked() + countBlocked);
            ArrayList<JpaPid> arrayList = this.mySyncedPids;
            synchronized (arrayList) {
                numSynced = this.mySyncedPids.size();
            }
            if (this.myStorageSettings.getCountSearchResultsUpTo() == null || this.myStorageSettings.getCountSearchResultsUpTo() <= 0 || this.myStorageSettings.getCountSearchResultsUpTo() <= numSynced) {
                this.myInitialCollectionLatch.countDown();
            }
            this.doSaveSearch();
            ourLog.trace("saveUnsynced() - pre-commit");
        });
        ourLog.trace("saveUnsynced() - post-commit");
    }

    private boolean isFinished(IResultIterator theResultIter) {
        int skippedCount = theResultIter.getSkippedCount();
        int nonSkippedCount = theResultIter.getNonSkippedCount();
        int totalFetched = skippedCount + this.myCountSavedThisPass + this.myCountBlockedThisPass;
        if (this.myMaxResultsToFetch != null && totalFetched < this.myMaxResultsToFetch) {
            return true;
        }
        if (nonSkippedCount == 0) {
            if (this.myParams.getCount() != null) {
                return this.myParams.getCount() > totalFetched;
            }
            return true;
        }
        return false;
    }

    public boolean isNotAborted() {
        return !this.myAbortRequested;
    }

    public void markComplete() {
        this.myCompletionLatch.countDown();
    }

    public CountDownLatch getCompletionLatch() {
        return this.myCompletionLatch;
    }

    public void requestImmediateAbort() {
        this.myAbortRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() {
        StopWatch sw = new StopWatch();
        Span span = this.myParentTransaction.startSpan("db", "query", "search");
        span.setName("FHIR Database Search");
        try {
            this.saveSearch();
            this.myTxService.withRequest(this.myRequest).withRequestPartitionId(this.myRequestPartitionId).withIsolation(Isolation.READ_COMMITTED).execute(() -> this.doSearch());
            this.mySearchRuntimeDetails.setSearchStatus(this.mySearch.getStatus());
            if (this.mySearch.getStatus() == SearchStatusEnum.FINISHED) {
                HookParams params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_COMPLETE, (HookParams)params);
            } else {
                HookParams params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_PASS_COMPLETE, (HookParams)params);
            }
            ourLog.trace("Have completed search for [{}{}] and found {} resources in {}ms - Status is {}", new Object[]{this.mySearch.getResourceType(), this.mySearch.getSearchQueryString(), this.mySyncedPids.size(), sw.getMillis(), this.mySearch.getStatus()});
        }
        catch (Throwable t) {
            BaseServerResponseException exception;
            boolean logged = false;
            if (t instanceof BaseServerResponseException && (exception = (BaseServerResponseException)t).getStatusCode() >= 400 && exception.getStatusCode() < 500) {
                logged = true;
                ourLog.warn("Failed during search due to invalid request: {}", (Object)t.toString());
            }
            if (!logged) {
                ourLog.error("Failed during search loading after {}ms", (Object)sw.getMillis(), (Object)t);
            }
            this.myUnsyncedPids.clear();
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
            rootCause = (Throwable)ObjectUtils.defaultIfNull((Object)rootCause, (Object)t);
            Object failureMessage = rootCause.getMessage();
            int failureCode = 500;
            if (t instanceof BaseServerResponseException) {
                failureCode = ((BaseServerResponseException)t).getStatusCode();
            }
            if (HapiSystemProperties.isUnitTestCaptureStackEnabled()) {
                failureMessage = (String)failureMessage + "\nStack\n" + ExceptionUtils.getStackTrace((Throwable)rootCause);
            }
            this.mySearch.setFailureMessage((String)failureMessage);
            this.mySearch.setFailureCode(failureCode);
            this.mySearch.setStatus(SearchStatusEnum.FAILED);
            this.mySearchRuntimeDetails.setSearchStatus(this.mySearch.getStatus());
            HookParams params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FAILED, (HookParams)params);
            this.saveSearch();
            span.captureException(t);
        }
        finally {
            this.myOnRemove.accept(this.mySearch.getUuid());
            this.myInitialCollectionLatch.countDown();
            this.markComplete();
            span.end();
        }
        return null;
    }

    private void doSaveSearch() {
        Search newSearch = this.mySearchCacheSvc.save(this.mySearch, this.myRequestPartitionId);
        if (newSearch != null) {
            this.mySearch = newSearch;
        }
    }

    private void doSearch() {
        boolean myParamOrDefaultWantCount;
        boolean myParamWantOnlyCount = SearchParameterMapCalculator.isWantOnlyCount(this.myParams);
        boolean bl = myParamOrDefaultWantCount = Objects.nonNull(this.myParams.getSearchTotalMode()) ? SearchParameterMapCalculator.isWantCount(this.myParams) : SearchParameterMapCalculator.isWantCount(this.myStorageSettings.getDefaultTotalMode());
        if (myParamWantOnlyCount || myParamOrDefaultWantCount) {
            this.doCountOnlyQuery(myParamWantOnlyCount);
            if (myParamWantOnlyCount) {
                return;
            }
        }
        ourLog.trace("Done count");
        ISearchBuilder sb = this.newSearchBuilder();
        int currentlyLoaded = (Integer)ObjectUtils.defaultIfNull((Object)this.mySearch.getNumFound(), (Object)0);
        int minWanted = 0;
        if (this.myParams.getCount() != null) {
            minWanted = Math.min(this.myParams.getCount(), this.myPagingProvider.getMaximumPageSize());
            minWanted += currentlyLoaded;
        }
        Iterator iter = this.myStorageSettings.getSearchPreFetchThresholds().iterator();
        while (iter.hasNext()) {
            int next = (Integer)iter.next();
            if (next != -1 && next <= currentlyLoaded) continue;
            if (next == -1) {
                sb.setMaxResultsToFetch(null);
            } else {
                this.myMaxResultsToFetch = Math.max(next, minWanted);
                sb.setMaxResultsToFetch(Integer.valueOf(this.myMaxResultsToFetch + 1));
            }
            if (!iter.hasNext()) break;
            this.myAdditionalPrefetchThresholdsRemaining = true;
            break;
        }
        if (this.myPreviouslyAddedResourcePids != null) {
            sb.setPreviouslyAddedResourcePids(this.myPreviouslyAddedResourcePids);
            this.mySyncedPids.addAll(this.myPreviouslyAddedResourcePids);
        }
        try (IResultIterator resultIterator = sb.createQuery(this.myParams, this.mySearchRuntimeDetails, this.myRequest, this.myRequestPartitionId);){
            assert (resultIterator != null);
            int syncSize = this.mySyncSize;
            while (resultIterator.hasNext()) {
                boolean shouldSync;
                this.myUnsyncedPids.add((JpaPid)resultIterator.next());
                boolean bl2 = shouldSync = this.myUnsyncedPids.size() >= syncSize;
                if (this.myStorageSettings.getCountSearchResultsUpTo() != null && this.myStorageSettings.getCountSearchResultsUpTo() > 0 && this.myStorageSettings.getCountSearchResultsUpTo() < this.myUnsyncedPids.size()) {
                    shouldSync = false;
                }
                if (this.myUnsyncedPids.size() > 50000) {
                    shouldSync = true;
                }
                Validate.isTrue((boolean)this.isNotAborted(), (String)"Abort has been requested", (Object[])new Object[0]);
                if (shouldSync) {
                    this.saveUnsynced(resultIterator);
                }
                if (this.myLoadingThrottleForUnitTests == null) continue;
                AsyncUtil.sleep((long)this.myLoadingThrottleForUnitTests.intValue());
            }
            Validate.isTrue((boolean)this.isNotAborted(), (String)"Abort has been requested", (Object[])new Object[0]);
            this.saveUnsynced(resultIterator);
        }
        catch (IOException e) {
            ourLog.error("IO failure during database access", (Throwable)e);
            throw new InternalErrorException(Msg.code((int)1166) + e);
        }
    }

    private void doCountOnlyQuery(boolean theParamWantOnlyCount) {
        ourLog.trace("Performing count");
        ISearchBuilder sb = this.newSearchBuilder();
        Long count = sb.createCountQuery(this.myParams.clone(), this.mySearch.getUuid(), this.myRequest, this.myRequestPartitionId);
        ourLog.trace("Got count {}", (Object)count);
        this.myTxService.withRequest(this.myRequest).withRequestPartitionId(this.myRequestPartitionId).execute(() -> {
            this.mySearch.setTotalCount(count.intValue());
            if (theParamWantOnlyCount) {
                this.mySearch.setStatus(SearchStatusEnum.FINISHED);
            }
            this.doSaveSearch();
        });
    }
}

