/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.cache;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.data.ISearchResultDao;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchResult;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.search.SearchCoordinatorSvcImpl;
import ca.uhn.fhir.jpa.search.cache.ISearchResultCacheSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;

public class DatabaseSearchResultCacheSvcImpl
implements ISearchResultCacheSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(DatabaseSearchResultCacheSvcImpl.class);
    @Autowired
    private ISearchResultDao mySearchResultDao;
    @Autowired
    private IHapiTransactionService myTransactionService;

    @Override
    public List<JpaPid> fetchResultPids(Search theSearch, int theFrom, int theTo, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        return (List)this.myTransactionService.withRequest(theRequestDetails).withRequestPartitionId(theRequestPartitionId).execute(() -> {
            Pageable page = SearchCoordinatorSvcImpl.toPage(theFrom, theTo);
            if (page == null) {
                return Collections.emptyList();
            }
            List retVal = this.mySearchResultDao.findWithSearchPid(theSearch.getId(), page).getContent();
            ourLog.debug("fetchResultPids for range {}-{} returned {} pids", new Object[]{theFrom, theTo, retVal.size()});
            return JpaPid.fromLongList((Collection)retVal);
        });
    }

    @Override
    public List<JpaPid> fetchAllResultPids(Search theSearch, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        return (List)this.myTransactionService.withRequest(theRequestDetails).withRequestPartitionId(theRequestPartitionId).execute(() -> {
            List<Long> retVal = this.mySearchResultDao.findWithSearchPidOrderIndependent(theSearch.getId());
            ourLog.trace("fetchAllResultPids returned {} pids", (Object)retVal.size());
            return JpaPid.fromLongList(retVal);
        });
    }

    @Override
    public void storeResults(Search theSearch, List<JpaPid> thePreviouslyStoredResourcePids, List<JpaPid> theNewResourcePids, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        this.myTransactionService.withRequest(theRequestDetails).withRequestPartitionId(theRequestPartitionId).execute(() -> {
            ArrayList resultsToSave = Lists.newArrayList();
            ourLog.debug("Storing {} results with {} previous for search", (Object)theNewResourcePids.size(), (Object)thePreviouslyStoredResourcePids.size());
            int order = thePreviouslyStoredResourcePids.size();
            for (JpaPid nextPid : theNewResourcePids) {
                SearchResult nextResult = new SearchResult(theSearch);
                nextResult.setResourcePid(nextPid.getId());
                nextResult.setOrder(order);
                resultsToSave.add(nextResult);
                ourLog.trace("Saving ORDER[{}] Resource {}", (Object)order, (Object)nextResult.getResourcePid());
                ++order;
            }
            this.mySearchResultDao.saveAll(resultsToSave);
        });
    }
}

