/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.reindex;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.ReindexOutcome;
import ca.uhn.fhir.jpa.api.dao.ReindexParameters;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.IJpaStorageResourceParser;
import ca.uhn.fhir.jpa.dao.index.DaoSearchParamSynchronizer;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BaseResourceIndexedSearchParam;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboStringUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedComboTokenNonUnique;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamCoords;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamDate;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamNumber;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantity;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamQuantityNormalized;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamToken;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresentEntity;
import ca.uhn.fhir.jpa.partition.BaseRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.search.reindex.IInstanceReindexService;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.extractor.SearchParamExtractorService;
import ca.uhn.fhir.narrative.CustomThymeleafNarrativeGenerator;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.springframework.beans.factory.annotation.Autowired;

public class InstanceReindexServiceImpl
implements IInstanceReindexService {
    private final FhirContext myContextR4 = FhirContext.forR4Cached();
    @Autowired
    protected IJpaStorageResourceParser myJpaStorageResourceParser;
    @Autowired
    private SearchParamExtractorService mySearchParamExtractorService;
    @Autowired
    private BaseRequestPartitionHelperSvc myPartitionHelperSvc;
    @Autowired
    private IHapiTransactionService myTransactionService;
    @Autowired
    private IInterceptorService myInterceptorService;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private VersionCanonicalizer myVersionCanonicalizer;
    @Autowired
    private PartitionSettings myPartitionSettings;
    private final CustomThymeleafNarrativeGenerator myNarrativeGenerator = new CustomThymeleafNarrativeGenerator(new String[]{"classpath:ca/uhn/fhir/jpa/search/reindex/reindex-outcome-narrative.properties"});
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;

    @Override
    public IBaseParameters reindexDryRun(RequestDetails theRequestDetails, IIdType theResourceId, @Nullable Set<String> theParameters) {
        RequestPartitionId partitionId = this.determinePartition(theRequestDetails, theResourceId);
        TransactionDetails transactionDetails = new TransactionDetails();
        Parameters retValCanonical = (Parameters)this.myTransactionService.withRequest(theRequestDetails).withTransactionDetails(transactionDetails).withRequestPartitionId(partitionId).execute(() -> this.reindexDryRunInTransaction(theRequestDetails, theResourceId, partitionId, transactionDetails, theParameters));
        return this.myVersionCanonicalizer.parametersFromCanonical(retValCanonical);
    }

    @Override
    public IBaseParameters reindex(RequestDetails theRequestDetails, IIdType theResourceId) {
        RequestPartitionId partitionId = this.determinePartition(theRequestDetails, theResourceId);
        TransactionDetails transactionDetails = new TransactionDetails();
        Parameters retValCanonical = (Parameters)this.myTransactionService.withRequest(theRequestDetails).withTransactionDetails(transactionDetails).withRequestPartitionId(partitionId).execute(() -> this.reindexInTransaction(theRequestDetails, theResourceId));
        return this.myVersionCanonicalizer.parametersFromCanonical(retValCanonical);
    }

    @Nonnull
    private Parameters reindexInTransaction(RequestDetails theRequestDetails, IIdType theResourceId) {
        StopWatch sw = new StopWatch();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceId.getResourceType());
        ResourceTable entity = (ResourceTable)dao.readEntity(theResourceId, theRequestDetails);
        IBaseResource resource = this.myJpaStorageResourceParser.toResource((IBasePersistedResource)entity, false);
        BaseHapiFhirResourceDao.invokeStoragePreAccessResources((IInterceptorBroadcaster)this.myInterceptorService, theRequestDetails, theResourceId, resource);
        BaseHapiFhirResourceDao.invokeStoragePreShowResources((IInterceptorBroadcaster)this.myInterceptorService, theRequestDetails, resource);
        ResourceIndexedSearchParams existingParamsToPopulate = new ResourceIndexedSearchParams(entity);
        existingParamsToPopulate.mySearchParamPresentEntities.addAll(entity.getSearchParamPresents());
        ArrayList<String> messages = new ArrayList<String>();
        JpaPid pid = JpaPid.fromId((Long)entity.getId());
        ReindexOutcome outcome = dao.reindex((IResourcePersistentId)pid, new ReindexParameters(), theRequestDetails, new TransactionDetails());
        messages.add("Reindex completed in " + sw);
        for (String next : outcome.getWarnings()) {
            messages.add("WARNING: " + next);
        }
        ResourceIndexedSearchParams newParamsToPopulate = new ResourceIndexedSearchParams(entity);
        newParamsToPopulate.mySearchParamPresentEntities.addAll(entity.getSearchParamPresents());
        return this.buildIndexResponse(existingParamsToPopulate, newParamsToPopulate, true, messages);
    }

    @Nonnull
    private Parameters reindexDryRunInTransaction(RequestDetails theRequestDetails, IIdType theResourceId, RequestPartitionId theRequestPartitionId, TransactionDetails theTransactionDetails, Set<String> theParameters) {
        boolean showAction;
        ResourceIndexedSearchParams existingParamsToPopulate;
        StopWatch sw = new StopWatch();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceId.getResourceType());
        ResourceTable entity = (ResourceTable)dao.readEntity(theResourceId, theRequestDetails);
        IBaseResource resource = this.myJpaStorageResourceParser.toResource((IBasePersistedResource)entity, false);
        BaseHapiFhirResourceDao.invokeStoragePreAccessResources((IInterceptorBroadcaster)this.myInterceptorService, theRequestDetails, theResourceId, resource);
        BaseHapiFhirResourceDao.invokeStoragePreShowResources((IInterceptorBroadcaster)this.myInterceptorService, theRequestDetails, resource);
        ISearchParamExtractor.ISearchParamFilter searchParamFilter = ISearchParamExtractor.ALL_PARAMS;
        if (theParameters != null) {
            searchParamFilter = params -> params.stream().filter(t -> theParameters.contains(t.getName())).collect(Collectors.toSet());
        }
        ResourceIndexedSearchParams newParamsToPopulate = new ResourceIndexedSearchParams();
        this.mySearchParamExtractorService.extractFromResource(theRequestPartitionId, theRequestDetails, newParamsToPopulate, new ResourceIndexedSearchParams(), entity, resource, theTransactionDetails, false, searchParamFilter);
        if (theParameters == null) {
            existingParamsToPopulate = new ResourceIndexedSearchParams(entity);
            existingParamsToPopulate.mySearchParamPresentEntities.addAll(entity.getSearchParamPresents());
            this.fillInParamNames(entity, existingParamsToPopulate.mySearchParamPresentEntities, theResourceId.getResourceType());
            showAction = true;
        } else {
            existingParamsToPopulate = new ResourceIndexedSearchParams();
            showAction = false;
        }
        String message = "Reindex dry-run completed in " + sw + ". No changes were committed to any stored data.";
        return this.buildIndexResponse(existingParamsToPopulate, newParamsToPopulate, showAction, List.of(message));
    }

    @Nonnull
    private RequestPartitionId determinePartition(RequestDetails theRequestDetails, IIdType theResourceId) {
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forRead((IIdType)theResourceId);
        return this.myPartitionHelperSvc.determineReadPartitionForRequest(theRequestDetails, details);
    }

    @Nonnull
    @VisibleForTesting
    Parameters buildIndexResponse(ResourceIndexedSearchParams theExistingParams, ResourceIndexedSearchParams theNewParams, boolean theShowAction, List<String> theMessages) {
        Parameters parameters = new Parameters();
        Parameters.ParametersParameterComponent narrativeParameter = parameters.addParameter();
        narrativeParameter.setName("Narrative");
        for (String next : theMessages) {
            parameters.addParameter("Message", (Type)new StringType(next));
        }
        InstanceReindexServiceImpl.addParamsNonMissing(parameters, "CoordinateIndexes", "Coords", theExistingParams.myCoordsParams, theNewParams.myCoordsParams, new CoordsParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsNonMissing(parameters, "DateIndexes", "Date", theExistingParams.myDateParams, theNewParams.myDateParams, new DateParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsNonMissing(parameters, "NumberIndexes", "Number", theExistingParams.myNumberParams, theNewParams.myNumberParams, new NumberParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsNonMissing(parameters, "QuantityIndexes", "Quantity", theExistingParams.myQuantityParams, theNewParams.myQuantityParams, new QuantityParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsNonMissing(parameters, "QuantityIndexes", "QuantityNormalized", theExistingParams.myQuantityNormalizedParams, theNewParams.myQuantityNormalizedParams, new QuantityNormalizedParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsNonMissing(parameters, "UriIndexes", "Uri", theExistingParams.myUriParams, theNewParams.myUriParams, new UriParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsNonMissing(parameters, "StringIndexes", "String", theExistingParams.myStringParams, theNewParams.myStringParams, new StringParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsNonMissing(parameters, "TokenIndexes", "Token", theExistingParams.myTokenParams, theNewParams.myTokenParams, new TokenParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParams(parameters, "ResourceLinks", "Reference", InstanceReindexServiceImpl.normalizeLinks(theExistingParams.myLinks), InstanceReindexServiceImpl.normalizeLinks(theNewParams.myLinks), new ResourceLinkPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParams(parameters, "UniqueIndexes", "ComboStringUnique", theExistingParams.myComboStringUniques, theNewParams.myComboStringUniques, new ComboStringUniquePopulator(), theShowAction);
        InstanceReindexServiceImpl.addParams(parameters, "NonUniqueIndexes", "ComboTokenNonUnique", theExistingParams.myComboTokenNonUnique, theNewParams.myComboTokenNonUnique, new ComboTokenNonUniquePopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsMissing(parameters, "Coords", theExistingParams.myCoordsParams, theNewParams.myCoordsParams, new MissingIndexParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsMissing(parameters, "Date", theExistingParams.myDateParams, theNewParams.myDateParams, new MissingIndexParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsMissing(parameters, "Number", theExistingParams.myNumberParams, theNewParams.myNumberParams, new MissingIndexParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsMissing(parameters, "Quantity", theExistingParams.myQuantityParams, theNewParams.myQuantityParams, new MissingIndexParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsMissing(parameters, "QuantityNormalized", theExistingParams.myQuantityNormalizedParams, theNewParams.myQuantityNormalizedParams, new MissingIndexParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsMissing(parameters, "Uri", theExistingParams.myUriParams, theNewParams.myUriParams, new MissingIndexParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsMissing(parameters, "String", theExistingParams.myStringParams, theNewParams.myStringParams, new MissingIndexParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParamsMissing(parameters, "Token", theExistingParams.myTokenParams, theNewParams.myTokenParams, new MissingIndexParamPopulator(), theShowAction);
        InstanceReindexServiceImpl.addParams(parameters, "MissingIndexes", "Reference", theExistingParams.mySearchParamPresentEntities, theNewParams.mySearchParamPresentEntities, new SearchParamPresentParamPopulator(), theShowAction);
        String narrativeText = this.myNarrativeGenerator.generateResourceNarrative(this.myContextR4, (IBaseResource)parameters);
        narrativeParameter.setValue((Type)new StringType(narrativeText));
        return parameters;
    }

    private void fillInParamNames(ResourceTable theEntity, Collection<SearchParamPresentEntity> theTarget, String theResourceName) {
        HashMap<Long, String> hashes = new HashMap<Long, String>();
        ResourceSearchParams searchParams = this.mySearchParamRegistry.getActiveSearchParams(theResourceName);
        for (RuntimeSearchParam runtimeSearchParam : searchParams.values()) {
            hashes.put(SearchParamPresentEntity.calculateHashPresence((PartitionSettings)this.myPartitionSettings, (PartitionablePartitionId)theEntity.getPartitionId(), (String)theResourceName, (String)runtimeSearchParam.getName(), (Boolean)true), runtimeSearchParam.getName());
            hashes.put(SearchParamPresentEntity.calculateHashPresence((PartitionSettings)this.myPartitionSettings, (PartitionablePartitionId)theEntity.getPartitionId(), (String)theResourceName, (String)runtimeSearchParam.getName(), (Boolean)false), runtimeSearchParam.getName());
        }
        for (SearchParamPresentEntity searchParamPresentEntity : theTarget) {
            if (searchParamPresentEntity.getParamName() != null) continue;
            String name = (String)hashes.get(searchParamPresentEntity.getHashPresence());
            name = (String)StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)"(unknown)");
            searchParamPresentEntity.setParamName(name);
        }
    }

    private static List<ResourceLink> normalizeLinks(Collection<ResourceLink> theLinks) {
        return theLinks.stream().map(ResourceLink::cloneWithoutTargetPid).collect(Collectors.toList());
    }

    private static <T> void addParams(Parameters theParameters, String theSectionName, String theTypeName, Collection<T> theExistingParams, Collection<T> theNewParams, BaseParamPopulator<T> thePopulator, boolean theShowAction) {
        List<Object> addedParams = DaoSearchParamSynchronizer.subtract(theNewParams, theExistingParams);
        thePopulator.sort(addedParams);
        for (Iterator next : addedParams) {
            Parameters.ParametersParameterComponent parent = InstanceReindexServiceImpl.getOrCreateSection(theParameters, theSectionName);
            if (theShowAction) {
                thePopulator.addIndexValue(ActionEnum.ADD, parent, next, theTypeName);
                continue;
            }
            thePopulator.addIndexValue(ActionEnum.UNKNOWN, parent, next, theTypeName);
        }
        List removedParams = DaoSearchParamSynchronizer.subtract(theExistingParams, theNewParams);
        addedParams.sort(Comparator.comparing(thePopulator::toPartName));
        for (Object next : removedParams) {
            Parameters.ParametersParameterComponent parent = InstanceReindexServiceImpl.getOrCreateSection(theParameters, theSectionName);
            thePopulator.addIndexValue(ActionEnum.REMOVE, parent, next, theTypeName);
        }
        ArrayList unchangedParams = new ArrayList(CollectionUtils.intersection(theNewParams, theExistingParams));
        addedParams.sort(Comparator.comparing(thePopulator::toPartName));
        for (Object next : unchangedParams) {
            Parameters.ParametersParameterComponent parent = InstanceReindexServiceImpl.getOrCreateSection(theParameters, theSectionName);
            thePopulator.addIndexValue(ActionEnum.NO_CHANGE, parent, next, theTypeName);
        }
    }

    private static <T extends BaseResourceIndexedSearchParam> void addParamsNonMissing(Parameters theParameters, String theSectionName, String theTypeName, Collection<T> theExistingParams, Collection<T> theNewParams, BaseParamPopulator<T> thePopulator, boolean theShowAction) {
        Collection<T> existingParams = InstanceReindexServiceImpl.filterWantMissing(theExistingParams, false);
        Collection<T> newParams = InstanceReindexServiceImpl.filterWantMissing(theNewParams, false);
        InstanceReindexServiceImpl.addParams(theParameters, theSectionName, theTypeName, existingParams, newParams, thePopulator, theShowAction);
    }

    private static <T extends BaseResourceIndexedSearchParam> void addParamsMissing(Parameters theParameters, String theTypeName, Collection<T> theExistingParams, Collection<T> theNewParams, BaseParamPopulator<T> thePopulator, boolean theShowAction) {
        Collection<T> existingParams = InstanceReindexServiceImpl.filterWantMissing(theExistingParams, true);
        Collection<T> newParams = InstanceReindexServiceImpl.filterWantMissing(theNewParams, true);
        InstanceReindexServiceImpl.addParams(theParameters, "MissingIndexes", theTypeName, existingParams, newParams, thePopulator, theShowAction);
    }

    private static <T extends BaseResourceIndexedSearchParam> Collection<T> filterWantMissing(Collection<T> theNewParams, boolean theWantMissing) {
        return theNewParams.stream().filter(t -> t.isMissing() == theWantMissing).collect(Collectors.toList());
    }

    @Nonnull
    private static Parameters.ParametersParameterComponent getOrCreateSection(Parameters theParameters, String theSectionName) {
        Parameters.ParametersParameterComponent parent = theParameters.getParameter(theSectionName);
        if (parent == null) {
            parent = theParameters.addParameter();
            parent.setName(theSectionName);
        }
        return parent;
    }

    private static class CoordsParamPopulator
    extends BaseIndexParamPopulator<ResourceIndexedSearchParamCoords> {
        private CoordsParamPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, ResourceIndexedSearchParamCoords theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, theParam, theParamTypeName);
            retVal.addPart().setName("Latitude").setValue((Type)new DecimalType(theParam.getLatitude()));
            retVal.addPart().setName("Longitude").setValue((Type)new DecimalType(theParam.getLongitude()));
            return retVal;
        }
    }

    private static abstract class BaseParamPopulator<T> {
        private BaseParamPopulator() {
        }

        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, T theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = theParent.addPart().setName(this.toPartName(theParam));
            retVal.addPart().setName("Action").setValue((Type)new CodeType(theAction.name()));
            if (theParamTypeName != null) {
                retVal.addPart().setName("Type").setValue((Type)new CodeType(theParamTypeName));
            }
            return retVal;
        }

        protected abstract String toPartName(T var1);

        public void sort(List<T> theParams) {
            theParams.sort(Comparator.comparing(this::toPartName));
        }
    }

    private static class DateParamPopulator
    extends BaseIndexParamPopulator<ResourceIndexedSearchParamDate> {
        private DateParamPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, ResourceIndexedSearchParamDate theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, theParam, theParamTypeName);
            retVal.addPart().setName("High").setValue((Type)new InstantType(theParam.getValueHigh()));
            retVal.addPart().setName("Low").setValue((Type)new InstantType(theParam.getValueLow()));
            return retVal;
        }
    }

    private static class NumberParamPopulator
    extends BaseIndexParamPopulator<ResourceIndexedSearchParamNumber> {
        private NumberParamPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, ResourceIndexedSearchParamNumber theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, theParam, theParamTypeName);
            retVal.addPart().setName("Value").setValue((Type)new DecimalType(theParam.getValue()));
            return retVal;
        }
    }

    private static class QuantityParamPopulator
    extends BaseIndexParamPopulator<ResourceIndexedSearchParamQuantity> {
        private QuantityParamPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, ResourceIndexedSearchParamQuantity theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, theParam, theParamTypeName);
            retVal.addPart().setName("Value").setValue((Type)new DecimalType(theParam.getValue()));
            retVal.addPart().setName("System").setValue((Type)new UriType(theParam.getSystem()));
            retVal.addPart().setName("Units").setValue((Type)new CodeType(theParam.getUnits()));
            return retVal;
        }
    }

    private static class QuantityNormalizedParamPopulator
    extends BaseIndexParamPopulator<ResourceIndexedSearchParamQuantityNormalized> {
        private QuantityNormalizedParamPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, ResourceIndexedSearchParamQuantityNormalized theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, theParam, theParamTypeName);
            retVal.addPart().setName("Value").setValue((Type)new DecimalType(theParam.getValue().doubleValue()));
            retVal.addPart().setName("System").setValue((Type)new UriType(theParam.getSystem()));
            retVal.addPart().setName("Units").setValue((Type)new CodeType(theParam.getUnits()));
            return retVal;
        }
    }

    private static class UriParamPopulator
    extends BaseIndexParamPopulator<ResourceIndexedSearchParamUri> {
        private UriParamPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, ResourceIndexedSearchParamUri theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, theParam, theParamTypeName);
            retVal.addPart().setName("Value").setValue((Type)new UriType(theParam.getUri()));
            return retVal;
        }
    }

    private static class StringParamPopulator
    extends BaseIndexParamPopulator<ResourceIndexedSearchParamString> {
        private StringParamPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, ResourceIndexedSearchParamString theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, theParam, theParamTypeName);
            retVal.addPart().setName("ValueNormalized").setValue((Type)new StringType(theParam.getValueNormalized()));
            retVal.addPart().setName("ValueExact").setValue((Type)new StringType(theParam.getValueExact()));
            return retVal;
        }
    }

    private static class TokenParamPopulator
    extends BaseIndexParamPopulator<ResourceIndexedSearchParamToken> {
        private TokenParamPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, ResourceIndexedSearchParamToken theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, theParam, theParamTypeName);
            if (StringUtils.isNotBlank((CharSequence)theParam.getSystem())) {
                retVal.addPart().setName("System").setValue((Type)new StringType(theParam.getSystem()));
            }
            if (StringUtils.isNotBlank((CharSequence)theParam.getValue())) {
                retVal.addPart().setName("Value").setValue((Type)new StringType(theParam.getValue()));
            }
            return retVal;
        }
    }

    private static class ResourceLinkPopulator
    extends BaseParamPopulator<ResourceLink> {
        private ResourceLinkPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, ResourceLink theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, theParam, theParamTypeName);
            if (theParam.getTargetResourceId() != null) {
                retVal.addPart().setName("TargetId").setValue((Type)new StringType(theParam.getTargetResourceType() + "/" + theParam.getTargetResourceId()));
            } else if (theParam.getTargetResourceUrl() != null) {
                retVal.addPart().setName("TargetUrl").setValue((Type)new UrlType(theParam.getTargetResourceUrl()));
            }
            if (theParam.getTargetResourceVersion() != null) {
                retVal.addPart().setName("TargetVersion").setValue((Type)new StringType(theParam.getTargetResourceVersion().toString()));
            }
            return retVal;
        }

        @Override
        protected String toPartName(ResourceLink theParam) {
            return theParam.getSourcePath();
        }
    }

    private static class ComboStringUniquePopulator
    extends BaseParamPopulator<ResourceIndexedComboStringUnique> {
        private ComboStringUniquePopulator() {
        }

        @Override
        protected String toPartName(ResourceIndexedComboStringUnique theParam) {
            return theParam.getIndexString();
        }
    }

    private static class ComboTokenNonUniquePopulator
    extends BaseParamPopulator<ResourceIndexedComboTokenNonUnique> {
        private ComboTokenNonUniquePopulator() {
        }

        @Override
        protected String toPartName(ResourceIndexedComboTokenNonUnique theParam) {
            return theParam.getIndexString();
        }
    }

    private static class MissingIndexParamPopulator<T extends BaseResourceIndexedSearchParam>
    extends BaseIndexParamPopulator<T> {
        private MissingIndexParamPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, T theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, (Object)theParam, theParamTypeName);
            retVal.addPart().setName("Missing").setValue((Type)new BooleanType(theParam.isMissing()));
            return retVal;
        }
    }

    private static class SearchParamPresentParamPopulator
    extends BaseParamPopulator<SearchParamPresentEntity> {
        private SearchParamPresentParamPopulator() {
        }

        @Override
        @Nonnull
        public Parameters.ParametersParameterComponent addIndexValue(ActionEnum theAction, Parameters.ParametersParameterComponent theParent, SearchParamPresentEntity theParam, String theParamTypeName) {
            Parameters.ParametersParameterComponent retVal = super.addIndexValue(theAction, theParent, theParam, theParamTypeName);
            retVal.addPart().setName("Missing").setValue((Type)new BooleanType(!theParam.isPresent()));
            return retVal;
        }

        @Override
        protected String toPartName(SearchParamPresentEntity theParam) {
            return theParam.getParamName();
        }
    }

    private static enum ActionEnum {
        ADD,
        REMOVE,
        UNKNOWN,
        NO_CHANGE;

    }

    public static abstract class BaseIndexParamPopulator<T extends BaseResourceIndexedSearchParam>
    extends BaseParamPopulator<T> {
        @Override
        protected String toPartName(T theParam) {
            return theParam.getParamName();
        }
    }
}

