/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.warm;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.WarmCacheEntry;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.search.warm.ICacheWarmingSvc;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.util.UrlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CacheWarmingSvcImpl
implements ICacheWarmingSvc,
IHasScheduledJobs {
    private static final Logger ourLog = LoggerFactory.getLogger(CacheWarmingSvcImpl.class);
    @Autowired
    private JpaStorageSettings myStorageSettings;
    private Map<WarmCacheEntry, Long> myCacheEntryToNextRefresh = new LinkedHashMap<WarmCacheEntry, Long>();
    @Autowired
    private FhirContext myCtx;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private MatchUrlService myMatchUrlService;

    @Override
    public synchronized void performWarmingPass() {
        ourLog.trace("Starting cache warming pass for {} tasks", (Object)this.myCacheEntryToNextRefresh.size());
        for (WarmCacheEntry nextCacheEntry : new ArrayList<WarmCacheEntry>(this.myCacheEntryToNextRefresh.keySet())) {
            long nextRefresh = this.myCacheEntryToNextRefresh.get(nextCacheEntry);
            if (nextRefresh >= System.currentTimeMillis()) continue;
            this.refreshNow(nextCacheEntry);
            nextRefresh = nextCacheEntry.getPeriodMillis() + System.currentTimeMillis();
            this.myCacheEntryToNextRefresh.put(nextCacheEntry, nextRefresh);
        }
    }

    private void refreshNow(WarmCacheEntry theCacheEntry) {
        String nextUrl = theCacheEntry.getUrl();
        RuntimeResourceDefinition resourceDef = UrlUtil.parseUrlResourceType((FhirContext)this.myCtx, (String)nextUrl);
        IFhirResourceDao callingDao = this.myDaoRegistry.getResourceDao(resourceDef.getName());
        String queryPart = this.parseWarmUrlParamPart(nextUrl);
        SearchParameterMap responseCriteriaUrl = this.myMatchUrlService.translateMatchUrl(queryPart, resourceDef, new MatchUrlService.Flag[0]);
        callingDao.search(responseCriteriaUrl);
    }

    private String parseWarmUrlParamPart(String theNextUrl) {
        int paramIndex = theNextUrl.indexOf(63);
        if (paramIndex == -1) {
            throw new ConfigurationException(Msg.code((int)1172) + "Invalid warm cache URL (must have ? character)");
        }
        return theNextUrl.substring(paramIndex);
    }

    @PostConstruct
    public void start() {
        this.initCacheMap();
    }

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(this.getClass().getName());
        jobDetail.setJobClass(Job.class);
        theSchedulerService.scheduleClusteredJob(10000L, jobDetail);
    }

    public synchronized Set<WarmCacheEntry> initCacheMap() {
        this.myCacheEntryToNextRefresh.clear();
        List warmCacheEntries = this.myStorageSettings.getWarmCacheEntries();
        for (WarmCacheEntry next : warmCacheEntries) {
            this.parseWarmUrlParamPart(next.getUrl());
            UrlUtil.parseUrlResourceType((FhirContext)this.myCtx, (String)next.getUrl());
            this.myCacheEntryToNextRefresh.put(next, 0L);
        }
        return Collections.unmodifiableSet(this.myCacheEntryToNextRefresh.keySet());
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private ICacheWarmingSvc myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.performWarmingPass();
        }
    }
}

