/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.util.FhirVersionIndependentConcept;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.r4.model.ValueSet;

class ExpansionFilter {
    public static final ExpansionFilter NO_FILTER = new ExpansionFilter(null, null);
    private final String myCode;
    private final String mySystem;
    private final List<ValueSet.ConceptSetFilterComponent> myFilters;
    private final Integer myMaxCount;

    ExpansionFilter(String theSystem, String theCode) {
        this(theSystem, theCode, Collections.emptyList(), null);
    }

    ExpansionFilter(ExpansionFilter theExpansionFilter, List<ValueSet.ConceptSetFilterComponent> theFilters, Integer theMaxCount) {
        this(theExpansionFilter.getSystem(), theExpansionFilter.getCode(), theFilters, theMaxCount);
    }

    ExpansionFilter(@Nullable String theSystem, @Nullable String theCode, @Nonnull List<ValueSet.ConceptSetFilterComponent> theFilters, Integer theMaxCount) {
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)theSystem) == StringUtils.isNotBlank((CharSequence)theCode) ? 1 : 0) != 0);
        Validate.notNull(theFilters);
        this.mySystem = theSystem;
        this.myCode = theCode;
        this.myFilters = theFilters;
        this.myMaxCount = theMaxCount;
    }

    public List<ValueSet.ConceptSetFilterComponent> getFilters() {
        return this.myFilters;
    }

    boolean hasCode() {
        return this.myCode != null;
    }

    String getCode() {
        return this.myCode;
    }

    String getSystem() {
        return this.mySystem;
    }

    @Nonnull
    public FhirVersionIndependentConcept toFhirVersionIndependentConcept() {
        Validate.isTrue((boolean)this.hasCode());
        return new FhirVersionIndependentConcept(this.mySystem, this.myCode);
    }

    public Integer getMaxCount() {
        return this.myMaxCount;
    }

    @Nonnull
    public static ExpansionFilter fromFilterString(@Nullable String theFilter) {
        ExpansionFilter filter;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{theFilter})) {
            List<ValueSet.ConceptSetFilterComponent> filters = Collections.singletonList(new ValueSet.ConceptSetFilterComponent().setProperty("display").setOp(ValueSet.FilterOperator.EQUAL).setValue(theFilter));
            filter = new ExpansionFilter(null, null, filters, null);
        } else {
            filter = NO_FILTER;
        }
        return filter;
    }
}

