/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.term.api.ITermLoaderSvc;
import ca.uhn.fhir.jpa.util.LogicUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadedFileDescriptors
implements Closeable {
    private static final Logger ourLog = LoggerFactory.getLogger(LoadedFileDescriptors.class);
    private List<File> myTemporaryFiles = new ArrayList<File>();
    private List<ITermLoaderSvc.FileDescriptor> myUncompressedFileDescriptors = new ArrayList<ITermLoaderSvc.FileDescriptor>();

    LoadedFileDescriptors(List<ITermLoaderSvc.FileDescriptor> theFileDescriptors) {
        try {
            for (ITermLoaderSvc.FileDescriptor next : theFileDescriptors) {
                if (next.getFilename().toLowerCase().endsWith(".zip")) {
                    ourLog.info("Uncompressing {} into temporary files", (Object)next.getFilename());
                    InputStream inputStream = next.getInputStream();
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                        try {
                            ZipInputStream zis = new ZipInputStream(bufferedInputStream);
                            try {
                                ZipEntry nextEntry;
                                while ((nextEntry = zis.getNextEntry()) != null) {
                                    try (NonClosableBOMInputStream fis = new NonClosableBOMInputStream(zis);){
                                        final File nextTemporaryFile = File.createTempFile("hapifhir", ".tmp");
                                        ourLog.info("Creating temporary file: {}", (Object)nextTemporaryFile.getAbsolutePath());
                                        nextTemporaryFile.deleteOnExit();
                                        try (FileOutputStream fos = new FileOutputStream(nextTemporaryFile, false);){
                                            IOUtils.copy((InputStream)((Object)fis), (OutputStream)fos);
                                            final String nextEntryFileName = nextEntry.getName();
                                            this.myUncompressedFileDescriptors.add(new ITermLoaderSvc.FileDescriptor(){

                                                public String getFilename() {
                                                    return nextEntryFileName;
                                                }

                                                public InputStream getInputStream() {
                                                    try {
                                                        return new FileInputStream(nextTemporaryFile);
                                                    }
                                                    catch (FileNotFoundException e) {
                                                        throw new InternalErrorException(Msg.code((int)860) + e);
                                                    }
                                                }
                                            });
                                            this.myTemporaryFiles.add(nextTemporaryFile);
                                        }
                                    }
                                }
                                continue;
                            }
                            finally {
                                zis.close();
                                continue;
                            }
                        }
                        finally {
                            bufferedInputStream.close();
                            continue;
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        continue;
                    }
                }
                this.myUncompressedFileDescriptors.add(next);
            }
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code((int)861) + e);
        }
    }

    public boolean hasFile(String theFilename) {
        return this.myUncompressedFileDescriptors.stream().map(t -> t.getFilename().replaceAll(".*[\\\\/]", "")).anyMatch(t -> t.equals(theFilename));
    }

    @Override
    public void close() {
        for (File next : this.myTemporaryFiles) {
            ourLog.info("Deleting temporary file: {}", (Object)next.getAbsolutePath());
            FileUtils.deleteQuietly((File)next);
        }
    }

    List<ITermLoaderSvc.FileDescriptor> getUncompressedFileDescriptors() {
        return this.myUncompressedFileDescriptors;
    }

    private List<String> notFound(List<String> theExpectedFilenameFragments) {
        HashSet<String> foundFragments = new HashSet<String>();
        block0: for (String nextExpected : theExpectedFilenameFragments) {
            for (ITermLoaderSvc.FileDescriptor next : this.myUncompressedFileDescriptors) {
                if (!next.getFilename().contains(nextExpected)) continue;
                foundFragments.add(nextExpected);
                continue block0;
            }
        }
        ArrayList<String> notFoundFileNameFragments = new ArrayList<String>(theExpectedFilenameFragments);
        notFoundFileNameFragments.removeAll(foundFragments);
        return notFoundFileNameFragments;
    }

    void verifyMandatoryFilesExist(List<String> theExpectedFilenameFragments) {
        List<String> notFound = this.notFound(theExpectedFilenameFragments);
        if (!notFound.isEmpty()) {
            throw new UnprocessableEntityException(Msg.code((int)862) + "Could not find the following mandatory files in input: " + notFound);
        }
    }

    void verifyOptionalFilesExist(List<String> theExpectedFilenameFragments) {
        List<String> notFound = this.notFound(theExpectedFilenameFragments);
        if (!notFound.isEmpty()) {
            ourLog.warn("Could not find the following optional files: " + notFound);
        }
    }

    boolean isOptionalFilesExist(List<String> theFileList) {
        return this.notFound(theFileList).isEmpty();
    }

    void verifyPartLinkFilesExist(List<String> theMultiPartLinkFiles, String theSinglePartLinkFile) {
        boolean singlePartFilesFound;
        List<String> notFoundMulti = this.notFound(theMultiPartLinkFiles);
        List<String> notFoundSingle = this.notFound(Arrays.asList(theSinglePartLinkFile));
        boolean multiPartFilesFound = notFoundMulti.isEmpty();
        if (!LogicUtil.multiXor(multiPartFilesFound, singlePartFilesFound = notFoundSingle.isEmpty())) {
            String msg = !multiPartFilesFound && !singlePartFilesFound ? "Could not find any of the PartLink files: " + notFoundMulti + " nor " + notFoundSingle : "Only either the single PartLink file or the split PartLink files can be present. Found both the single PartLink file, " + theSinglePartLinkFile + ", and the split PartLink files: " + theMultiPartLinkFiles;
            throw new UnprocessableEntityException(Msg.code((int)863) + msg);
        }
    }

    private static class NonClosableBOMInputStream
    extends BOMInputStream {
        NonClosableBOMInputStream(InputStream theWrap) {
            super(theWrap);
        }

        public void close() {
        }
    }
}

