/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.dao.data.ITermCodeSystemDao;
import ca.uhn.fhir.jpa.dao.data.ITermCodeSystemVersionDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptDesignationDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptParentChildLinkDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptPropertyDao;
import ca.uhn.fhir.jpa.entity.TermCodeSystem;
import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptDesignation;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.TermConceptDaoSvc;
import ca.uhn.fhir.jpa.term.TermReadSvcImpl;
import ca.uhn.fhir.jpa.term.UploadStatistics;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.jpa.term.custom.CustomTerminologySet;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.util.ObjectUtil;
import ca.uhn.fhir.util.ValidateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TermCodeSystemStorageSvcImpl
implements ITermCodeSystemStorageSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(TermCodeSystemStorageSvcImpl.class);
    private static final Object PLACEHOLDER_OBJECT = new Object();
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    protected ITermCodeSystemDao myCodeSystemDao;
    @Autowired
    protected ITermCodeSystemVersionDao myCodeSystemVersionDao;
    @Autowired
    protected ITermConceptDao myConceptDao;
    @Autowired
    protected ITermConceptPropertyDao myConceptPropertyDao;
    @Autowired
    protected ITermConceptDesignationDao myConceptDesignationDao;
    @Autowired
    protected IIdHelperService<JpaPid> myIdHelperService;
    @Autowired
    private ITermConceptParentChildLinkDao myConceptParentChildLinkDao;
    @Autowired
    private ITermVersionAdapterSvc myTerminologyVersionAdapterSvc;
    @Autowired
    private ITermDeferredStorageSvc myDeferredStorageSvc;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private ITermReadSvc myTerminologySvc;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private IResourceTableDao myResourceTableDao;
    @Autowired
    private TermConceptDaoSvc myTermConceptDaoSvc;

    @Override
    @Transactional
    public UploadStatistics applyDeltaCodeSystemsAdd(String theSystem, CustomTerminologySet theAdditions) {
        ValidateUtil.isNotBlankOrThrowInvalidRequest((String)theSystem, (String)"No system provided");
        this.validateDstu3OrNewer();
        theAdditions.validateNoCycleOrThrowInvalidRequest();
        TermCodeSystem cs = this.myCodeSystemDao.findByCodeSystemUri(theSystem);
        if (cs == null) {
            CodeSystem codeSystemResource = new CodeSystem();
            codeSystemResource.setUrl(theSystem);
            codeSystemResource.setContent(CodeSystem.CodeSystemContentMode.NOTPRESENT);
            if (StringUtils.isBlank((CharSequence)codeSystemResource.getIdElement().getIdPart()) && theSystem.contains("loinc")) {
                codeSystemResource.setId("loinc");
            }
            this.myTerminologyVersionAdapterSvc.createOrUpdateCodeSystem(codeSystemResource);
            cs = this.myCodeSystemDao.findByCodeSystemUri(theSystem);
        }
        TermCodeSystemVersion csv = cs.getCurrentVersion();
        Validate.notNull((Object)csv);
        CodeSystem codeSystem = this.myTerminologySvc.fetchCanonicalCodeSystemFromCompleteContext(theSystem);
        if (codeSystem.getContent() != CodeSystem.CodeSystemContentMode.NOTPRESENT) {
            throw new InvalidRequestException(Msg.code((int)844) + "CodeSystem with url[" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "] can not apply a delta - wrong content mode: " + codeSystem.getContent());
        }
        Validate.notNull((Object)cs);
        Validate.notNull((Object)cs.getPid());
        IdDt codeSystemId = cs.getResource().getIdDt();
        UploadStatistics retVal = new UploadStatistics((IIdType)codeSystemId);
        HashMap<String, TermConcept> codeToConcept = new HashMap<String, TermConcept>();
        for (TermConcept nextRootConcept : theAdditions.getRootConcepts()) {
            List<String> parentCodes = Collections.emptyList();
            this.addConceptInHierarchy(csv, parentCodes, nextRootConcept, retVal, codeToConcept, 0);
        }
        return retVal;
    }

    @Override
    @Transactional
    public UploadStatistics applyDeltaCodeSystemsRemove(String theSystem, CustomTerminologySet theValue) {
        ValidateUtil.isNotBlankOrThrowInvalidRequest((String)theSystem, (String)"No system provided");
        this.validateDstu3OrNewer();
        TermCodeSystem cs = this.myCodeSystemDao.findByCodeSystemUri(theSystem);
        if (cs == null) {
            throw new InvalidRequestException(Msg.code((int)845) + "Unknown code system: " + theSystem);
        }
        IdDt target = cs.getResource().getIdDt();
        AtomicInteger removeCounter = new AtomicInteger(0);
        List collect = theValue.getRootConcepts().stream().map(val -> this.myTerminologySvc.findCode(theSystem, val.getCode())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Set allFoundTermConcepts = collect.stream().flatMap(concept -> this.flattenChildren((TermConcept)concept).stream()).map(suppliedTermConcept -> this.myTerminologySvc.findCode(theSystem, suppliedTermConcept.getCode())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        for (TermConcept code : allFoundTermConcepts) {
            this.deleteEverythingRelatedToConcept(code, removeCounter);
        }
        return new UploadStatistics(removeCounter.get(), (IIdType)target);
    }

    private void deleteEverythingRelatedToConcept(TermConcept theConcept, AtomicInteger theRemoveCounter) {
        for (TermConceptParentChildLink termConceptParentChildLink : theConcept.getParents()) {
            termConceptParentChildLink.getParent().getChildren().remove(termConceptParentChildLink);
            this.myConceptParentChildLinkDao.deleteById(termConceptParentChildLink.getId());
        }
        for (TermConceptParentChildLink termConceptParentChildLink : theConcept.getChildren()) {
            termConceptParentChildLink.getChild().getParents().remove(termConceptParentChildLink);
            this.myConceptParentChildLinkDao.deleteById(termConceptParentChildLink.getId());
        }
        for (TermConceptDesignation termConceptDesignation : theConcept.getDesignations()) {
            this.myConceptDesignationDao.deleteById(termConceptDesignation.getPid());
        }
        theConcept.getDesignations().clear();
        for (TermConceptProperty termConceptProperty : theConcept.getProperties()) {
            this.myConceptPropertyDao.deleteById(termConceptProperty.getPid());
        }
        theConcept.getProperties().clear();
        ourLog.info("Deleting concept {} - Code {}", (Object)theConcept.getId(), (Object)theConcept.getCode());
        this.myConceptDao.deleteById(theConcept.getId());
        theRemoveCounter.incrementAndGet();
    }

    private List<TermConcept> flattenChildren(TermConcept theTermConcept) {
        if (theTermConcept.getChildren().isEmpty()) {
            return Arrays.asList(theTermConcept);
        }
        List<TermConcept> childTermConcepts = theTermConcept.getChildren().stream().map(TermConceptParentChildLink::getChild).flatMap(childConcept -> this.flattenChildren((TermConcept)childConcept).stream()).collect(Collectors.toList());
        childTermConcepts.add(0, theTermConcept);
        return childTermConcepts;
    }

    @Override
    public int saveConcept(TermConcept theConcept) {
        return this.myTermConceptDaoSvc.saveConcept(theConcept);
    }

    @Override
    @Transactional(propagation=Propagation.MANDATORY)
    public void storeNewCodeSystemVersionIfNeeded(CodeSystem theCodeSystem, ResourceTable theResourceEntity, RequestDetails theRequestDetails) {
        if (theCodeSystem != null && StringUtils.isNotBlank((CharSequence)theCodeSystem.getUrl())) {
            String codeSystemUrl = theCodeSystem.getUrl();
            if (theCodeSystem.getContent() == CodeSystem.CodeSystemContentMode.COMPLETE || theCodeSystem.getContent() == null || theCodeSystem.getContent() == CodeSystem.CodeSystemContentMode.NOTPRESENT) {
                TermCodeSystemVersion codeSystemVersion;
                TermCodeSystem termCodeSystem;
                ourLog.info("CodeSystem {} has a status of {}, going to store concepts in terminology tables", (Object)theResourceEntity.getIdDt().getValue(), (Object)theCodeSystem.getContentElement().getValueAsString());
                Long pid = (Long)theCodeSystem.getUserData("RESOURCE_PID");
                assert (pid != null);
                JpaPid codeSystemResourcePid = JpaPid.fromId((Long)pid);
                if (theCodeSystem.getContent() == CodeSystem.CodeSystemContentMode.NOTPRESENT && (termCodeSystem = this.myCodeSystemDao.findByCodeSystemUri(theCodeSystem.getUrl())) != null && (codeSystemVersion = this.getExistingTermCodeSystemVersion(termCodeSystem.getPid(), theCodeSystem.getVersion())) != null) {
                    TermCodeSystem myCodeSystemEntity = this.getOrCreateDistinctTermCodeSystem((IResourcePersistentId)codeSystemResourcePid, theCodeSystem.getUrl(), theCodeSystem.getUrl(), theCodeSystem.getVersion(), theResourceEntity);
                    return;
                }
                TermCodeSystemVersion persCs = new TermCodeSystemVersion();
                this.populateCodeSystemVersionProperties(persCs, theCodeSystem, theResourceEntity);
                persCs.getConcepts().addAll(TermReadSvcImpl.toPersistedConcepts(theCodeSystem.getConcept(), persCs));
                ourLog.debug("Code system has {} concepts", (Object)persCs.getConcepts().size());
                this.storeNewCodeSystemVersion((IResourcePersistentId)codeSystemResourcePid, codeSystemUrl, theCodeSystem.getName(), theCodeSystem.getVersion(), persCs, theResourceEntity, theRequestDetails);
            }
        }
    }

    @Override
    @Transactional
    public IIdType storeNewCodeSystemVersion(CodeSystem theCodeSystemResource, TermCodeSystemVersion theCodeSystemVersion, RequestDetails theRequest, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps) {
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        Validate.notBlank((CharSequence)theCodeSystemResource.getUrl(), (String)"theCodeSystemResource must have a URL", (Object[])new Object[0]);
        IIdType csId = this.myTerminologyVersionAdapterSvc.createOrUpdateCodeSystem(theCodeSystemResource, theRequest);
        JpaPid codeSystemResourcePid = (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(RequestPartitionId.allPartitions(), csId.getResourceType(), csId.getIdPart());
        ResourceTable resource = (ResourceTable)this.myResourceTableDao.getOne(codeSystemResourcePid.getId());
        ourLog.info("CodeSystem resource has ID: {}", (Object)csId.getValue());
        this.populateCodeSystemVersionProperties(theCodeSystemVersion, theCodeSystemResource, resource);
        this.storeNewCodeSystemVersion((IResourcePersistentId)codeSystemResourcePid, theCodeSystemResource.getUrl(), theCodeSystemResource.getName(), theCodeSystemResource.getVersion(), theCodeSystemVersion, resource, theRequest);
        this.myDeferredStorageSvc.addConceptMapsToStorageQueue(theConceptMaps);
        this.myDeferredStorageSvc.addValueSetsToStorageQueue(theValueSets);
        return csId;
    }

    @Override
    @Transactional
    public void storeNewCodeSystemVersion(IResourcePersistentId theCodeSystemResourcePid, String theSystemUri, String theSystemName, String theCodeSystemVersionId, TermCodeSystemVersion theCodeSystemVersion, ResourceTable theCodeSystemResourceTable, RequestDetails theRequestDetails) {
        boolean isMakeVersionCurrent;
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        ourLog.debug("Storing code system");
        TermCodeSystemVersion codeSystemToStore = theCodeSystemVersion;
        ValidateUtil.isTrueOrThrowInvalidRequest((codeSystemToStore.getResource() != null ? 1 : 0) != 0, (String)"No resource supplied", (Object[])new Object[0]);
        ValidateUtil.isNotBlankOrThrowInvalidRequest((String)theSystemUri, (String)"No system URI supplied");
        TermCodeSystem codeSystem = this.getOrCreateDistinctTermCodeSystem(theCodeSystemResourcePid, theSystemUri, theSystemName, theCodeSystemVersionId, theCodeSystemResourceTable);
        List<TermCodeSystemVersion> existing = this.myCodeSystemVersionDao.findByCodeSystemResourcePid(((JpaPid)theCodeSystemResourcePid).getId());
        for (TermCodeSystemVersion next : existing) {
            if (Objects.equals(next.getCodeSystemVersionId(), theCodeSystemVersionId) && this.myConceptDao.countByCodeSystemVersion(next.getPid()) == 0) {
                next.setCodeSystemDisplayName(theSystemName);
                codeSystemToStore = next;
                continue;
            }
            next.setCodeSystemVersionId("DELETED_" + UUID.randomUUID().toString());
            this.myCodeSystemVersionDao.saveAndFlush(next);
            this.myDeferredStorageSvc.deleteCodeSystemVersion(next);
        }
        codeSystemToStore.setCodeSystem(codeSystem);
        codeSystemToStore.setCodeSystemDisplayName(theSystemName);
        codeSystemToStore.setCodeSystemVersionId(theCodeSystemVersionId);
        ourLog.debug("Validating all codes in CodeSystem for storage (this can take some time for large sets)");
        ArrayList<String> conceptsStack = new ArrayList<String>();
        IdentityHashMap<TermConcept, Object> allConcepts = new IdentityHashMap<TermConcept, Object>();
        int totalCodeCount = 0;
        Collection<TermConcept> conceptsToSave = theCodeSystemVersion.getConcepts();
        for (TermConcept termConcept : conceptsToSave) {
            totalCodeCount += this.validateConceptForStorage(termConcept, codeSystemToStore, conceptsStack, allConcepts);
        }
        ourLog.debug("Saving version containing {} concepts", (Object)totalCodeCount);
        if (codeSystemToStore.getPid() == null) {
            codeSystemToStore = (TermCodeSystemVersion)this.myCodeSystemVersionDao.saveAndFlush(codeSystemToStore);
        }
        if (isMakeVersionCurrent = ITermCodeSystemStorageSvc.isMakeVersionCurrent(theRequestDetails)) {
            codeSystem.setCurrentVersion(codeSystemToStore);
            if (codeSystem.getPid() == null) {
                codeSystem = (TermCodeSystem)this.myCodeSystemDao.saveAndFlush(codeSystem);
            }
        }
        ourLog.debug("Setting CodeSystemVersion[{}] on {} concepts...", (Object)codeSystem.getPid(), (Object)totalCodeCount);
        for (TermConcept next : conceptsToSave) {
            this.populateVersion(next, codeSystemToStore);
        }
        ourLog.debug("Saving {} concepts...", (Object)totalCodeCount);
        IdentityHashMap<TermConcept, Object> identityHashMap = new IdentityHashMap<TermConcept, Object>();
        for (TermConcept next : conceptsToSave) {
            this.persistChildren(next, codeSystemToStore, identityHashMap, totalCodeCount);
        }
        ourLog.debug("Done saving concepts, flushing to database");
        if (!this.myDeferredStorageSvc.isStorageQueueEmpty(true)) {
            ourLog.info("Note that some concept saving has been deferred");
        }
    }

    private TermCodeSystemVersion getExistingTermCodeSystemVersion(Long theCodeSystemVersionPid, String theCodeSystemVersion) {
        TermCodeSystemVersion existing = theCodeSystemVersion == null ? this.myCodeSystemVersionDao.findByCodeSystemPidVersionIsNull(theCodeSystemVersionPid) : this.myCodeSystemVersionDao.findByCodeSystemPidAndVersion(theCodeSystemVersionPid, theCodeSystemVersion);
        return existing;
    }

    private void validateDstu3OrNewer() {
        Validate.isTrue((boolean)this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3), (String)"Terminology operations only supported in DSTU3+ mode", (Object[])new Object[0]);
    }

    private void addConceptInHierarchy(TermCodeSystemVersion theCsv, Collection<String> theParentCodes, TermConcept theConceptToAdd, UploadStatistics theStatisticsTracker, Map<String, TermConcept> theCodeToConcept, int theSequence) {
        List<Object> existingParentLinks;
        TermConcept conceptToAdd = theConceptToAdd;
        List<TermConceptParentChildLink> childrenToAdd = theConceptToAdd.getChildren();
        String nextCodeToAdd = conceptToAdd.getCode();
        String parentDescription = "(root concept)";
        ourLog.info("Saving concept {} with parent {}", (Object)theStatisticsTracker.getUpdatedConceptCount(), (Object)parentDescription);
        Optional<TermConcept> existingCodeOpt = this.myConceptDao.findByCodeSystemAndCode(theCsv.getPid(), nextCodeToAdd);
        if (existingCodeOpt.isPresent()) {
            TermConcept existingCode = existingCodeOpt.get();
            existingCode.setIndexStatus(null);
            existingCode.setDisplay(conceptToAdd.getDisplay());
            conceptToAdd = existingCode;
            existingParentLinks = conceptToAdd.getParents();
        } else {
            existingParentLinks = Collections.emptyList();
        }
        HashSet<TermConcept> parentConceptsWeShouldLinkTo = new HashSet<TermConcept>();
        for (String nextParentCode : theParentCodes) {
            if (existingParentLinks.stream().anyMatch(t -> t.getParent().getCode().equals(nextParentCode))) continue;
            TermConcept nextParentOpt = theCodeToConcept.get(nextParentCode);
            if (nextParentOpt == null) {
                nextParentOpt = this.myConceptDao.findByCodeSystemAndCode(theCsv.getPid(), nextParentCode).orElse(null);
            }
            if (nextParentOpt == null) {
                throw new InvalidRequestException(Msg.code((int)846) + "Unable to add code \"" + nextCodeToAdd + "\" to unknown parent: " + nextParentCode);
            }
            parentConceptsWeShouldLinkTo.add(nextParentOpt);
        }
        if (conceptToAdd.getSequence() == null) {
            conceptToAdd.setSequence(theSequence);
        }
        conceptToAdd.setParentPids((String)null);
        conceptToAdd.setCodeSystemVersion(theCsv);
        if (conceptToAdd.getProperties() != null) {
            conceptToAdd.getProperties().forEach(termConceptProperty -> {
                termConceptProperty.setConcept(theConceptToAdd);
                termConceptProperty.setCodeSystemVersion(theCsv);
            });
        }
        if (theStatisticsTracker.getUpdatedConceptCount() <= this.myStorageSettings.getDeferIndexingForCodesystemsOfSize()) {
            this.saveConcept(conceptToAdd);
            Long nextConceptPid = conceptToAdd.getId();
            Validate.notNull((Object)nextConceptPid);
        } else {
            this.myDeferredStorageSvc.addConceptToStorageQueue(conceptToAdd);
        }
        theCodeToConcept.put(conceptToAdd.getCode(), conceptToAdd);
        theStatisticsTracker.incrementUpdatedConceptCount();
        for (TermConcept nextParentConcept : parentConceptsWeShouldLinkTo) {
            TermConceptParentChildLink parentLink = new TermConceptParentChildLink();
            parentLink.setParent(nextParentConcept);
            parentLink.setChild(conceptToAdd);
            parentLink.setCodeSystem(theCsv);
            parentLink.setRelationshipType(TermConceptParentChildLink.RelationshipTypeEnum.ISA);
            nextParentConcept.getChildren().add(parentLink);
            conceptToAdd.getParents().add(parentLink);
            ourLog.info("Saving parent/child link - Parent[{}] Child[{}]", (Object)parentLink.getParent().getCode(), (Object)parentLink.getChild().getCode());
            if (theStatisticsTracker.getUpdatedConceptCount() <= this.myStorageSettings.getDeferIndexingForCodesystemsOfSize()) {
                this.myConceptParentChildLinkDao.save(parentLink);
                continue;
            }
            this.myDeferredStorageSvc.addConceptLinkToStorageQueue(parentLink);
        }
        ourLog.trace("About to save parent-child links");
        int childIndex = 0;
        for (TermConceptParentChildLink nextChildConceptLink : new ArrayList<TermConceptParentChildLink>(childrenToAdd)) {
            TermConcept nextChild = nextChildConceptLink.getChild();
            for (int i = 0; i < nextChild.getParents().size(); ++i) {
                if (nextChild.getParents().get(i).getId() != null) continue;
                String parentCode = nextChild.getParents().get(i).getParent().getCode();
                TermConcept parentConcept = theCodeToConcept.get(parentCode);
                if (parentConcept == null) {
                    parentConcept = this.myConceptDao.findByCodeSystemAndCode(theCsv.getPid(), parentCode).orElse(null);
                }
                if (parentConcept == null) {
                    throw new IllegalArgumentException(Msg.code((int)847) + "Unknown parent code: " + parentCode);
                }
                nextChild.getParents().get(i).setParent(parentConcept);
            }
            Collection parentCodes = nextChild.getParents().stream().map(t -> t.getParent().getCode()).collect(Collectors.toList());
            this.addConceptInHierarchy(theCsv, parentCodes, nextChild, theStatisticsTracker, theCodeToConcept, childIndex);
            ++childIndex;
        }
    }

    private void persistChildren(TermConcept theConcept, TermCodeSystemVersion theCodeSystem, IdentityHashMap<TermConcept, Object> theConceptsStack, int theTotalConcepts) {
        if (theConceptsStack.put(theConcept, PLACEHOLDER_OBJECT) != null) {
            return;
        }
        if ((theConceptsStack.size() + 1) % 10000 == 0) {
            float pct = (float)theConceptsStack.size() / (float)theTotalConcepts;
            ourLog.info("Have processed {}/{} concepts ({}%)", new Object[]{theConceptsStack.size(), theTotalConcepts, (int)(pct * 100.0f)});
        }
        theConcept.setCodeSystemVersion(theCodeSystem);
        theConcept.setIndexStatus(1L);
        if (theConceptsStack.size() <= this.myStorageSettings.getDeferIndexingForCodesystemsOfSize()) {
            this.saveConcept(theConcept);
        } else {
            this.myDeferredStorageSvc.addConceptToStorageQueue(theConcept);
        }
        for (TermConceptParentChildLink next : theConcept.getChildren()) {
            this.persistChildren(next.getChild(), theCodeSystem, theConceptsStack, theTotalConcepts);
        }
        for (TermConceptParentChildLink next : theConcept.getChildren()) {
            if (theConceptsStack.size() <= this.myStorageSettings.getDeferIndexingForCodesystemsOfSize()) {
                this.saveConceptLink(next);
                continue;
            }
            this.myDeferredStorageSvc.addConceptLinkToStorageQueue(next);
        }
    }

    private void populateVersion(TermConcept theNext, TermCodeSystemVersion theCodeSystemVersion) {
        theNext.setCodeSystemVersion(theCodeSystemVersion);
        for (TermConceptParentChildLink next : theNext.getChildren()) {
            this.populateVersion(next.getChild(), theCodeSystemVersion);
        }
        theNext.getProperties().forEach(t -> t.setCodeSystemVersion(theCodeSystemVersion));
        theNext.getDesignations().forEach(t -> t.setCodeSystemVersion(theCodeSystemVersion));
    }

    private void saveConceptLink(TermConceptParentChildLink next) {
        if (next.getId() == null) {
            this.myConceptParentChildLinkDao.save(next);
        }
    }

    private int ensureParentsSaved(Collection<TermConceptParentChildLink> theParents) {
        ourLog.trace("Checking {} parents", (Object)theParents.size());
        int retVal = 0;
        for (TermConceptParentChildLink nextLink : theParents) {
            if (nextLink.getRelationshipType() != TermConceptParentChildLink.RelationshipTypeEnum.ISA) continue;
            TermConcept nextParent = nextLink.getParent();
            retVal += this.ensureParentsSaved(nextParent.getParents());
            if (nextParent.getId() != null) continue;
            nextParent.setUpdated(new Date());
            this.myConceptDao.saveAndFlush(nextParent);
            ++retVal;
            ourLog.debug("Saved parent code {} and got id {}", (Object)nextParent.getCode(), (Object)nextParent.getId());
        }
        return retVal;
    }

    @Nonnull
    private TermCodeSystem getOrCreateDistinctTermCodeSystem(IResourcePersistentId theCodeSystemResourcePid, String theSystemUri, String theSystemName, String theSystemVersionId, ResourceTable theCodeSystemResourceTable) {
        TermCodeSystem codeSystem = this.myCodeSystemDao.findByCodeSystemUri(theSystemUri);
        if (codeSystem == null) {
            codeSystem = this.myCodeSystemDao.findByResourcePid(((JpaPid)theCodeSystemResourcePid).getId());
            if (codeSystem == null) {
                codeSystem = new TermCodeSystem();
            }
        } else {
            this.checkForCodeSystemVersionDuplicate(codeSystem, theSystemUri, theSystemVersionId, theCodeSystemResourceTable);
        }
        codeSystem.setResource(theCodeSystemResourceTable);
        codeSystem.setCodeSystemUri(theSystemUri);
        codeSystem.setName(theSystemName);
        codeSystem = (TermCodeSystem)this.myCodeSystemDao.save(codeSystem);
        return codeSystem;
    }

    private void checkForCodeSystemVersionDuplicate(TermCodeSystem theCodeSystem, String theSystemUri, String theSystemVersionId, ResourceTable theCodeSystemResourceTable) {
        TermCodeSystemVersion codeSystemVersionEntity;
        String msg = null;
        if (theSystemVersionId == null) {
            codeSystemVersionEntity = this.myCodeSystemVersionDao.findByCodeSystemPidVersionIsNull(theCodeSystem.getPid());
            if (codeSystemVersionEntity != null) {
                msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "cannotCreateDuplicateCodeSystemUrl", new Object[]{theSystemUri, codeSystemVersionEntity.getResource().getIdDt().toUnqualifiedVersionless().getValue()});
            }
        } else {
            codeSystemVersionEntity = this.myCodeSystemVersionDao.findByCodeSystemPidAndVersion(theCodeSystem.getPid(), theSystemVersionId);
            if (codeSystemVersionEntity != null) {
                msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "cannotCreateDuplicateCodeSystemUrlAndVersion", new Object[]{theSystemUri, theSystemVersionId, codeSystemVersionEntity.getResource().getIdDt().toUnqualifiedVersionless().getValue()});
            }
        }
        if (codeSystemVersionEntity != null && !ObjectUtil.equals((Object)codeSystemVersionEntity.getResource().getId(), (Object)theCodeSystemResourceTable.getId())) {
            throw new UnprocessableEntityException(Msg.code((int)848) + msg);
        }
    }

    private void populateCodeSystemVersionProperties(TermCodeSystemVersion theCodeSystemVersion, CodeSystem theCodeSystemResource, ResourceTable theResourceTable) {
        theCodeSystemVersion.setResource(theResourceTable);
        theCodeSystemVersion.setCodeSystemDisplayName(theCodeSystemResource.getName());
        theCodeSystemVersion.setCodeSystemVersionId(theCodeSystemResource.getVersion());
    }

    private int validateConceptForStorage(TermConcept theConcept, TermCodeSystemVersion theCodeSystemVersion, ArrayList<String> theConceptsStack, IdentityHashMap<TermConcept, Object> theAllConcepts) {
        ValidateUtil.isTrueOrThrowInvalidRequest((theConcept.getCodeSystemVersion() != null ? 1 : 0) != 0, (String)"CodeSystemVersion is null", (Object[])new Object[0]);
        ValidateUtil.isNotBlankOrThrowInvalidRequest((String)theConcept.getCode(), (String)"CodeSystem contains a code with no code value");
        theConcept.setCodeSystemVersion(theCodeSystemVersion);
        if (theConceptsStack.contains(theConcept.getCode())) {
            throw new InvalidRequestException(Msg.code((int)849) + "CodeSystem contains circular reference around code " + theConcept.getCode());
        }
        theConceptsStack.add(theConcept.getCode());
        int retVal = 0;
        if (theAllConcepts.put(theConcept, theAllConcepts) == null) {
            if (theAllConcepts.size() % 1000 == 0) {
                ourLog.info("Have validated {} concepts", (Object)theAllConcepts.size());
            }
            retVal = 1;
        }
        for (TermConceptParentChildLink next : theConcept.getChildren()) {
            next.setCodeSystem(theCodeSystemVersion);
            retVal += this.validateConceptForStorage(next.getChild(), theCodeSystemVersion, theConceptsStack, theAllConcepts);
        }
        theConceptsStack.remove(theConceptsStack.size() - 1);
        return retVal;
    }
}

