/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.jpa.dao.data.ITermConceptDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptDesignationDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptPropertyDao;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptDesignation;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.term.TermCodeSystemStorageSvcImpl;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TermConceptDaoSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(TermCodeSystemStorageSvcImpl.class);
    @Autowired
    protected ITermConceptPropertyDao myConceptPropertyDao;
    @Autowired
    protected ITermConceptDao myConceptDao;
    @Autowired
    protected ITermConceptDesignationDao myConceptDesignationDao;

    public int saveConcept(TermConcept theConcept) {
        int retVal = 0;
        if (theConcept.getId() == null) {
            boolean needToSaveParents = false;
            for (TermConceptParentChildLink next : theConcept.getParents()) {
                if (next.getParent().getId() != null) continue;
                needToSaveParents = true;
                break;
            }
            if (needToSaveParents) {
                retVal += this.ensureParentsSaved(theConcept.getParents());
            }
        }
        if (theConcept.getId() == null || theConcept.getIndexStatus() == null) {
            ++retVal;
            theConcept.setIndexStatus(1L);
            theConcept.setUpdated(new Date());
            this.myConceptDao.save(theConcept);
            for (TermConceptProperty termConceptProperty : theConcept.getProperties()) {
                this.myConceptPropertyDao.save(termConceptProperty);
            }
            for (TermConceptDesignation termConceptDesignation : theConcept.getDesignations()) {
                this.myConceptDesignationDao.save(termConceptDesignation);
            }
        }
        ourLog.trace("Saved {} and got PID {}", (Object)theConcept.getCode(), (Object)theConcept.getId());
        return retVal;
    }

    private int ensureParentsSaved(Collection<TermConceptParentChildLink> theParents) {
        ourLog.trace("Checking {} parents", (Object)theParents.size());
        int retVal = 0;
        for (TermConceptParentChildLink nextLink : theParents) {
            if (nextLink.getRelationshipType() != TermConceptParentChildLink.RelationshipTypeEnum.ISA) continue;
            TermConcept nextParent = nextLink.getParent();
            retVal += this.ensureParentsSaved(nextParent.getParents());
            if (nextParent.getId() != null) continue;
            nextParent.setUpdated(new Date());
            this.myConceptDao.saveAndFlush(nextParent);
            ++retVal;
            ourLog.debug("Saved parent code {} and got id {}", (Object)nextParent.getCode(), (Object)nextParent.getId());
        }
        return retVal;
    }
}

