/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResult;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.model.TranslationQuery;
import ca.uhn.fhir.jpa.api.model.TranslationRequest;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.ITermConceptMapDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptMapGroupDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptMapGroupElementDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptMapGroupElementTargetDao;
import ca.uhn.fhir.jpa.entity.TermConceptMap;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroup;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElement;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElementTarget;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.TermReadSvcImpl;
import ca.uhn.fhir.jpa.term.api.ITermConceptMappingSvc;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.jpa.util.ScrollableResultsIterator;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.util.ValidateUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.query.Query;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class TermConceptMappingSvcImpl
implements ITermConceptMappingSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(TermConceptMappingSvcImpl.class);
    private static boolean ourLastResultsFromTranslationCache;
    private static boolean ourLastResultsFromTranslationWithReverseCache;
    private final int myFetchSize = 250;
    @Autowired
    protected ITermConceptMapDao myConceptMapDao;
    @Autowired
    protected ITermConceptMapGroupDao myConceptMapGroupDao;
    @Autowired
    protected ITermConceptMapGroupElementDao myConceptMapGroupElementDao;
    @Autowired
    protected ITermConceptMapGroupElementTargetDao myConceptMapGroupElementTargetDao;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    @Autowired
    private IIdHelperService<JpaPid> myIdHelperService;

    @Override
    @Transactional
    public void deleteConceptMapAndChildren(ResourceTable theResourceTable) {
        this.deleteConceptMap(theResourceTable);
    }

    public FhirContext getFhirContext() {
        return this.myContext;
    }

    @Transactional
    public TranslateConceptResults translateConcept(IValidationSupport.TranslateCodeRequest theRequest) {
        TranslationRequest request = TranslationRequest.fromTranslateCodeRequest((IValidationSupport.TranslateCodeRequest)theRequest);
        if (request.hasReverse() && request.getReverseAsBoolean()) {
            return this.translateWithReverse(request);
        }
        return this.translate(request);
    }

    @Override
    @Transactional
    public void storeTermConceptMapAndChildren(ResourceTable theResourceTable, ConceptMap theConceptMap) {
        String target;
        ValidateUtil.isTrueOrThrowInvalidRequest((theResourceTable != null ? 1 : 0) != 0, (String)"No resource supplied", (Object[])new Object[0]);
        if (TermReadSvcImpl.isPlaceholder((DomainResource)theConceptMap)) {
            ourLog.info("Not storing TermConceptMap for placeholder {}", (Object)theConceptMap.getIdElement().toVersionless().getValueAsString());
            return;
        }
        ValidateUtil.isNotBlankOrThrowUnprocessableEntity((String)theConceptMap.getUrl(), (String)"ConceptMap has no value for ConceptMap.url");
        ourLog.info("Storing TermConceptMap for {}", (Object)theConceptMap.getIdElement().toVersionless().getValueAsString());
        TermConceptMap termConceptMap = new TermConceptMap();
        termConceptMap.setResource(theResourceTable);
        termConceptMap.setUrl(theConceptMap.getUrl());
        termConceptMap.setVersion(theConceptMap.getVersion());
        String source = theConceptMap.hasSourceUriType() ? theConceptMap.getSourceUriType().getValueAsString() : null;
        String string = target = theConceptMap.hasTargetUriType() ? theConceptMap.getTargetUriType().getValueAsString() : null;
        if ("StructureDefinition".equals(new IdType(source).getResourceType()) || "StructureDefinition".equals(new IdType(target).getResourceType())) {
            return;
        }
        if (source == null && theConceptMap.hasSourceCanonicalType()) {
            source = theConceptMap.getSourceCanonicalType().getValueAsString();
        }
        if (target == null && theConceptMap.hasTargetCanonicalType()) {
            target = theConceptMap.getTargetCanonicalType().getValueAsString();
        }
        this.deleteConceptMap(theResourceTable);
        String conceptMapUrl = termConceptMap.getUrl();
        String conceptMapVersion = termConceptMap.getVersion();
        Optional<TermConceptMap> optionalExistingTermConceptMapByUrl = StringUtils.isBlank((CharSequence)conceptMapVersion) ? this.myConceptMapDao.findTermConceptMapByUrlAndNullVersion(conceptMapUrl) : this.myConceptMapDao.findTermConceptMapByUrlAndVersion(conceptMapUrl, conceptMapVersion);
        if (!optionalExistingTermConceptMapByUrl.isPresent()) {
            try {
                if (StringUtils.isNotBlank((CharSequence)source)) {
                    termConceptMap.setSource(source);
                }
                if (StringUtils.isNotBlank((CharSequence)target)) {
                    termConceptMap.setTarget(target);
                }
            }
            catch (FHIRException fe) {
                throw new InternalErrorException(Msg.code((int)837) + fe);
            }
            termConceptMap = (TermConceptMap)this.myConceptMapDao.save(termConceptMap);
            int codesSaved = 0;
            for (ConceptMap.ConceptMapGroupComponent group : theConceptMap.getGroup()) {
                String groupSource = group.getSource();
                if (StringUtils.isBlank((CharSequence)groupSource)) {
                    groupSource = source;
                }
                if (StringUtils.isBlank((CharSequence)groupSource)) {
                    throw new UnprocessableEntityException(Msg.code((int)838) + "ConceptMap[url='" + theConceptMap.getUrl() + "'] contains at least one group without a value in ConceptMap.group.source");
                }
                String groupTarget = group.getTarget();
                if (StringUtils.isBlank((CharSequence)groupTarget)) {
                    groupTarget = target;
                }
                if (StringUtils.isBlank((CharSequence)groupTarget)) {
                    throw new UnprocessableEntityException(Msg.code((int)839) + "ConceptMap[url='" + theConceptMap.getUrl() + "'] contains at least one group without a value in ConceptMap.group.target");
                }
                TermConceptMapGroup termConceptMapGroup = new TermConceptMapGroup();
                termConceptMapGroup.setConceptMap(termConceptMap);
                termConceptMapGroup.setSource(groupSource);
                termConceptMapGroup.setSourceVersion(group.getSourceVersion());
                termConceptMapGroup.setTarget(groupTarget);
                termConceptMapGroup.setTargetVersion(group.getTargetVersion());
                termConceptMap.getConceptMapGroups().add(termConceptMapGroup);
                termConceptMapGroup = (TermConceptMapGroup)this.myConceptMapGroupDao.save(termConceptMapGroup);
                if (!group.hasElement()) continue;
                for (ConceptMap.SourceElementComponent element : group.getElement()) {
                    if (StringUtils.isBlank((CharSequence)element.getCode())) continue;
                    TermConceptMapGroupElement termConceptMapGroupElement = new TermConceptMapGroupElement();
                    termConceptMapGroupElement.setConceptMapGroup(termConceptMapGroup);
                    termConceptMapGroupElement.setCode(element.getCode());
                    termConceptMapGroupElement.setDisplay(element.getDisplay());
                    termConceptMapGroup.getConceptMapGroupElements().add(termConceptMapGroupElement);
                    termConceptMapGroupElement = (TermConceptMapGroupElement)this.myConceptMapGroupElementDao.save(termConceptMapGroupElement);
                    if (!element.hasTarget()) continue;
                    for (ConceptMap.TargetElementComponent elementTarget : element.getTarget()) {
                        if (StringUtils.isBlank((CharSequence)elementTarget.getCode())) continue;
                        TermConceptMapGroupElementTarget termConceptMapGroupElementTarget = new TermConceptMapGroupElementTarget();
                        termConceptMapGroupElementTarget.setConceptMapGroupElement(termConceptMapGroupElement);
                        termConceptMapGroupElementTarget.setCode(elementTarget.getCode());
                        termConceptMapGroupElementTarget.setDisplay(elementTarget.getDisplay());
                        termConceptMapGroupElementTarget.setEquivalence(elementTarget.getEquivalence());
                        termConceptMapGroupElement.getConceptMapGroupElementTargets().add(termConceptMapGroupElementTarget);
                        this.myConceptMapGroupElementTargetDao.save(termConceptMapGroupElementTarget);
                        if (++codesSaved % 250 != 0) continue;
                        ourLog.info("Have saved {} codes in ConceptMap", (Object)codesSaved);
                        this.myConceptMapGroupElementTargetDao.flush();
                    }
                }
            }
        } else {
            TermConceptMap existingTermConceptMap = optionalExistingTermConceptMapByUrl.get();
            if (StringUtils.isBlank((CharSequence)conceptMapVersion)) {
                String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "cannotCreateDuplicateConceptMapUrl", new Object[]{conceptMapUrl, existingTermConceptMap.getResource().getIdDt().toUnqualifiedVersionless().getValue()});
                throw new UnprocessableEntityException(Msg.code((int)840) + msg);
            }
            String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "cannotCreateDuplicateConceptMapUrlAndVersion", new Object[]{conceptMapUrl, conceptMapVersion, existingTermConceptMap.getResource().getIdDt().toUnqualifiedVersionless().getValue()});
            throw new UnprocessableEntityException(Msg.code((int)841) + msg);
        }
        ourLog.info("Done storing TermConceptMap[{}] for {}", (Object)termConceptMap.getId(), (Object)theConceptMap.getIdElement().toVersionless().getValueAsString());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public TranslateConceptResults translate(TranslationRequest theTranslationRequest) {
        TranslateConceptResults retVal = new TranslateConceptResults();
        CriteriaBuilder criteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(TermConceptMapGroupElementTarget.class);
        Root root = query.from(TermConceptMapGroupElementTarget.class);
        Join elementJoin = root.join("myConceptMapGroupElement");
        Join groupJoin = elementJoin.join("myConceptMapGroup");
        Join conceptMapJoin = groupJoin.join("myConceptMap");
        List translationQueries = theTranslationRequest.getTranslationQueries();
        String latestConceptMapVersion = null;
        if (theTranslationRequest.hasUrl() && !theTranslationRequest.hasConceptMapVersion()) {
            latestConceptMapVersion = this.getLatestConceptMapVersion(theTranslationRequest);
        }
        for (TranslationQuery translationQuery : translationQueries) {
            List cachedTargets = (List)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.CONCEPT_TRANSLATION, (Object)translationQuery);
            if (cachedTargets == null) {
                ArrayList<TranslateConceptResult> targets = new ArrayList<TranslateConceptResult>();
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                Coding coding = translationQuery.getCoding();
                if (!coding.hasCode()) {
                    throw new InvalidRequestException(Msg.code((int)842) + "A code must be provided for translation to occur.");
                }
                predicates.add(criteriaBuilder.equal((Expression)elementJoin.get("myCode"), (Object)coding.getCode()));
                if (coding.hasSystem()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("mySource"), (Object)coding.getSystem()));
                }
                if (coding.hasVersion()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("mySourceVersion"), (Object)coding.getVersion()));
                }
                if (translationQuery.hasTargetSystem()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("myTarget"), (Object)translationQuery.getTargetSystem()));
                }
                if (translationQuery.hasUrl()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myUrl"), (Object)translationQuery.getUrl()));
                    if (translationQuery.hasConceptMapVersion()) {
                        predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myVersion"), (Object)translationQuery.getConceptMapVersion()));
                    } else if (StringUtils.isNotBlank((CharSequence)latestConceptMapVersion)) {
                        predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myVersion"), (Object)latestConceptMapVersion));
                    } else {
                        predicates.add(criteriaBuilder.isNull((Expression)conceptMapJoin.get("myVersion")));
                    }
                }
                if (translationQuery.hasSource()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("mySource"), (Object)translationQuery.getSource()));
                }
                if (translationQuery.hasTarget()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myTarget"), (Object)translationQuery.getTarget()));
                }
                if (translationQuery.hasResourceId()) {
                    IIdType resourceId = translationQuery.getResourceId();
                    JpaPid resourcePid = (JpaPid)this.myIdHelperService.getPidOrThrowException(RequestPartitionId.defaultPartition(), resourceId);
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myResourcePid"), (Object)resourcePid.getId()));
                }
                Predicate outerPredicate = criteriaBuilder.and(predicates.toArray(new Predicate[0]));
                query.where((Expression)outerPredicate);
                TypedQuery typedQuery = this.myEntityManager.createQuery(query.select((Selection)root));
                Query hibernateQuery = (Query)typedQuery;
                hibernateQuery.setFetchSize(250);
                ScrollableResults scrollableResults = hibernateQuery.scroll(ScrollMode.FORWARD_ONLY);
                try (ScrollableResultsIterator scrollableResultsIterator = new ScrollableResultsIterator(scrollableResults);){
                    HashSet<TermConceptMapGroupElementTarget> matches = new HashSet<TermConceptMapGroupElementTarget>();
                    while (scrollableResultsIterator.hasNext()) {
                        TermConceptMapGroupElementTarget next = (TermConceptMapGroupElementTarget)scrollableResultsIterator.next();
                        if (!matches.add(next)) continue;
                        TranslateConceptResult translationMatch = new TranslateConceptResult();
                        if (next.getEquivalence() != null) {
                            translationMatch.setEquivalence(next.getEquivalence().toCode());
                        }
                        translationMatch.setCode(next.getCode());
                        translationMatch.setSystem(next.getSystem());
                        translationMatch.setSystemVersion(next.getSystemVersion());
                        translationMatch.setDisplay(next.getDisplay());
                        translationMatch.setValueSet(next.getValueSet());
                        translationMatch.setSystemVersion(next.getSystemVersion());
                        translationMatch.setConceptMapUrl(next.getConceptMapUrl());
                        targets.add(translationMatch);
                    }
                }
                ourLastResultsFromTranslationCache = false;
                this.myMemoryCacheService.put(MemoryCacheService.CacheEnum.CONCEPT_TRANSLATION, (Object)translationQuery, targets);
                retVal.getResults().addAll(targets);
                continue;
            }
            ourLastResultsFromTranslationCache = true;
            retVal.getResults().addAll(cachedTargets);
        }
        this.buildTranslationResult(retVal);
        return retVal;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public TranslateConceptResults translateWithReverse(TranslationRequest theTranslationRequest) {
        TranslateConceptResults retVal = new TranslateConceptResults();
        CriteriaBuilder criteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(TermConceptMapGroupElement.class);
        Root root = query.from(TermConceptMapGroupElement.class);
        Join targetJoin = root.join("myConceptMapGroupElementTargets");
        Join groupJoin = root.join("myConceptMapGroup");
        Join conceptMapJoin = groupJoin.join("myConceptMap");
        List translationQueries = theTranslationRequest.getTranslationQueries();
        String latestConceptMapVersion = null;
        if (theTranslationRequest.hasUrl() && !theTranslationRequest.hasConceptMapVersion()) {
            latestConceptMapVersion = this.getLatestConceptMapVersion(theTranslationRequest);
        }
        for (TranslationQuery translationQuery : translationQueries) {
            List cachedElements = (List)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.CONCEPT_TRANSLATION_REVERSE, (Object)translationQuery);
            if (cachedElements == null) {
                ArrayList<TranslateConceptResult> elements = new ArrayList<TranslateConceptResult>();
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                Coding coding = translationQuery.getCoding();
                String targetCodeSystem = null;
                if (!coding.hasCode()) {
                    throw new InvalidRequestException(Msg.code((int)843) + "A code must be provided for translation to occur.");
                }
                predicates.add(criteriaBuilder.equal((Expression)targetJoin.get("myCode"), (Object)coding.getCode()));
                String targetCode = coding.getCode();
                if (coding.hasSystem()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("myTarget"), (Object)coding.getSystem()));
                    targetCodeSystem = coding.getSystem();
                }
                if (coding.hasVersion()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("myTargetVersion"), (Object)coding.getVersion()));
                }
                if (translationQuery.hasUrl()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myUrl"), (Object)translationQuery.getUrl()));
                    if (translationQuery.hasConceptMapVersion()) {
                        predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myVersion"), (Object)translationQuery.getConceptMapVersion()));
                    } else if (StringUtils.isNotBlank((CharSequence)latestConceptMapVersion)) {
                        predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myVersion"), (Object)latestConceptMapVersion));
                    } else {
                        predicates.add(criteriaBuilder.isNull((Expression)conceptMapJoin.get("myVersion")));
                    }
                }
                if (translationQuery.hasTargetSystem()) {
                    predicates.add(criteriaBuilder.equal((Expression)groupJoin.get("mySource"), (Object)translationQuery.getTargetSystem()));
                }
                if (translationQuery.hasSource()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myTarget"), (Object)translationQuery.getSource()));
                }
                if (translationQuery.hasTarget()) {
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("mySource"), (Object)translationQuery.getTarget()));
                }
                if (translationQuery.hasResourceId()) {
                    IIdType resourceId = translationQuery.getResourceId();
                    JpaPid resourcePid = (JpaPid)this.myIdHelperService.getPidOrThrowException(RequestPartitionId.defaultPartition(), resourceId);
                    predicates.add(criteriaBuilder.equal((Expression)conceptMapJoin.get("myResourcePid"), (Object)resourcePid.getId()));
                }
                Predicate outerPredicate = criteriaBuilder.and(predicates.toArray(new Predicate[0]));
                query.where((Expression)outerPredicate);
                TypedQuery typedQuery = this.myEntityManager.createQuery(query.select((Selection)root));
                Query hibernateQuery = (Query)typedQuery;
                hibernateQuery.setFetchSize(250);
                ScrollableResults scrollableResults = hibernateQuery.scroll(ScrollMode.FORWARD_ONLY);
                try (ScrollableResultsIterator scrollableResultsIterator = new ScrollableResultsIterator(scrollableResults);){
                    HashSet<TermConceptMapGroupElementTarget> matches = new HashSet<TermConceptMapGroupElementTarget>();
                    while (scrollableResultsIterator.hasNext()) {
                        TermConceptMapGroupElement nextElement = (TermConceptMapGroupElement)scrollableResultsIterator.next();
                        int size = nextElement.getConceptMapGroupElementTargets().size();
                        ourLog.trace("Have {} targets", (Object)size);
                        this.myEntityManager.detach((Object)nextElement);
                        if (!StringUtils.isNotBlank((CharSequence)targetCode)) continue;
                        for (TermConceptMapGroupElementTarget next : nextElement.getConceptMapGroupElementTargets()) {
                            if (!matches.add(next) || !StringUtils.isBlank((CharSequence)targetCodeSystem) && !StringUtils.equals((CharSequence)targetCodeSystem, (CharSequence)next.getSystem()) || !StringUtils.equals((CharSequence)targetCode, (CharSequence)next.getCode())) continue;
                            TranslateConceptResult translationMatch = new TranslateConceptResult();
                            translationMatch.setCode(nextElement.getCode());
                            translationMatch.setSystem(nextElement.getSystem());
                            translationMatch.setSystemVersion(nextElement.getSystemVersion());
                            translationMatch.setDisplay(nextElement.getDisplay());
                            translationMatch.setValueSet(nextElement.getValueSet());
                            translationMatch.setSystemVersion(nextElement.getSystemVersion());
                            translationMatch.setConceptMapUrl(nextElement.getConceptMapUrl());
                            if (next.getEquivalence() != null) {
                                translationMatch.setEquivalence(next.getEquivalence().toCode());
                            }
                            if (this.alreadyContainsMapping(elements, translationMatch) || this.alreadyContainsMapping(retVal.getResults(), translationMatch)) continue;
                            elements.add(translationMatch);
                        }
                    }
                }
                ourLastResultsFromTranslationWithReverseCache = false;
                this.myMemoryCacheService.put(MemoryCacheService.CacheEnum.CONCEPT_TRANSLATION_REVERSE, (Object)translationQuery, elements);
                retVal.getResults().addAll(elements);
                continue;
            }
            ourLastResultsFromTranslationWithReverseCache = true;
            retVal.getResults().addAll(cachedElements);
        }
        this.buildTranslationResult(retVal);
        return retVal;
    }

    private boolean alreadyContainsMapping(List<TranslateConceptResult> elements, TranslateConceptResult translationMatch) {
        for (TranslateConceptResult nextExistingElement : elements) {
            if (!StringUtils.equals((CharSequence)nextExistingElement.getSystem(), (CharSequence)translationMatch.getSystem()) || !StringUtils.equals((CharSequence)nextExistingElement.getSystemVersion(), (CharSequence)translationMatch.getSystemVersion()) || !StringUtils.equals((CharSequence)nextExistingElement.getCode(), (CharSequence)translationMatch.getCode())) continue;
            return true;
        }
        return false;
    }

    public void deleteConceptMap(ResourceTable theResourceTable) {
        Optional<TermConceptMap> optionalExistingTermConceptMapById = this.myConceptMapDao.findTermConceptMapByResourcePid(theResourceTable.getId());
        if (optionalExistingTermConceptMapById.isPresent()) {
            TermConceptMap existingTermConceptMap = optionalExistingTermConceptMapById.get();
            ourLog.info("Deleting existing TermConceptMap[{}] and its children...", (Object)existingTermConceptMap.getId());
            for (TermConceptMapGroup group : existingTermConceptMap.getConceptMapGroups()) {
                for (TermConceptMapGroupElement element : group.getConceptMapGroupElements()) {
                    for (TermConceptMapGroupElementTarget target : element.getConceptMapGroupElementTargets()) {
                        this.myConceptMapGroupElementTargetDao.deleteTermConceptMapGroupElementTargetById(target.getId());
                    }
                    this.myConceptMapGroupElementDao.deleteTermConceptMapGroupElementById(element.getId());
                }
                this.myConceptMapGroupDao.deleteTermConceptMapGroupById(group.getId());
            }
            this.myConceptMapDao.deleteTermConceptMapById(existingTermConceptMap.getId());
            ourLog.info("Done deleting existing TermConceptMap[{}] and its children.", (Object)existingTermConceptMap.getId());
        }
    }

    private String getLatestConceptMapVersion(TranslationRequest theTranslationRequest) {
        PageRequest page = PageRequest.of((int)0, (int)1);
        List<TermConceptMap> theConceptMapList = this.myConceptMapDao.getTermConceptMapEntitiesByUrlOrderByMostRecentUpdate((Pageable)page, theTranslationRequest.getUrl());
        if (!theConceptMapList.isEmpty()) {
            return theConceptMapList.get(0).getVersion();
        }
        return null;
    }

    private void buildTranslationResult(TranslateConceptResults theTranslationResult) {
        if (theTranslationResult.getResults().isEmpty()) {
            theTranslationResult.setResult(false);
            String msg = this.myContext.getLocalizer().getMessage(TermConceptMappingSvcImpl.class, "noMatchesFound", new Object[0]);
            theTranslationResult.setMessage(msg);
        } else {
            theTranslationResult.setResult(true);
            String msg = this.myContext.getLocalizer().getMessage(TermConceptMappingSvcImpl.class, "matchesFound", new Object[0]);
            theTranslationResult.setMessage(msg);
        }
    }

    @VisibleForTesting
    public static void clearOurLastResultsFromTranslationCache() {
        ourLastResultsFromTranslationCache = false;
    }

    @VisibleForTesting
    public static void clearOurLastResultsFromTranslationWithReverseCache() {
        ourLastResultsFromTranslationWithReverseCache = false;
    }

    @VisibleForTesting
    static boolean isOurLastResultsFromTranslationCache() {
        return ourLastResultsFromTranslationCache;
    }

    @VisibleForTesting
    static boolean isOurLastResultsFromTranslationWithReverseCache() {
        return ourLastResultsFromTranslationWithReverseCache;
    }

    public static Parameters toParameters(TranslateConceptResults theTranslationResult) {
        Parameters retVal = new Parameters();
        retVal.addParameter().setName("result").setValue((Type)new BooleanType(theTranslationResult.getResult()));
        if (theTranslationResult.getMessage() != null) {
            retVal.addParameter().setName("message").setValue((Type)new StringType(theTranslationResult.getMessage()));
        }
        for (TranslateConceptResult translationMatch : theTranslationResult.getResults()) {
            Parameters.ParametersParameterComponent matchParam = retVal.addParameter().setName("match");
            TermConceptMappingSvcImpl.populateTranslateMatchParts(translationMatch, matchParam);
        }
        return retVal;
    }

    private static void populateTranslateMatchParts(TranslateConceptResult theTranslationMatch, Parameters.ParametersParameterComponent theParam) {
        if (theTranslationMatch.getEquivalence() != null) {
            theParam.addPart().setName("equivalence").setValue((Type)new CodeType(theTranslationMatch.getEquivalence()));
        }
        if (StringUtils.isNotBlank((CharSequence)theTranslationMatch.getSystem()) || StringUtils.isNotBlank((CharSequence)theTranslationMatch.getCode()) || StringUtils.isNotBlank((CharSequence)theTranslationMatch.getDisplay())) {
            Coding value = new Coding(theTranslationMatch.getSystem(), theTranslationMatch.getCode(), theTranslationMatch.getDisplay());
            if (StringUtils.isNotBlank((CharSequence)theTranslationMatch.getSystemVersion())) {
                value.setVersion(theTranslationMatch.getSystemVersion());
            }
            theParam.addPart().setName("concept").setValue((Type)value);
        }
        if (StringUtils.isNotBlank((CharSequence)theTranslationMatch.getConceptMapUrl())) {
            theParam.addPart().setName("source").setValue((Type)new UriType(theTranslationMatch.getConceptMapUrl()));
        }
    }
}

