/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermReadSvcUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(TermReadSvcUtil.class);

    public static Optional<String> getValueSetId(String theUrl) {
        if (!theUrl.startsWith("http://loinc.org/vs")) {
            return Optional.empty();
        }
        if (!theUrl.startsWith("http://loinc.org/vs/")) {
            if (theUrl.equals("http://loinc.org/vs")) {
                return Optional.of("loinc-all");
            }
            ourLog.error("Don't know how to extract ValueSet's ForcedId from url: " + theUrl);
            return Optional.empty();
        }
        String forcedId = theUrl.substring("http://loinc.org/vs/".length());
        return StringUtils.isBlank((CharSequence)forcedId) ? Optional.empty() : Optional.of(forcedId);
    }

    public static boolean isLoincUnversionedValueSet(String theUrl) {
        boolean isLoincCodeSystem = StringUtils.containsIgnoreCase((CharSequence)theUrl, (CharSequence)"loinc");
        boolean isNoVersion = !theUrl.contains("|");
        return isLoincCodeSystem && isNoVersion;
    }

    public static boolean isLoincUnversionedCodeSystem(String theUrl) {
        boolean isLoincCodeSystem = StringUtils.containsIgnoreCase((CharSequence)theUrl, (CharSequence)"loinc");
        boolean isNoVersion = !theUrl.contains("|");
        return isLoincCodeSystem && isNoVersion;
    }
}

