/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.jpa.dao.data.ITermConceptDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptParentChildLinkDao;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.term.TermConceptDaoSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermReindexingSvc;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class TermReindexingSvcImpl
implements ITermReindexingSvc,
IHasScheduledJobs {
    private static final Logger ourLog = LoggerFactory.getLogger(TermReindexingSvcImpl.class);
    private static boolean ourForceSaveDeferredAlwaysForUnitTest;
    @Autowired
    protected ITermConceptDao myConceptDao;
    private ArrayListMultimap<Long, Long> myChildToParentPidCache;
    @Autowired
    private PlatformTransactionManager myTransactionMgr;
    @Autowired
    private ITermConceptParentChildLinkDao myConceptParentChildLinkDao;
    @Autowired
    private ITermDeferredStorageSvc myDeferredStorageSvc;
    @Autowired
    private TermConceptDaoSvc myTermConceptDaoSvc;

    @Override
    public void processReindexing() {
        if (!this.myDeferredStorageSvc.isStorageQueueEmpty(true) && !ourForceSaveDeferredAlwaysForUnitTest) {
            return;
        }
        TransactionTemplate tt = new TransactionTemplate(this.myTransactionMgr);
        tt.setPropagationBehavior(3);
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            private void createParentsString(StringBuilder theParentsBuilder, Long theConceptPid) {
                Validate.notNull((Object)theConceptPid, (String)"theConceptPid must not be null", (Object[])new Object[0]);
                List parents = TermReindexingSvcImpl.this.myChildToParentPidCache.get((Object)theConceptPid);
                if (parents.contains(-1L)) {
                    return;
                }
                if (parents.isEmpty()) {
                    Collection<Long> parentLinks = TermReindexingSvcImpl.this.myConceptParentChildLinkDao.findAllWithChild(theConceptPid);
                    if (parentLinks.isEmpty()) {
                        TermReindexingSvcImpl.this.myChildToParentPidCache.put((Object)theConceptPid, (Object)-1L);
                        ourLog.info("Found {} parent concepts of concept {} (cache has {})", new Object[]{0, theConceptPid, TermReindexingSvcImpl.this.myChildToParentPidCache.size()});
                        return;
                    }
                    for (Long next : parentLinks) {
                        TermReindexingSvcImpl.this.myChildToParentPidCache.put((Object)theConceptPid, (Object)next);
                    }
                    int parentCount = TermReindexingSvcImpl.this.myChildToParentPidCache.get((Object)theConceptPid).size();
                    ourLog.info("Found {} parent concepts of concept {} (cache has {})", new Object[]{parentCount, theConceptPid, TermReindexingSvcImpl.this.myChildToParentPidCache.size()});
                }
                for (Long nextParent : parents) {
                    if (theParentsBuilder.length() > 0) {
                        theParentsBuilder.append(' ');
                    }
                    theParentsBuilder.append(nextParent);
                    this.createParentsString(theParentsBuilder, nextParent);
                }
            }

            protected void doInTransactionWithoutResult(TransactionStatus theArg0) {
                int maxResult = 1000;
                Page<TermConcept> concepts = TermReindexingSvcImpl.this.myConceptDao.findResourcesRequiringReindexing((Pageable)PageRequest.of((int)0, (int)maxResult));
                if (!concepts.hasContent()) {
                    if (TermReindexingSvcImpl.this.myChildToParentPidCache != null) {
                        ourLog.info("Clearing parent concept cache");
                        TermReindexingSvcImpl.this.myChildToParentPidCache = null;
                    }
                    return;
                }
                if (TermReindexingSvcImpl.this.myChildToParentPidCache == null) {
                    TermReindexingSvcImpl.this.myChildToParentPidCache = ArrayListMultimap.create();
                }
                ourLog.info("Indexing {} / {} concepts", (Object)concepts.getContent().size(), (Object)concepts.getTotalElements());
                int count = 0;
                StopWatch stopwatch = new StopWatch();
                for (TermConcept nextConcept : concepts) {
                    if (StringUtils.isBlank((CharSequence)nextConcept.getParentPidsAsString())) {
                        StringBuilder parentsBuilder = new StringBuilder();
                        this.createParentsString(parentsBuilder, nextConcept.getId());
                        nextConcept.setParentPids(parentsBuilder.toString());
                    }
                    TermReindexingSvcImpl.this.myTermConceptDaoSvc.saveConcept(nextConcept);
                    ++count;
                }
                ourLog.info("Indexed {} / {} concepts in {}ms - Avg {}ms / resource", new Object[]{count, concepts.getContent().size(), stopwatch.getMillis(), stopwatch.getMillisPerOperation((long)count)});
            }
        });
    }

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        ScheduledJobDefinition jobDefinition = new ScheduledJobDefinition();
        jobDefinition.setId(this.getClass().getName());
        jobDefinition.setJobClass(Job.class);
        theSchedulerService.scheduleLocalJob(60000L, jobDefinition);
    }

    @VisibleForTesting
    public static void setForceSaveDeferredAlwaysForUnitTest(boolean theForceSaveDeferredAlwaysForUnitTest) {
        ourForceSaveDeferredAlwaysForUnitTest = theForceSaveDeferredAlwaysForUnitTest;
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private ITermReindexingSvc myTermReindexingSvc;

        public void execute(JobExecutionContext theContext) {
            this.myTermReindexingSvc.processReindexing();
        }
    }
}

