/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.term.BaseTermVersionAdapterSvcImpl;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.UrlUtil;
import java.security.InvalidParameterException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ValueSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

public class TermVersionAdapterSvcR4
extends BaseTermVersionAdapterSvcImpl
implements ITermVersionAdapterSvc {
    private IFhirResourceDao<ConceptMap> myConceptMapResourceDao;
    private IFhirResourceDao<CodeSystem> myCodeSystemResourceDao;
    private IFhirResourceDao<ValueSet> myValueSetResourceDao;
    @Autowired
    private ApplicationContext myAppCtx;

    @EventListener
    public void start(ContextRefreshedEvent theEvent) {
        this.myCodeSystemResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myCodeSystemDaoR4");
        this.myValueSetResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myValueSetDaoR4");
        this.myConceptMapResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myConceptMapDaoR4");
    }

    @Override
    public IIdType createOrUpdateCodeSystem(CodeSystem theCodeSystemResource, RequestDetails theRequestDetails) {
        this.validateCodeSystemForStorage(theCodeSystemResource);
        if (StringUtils.isBlank((CharSequence)theCodeSystemResource.getIdElement().getIdPart())) {
            if (theCodeSystemResource.getUrl().contains("loinc")) {
                throw new InvalidParameterException(Msg.code((int)859) + "'loinc' CodeSystem must have an 'ID' element");
            }
            String matchUrl = "CodeSystem?url=" + UrlUtil.escapeUrlParam((String)theCodeSystemResource.getUrl());
            return this.myCodeSystemResourceDao.update((IBaseResource)theCodeSystemResource, matchUrl, theRequestDetails).getId();
        }
        return this.myCodeSystemResourceDao.update((IBaseResource)theCodeSystemResource, theRequestDetails).getId();
    }

    @Override
    public void createOrUpdateConceptMap(ConceptMap theConceptMap) {
        if (StringUtils.isBlank((CharSequence)theConceptMap.getIdElement().getIdPart())) {
            String matchUrl = "ConceptMap?url=" + UrlUtil.escapeUrlParam((String)theConceptMap.getUrl());
            this.myConceptMapResourceDao.update((IBaseResource)theConceptMap, matchUrl);
        } else {
            this.myConceptMapResourceDao.update((IBaseResource)theConceptMap);
        }
    }

    @Override
    public void createOrUpdateValueSet(ValueSet theValueSet) {
        if (StringUtils.isBlank((CharSequence)theValueSet.getIdElement().getIdPart())) {
            String matchUrl = "ValueSet?url=" + UrlUtil.escapeUrlParam((String)theValueSet.getUrl());
            this.myValueSetResourceDao.update((IBaseResource)theValueSet, matchUrl);
        } else {
            this.myValueSetResourceDao.update((IBaseResource)theValueSet);
        }
    }
}

