/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.term.BaseTermVersionAdapterSvcImpl;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.UrlUtil;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_43_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_43_50;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4b.model.ConceptMap;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

public class TermVersionAdapterSvcR4B
extends BaseTermVersionAdapterSvcImpl
implements ITermVersionAdapterSvc {
    private IFhirResourceDao<ConceptMap> myConceptMapResourceDao;
    private IFhirResourceDao<org.hl7.fhir.r4b.model.CodeSystem> myCodeSystemResourceDao;
    private IFhirResourceDao<org.hl7.fhir.r4b.model.ValueSet> myValueSetResourceDao;
    @Autowired
    private ApplicationContext myAppCtx;

    @EventListener
    public void start(ContextRefreshedEvent theEvent) {
        this.myCodeSystemResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myCodeSystemDaoR4B");
        this.myValueSetResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myValueSetDaoR4B");
        this.myConceptMapResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myConceptMapDaoR4B");
    }

    @Override
    public IIdType createOrUpdateCodeSystem(org.hl7.fhir.r4.model.CodeSystem theCodeSystemResource, RequestDetails theRequestDetails) {
        this.validateCodeSystemForStorage(theCodeSystemResource);
        CodeSystem codeSystemR5 = (CodeSystem)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theCodeSystemResource, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
        org.hl7.fhir.r4b.model.CodeSystem codeSystemR4 = (org.hl7.fhir.r4b.model.CodeSystem)VersionConvertorFactory_43_50.convertResource((Resource)codeSystemR5, (BaseAdvisor_43_50)new BaseAdvisor_43_50(Boolean.valueOf(false)));
        if (StringUtils.isBlank((CharSequence)theCodeSystemResource.getIdElement().getIdPart())) {
            String matchUrl = "CodeSystem?url=" + UrlUtil.escapeUrlParam((String)theCodeSystemResource.getUrl());
            return this.myCodeSystemResourceDao.update((IBaseResource)codeSystemR4, matchUrl, theRequestDetails).getId();
        }
        return this.myCodeSystemResourceDao.update((IBaseResource)codeSystemR4, theRequestDetails).getId();
    }

    @Override
    public void createOrUpdateConceptMap(org.hl7.fhir.r4.model.ConceptMap theConceptMap) {
        org.hl7.fhir.r5.model.ConceptMap conceptMapR5 = (org.hl7.fhir.r5.model.ConceptMap)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theConceptMap, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
        ConceptMap conceptMapR4 = (ConceptMap)VersionConvertorFactory_43_50.convertResource((Resource)conceptMapR5, (BaseAdvisor_43_50)new BaseAdvisor_43_50(Boolean.valueOf(false)));
        if (StringUtils.isBlank((CharSequence)theConceptMap.getIdElement().getIdPart())) {
            String matchUrl = "ConceptMap?url=" + UrlUtil.escapeUrlParam((String)theConceptMap.getUrl());
            this.myConceptMapResourceDao.update((IBaseResource)conceptMapR4, matchUrl);
        } else {
            this.myConceptMapResourceDao.update((IBaseResource)conceptMapR4);
        }
    }

    @Override
    public void createOrUpdateValueSet(org.hl7.fhir.r4.model.ValueSet theValueSet) {
        ValueSet valueSetR5 = (ValueSet)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)theValueSet, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
        org.hl7.fhir.r4b.model.ValueSet valueSetR4 = (org.hl7.fhir.r4b.model.ValueSet)VersionConvertorFactory_43_50.convertResource((Resource)valueSetR5, (BaseAdvisor_43_50)new BaseAdvisor_43_50(Boolean.valueOf(false)));
        if (StringUtils.isBlank((CharSequence)theValueSet.getIdElement().getIdPart())) {
            String matchUrl = "ValueSet?url=" + UrlUtil.escapeUrlParam((String)theValueSet.getUrl());
            this.myValueSetResourceDao.update((IBaseResource)valueSetR4, matchUrl);
        } else {
            this.myValueSetResourceDao.update((IBaseResource)valueSetR4);
        }
    }
}

