/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.entity.TermConceptDesignation;
import ca.uhn.fhir.jpa.term.IValueSetConceptAccumulator;
import ca.uhn.fhir.jpa.term.TermReadSvcImpl;
import ca.uhn.fhir.jpa.term.ex.ExpansionTooCostlyException;
import ca.uhn.fhir.model.api.annotation.Block;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.ValueSet;

@Block
public class ValueSetExpansionComponentWithConceptAccumulator
extends ValueSet.ValueSetExpansionComponent
implements IValueSetConceptAccumulator {
    private final int myMaxCapacity;
    private final FhirContext myContext;
    private int mySkipCountRemaining;
    private int myHardExpansionMaximumSize;
    private List<String> myMessages;
    private int myAddedConcepts;
    private Integer myTotalConcepts;
    private Map<Long, ValueSet.ValueSetExpansionContainsComponent> mySourcePidToConcept = new HashMap<Long, ValueSet.ValueSetExpansionContainsComponent>();
    private Map<ValueSet.ValueSetExpansionContainsComponent, String> myConceptToSourceDirectParentPids = new HashMap<ValueSet.ValueSetExpansionContainsComponent, String>();
    private boolean myTrackingHierarchy;

    ValueSetExpansionComponentWithConceptAccumulator(FhirContext theContext, int theMaxCapacity, boolean theTrackingHierarchy) {
        this.myMaxCapacity = theMaxCapacity;
        this.myContext = theContext;
        this.myTrackingHierarchy = theTrackingHierarchy;
    }

    @Override
    @Nonnull
    public Integer getCapacityRemaining() {
        return this.myMaxCapacity - this.myAddedConcepts + this.mySkipCountRemaining;
    }

    public List<String> getMessages() {
        if (this.myMessages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.myMessages);
    }

    @Override
    public boolean isTrackingHierarchy() {
        return this.myTrackingHierarchy;
    }

    @Override
    public void addMessage(String theMessage) {
        if (this.myMessages == null) {
            this.myMessages = new ArrayList<String>();
        }
        this.myMessages.add(theMessage);
    }

    @Override
    public void includeConcept(String theSystem, String theCode, String theDisplay, Long theSourceConceptPid, String theSourceConceptDirectParentPids, String theCodeSystemVersion) {
        if (this.mySkipCountRemaining > 0) {
            --this.mySkipCountRemaining;
            return;
        }
        this.incrementConceptsCount();
        ValueSet.ValueSetExpansionContainsComponent contains = this.addContains();
        this.setSystemAndVersion(theSystem, contains);
        contains.setCode(theCode);
        contains.setDisplay(theDisplay);
        contains.setVersion(theCodeSystemVersion);
    }

    @Override
    public void includeConceptWithDesignations(String theSystem, String theCode, String theDisplay, Collection<TermConceptDesignation> theDesignations, Long theSourceConceptPid, String theSourceConceptDirectParentPids, String theCodeSystemVersion) {
        if (this.mySkipCountRemaining > 0) {
            --this.mySkipCountRemaining;
            return;
        }
        this.incrementConceptsCount();
        ValueSet.ValueSetExpansionContainsComponent contains = this.addContains();
        if (theSourceConceptPid != null) {
            this.mySourcePidToConcept.put(theSourceConceptPid, contains);
        }
        if (theSourceConceptDirectParentPids != null) {
            this.myConceptToSourceDirectParentPids.put(contains, theSourceConceptDirectParentPids);
        }
        this.setSystemAndVersion(theSystem, contains);
        contains.setCode(theCode);
        contains.setDisplay(theDisplay);
        if (StringUtils.isNotBlank((CharSequence)theCodeSystemVersion)) {
            contains.setVersion(theCodeSystemVersion);
        }
        if (theDesignations != null) {
            for (TermConceptDesignation termConceptDesignation : theDesignations) {
                contains.addDesignation().setValue(termConceptDesignation.getValue()).setLanguage(termConceptDesignation.getLanguage()).getUse().setSystem(termConceptDesignation.getUseSystem()).setCode(termConceptDesignation.getUseCode()).setDisplay(termConceptDesignation.getUseDisplay());
            }
        }
    }

    @Override
    public void consumeSkipCount(int theSkipCountToConsume) {
        this.mySkipCountRemaining -= theSkipCountToConsume;
    }

    @Override
    @Nullable
    public Integer getSkipCountRemaining() {
        return this.mySkipCountRemaining;
    }

    @Override
    public boolean excludeConcept(String theSystem, String theCode) {
        String excludeSystem;
        String excludeSystemVersion;
        int versionSeparator = theSystem.indexOf("|");
        if (versionSeparator > -1) {
            excludeSystemVersion = theSystem.substring(versionSeparator + 1);
            excludeSystem = theSystem.substring(0, versionSeparator);
        } else {
            excludeSystem = theSystem;
            excludeSystemVersion = null;
        }
        if (excludeSystemVersion != null) {
            return this.getContains().removeIf(t -> excludeSystem.equals(t.getSystem()) && theCode.equals(t.getCode()) && excludeSystemVersion.equals(t.getVersion()));
        }
        return this.getContains().removeIf(t -> theSystem.equals(t.getSystem()) && theCode.equals(t.getCode()));
    }

    private void incrementConceptsCount() {
        Integer capacityRemaining = this.getCapacityRemaining();
        if (capacityRemaining == 0) {
            String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "expansionTooLarge", new Object[]{this.myMaxCapacity});
            msg = this.appendAccumulatorMessages(msg);
            throw new ExpansionTooCostlyException(Msg.code((int)831) + msg);
        }
        if (this.myHardExpansionMaximumSize > 0 && this.myAddedConcepts > this.myHardExpansionMaximumSize) {
            String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "expansionTooLarge", new Object[]{this.myHardExpansionMaximumSize});
            msg = this.appendAccumulatorMessages(msg);
            throw new ExpansionTooCostlyException(Msg.code((int)832) + msg);
        }
        ++this.myAddedConcepts;
    }

    @Nonnull
    private String appendAccumulatorMessages(String msg) {
        msg = (String)msg + this.getMessages().stream().map(t -> " - " + t).collect(Collectors.joining());
        return msg;
    }

    public Integer getTotalConcepts() {
        return this.myTotalConcepts;
    }

    @Override
    public void incrementOrDecrementTotalConcepts(boolean theAdd, int theDelta) {
        int delta = theDelta;
        if (!theAdd) {
            delta = -delta;
        }
        this.myTotalConcepts = this.myTotalConcepts == null ? Integer.valueOf(delta) : Integer.valueOf(this.myTotalConcepts + delta);
    }

    private void setSystemAndVersion(String theSystemAndVersion, ValueSet.ValueSetExpansionContainsComponent myComponent) {
        if (StringUtils.isNotEmpty((CharSequence)theSystemAndVersion)) {
            int versionSeparator = theSystemAndVersion.lastIndexOf(124);
            if (versionSeparator != -1) {
                myComponent.setVersion(theSystemAndVersion.substring(versionSeparator + 1));
                myComponent.setSystem(theSystemAndVersion.substring(0, versionSeparator));
            } else {
                myComponent.setSystem(theSystemAndVersion);
            }
        }
    }

    public void setSkipCountRemaining(int theSkipCountRemaining) {
        this.mySkipCountRemaining = theSkipCountRemaining;
    }

    public void setHardExpansionMaximumSize(int theHardExpansionMaximumSize) {
        this.myHardExpansionMaximumSize = theHardExpansionMaximumSize;
    }

    public void applyHierarchy() {
        for (int i = 0; i < this.getContains().size(); ++i) {
            ValueSet.ValueSetExpansionContainsComponent nextContains = (ValueSet.ValueSetExpansionContainsComponent)this.getContains().get(i);
            String directParentPidsString = this.myConceptToSourceDirectParentPids.get(nextContains);
            if (!StringUtils.isNotBlank((CharSequence)directParentPidsString) || directParentPidsString.equals("NONE")) continue;
            List directParentPids = Arrays.stream(directParentPidsString.split(" ")).map(t -> Long.parseLong(t)).collect(Collectors.toList());
            boolean firstMatch = false;
            for (Long next : directParentPids) {
                ValueSet.ValueSetExpansionContainsComponent parentConcept = this.mySourcePidToConcept.get(next);
                if (parentConcept == null) continue;
                if (!firstMatch) {
                    firstMatch = true;
                    this.getContains().remove(i);
                    --i;
                }
                parentConcept.addContains(nextContains);
            }
        }
    }
}

