/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.api;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.UploadStatistics;
import ca.uhn.fhir.jpa.term.custom.CustomTerminologySet;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import java.util.List;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ValueSet;
import org.springframework.transaction.annotation.Transactional;

public interface ITermCodeSystemStorageSvc {
    public static final String MAKE_LOADING_VERSION_CURRENT = "make.loading.version.current";

    public static boolean isMakeVersionCurrent(RequestDetails theRequestDetails) {
        return theRequestDetails == null || theRequestDetails.getUserData().getOrDefault(MAKE_LOADING_VERSION_CURRENT, Boolean.TRUE) != false;
    }

    public void storeNewCodeSystemVersion(IResourcePersistentId var1, String var2, String var3, String var4, TermCodeSystemVersion var5, ResourceTable var6, RequestDetails var7);

    @Transactional
    default public void storeNewCodeSystemVersion(IResourcePersistentId theCodeSystemResourcePid, String theSystemUri, String theSystemName, String theSystemVersionId, TermCodeSystemVersion theCodeSystemVersion, ResourceTable theCodeSystemResourceTable) {
        this.storeNewCodeSystemVersion(theCodeSystemResourcePid, theSystemUri, theSystemName, theSystemVersionId, theCodeSystemVersion, theCodeSystemResourceTable, null);
    }

    public IIdType storeNewCodeSystemVersion(CodeSystem var1, TermCodeSystemVersion var2, RequestDetails var3, List<ValueSet> var4, List<ConceptMap> var5);

    public void storeNewCodeSystemVersionIfNeeded(CodeSystem var1, ResourceTable var2, RequestDetails var3);

    default public void storeNewCodeSystemVersionIfNeeded(CodeSystem theCodeSystem, ResourceTable theResourceEntity) {
        this.storeNewCodeSystemVersionIfNeeded(theCodeSystem, theResourceEntity, null);
    }

    public UploadStatistics applyDeltaCodeSystemsAdd(String var1, CustomTerminologySet var2);

    public UploadStatistics applyDeltaCodeSystemsRemove(String var1, CustomTerminologySet var2);

    public int saveConcept(TermConcept var1);
}

