/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.custom;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptHandler
implements IZipContentsHandlerCsv {
    private static final Logger ourLog = LoggerFactory.getLogger(ConceptHandler.class);
    public static final String CODE = "CODE";
    public static final String DISPLAY = "DISPLAY";
    private final Map<String, TermConcept> myCode2Concept;

    public ConceptHandler(Map<String, TermConcept> theCode2concept) {
        this.myCode2Concept = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String code = StringUtils.trim((String)theRecord.get(CODE));
        if (StringUtils.isNotBlank((CharSequence)code)) {
            String display = StringUtils.trim((String)theRecord.get(DISPLAY));
            Validate.isTrue((!this.myCode2Concept.containsKey(code) ? 1 : 0) != 0, (String)"The code %s has appeared more than once", (Object[])new Object[]{code});
            TermConcept concept = TermLoaderSvcImpl.getOrCreateConcept(this.myCode2Concept, code);
            concept.setCode(code);
            concept.setDisplay(display);
            this.myCode2Concept.put(code, concept);
        }
    }
}

