/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.custom;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.util.ValidateUtil;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;

public class HierarchyHandler
implements IZipContentsHandlerCsv {
    public static final String PARENT = "PARENT";
    public static final String CHILD = "CHILD";
    private final Map<String, TermConcept> myCode2Concept;

    public HierarchyHandler(Map<String, TermConcept> theCode2concept) {
        this.myCode2Concept = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String parent = StringUtils.trim((String)theRecord.get(PARENT));
        String child = StringUtils.trim((String)theRecord.get(CHILD));
        if (StringUtils.isNotBlank((CharSequence)parent) && StringUtils.isNotBlank((CharSequence)child)) {
            TermConcept childConcept = this.myCode2Concept.get(child);
            ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)childConcept, (String)"Child code %s not found in file", (Object[])new Object[]{child});
            TermConcept parentConcept = this.myCode2Concept.get(parent);
            ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)parentConcept, (String)"Parent code %s not found in file", (Object[])new Object[]{child});
            parentConcept.addChild(childConcept, TermConceptParentChildLink.RelationshipTypeEnum.ISA);
        }
    }
}

