/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.loinc.LoincUploadPropertiesEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLoincHandler
implements IZipContentsHandlerCsv {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseLoincHandler.class);
    public static final String LOINC_WEBSITE_URL = "https://loinc.org";
    public static final String REGENSTRIEF_INSTITUTE_INC = "Regenstrief Institute, Inc.";
    private final List<ConceptMap> myConceptMaps;
    private final Map<String, ConceptMap> myIdToConceptMaps = new HashMap<String, ConceptMap>();
    private final List<ValueSet> myValueSets;
    private final Map<String, ValueSet> myIdToValueSet = new HashMap<String, ValueSet>();
    private final Map<String, TermConcept> myCode2Concept;
    protected final Properties myUploadProperties;
    protected String myLoincCopyrightStatement;

    BaseLoincHandler(Map<String, TermConcept> theCode2Concept, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps, Properties theUploadProperties) {
        this(theCode2Concept, theValueSets, theConceptMaps, theUploadProperties, null);
    }

    BaseLoincHandler(Map<String, TermConcept> theCode2Concept, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps, Properties theUploadProperties, String theCopyrightStatement) {
        this.myValueSets = theValueSets;
        this.myValueSets.forEach(t -> this.myIdToValueSet.put(t.getId(), (ValueSet)t));
        this.myCode2Concept = theCode2Concept;
        this.myConceptMaps = theConceptMaps;
        this.myConceptMaps.forEach(t -> this.myIdToConceptMaps.put(t.getId(), (ConceptMap)t));
        this.myUploadProperties = theUploadProperties;
        this.myLoincCopyrightStatement = theCopyrightStatement;
    }

    void addCodeAsIncludeToValueSet(ValueSet theVs, String theCodeSystemUrl, String theCode, String theDisplayName) {
        Object include = null;
        for (Object next : theVs.getCompose().getInclude()) {
            if (!next.getSystem().equals(theCodeSystemUrl)) continue;
            include = next;
            break;
        }
        if (include == null) {
            include = theVs.getCompose().addInclude();
            include.setSystem(theCodeSystemUrl);
            if (StringUtils.isNotBlank((CharSequence)theVs.getVersion())) {
                include.setVersion(theVs.getVersion());
            }
        }
        boolean found = false;
        for (ValueSet.ConceptReferenceComponent next : include.getConcept()) {
            if (!next.getCode().equals(theCode)) continue;
            found = true;
        }
        if (!found) {
            TermConcept concept;
            String displayName = theDisplayName;
            if (StringUtils.isBlank((CharSequence)displayName) && (concept = this.myCode2Concept.get(theCode)) != null) {
                displayName = concept.getDisplay();
            }
            include.addConcept().setCode(theCode).setDisplay(displayName);
        }
    }

    void addConceptMapEntry(ConceptMapping theMapping, String theExternalCopyright) {
        ConceptMap conceptMap;
        if (StringUtils.isBlank((CharSequence)theMapping.getSourceCode())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)theMapping.getTargetCode())) {
            return;
        }
        if (!this.myIdToConceptMaps.containsKey(theMapping.getConceptMapId())) {
            conceptMap = new ConceptMap();
            conceptMap.setId(theMapping.getConceptMapId());
            conceptMap.setUrl(theMapping.getConceptMapUri());
            conceptMap.setName(theMapping.getConceptMapName());
            conceptMap.setVersion(theMapping.getConceptMapVersion());
            conceptMap.setPublisher(REGENSTRIEF_INSTITUTE_INC);
            conceptMap.addContact().setName(REGENSTRIEF_INSTITUTE_INC).addTelecom().setSystem(ContactPoint.ContactPointSystem.URL).setValue(LOINC_WEBSITE_URL);
            Object copyright = theExternalCopyright;
            if (!((String)copyright).contains("LOINC")) {
                copyright = this.myLoincCopyrightStatement + (this.myLoincCopyrightStatement.endsWith(".") ? " " : ". ") + (String)copyright;
            }
            conceptMap.setCopyright((String)copyright);
            this.myIdToConceptMaps.put(theMapping.getConceptMapId(), conceptMap);
            this.myConceptMaps.add(conceptMap);
        } else {
            conceptMap = this.myIdToConceptMaps.get(theMapping.getConceptMapId());
        }
        if (StringUtils.isBlank((CharSequence)theMapping.getCopyright())) {
            conceptMap.setCopyright(theMapping.getCopyright());
        }
        ConceptMap.SourceElementComponent source = null;
        ConceptMap.ConceptMapGroupComponent group = null;
        for (ConceptMap.ConceptMapGroupComponent next : conceptMap.getGroup()) {
            if (!next.getSource().equals(theMapping.getSourceCodeSystem()) || !next.getTarget().equals(theMapping.getTargetCodeSystem()) || !StringUtils.defaultString((String)theMapping.getTargetCodeSystemVersion()).equals(StringUtils.defaultString((String)next.getTargetVersion()))) continue;
            group = next;
            break;
        }
        if (group == null) {
            group = conceptMap.addGroup();
            group.setSource(theMapping.getSourceCodeSystem());
            group.setSourceVersion(theMapping.getSourceCodeSystemVersion());
            group.setTarget(theMapping.getTargetCodeSystem());
            group.setTargetVersion((String)StringUtils.defaultIfBlank((CharSequence)theMapping.getTargetCodeSystemVersion(), null));
        }
        for (ConceptMap.ConceptMapGroupComponent next : group.getElement()) {
            if (!next.getCode().equals(theMapping.getSourceCode())) continue;
            source = next;
        }
        if (source == null) {
            source = group.addElement();
            source.setCode(theMapping.getSourceCode());
            source.setDisplay(theMapping.getSourceDisplay());
        }
        boolean found = false;
        for (ConceptMap.TargetElementComponent next : source.getTarget()) {
            if (!next.getCode().equals(theMapping.getTargetCode())) continue;
            found = true;
        }
        if (!found) {
            source.addTarget().setCode(theMapping.getTargetCode()).setDisplay(theMapping.getTargetDisplay()).setEquivalence(theMapping.getEquivalence());
        } else {
            ourLog.info("Not going to add a mapping from [{}/{}] to [{}/{}] because one already exists", new Object[]{theMapping.getSourceCodeSystem(), theMapping.getSourceCode(), theMapping.getTargetCodeSystem(), theMapping.getTargetCode()});
        }
    }

    ValueSet getValueSet(String theValueSetId, String theValueSetUri, String theValueSetName, String theVersionPropertyName) {
        ValueSet vs;
        String codeSystemVersion = this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
        Object version = StringUtils.isNotBlank((CharSequence)theVersionPropertyName) ? (codeSystemVersion != null ? this.myUploadProperties.getProperty(theVersionPropertyName) + "-" + codeSystemVersion : this.myUploadProperties.getProperty(theVersionPropertyName)) : codeSystemVersion;
        if (!this.myIdToValueSet.containsKey(theValueSetId)) {
            vs = new ValueSet();
            vs.setUrl(theValueSetUri);
            vs.setId(theValueSetId);
            vs.setVersion((String)version);
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setPublisher(REGENSTRIEF_INSTITUTE_INC);
            vs.addContact().setName(REGENSTRIEF_INSTITUTE_INC).addTelecom().setSystem(ContactPoint.ContactPointSystem.URL).setValue(LOINC_WEBSITE_URL);
            vs.setCopyright(this.myLoincCopyrightStatement);
            this.myIdToValueSet.put(theValueSetId, vs);
            this.myValueSets.add(vs);
        } else {
            vs = this.myIdToValueSet.get(theValueSetId);
        }
        if (StringUtils.isBlank((CharSequence)vs.getName()) && StringUtils.isNotBlank((CharSequence)theValueSetName)) {
            vs.setName(theValueSetName);
        }
        return vs;
    }

    static class ConceptMapping {
        private String myCopyright;
        private String myConceptMapId;
        private String myConceptMapUri;
        private String myConceptMapVersion;
        private String myConceptMapName;
        private String mySourceCodeSystem;
        private String mySourceCodeSystemVersion;
        private String mySourceCode;
        private String mySourceDisplay;
        private String myTargetCodeSystem;
        private String myTargetCode;
        private String myTargetDisplay;
        private Enumerations.ConceptMapEquivalence myEquivalence;
        private String myTargetCodeSystemVersion;

        ConceptMapping() {
        }

        String getConceptMapId() {
            return this.myConceptMapId;
        }

        ConceptMapping setConceptMapId(String theConceptMapId) {
            this.myConceptMapId = theConceptMapId;
            return this;
        }

        String getConceptMapName() {
            return this.myConceptMapName;
        }

        ConceptMapping setConceptMapName(String theConceptMapName) {
            this.myConceptMapName = theConceptMapName;
            return this;
        }

        String getConceptMapUri() {
            return this.myConceptMapUri;
        }

        ConceptMapping setConceptMapUri(String theConceptMapUri) {
            this.myConceptMapUri = theConceptMapUri;
            return this;
        }

        String getConceptMapVersion() {
            return this.myConceptMapVersion;
        }

        ConceptMapping setConceptMapVersion(String theConceptMapVersion) {
            this.myConceptMapVersion = theConceptMapVersion;
            return this;
        }

        String getCopyright() {
            return this.myCopyright;
        }

        ConceptMapping setCopyright(String theCopyright) {
            this.myCopyright = theCopyright;
            return this;
        }

        Enumerations.ConceptMapEquivalence getEquivalence() {
            return this.myEquivalence;
        }

        ConceptMapping setEquivalence(Enumerations.ConceptMapEquivalence theEquivalence) {
            this.myEquivalence = theEquivalence;
            return this;
        }

        String getSourceCode() {
            return this.mySourceCode;
        }

        ConceptMapping setSourceCode(String theSourceCode) {
            this.mySourceCode = theSourceCode;
            return this;
        }

        String getSourceCodeSystem() {
            return this.mySourceCodeSystem;
        }

        ConceptMapping setSourceCodeSystem(String theSourceCodeSystem) {
            this.mySourceCodeSystem = theSourceCodeSystem;
            return this;
        }

        String getSourceCodeSystemVersion() {
            return this.mySourceCodeSystemVersion;
        }

        ConceptMapping setSourceCodeSystemVersion(String theSourceCodeSystemVersion) {
            this.mySourceCodeSystemVersion = theSourceCodeSystemVersion;
            return this;
        }

        String getSourceDisplay() {
            return this.mySourceDisplay;
        }

        ConceptMapping setSourceDisplay(String theSourceDisplay) {
            this.mySourceDisplay = theSourceDisplay;
            return this;
        }

        String getTargetCode() {
            return this.myTargetCode;
        }

        ConceptMapping setTargetCode(String theTargetCode) {
            this.myTargetCode = theTargetCode;
            return this;
        }

        String getTargetCodeSystem() {
            return this.myTargetCodeSystem;
        }

        ConceptMapping setTargetCodeSystem(String theTargetCodeSystem) {
            this.myTargetCodeSystem = theTargetCodeSystem;
            return this;
        }

        String getTargetCodeSystemVersion() {
            return this.myTargetCodeSystemVersion;
        }

        ConceptMapping setTargetCodeSystemVersion(String theTargetCodeSystemVersion) {
            this.myTargetCodeSystemVersion = theTargetCodeSystemVersion;
            return this;
        }

        String getTargetDisplay() {
            return this.myTargetDisplay;
        }

        ConceptMapping setTargetDisplay(String theTargetDisplay) {
            this.myTargetDisplay = theTargetDisplay;
            return this;
        }
    }
}

