/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.loinc.BaseLoincHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincUploadPropertiesEnum;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ValueSet;

public class BaseLoincTop2000LabResultsHandler
extends BaseLoincHandler
implements IZipContentsHandlerCsv {
    private String myValueSetId;
    private String myValueSetUri;
    private String myValueSetName;

    public BaseLoincTop2000LabResultsHandler(Map<String, TermConcept> theCode2concept, List<ValueSet> theValueSets, String theValueSetId, String theValueSetUri, String theValueSetName, List<ConceptMap> theConceptMaps, Properties theUploadProperties, String theCopyrightStatement) {
        super(theCode2concept, theValueSets, theConceptMaps, theUploadProperties, theCopyrightStatement);
        String versionId = this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
        this.myValueSetId = versionId != null ? theValueSetId + "-" + versionId : theValueSetId;
        this.myValueSetUri = theValueSetUri;
        this.myValueSetName = theValueSetName;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String loincNumber = StringUtils.trim((String)theRecord.get("LOINC #"));
        String displayName = StringUtils.trim((String)theRecord.get("Long Common Name"));
        ValueSet valueSet = this.getValueSet(this.myValueSetId, this.myValueSetUri, this.myValueSetName, null);
        this.addCodeAsIncludeToValueSet(valueSet, "http://loinc.org", loincNumber, displayName);
    }
}

