/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;

public class LoincAnswerListLinkHandler
implements IZipContentsHandlerCsv {
    private final Map<String, TermConcept> myCode2Concept;

    public LoincAnswerListLinkHandler(Map<String, TermConcept> theCode2concept) {
        this.myCode2Concept = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        TermConcept answerListCode;
        String applicableContext = StringUtils.trim((String)theRecord.get("ApplicableContext"));
        if (StringUtils.isNotBlank((CharSequence)applicableContext)) {
            return;
        }
        String answerListId = StringUtils.trim((String)theRecord.get("AnswerListId"));
        if (StringUtils.isBlank((CharSequence)answerListId)) {
            return;
        }
        String loincNumber = StringUtils.trim((String)theRecord.get("LoincNumber"));
        if (StringUtils.isBlank((CharSequence)loincNumber)) {
            return;
        }
        TermConcept loincCode = this.myCode2Concept.get(loincNumber);
        if (loincCode != null) {
            loincCode.addPropertyString("answer-list", answerListId);
        }
        if ((answerListCode = this.myCode2Concept.get(answerListId)) != null) {
            answerListCode.addPropertyString("answers-for", loincNumber);
        }
    }
}

