/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;

public class LoincLinguisticVariantHandler
implements IZipContentsHandlerCsv {
    private final Map<String, TermConcept> myCode2Concept;
    private final String myLanguageCode;

    public LoincLinguisticVariantHandler(Map<String, TermConcept> theCode2Concept, String theLanguageCode) {
        this.myCode2Concept = theCode2Concept;
        this.myLanguageCode = theLanguageCode;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String loincNumber = StringUtils.trim((String)theRecord.get("LOINC_NUM"));
        if (StringUtils.isBlank((CharSequence)loincNumber)) {
            return;
        }
        TermConcept concept = this.myCode2Concept.get(loincNumber);
        if (concept == null) {
            return;
        }
        StringBuilder fullySpecifiedName = new StringBuilder();
        fullySpecifiedName.append(StringUtils.trimToEmpty((String)(theRecord.get("COMPONENT") + ":")));
        fullySpecifiedName.append(StringUtils.trimToEmpty((String)(theRecord.get("PROPERTY") + ":")));
        fullySpecifiedName.append(StringUtils.trimToEmpty((String)(theRecord.get("TIME_ASPCT") + ":")));
        fullySpecifiedName.append(StringUtils.trimToEmpty((String)(theRecord.get("SYSTEM") + ":")));
        fullySpecifiedName.append(StringUtils.trimToEmpty((String)(theRecord.get("SCALE_TYP") + ":")));
        fullySpecifiedName.append(StringUtils.trimToEmpty((String)theRecord.get("METHOD_TYP")));
        String fullySpecifiedNameStr = fullySpecifiedName.toString();
        if (!fullySpecifiedNameStr.equals(":::::")) {
            concept.addDesignation().setLanguage(this.myLanguageCode).setUseSystem("http://loinc.org").setUseCode("FullySpecifiedName").setUseDisplay("FullySpecifiedName").setValue(fullySpecifiedNameStr);
        }
        this.addDesignation(theRecord, concept, "SHORTNAME");
        this.addDesignation(theRecord, concept, "LONG_COMMON_NAME");
        this.addDesignation(theRecord, concept, "LinguisticVariantDisplayName");
    }

    private void addDesignation(CSVRecord theRecord, TermConcept concept, String fieldName) {
        String field = StringUtils.trim((String)theRecord.get(fieldName));
        if (StringUtils.isBlank((CharSequence)field)) {
            return;
        }
        concept.addDesignation().setLanguage(this.myLanguageCode).setUseSystem("http://loinc.org").setUseCode(fieldName).setUseDisplay(fieldName).setValue(field);
    }
}

