/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoincMapToHandler
implements IZipContentsHandlerCsv {
    private static final Logger ourLog = LoggerFactory.getLogger(LoincMapToHandler.class);
    public static final String CONCEPT_CODE_PROP_NAME = "LOINC";
    public static final String MAP_TO_PROP_NAME = "MAP_TO";
    public static final String DISPLAY_PROP_NAME = "COMMENT";
    private final Map<String, TermConcept> myCode2Concept;

    public LoincMapToHandler(Map<String, TermConcept> theCode2concept) {
        this.myCode2Concept = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String code = StringUtils.trim((String)theRecord.get(CONCEPT_CODE_PROP_NAME));
        String mapTo = StringUtils.trim((String)theRecord.get(MAP_TO_PROP_NAME));
        String display = StringUtils.trim((String)theRecord.get(DISPLAY_PROP_NAME));
        if (StringUtils.isBlank((CharSequence)code)) {
            ourLog.warn("MapTo record was found with a blank 'LOINC' property");
            return;
        }
        if (StringUtils.isBlank((CharSequence)mapTo)) {
            ourLog.warn("MapTo record was found with a blank 'MAP_TO' property");
            return;
        }
        TermConcept concept = this.myCode2Concept.get(code);
        if (concept == null) {
            ourLog.warn("A TermConcept was not found for MapTo 'LOINC' property: '" + code + "' MapTo record ignored.");
            return;
        }
        concept.addPropertyCoding(MAP_TO_PROP_NAME, "http://loinc.org", mapTo, display);
        ourLog.trace("Adding MAP_TO coding property: {} to concept.code {}", (Object)mapTo, (Object)concept.getCode());
    }
}

