/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.loinc.PartTypeAndPartName;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class LoincPartHandler
implements IZipContentsHandlerCsv {
    private final Map<String, TermConcept> myCode2Concept;
    private final TermCodeSystemVersion myCodeSystemVersion;
    private final Map<PartTypeAndPartName, String> myPartTypeAndPartNameToPartNumber = new HashMap<PartTypeAndPartName, String>();

    public LoincPartHandler(TermCodeSystemVersion theCodeSystemVersion, Map<String, TermConcept> theCode2concept) {
        this.myCodeSystemVersion = theCodeSystemVersion;
        this.myCode2Concept = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String partNumber = StringUtils.trim((String)theRecord.get("PartNumber"));
        String partTypeName = StringUtils.trim((String)theRecord.get("PartTypeName"));
        String partName = StringUtils.trim((String)theRecord.get("PartName"));
        String partDisplayName = StringUtils.trim((String)theRecord.get("PartDisplayName"));
        PartTypeAndPartName partTypeAndPartName = new PartTypeAndPartName(partTypeName, partName);
        String previousValue = this.myPartTypeAndPartNameToPartNumber.put(partTypeAndPartName, partNumber);
        Validate.isTrue((previousValue == null ? 1 : 0) != 0, (String)("Already had part: " + partTypeAndPartName), (Object[])new Object[0]);
        TermConcept concept = this.myCode2Concept.get(partNumber);
        if (concept == null) {
            concept = new TermConcept(this.myCodeSystemVersion, partNumber);
            concept.setDisplay(partName);
            this.myCode2Concept.put(partNumber, concept);
        }
        if (StringUtils.isNotBlank((CharSequence)partDisplayName)) {
            concept.addDesignation().setConcept(concept).setUseDisplay("PartDisplayName").setValue(partDisplayName);
        }
    }

    public Map<PartTypeAndPartName, String> getPartTypeAndPartNameToPartNumber() {
        return this.myPartTypeAndPartNameToPartNumber;
    }
}

