/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.loinc.BaseLoincHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincUploadPropertiesEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ValueSet;

public class LoincRsnaPlaybookHandler
extends BaseLoincHandler
implements IZipContentsHandlerCsv {
    public static final String RSNA_CODES_VS_ID = "loinc-rsna-radiology-playbook";
    public static final String RSNA_CODES_VS_URI = "http://loinc.org/vs/loinc-rsna-radiology-playbook";
    public static final String RSNA_CODES_VS_NAME = "LOINC/RSNA Radiology Playbook";
    public static final String RID_CS_URI = "http://www.radlex.org";
    public static final String RPID_CS_URI = "http://www.radlex.org";
    private static final String CM_COPYRIGHT = "The LOINC/RSNA Radiology Playbook and the LOINC Part File contain content from RadLex\u00ae (http://rsna.org/RadLex.aspx), copyright \u00a9 2005-2017, The Radiological Society of North America, Inc., available at no cost under the license at http://www.rsna.org/uploadedFiles/RSNA/Content/Informatics/RadLex_License_Agreement_and_Terms_of_Use_V2_Final.pdf.";
    private final Map<String, TermConcept> myCode2Concept;
    private final List<ValueSet> myValueSets;
    private final Map<String, ValueSet> myIdToValueSet = new HashMap<String, ValueSet>();
    private final Set<String> myCodesInRsnaPlaybookValueSet = new HashSet<String>();

    public LoincRsnaPlaybookHandler(Map<String, TermConcept> theCode2concept, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps, Properties theUploadProperties, String theCopyrightStatement) {
        super(theCode2concept, theValueSets, theConceptMaps, theUploadProperties, theCopyrightStatement);
        this.myCode2Concept = theCode2concept;
        this.myValueSets = theValueSets;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        Object termConceptMapId;
        Object partConceptMapId;
        String loincCodePropName;
        ValueSet vs;
        String loincNumber = StringUtils.trim((String)theRecord.get("LoincNumber"));
        String longCommonName = StringUtils.trim((String)theRecord.get("LongCommonName"));
        String partNumber = StringUtils.trim((String)theRecord.get("PartNumber"));
        String partTypeName = StringUtils.trim((String)theRecord.get("PartTypeName"));
        String partName = StringUtils.trim((String)theRecord.get("PartName"));
        String partSequenceOrder = StringUtils.trim((String)theRecord.get("PartSequenceOrder"));
        String rid = StringUtils.trim((String)theRecord.get("RID"));
        String preferredName = StringUtils.trim((String)theRecord.get("PreferredName"));
        String rpid = StringUtils.trim((String)theRecord.get("RPID"));
        String longName = StringUtils.trim((String)theRecord.get("LongName"));
        String codeSystemVersionId = this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
        Object loincRsnaCmVersion = codeSystemVersionId != null ? this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CONCEPTMAP_VERSION.getCode()) + "-" + codeSystemVersionId : this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CONCEPTMAP_VERSION.getCode());
        Object rsnaCodesValueSetId = codeSystemVersionId != null ? "loinc-rsna-radiology-playbook-" + codeSystemVersionId : RSNA_CODES_VS_ID;
        if (!this.myIdToValueSet.containsKey(rsnaCodesValueSetId)) {
            vs = new ValueSet();
            vs.setUrl(RSNA_CODES_VS_URI);
            vs.setId((String)rsnaCodesValueSetId);
            vs.setName(RSNA_CODES_VS_NAME);
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setVersion(codeSystemVersionId);
            this.myIdToValueSet.put((String)rsnaCodesValueSetId, vs);
            this.myValueSets.add(vs);
        } else {
            vs = this.myIdToValueSet.get(rsnaCodesValueSetId);
        }
        if (!this.myCodesInRsnaPlaybookValueSet.contains(loincNumber)) {
            vs.getCompose().getIncludeFirstRep().setSystem("http://loinc.org").setVersion(codeSystemVersionId).addConcept().setCode(loincNumber).setDisplay(longCommonName);
            this.myCodesInRsnaPlaybookValueSet.add(loincNumber);
        }
        switch (partTypeName.toLowerCase()) {
            case "rad.anatomic location.region imaged": {
                loincCodePropName = "rad-anatomic-location-region-imaged";
                break;
            }
            case "rad.anatomic location.imaging focus": {
                loincCodePropName = "rad-anatomic-location-imaging-focus";
                break;
            }
            case "rad.modality.modality type": {
                loincCodePropName = "rad-modality-modality-type";
                break;
            }
            case "rad.modality.modality subtype": {
                loincCodePropName = "rad-modality-modality-subtype";
                break;
            }
            case "rad.anatomic location.laterality": {
                loincCodePropName = "rad-anatomic-location-laterality";
                break;
            }
            case "rad.anatomic location.laterality.presence": {
                loincCodePropName = "rad-anatomic-location-laterality-presence";
                break;
            }
            case "rad.guidance for.action": {
                loincCodePropName = "rad-guidance-for-action";
                break;
            }
            case "rad.guidance for.approach": {
                loincCodePropName = "rad-guidance-for-approach";
                break;
            }
            case "rad.guidance for.object": {
                loincCodePropName = "rad-guidance-for-object";
                break;
            }
            case "rad.guidance for.presence": {
                loincCodePropName = "rad-guidance-for-presence";
                break;
            }
            case "rad.maneuver.maneuver type": {
                loincCodePropName = "rad-maneuver-maneuver-type";
                break;
            }
            case "rad.pharmaceutical.route": {
                loincCodePropName = "rad-pharmaceutical-route";
                break;
            }
            case "rad.pharmaceutical.substance given": {
                loincCodePropName = "rad-pharmaceutical-substance-given";
                break;
            }
            case "rad.reason for exam": {
                loincCodePropName = "rad-reason-for-exam";
                break;
            }
            case "rad.subject": {
                loincCodePropName = "rad-subject";
                break;
            }
            case "rad.timing": {
                loincCodePropName = "rad-timing";
                break;
            }
            case "rad.view.aggregation": {
                loincCodePropName = "rad-view-view-aggregation";
                break;
            }
            case "rad.view.view type": {
                loincCodePropName = "rad-view-view-type";
                break;
            }
            default: {
                throw new InternalErrorException(Msg.code((int)912) + "Unknown PartTypeName: " + partTypeName);
            }
        }
        TermConcept code = this.myCode2Concept.get(loincNumber);
        if (code != null) {
            code.addPropertyCoding(loincCodePropName, "http://loinc.org", partNumber, partName);
        }
        if (codeSystemVersionId != null) {
            partConceptMapId = "loinc-parts-to-radlex-" + codeSystemVersionId;
            termConceptMapId = "loinc-to-radlex-" + codeSystemVersionId;
        } else {
            partConceptMapId = "loinc-parts-to-radlex";
            termConceptMapId = "loinc-to-radlex";
        }
        if (StringUtils.isNotBlank((CharSequence)rid)) {
            this.addConceptMapEntry(new BaseLoincHandler.ConceptMapping().setConceptMapId((String)partConceptMapId).setConceptMapUri("http://loinc.org/cm/loinc-parts-to-radlex").setConceptMapVersion((String)loincRsnaCmVersion).setConceptMapName("LOINC Parts to RadLex RIDs").setSourceCodeSystem("http://loinc.org").setSourceCodeSystemVersion(codeSystemVersionId).setSourceCode(partNumber).setSourceDisplay(partName).setTargetCodeSystem("http://www.radlex.org").setTargetCode(rid).setTargetDisplay(preferredName).setEquivalence(Enumerations.ConceptMapEquivalence.EQUAL), this.myLoincCopyrightStatement + " The LOINC/RSNA Radiology Playbook and the LOINC Part File contain content from RadLex\u00ae (http://rsna.org/RadLex.aspx), copyright \u00a9 2005-2017, The Radiological Society of North America, Inc., available at no cost under the license at http://www.rsna.org/uploadedFiles/RSNA/Content/Informatics/RadLex_License_Agreement_and_Terms_of_Use_V2_Final.pdf.");
        }
        if (StringUtils.isNotBlank((CharSequence)rpid)) {
            this.addConceptMapEntry(new BaseLoincHandler.ConceptMapping().setConceptMapId((String)termConceptMapId).setConceptMapUri("http://loinc.org/cm/loinc-to-radlex").setConceptMapVersion((String)loincRsnaCmVersion).setConceptMapName("LOINC Terms to RadLex RPIDs").setSourceCodeSystem("http://loinc.org").setSourceCodeSystemVersion(codeSystemVersionId).setSourceCode(loincNumber).setSourceDisplay(longCommonName).setTargetCodeSystem("http://www.radlex.org").setTargetCode(rpid).setTargetDisplay(longName).setEquivalence(Enumerations.ConceptMapEquivalence.EQUAL), this.myLoincCopyrightStatement + " The LOINC/RSNA Radiology Playbook and the LOINC Part File contain content from RadLex\u00ae (http://rsna.org/RadLex.aspx), copyright \u00a9 2005-2017, The Radiological Society of North America, Inc., available at no cost under the license at http://www.rsna.org/uploadedFiles/RSNA/Content/Informatics/RadLex_License_Agreement_and_Terms_of_Use_V2_Final.pdf.");
        }
    }
}

