/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.jpa.searchparam.extractor.GeopointNormalizer;
import org.hibernate.search.engine.spatial.GeoBoundingBox;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordCalculator {
    private static final Logger ourLog = LoggerFactory.getLogger(CoordCalculator.class);
    public static final double MAX_SUPPORTED_DISTANCE_KM = 10000.0;
    private static final double RADIUS_EARTH_KM = 6378.1;

    static GeoPoint findTarget(double theLatitudeDegrees, double theLongitudeDegrees, double theBearingDegrees, double theDistanceKm) {
        double latitudeRadians = Math.toRadians(GeopointNormalizer.normalizeLatitude((double)theLatitudeDegrees));
        double longitudeRadians = Math.toRadians(GeopointNormalizer.normalizeLongitude((double)theLongitudeDegrees));
        double bearingRadians = Math.toRadians(theBearingDegrees);
        double distanceRadians = theDistanceKm / 6378.1;
        double targetLatitude = Math.asin(Math.sin(latitudeRadians) * Math.cos(distanceRadians) + Math.cos(latitudeRadians) * Math.sin(distanceRadians) * Math.cos(bearingRadians));
        double targetLongitude = longitudeRadians + Math.atan2(Math.sin(bearingRadians) * Math.sin(distanceRadians) * Math.cos(latitudeRadians), Math.cos(distanceRadians) - Math.sin(latitudeRadians) * Math.sin(targetLatitude));
        double latitude = Math.toDegrees(targetLatitude);
        double longitude = Math.toDegrees(targetLongitude);
        GeoPoint of = GeoPoint.of((double)GeopointNormalizer.normalizeLatitude((double)latitude), (double)GeopointNormalizer.normalizeLongitude((double)longitude));
        return of;
    }

    public static GeoBoundingBox getBox(double theLatitudeDegrees, double theLongitudeDegrees, Double theDistanceKm) {
        double diagonalDistanceKm = theDistanceKm * Math.sqrt(2.0);
        GeoPoint topLeft = CoordCalculator.findTarget(theLatitudeDegrees, theLongitudeDegrees, 315.0, diagonalDistanceKm);
        GeoPoint bottomRight = CoordCalculator.findTarget(theLatitudeDegrees, theLongitudeDegrees, 135.0, diagonalDistanceKm);
        return GeoBoundingBox.of((GeoPoint)topLeft, (GeoPoint)bottomRight);
    }
}

