/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.packages.NpmJpaValidationSupport;
import ca.uhn.fhir.jpa.term.api.ITermConceptMappingSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.SnapshotGeneratingValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.UnknownCodeSystemWarningValidationSupport;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class JpaValidationSupportChain
extends ValidationSupportChain {
    private final FhirContext myFhirContext;
    @Autowired
    @Qualifier(value="myJpaValidationSupport")
    public IValidationSupport myJpaValidationSupport;
    @Qualifier(value="myDefaultProfileValidationSupport")
    @Autowired
    private IValidationSupport myDefaultProfileValidationSupport;
    @Autowired
    private ITermReadSvc myTerminologyService;
    @Autowired
    private NpmJpaValidationSupport myNpmJpaValidationSupport;
    @Autowired
    private ITermConceptMappingSvc myConceptMappingSvc;
    @Autowired
    private UnknownCodeSystemWarningValidationSupport myUnknownCodeSystemWarningValidationSupport;
    @Autowired
    private InMemoryTerminologyServerValidationSupport myInMemoryTerminologyServerValidationSupport;

    public JpaValidationSupportChain(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    @PreDestroy
    public void flush() {
        this.invalidateCaches();
    }

    @PostConstruct
    public void postConstruct() {
        this.addValidationSupport(this.myDefaultProfileValidationSupport);
        this.addValidationSupport(this.myJpaValidationSupport);
        this.addValidationSupport(this.myTerminologyService);
        this.addValidationSupport((IValidationSupport)new SnapshotGeneratingValidationSupport(this.myFhirContext));
        this.addValidationSupport((IValidationSupport)this.myInMemoryTerminologyServerValidationSupport);
        this.addValidationSupport(this.myNpmJpaValidationSupport);
        this.addValidationSupport((IValidationSupport)new CommonCodeSystemsTerminologyService(this.myFhirContext));
        this.addValidationSupport(this.myConceptMappingSvc);
        this.addValidationSupport((IValidationSupport)this.myUnknownCodeSystemWarningValidationSupport);
    }
}

