/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.composite.ScheduleDt;
import ca.uhn.fhir.model.dstu.resource.Appointment;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ParticipantTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="AppointmentResponse", profile="http://hl7.org/fhir/profiles/AppointmentResponse", id="appointmentresponse")
public class AppointmentResponse
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="partstatus", path="AppointmentResponse.participantStatus", description="The overall status of the appointment", type="string")
    public static final String SP_PARTSTATUS = "partstatus";
    public static final StringClientParam PARTSTATUS = new StringClientParam("partstatus");
    @SearchParamDefinition(name="subject", path="AppointmentResponse.individual", description="The subject that the appointment response replies for", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_INDIVIDUAL = new Include("AppointmentResponse.individual");
    @SearchParamDefinition(name="appointment", path="AppointmentResponse.appointment", description="The appointment that the response is attached to", type="reference")
    public static final String SP_APPOINTMENT = "appointment";
    public static final ReferenceClientParam APPOINTMENT = new ReferenceClientParam("appointment");
    public static final Include INCLUDE_APPOINTMENT = new Include("AppointmentResponse.appointment");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="External Ids for this item", formalDefinition="This records identifiers associated with this appointment concern that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="appointment", order=1, min=1, max=1, summary=false, modifier=false, type={Appointment.class})
    @Description(shortDefinition="Parent appointment that this response is replying to", formalDefinition="")
    private ResourceReferenceDt myAppointment;
    @Child(name="participantType", type={CodeableConceptDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Role of participant in the appointment", formalDefinition="")
    private List<BoundCodeableConceptDt<ParticipantTypeEnum>> myParticipantType;
    @Child(name="individual", order=3, min=0, max=-1, summary=false, modifier=false, type={Practitioner.class, Patient.class, RelatedPerson.class, Device.class})
    @Description(shortDefinition="A Person of device that is participating in the appointment", formalDefinition="")
    private List<ResourceReferenceDt> myIndividual;
    @Child(name="participantStatus", type={CodeDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="accepted | declined | tentative | in-process | completed | needs-action", formalDefinition="Participation status of the Patient")
    private CodeDt myParticipantStatus;
    @Child(name="comment", type={StringDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Additional comments about the appointment", formalDefinition="")
    private StringDt myComment;
    @Child(name="start", type={InstantDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date/Time that the appointment is to take place", formalDefinition="")
    private InstantDt myStart;
    @Child(name="end", type={InstantDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date/Time that the appointment is to conclude", formalDefinition="")
    private InstantDt myEnd;
    @Child(name="schedule", type={ScheduleDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The recurrence schedule for the appointment. The end date in the schedule marks the end of the recurrence(s), not the end of an individual appointment", formalDefinition="")
    private ScheduleDt mySchedule;
    @Child(name="timezone", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The timezone that the times are to be converted to. Required for recurring appointments to remain accurate where the schedule makes the appointment cross a daylight saving boundry", formalDefinition="The timezone should be a value referenced from a timezone database")
    private StringDt myTimezone;
    @Child(name="recorder", order=10, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="Who recorded the appointment response", formalDefinition="")
    private ResourceReferenceDt myRecorder;
    @Child(name="recordedDate", type={DateTimeDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Date when the response was recorded or last updated", formalDefinition="")
    private DateTimeDt myRecordedDate;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myAppointment, this.myParticipantType, this.myIndividual, this.myParticipantStatus, this.myComment, this.myStart, this.myEnd, this.mySchedule, this.myTimezone, this.myRecorder, this.myRecordedDate});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myAppointment, this.myParticipantType, this.myIndividual, this.myParticipantStatus, this.myComment, this.myStart, this.myEnd, this.mySchedule, this.myTimezone, this.myRecorder, this.myRecordedDate});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public AppointmentResponse setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public AppointmentResponse addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public AppointmentResponse addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getAppointment() {
        if (this.myAppointment == null) {
            this.myAppointment = new ResourceReferenceDt();
        }
        return this.myAppointment;
    }

    public ResourceReferenceDt getAppointmentElement() {
        if (this.myAppointment == null) {
            this.myAppointment = new ResourceReferenceDt();
        }
        return this.myAppointment;
    }

    public AppointmentResponse setAppointment(ResourceReferenceDt theValue) {
        this.myAppointment = theValue;
        return this;
    }

    public List<BoundCodeableConceptDt<ParticipantTypeEnum>> getParticipantType() {
        if (this.myParticipantType == null) {
            this.myParticipantType = new ArrayList<BoundCodeableConceptDt<ParticipantTypeEnum>>();
        }
        return this.myParticipantType;
    }

    public List<BoundCodeableConceptDt<ParticipantTypeEnum>> getParticipantTypeElement() {
        if (this.myParticipantType == null) {
            this.myParticipantType = new ArrayList<BoundCodeableConceptDt<ParticipantTypeEnum>>();
        }
        return this.myParticipantType;
    }

    public AppointmentResponse setParticipantType(List<BoundCodeableConceptDt<ParticipantTypeEnum>> theValue) {
        this.myParticipantType = theValue;
        return this;
    }

    public BoundCodeableConceptDt<ParticipantTypeEnum> addParticipantType(ParticipantTypeEnum theValue) {
        BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER, theValue);
        this.getParticipantType().add(retVal);
        return retVal;
    }

    public BoundCodeableConceptDt<ParticipantTypeEnum> getParticipantTypeFirstRep() {
        if (this.getParticipantType().size() == 0) {
            this.addParticipantType();
        }
        return this.getParticipantType().get(0);
    }

    public BoundCodeableConceptDt<ParticipantTypeEnum> addParticipantType() {
        BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER);
        this.getParticipantType().add(retVal);
        return retVal;
    }

    public AppointmentResponse setParticipantType(ParticipantTypeEnum theValue) {
        this.getParticipantType().clear();
        this.addParticipantType(theValue);
        return this;
    }

    public List<ResourceReferenceDt> getIndividual() {
        if (this.myIndividual == null) {
            this.myIndividual = new ArrayList<ResourceReferenceDt>();
        }
        return this.myIndividual;
    }

    public List<ResourceReferenceDt> getIndividualElement() {
        if (this.myIndividual == null) {
            this.myIndividual = new ArrayList<ResourceReferenceDt>();
        }
        return this.myIndividual;
    }

    public AppointmentResponse setIndividual(List<ResourceReferenceDt> theValue) {
        this.myIndividual = theValue;
        return this;
    }

    public ResourceReferenceDt addIndividual() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getIndividual().add(newType);
        return newType;
    }

    public CodeDt getParticipantStatus() {
        if (this.myParticipantStatus == null) {
            this.myParticipantStatus = new CodeDt();
        }
        return this.myParticipantStatus;
    }

    public CodeDt getParticipantStatusElement() {
        if (this.myParticipantStatus == null) {
            this.myParticipantStatus = new CodeDt();
        }
        return this.myParticipantStatus;
    }

    public AppointmentResponse setParticipantStatus(CodeDt theValue) {
        this.myParticipantStatus = theValue;
        return this;
    }

    public AppointmentResponse setParticipantStatus(String theCode) {
        this.myParticipantStatus = new CodeDt(theCode);
        return this;
    }

    public StringDt getComment() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public StringDt getCommentElement() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public AppointmentResponse setComment(StringDt theValue) {
        this.myComment = theValue;
        return this;
    }

    public AppointmentResponse setComment(String theString) {
        this.myComment = new StringDt(theString);
        return this;
    }

    public InstantDt getStart() {
        if (this.myStart == null) {
            this.myStart = new InstantDt();
        }
        return this.myStart;
    }

    public InstantDt getStartElement() {
        if (this.myStart == null) {
            this.myStart = new InstantDt();
        }
        return this.myStart;
    }

    public AppointmentResponse setStart(InstantDt theValue) {
        this.myStart = theValue;
        return this;
    }

    public AppointmentResponse setStartWithMillisPrecision(Date theDate) {
        this.myStart = new InstantDt(theDate);
        return this;
    }

    public AppointmentResponse setStart(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myStart = new InstantDt(theDate, thePrecision);
        return this;
    }

    public InstantDt getEnd() {
        if (this.myEnd == null) {
            this.myEnd = new InstantDt();
        }
        return this.myEnd;
    }

    public InstantDt getEndElement() {
        if (this.myEnd == null) {
            this.myEnd = new InstantDt();
        }
        return this.myEnd;
    }

    public AppointmentResponse setEnd(InstantDt theValue) {
        this.myEnd = theValue;
        return this;
    }

    public AppointmentResponse setEndWithMillisPrecision(Date theDate) {
        this.myEnd = new InstantDt(theDate);
        return this;
    }

    public AppointmentResponse setEnd(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myEnd = new InstantDt(theDate, thePrecision);
        return this;
    }

    public ScheduleDt getSchedule() {
        if (this.mySchedule == null) {
            this.mySchedule = new ScheduleDt();
        }
        return this.mySchedule;
    }

    public ScheduleDt getScheduleElement() {
        if (this.mySchedule == null) {
            this.mySchedule = new ScheduleDt();
        }
        return this.mySchedule;
    }

    public AppointmentResponse setSchedule(ScheduleDt theValue) {
        this.mySchedule = theValue;
        return this;
    }

    public StringDt getTimezone() {
        if (this.myTimezone == null) {
            this.myTimezone = new StringDt();
        }
        return this.myTimezone;
    }

    public StringDt getTimezoneElement() {
        if (this.myTimezone == null) {
            this.myTimezone = new StringDt();
        }
        return this.myTimezone;
    }

    public AppointmentResponse setTimezone(StringDt theValue) {
        this.myTimezone = theValue;
        return this;
    }

    public AppointmentResponse setTimezone(String theString) {
        this.myTimezone = new StringDt(theString);
        return this;
    }

    public ResourceReferenceDt getRecorder() {
        if (this.myRecorder == null) {
            this.myRecorder = new ResourceReferenceDt();
        }
        return this.myRecorder;
    }

    public ResourceReferenceDt getRecorderElement() {
        if (this.myRecorder == null) {
            this.myRecorder = new ResourceReferenceDt();
        }
        return this.myRecorder;
    }

    public AppointmentResponse setRecorder(ResourceReferenceDt theValue) {
        this.myRecorder = theValue;
        return this;
    }

    public DateTimeDt getRecordedDate() {
        if (this.myRecordedDate == null) {
            this.myRecordedDate = new DateTimeDt();
        }
        return this.myRecordedDate;
    }

    public DateTimeDt getRecordedDateElement() {
        if (this.myRecordedDate == null) {
            this.myRecordedDate = new DateTimeDt();
        }
        return this.myRecordedDate;
    }

    public AppointmentResponse setRecordedDate(DateTimeDt theValue) {
        this.myRecordedDate = theValue;
        return this;
    }

    public AppointmentResponse setRecordedDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myRecordedDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public AppointmentResponse setRecordedDateWithSecondsPrecision(Date theDate) {
        this.myRecordedDate = new DateTimeDt(theDate);
        return this;
    }

    public String getResourceName() {
        return "AppointmentResponse";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

