/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.DurationDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.valueset.AdmitSourceEnum;
import ca.uhn.fhir.model.dstu.valueset.EncounterClassEnum;
import ca.uhn.fhir.model.dstu.valueset.EncounterStateEnum;
import ca.uhn.fhir.model.dstu.valueset.EncounterTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ParticipantTypeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Encounter", profile="http://hl7.org/fhir/profiles/Encounter", id="encounter")
public class Encounter
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Encounter.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="status", path="Encounter.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="Encounter.period", description="A date within the period the Encounter lasted", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="subject", path="Encounter.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Encounter.subject");
    @SearchParamDefinition(name="length", path="Encounter.length", description="Length of encounter in days", type="number")
    public static final String SP_LENGTH = "length";
    public static final NumberClientParam LENGTH = new NumberClientParam("length");
    @SearchParamDefinition(name="indication", path="Encounter.indication", description="", type="reference")
    public static final String SP_INDICATION = "indication";
    public static final ReferenceClientParam INDICATION = new ReferenceClientParam("indication");
    public static final Include INCLUDE_INDICATION = new Include("Encounter.indication");
    @SearchParamDefinition(name="location", path="Encounter.location.location", description="", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION_LOCATION = new Include("Encounter.location.location");
    @SearchParamDefinition(name="location-period", path="Encounter.location.period", description="", type="date")
    public static final String SP_LOCATION_PERIOD = "location-period";
    public static final DateClientParam LOCATION_PERIOD = new DateClientParam("location-period");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Identifier(s) by which this encounter is known", formalDefinition="")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="planned | in progress | onleave | finished | cancelled", formalDefinition="")
    private BoundCodeDt<EncounterStateEnum> myStatus;
    @Child(name="class", type={CodeDt.class}, order=2, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="inpatient | outpatient | ambulatory | emergency +", formalDefinition="")
    private BoundCodeDt<EncounterClassEnum> myClassElement;
    @Child(name="type", type={CodeableConceptDt.class}, order=3, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Specific type of encounter", formalDefinition="Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation)")
    private List<BoundCodeableConceptDt<EncounterTypeEnum>> myType;
    @Child(name="subject", order=4, min=0, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="The patient present at the encounter", formalDefinition="")
    private ResourceReferenceDt mySubject;
    @Child(name="participant", order=5, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="List of participants involved in the encounter", formalDefinition="The main practitioner responsible for providing the service")
    private List<Participant> myParticipant;
    @Child(name="period", type={PeriodDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The start and end time of the encounter", formalDefinition="The start and end time of the encounter")
    private PeriodDt myPeriod;
    @Child(name="length", type={DurationDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Quantity of time the encounter lasted", formalDefinition="Quantity of time the encounter lasted. This excludes the time during leaves of absence.")
    private DurationDt myLength;
    @Child(name="reason", type={CodeableConceptDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Reason the encounter takes place (code)", formalDefinition="Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis.")
    private CodeableConceptDt myReason;
    @Child(name="indication", order=9, min=0, max=1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="Reason the encounter takes place (resource)", formalDefinition="Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis.")
    private ResourceReferenceDt myIndication;
    @Child(name="priority", type={CodeableConceptDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Indicates the urgency of the encounter", formalDefinition="")
    private CodeableConceptDt myPriority;
    @Child(name="hospitalization", order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Details about an admission to a clinic", formalDefinition="Details about an admission to a clinic")
    private Hospitalization myHospitalization;
    @Child(name="location", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="List of locations the patient has been at", formalDefinition="List of locations at which the patient has been")
    private List<Location> myLocation;
    @Child(name="serviceProvider", order=13, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="Department or team providing care", formalDefinition="")
    private ResourceReferenceDt myServiceProvider;
    @Child(name="partOf", order=14, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="Another Encounter this encounter is part of", formalDefinition="Another Encounter of which this encounter is a part of (administratively or in time).")
    private ResourceReferenceDt myPartOf;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myClassElement, this.myType, this.mySubject, this.myParticipant, this.myPeriod, this.myLength, this.myReason, this.myIndication, this.myPriority, this.myHospitalization, this.myLocation, this.myServiceProvider, this.myPartOf});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myClassElement, this.myType, this.mySubject, this.myParticipant, this.myPeriod, this.myLength, this.myReason, this.myIndication, this.myPriority, this.myHospitalization, this.myLocation, this.myServiceProvider, this.myPartOf});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Encounter setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Encounter addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Encounter addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public BoundCodeDt<EncounterStateEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(EncounterStateEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<EncounterStateEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(EncounterStateEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public Encounter setStatus(BoundCodeDt<EncounterStateEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Encounter setStatus(EncounterStateEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BoundCodeDt<EncounterClassEnum> getClassElement() {
        if (this.myClassElement == null) {
            this.myClassElement = new BoundCodeDt(EncounterClassEnum.VALUESET_BINDER);
        }
        return this.myClassElement;
    }

    public BoundCodeDt<EncounterClassEnum> getClassElementElement() {
        if (this.myClassElement == null) {
            this.myClassElement = new BoundCodeDt(EncounterClassEnum.VALUESET_BINDER);
        }
        return this.myClassElement;
    }

    public Encounter setClassElement(BoundCodeDt<EncounterClassEnum> theValue) {
        this.myClassElement = theValue;
        return this;
    }

    public Encounter setClassElement(EncounterClassEnum theValue) {
        this.getClassElement().setValueAsEnum((Enum)theValue);
        return this;
    }

    public List<BoundCodeableConceptDt<EncounterTypeEnum>> getType() {
        if (this.myType == null) {
            this.myType = new ArrayList<BoundCodeableConceptDt<EncounterTypeEnum>>();
        }
        return this.myType;
    }

    public List<BoundCodeableConceptDt<EncounterTypeEnum>> getTypeElement() {
        if (this.myType == null) {
            this.myType = new ArrayList<BoundCodeableConceptDt<EncounterTypeEnum>>();
        }
        return this.myType;
    }

    public Encounter setType(List<BoundCodeableConceptDt<EncounterTypeEnum>> theValue) {
        this.myType = theValue;
        return this;
    }

    public BoundCodeableConceptDt<EncounterTypeEnum> addType(EncounterTypeEnum theValue) {
        BoundCodeableConceptDt<EncounterTypeEnum> retVal = new BoundCodeableConceptDt<EncounterTypeEnum>(EncounterTypeEnum.VALUESET_BINDER, theValue);
        this.getType().add(retVal);
        return retVal;
    }

    public BoundCodeableConceptDt<EncounterTypeEnum> getTypeFirstRep() {
        if (this.getType().size() == 0) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public BoundCodeableConceptDt<EncounterTypeEnum> addType() {
        BoundCodeableConceptDt<EncounterTypeEnum> retVal = new BoundCodeableConceptDt<EncounterTypeEnum>(EncounterTypeEnum.VALUESET_BINDER);
        this.getType().add(retVal);
        return retVal;
    }

    public Encounter setType(EncounterTypeEnum theValue) {
        this.getType().clear();
        this.addType(theValue);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Encounter setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public List<Participant> getParticipant() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public List<Participant> getParticipantElement() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public Encounter setParticipant(List<Participant> theValue) {
        this.myParticipant = theValue;
        return this;
    }

    public Participant addParticipant() {
        Participant newType = new Participant();
        this.getParticipant().add(newType);
        return newType;
    }

    public Participant getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            return this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PeriodDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public Encounter setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public DurationDt getLength() {
        if (this.myLength == null) {
            this.myLength = new DurationDt();
        }
        return this.myLength;
    }

    public DurationDt getLengthElement() {
        if (this.myLength == null) {
            this.myLength = new DurationDt();
        }
        return this.myLength;
    }

    public Encounter setLength(DurationDt theValue) {
        this.myLength = theValue;
        return this;
    }

    public CodeableConceptDt getReason() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public CodeableConceptDt getReasonElement() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public Encounter setReason(CodeableConceptDt theValue) {
        this.myReason = theValue;
        return this;
    }

    public ResourceReferenceDt getIndication() {
        if (this.myIndication == null) {
            this.myIndication = new ResourceReferenceDt();
        }
        return this.myIndication;
    }

    public ResourceReferenceDt getIndicationElement() {
        if (this.myIndication == null) {
            this.myIndication = new ResourceReferenceDt();
        }
        return this.myIndication;
    }

    public Encounter setIndication(ResourceReferenceDt theValue) {
        this.myIndication = theValue;
        return this;
    }

    public CodeableConceptDt getPriority() {
        if (this.myPriority == null) {
            this.myPriority = new CodeableConceptDt();
        }
        return this.myPriority;
    }

    public CodeableConceptDt getPriorityElement() {
        if (this.myPriority == null) {
            this.myPriority = new CodeableConceptDt();
        }
        return this.myPriority;
    }

    public Encounter setPriority(CodeableConceptDt theValue) {
        this.myPriority = theValue;
        return this;
    }

    public Hospitalization getHospitalization() {
        if (this.myHospitalization == null) {
            this.myHospitalization = new Hospitalization();
        }
        return this.myHospitalization;
    }

    public Hospitalization getHospitalizationElement() {
        if (this.myHospitalization == null) {
            this.myHospitalization = new Hospitalization();
        }
        return this.myHospitalization;
    }

    public Encounter setHospitalization(Hospitalization theValue) {
        this.myHospitalization = theValue;
        return this;
    }

    public List<Location> getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ArrayList<Location>();
        }
        return this.myLocation;
    }

    public List<Location> getLocationElement() {
        if (this.myLocation == null) {
            this.myLocation = new ArrayList<Location>();
        }
        return this.myLocation;
    }

    public Encounter setLocation(List<Location> theValue) {
        this.myLocation = theValue;
        return this;
    }

    public Location addLocation() {
        Location newType = new Location();
        this.getLocation().add(newType);
        return newType;
    }

    public Location getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            return this.addLocation();
        }
        return this.getLocation().get(0);
    }

    public ResourceReferenceDt getServiceProvider() {
        if (this.myServiceProvider == null) {
            this.myServiceProvider = new ResourceReferenceDt();
        }
        return this.myServiceProvider;
    }

    public ResourceReferenceDt getServiceProviderElement() {
        if (this.myServiceProvider == null) {
            this.myServiceProvider = new ResourceReferenceDt();
        }
        return this.myServiceProvider;
    }

    public Encounter setServiceProvider(ResourceReferenceDt theValue) {
        this.myServiceProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getPartOf() {
        if (this.myPartOf == null) {
            this.myPartOf = new ResourceReferenceDt();
        }
        return this.myPartOf;
    }

    public ResourceReferenceDt getPartOfElement() {
        if (this.myPartOf == null) {
            this.myPartOf = new ResourceReferenceDt();
        }
        return this.myPartOf;
    }

    public Encounter setPartOf(ResourceReferenceDt theValue) {
        this.myPartOf = theValue;
        return this;
    }

    public String getResourceName() {
        return "Encounter";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Location
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="location", order=0, min=1, max=1, summary=false, modifier=false, type={ca.uhn.fhir.model.dstu.resource.Location.class})
        @Description(shortDefinition="Location the encounter takes place", formalDefinition="The location where the encounter takes place")
        private ResourceReferenceDt myLocation;
        @Child(name="period", type={PeriodDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Time period during which the patient was present at the location", formalDefinition="")
        private PeriodDt myPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLocation, this.myPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLocation, this.myPeriod});
        }

        public ResourceReferenceDt getLocation() {
            if (this.myLocation == null) {
                this.myLocation = new ResourceReferenceDt();
            }
            return this.myLocation;
        }

        public ResourceReferenceDt getLocationElement() {
            if (this.myLocation == null) {
                this.myLocation = new ResourceReferenceDt();
            }
            return this.myLocation;
        }

        public Location setLocation(ResourceReferenceDt theValue) {
            this.myLocation = theValue;
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public PeriodDt getPeriodElement() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Location setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }
    }

    @Block
    public static class HospitalizationAccomodation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="bed", order=0, min=0, max=1, summary=false, modifier=false, type={ca.uhn.fhir.model.dstu.resource.Location.class})
        @Description(shortDefinition="The bed that is assigned to the patient", formalDefinition="")
        private ResourceReferenceDt myBed;
        @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Period during which the patient was assigned the bed", formalDefinition="")
        private PeriodDt myPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myBed, this.myPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myBed, this.myPeriod});
        }

        public ResourceReferenceDt getBed() {
            if (this.myBed == null) {
                this.myBed = new ResourceReferenceDt();
            }
            return this.myBed;
        }

        public ResourceReferenceDt getBedElement() {
            if (this.myBed == null) {
                this.myBed = new ResourceReferenceDt();
            }
            return this.myBed;
        }

        public HospitalizationAccomodation setBed(ResourceReferenceDt theValue) {
            this.myBed = theValue;
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public PeriodDt getPeriodElement() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public HospitalizationAccomodation setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }
    }

    @Block
    public static class Hospitalization
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="preAdmissionIdentifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Pre-admission identifier", formalDefinition="")
        private IdentifierDt myPreAdmissionIdentifier;
        @Child(name="origin", order=1, min=0, max=1, summary=false, modifier=false, type={ca.uhn.fhir.model.dstu.resource.Location.class})
        @Description(shortDefinition="The location from which the patient came before admission", formalDefinition="")
        private ResourceReferenceDt myOrigin;
        @Child(name="admitSource", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="From where patient was admitted (physician referral, transfer)", formalDefinition="")
        private BoundCodeableConceptDt<AdmitSourceEnum> myAdmitSource;
        @Child(name="period", type={PeriodDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Period during which the patient was admitted", formalDefinition="Period during which the patient was admitted")
        private PeriodDt myPeriod;
        @Child(name="accomodation", order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Where the patient stays during this encounter", formalDefinition="")
        private List<HospitalizationAccomodation> myAccomodation;
        @Child(name="diet", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Dietary restrictions for the patient", formalDefinition="Dietary restrictions for the patient")
        private CodeableConceptDt myDiet;
        @Child(name="specialCourtesy", type={CodeableConceptDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Special courtesies (VIP, board member)", formalDefinition="")
        private List<CodeableConceptDt> mySpecialCourtesy;
        @Child(name="specialArrangement", type={CodeableConceptDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Wheelchair, translator, stretcher, etc", formalDefinition="")
        private List<CodeableConceptDt> mySpecialArrangement;
        @Child(name="destination", order=8, min=0, max=1, summary=false, modifier=false, type={ca.uhn.fhir.model.dstu.resource.Location.class})
        @Description(shortDefinition="Location to which the patient is discharged", formalDefinition="")
        private ResourceReferenceDt myDestination;
        @Child(name="dischargeDisposition", type={CodeableConceptDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Category or kind of location after discharge", formalDefinition="")
        private CodeableConceptDt myDischargeDisposition;
        @Child(name="dischargeDiagnosis", order=10, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="The final diagnosis given a patient before release from the hospital after all testing, surgery, and workup are complete", formalDefinition="")
        private ResourceReferenceDt myDischargeDiagnosis;
        @Child(name="reAdmission", type={BooleanDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Is this hospitalization a readmission?", formalDefinition="Whether this hospitalization is a readmission")
        private BooleanDt myReAdmission;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPreAdmissionIdentifier, this.myOrigin, this.myAdmitSource, this.myPeriod, this.myAccomodation, this.myDiet, this.mySpecialCourtesy, this.mySpecialArrangement, this.myDestination, this.myDischargeDisposition, this.myDischargeDiagnosis, this.myReAdmission});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPreAdmissionIdentifier, this.myOrigin, this.myAdmitSource, this.myPeriod, this.myAccomodation, this.myDiet, this.mySpecialCourtesy, this.mySpecialArrangement, this.myDestination, this.myDischargeDisposition, this.myDischargeDiagnosis, this.myReAdmission});
        }

        public IdentifierDt getPreAdmissionIdentifier() {
            if (this.myPreAdmissionIdentifier == null) {
                this.myPreAdmissionIdentifier = new IdentifierDt();
            }
            return this.myPreAdmissionIdentifier;
        }

        public IdentifierDt getPreAdmissionIdentifierElement() {
            if (this.myPreAdmissionIdentifier == null) {
                this.myPreAdmissionIdentifier = new IdentifierDt();
            }
            return this.myPreAdmissionIdentifier;
        }

        public Hospitalization setPreAdmissionIdentifier(IdentifierDt theValue) {
            this.myPreAdmissionIdentifier = theValue;
            return this;
        }

        public Hospitalization setPreAdmissionIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            this.myPreAdmissionIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
            return this;
        }

        public Hospitalization setPreAdmissionIdentifier(String theSystem, String theValue) {
            this.myPreAdmissionIdentifier = new IdentifierDt(theSystem, theValue);
            return this;
        }

        public ResourceReferenceDt getOrigin() {
            if (this.myOrigin == null) {
                this.myOrigin = new ResourceReferenceDt();
            }
            return this.myOrigin;
        }

        public ResourceReferenceDt getOriginElement() {
            if (this.myOrigin == null) {
                this.myOrigin = new ResourceReferenceDt();
            }
            return this.myOrigin;
        }

        public Hospitalization setOrigin(ResourceReferenceDt theValue) {
            this.myOrigin = theValue;
            return this;
        }

        public BoundCodeableConceptDt<AdmitSourceEnum> getAdmitSource() {
            if (this.myAdmitSource == null) {
                this.myAdmitSource = new BoundCodeableConceptDt<AdmitSourceEnum>(AdmitSourceEnum.VALUESET_BINDER);
            }
            return this.myAdmitSource;
        }

        public BoundCodeableConceptDt<AdmitSourceEnum> getAdmitSourceElement() {
            if (this.myAdmitSource == null) {
                this.myAdmitSource = new BoundCodeableConceptDt<AdmitSourceEnum>(AdmitSourceEnum.VALUESET_BINDER);
            }
            return this.myAdmitSource;
        }

        public Hospitalization setAdmitSource(BoundCodeableConceptDt<AdmitSourceEnum> theValue) {
            this.myAdmitSource = theValue;
            return this;
        }

        public Hospitalization setAdmitSource(AdmitSourceEnum theValue) {
            this.getAdmitSource().setValueAsEnum(theValue);
            return this;
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public PeriodDt getPeriodElement() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Hospitalization setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public List<HospitalizationAccomodation> getAccomodation() {
            if (this.myAccomodation == null) {
                this.myAccomodation = new ArrayList<HospitalizationAccomodation>();
            }
            return this.myAccomodation;
        }

        public List<HospitalizationAccomodation> getAccomodationElement() {
            if (this.myAccomodation == null) {
                this.myAccomodation = new ArrayList<HospitalizationAccomodation>();
            }
            return this.myAccomodation;
        }

        public Hospitalization setAccomodation(List<HospitalizationAccomodation> theValue) {
            this.myAccomodation = theValue;
            return this;
        }

        public HospitalizationAccomodation addAccomodation() {
            HospitalizationAccomodation newType = new HospitalizationAccomodation();
            this.getAccomodation().add(newType);
            return newType;
        }

        public HospitalizationAccomodation getAccomodationFirstRep() {
            if (this.getAccomodation().isEmpty()) {
                return this.addAccomodation();
            }
            return this.getAccomodation().get(0);
        }

        public CodeableConceptDt getDiet() {
            if (this.myDiet == null) {
                this.myDiet = new CodeableConceptDt();
            }
            return this.myDiet;
        }

        public CodeableConceptDt getDietElement() {
            if (this.myDiet == null) {
                this.myDiet = new CodeableConceptDt();
            }
            return this.myDiet;
        }

        public Hospitalization setDiet(CodeableConceptDt theValue) {
            this.myDiet = theValue;
            return this;
        }

        public List<CodeableConceptDt> getSpecialCourtesy() {
            if (this.mySpecialCourtesy == null) {
                this.mySpecialCourtesy = new ArrayList<CodeableConceptDt>();
            }
            return this.mySpecialCourtesy;
        }

        public List<CodeableConceptDt> getSpecialCourtesyElement() {
            if (this.mySpecialCourtesy == null) {
                this.mySpecialCourtesy = new ArrayList<CodeableConceptDt>();
            }
            return this.mySpecialCourtesy;
        }

        public Hospitalization setSpecialCourtesy(List<CodeableConceptDt> theValue) {
            this.mySpecialCourtesy = theValue;
            return this;
        }

        public CodeableConceptDt addSpecialCourtesy() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getSpecialCourtesy().add(newType);
            return newType;
        }

        public CodeableConceptDt getSpecialCourtesyFirstRep() {
            if (this.getSpecialCourtesy().isEmpty()) {
                return this.addSpecialCourtesy();
            }
            return this.getSpecialCourtesy().get(0);
        }

        public List<CodeableConceptDt> getSpecialArrangement() {
            if (this.mySpecialArrangement == null) {
                this.mySpecialArrangement = new ArrayList<CodeableConceptDt>();
            }
            return this.mySpecialArrangement;
        }

        public List<CodeableConceptDt> getSpecialArrangementElement() {
            if (this.mySpecialArrangement == null) {
                this.mySpecialArrangement = new ArrayList<CodeableConceptDt>();
            }
            return this.mySpecialArrangement;
        }

        public Hospitalization setSpecialArrangement(List<CodeableConceptDt> theValue) {
            this.mySpecialArrangement = theValue;
            return this;
        }

        public CodeableConceptDt addSpecialArrangement() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getSpecialArrangement().add(newType);
            return newType;
        }

        public CodeableConceptDt getSpecialArrangementFirstRep() {
            if (this.getSpecialArrangement().isEmpty()) {
                return this.addSpecialArrangement();
            }
            return this.getSpecialArrangement().get(0);
        }

        public ResourceReferenceDt getDestination() {
            if (this.myDestination == null) {
                this.myDestination = new ResourceReferenceDt();
            }
            return this.myDestination;
        }

        public ResourceReferenceDt getDestinationElement() {
            if (this.myDestination == null) {
                this.myDestination = new ResourceReferenceDt();
            }
            return this.myDestination;
        }

        public Hospitalization setDestination(ResourceReferenceDt theValue) {
            this.myDestination = theValue;
            return this;
        }

        public CodeableConceptDt getDischargeDisposition() {
            if (this.myDischargeDisposition == null) {
                this.myDischargeDisposition = new CodeableConceptDt();
            }
            return this.myDischargeDisposition;
        }

        public CodeableConceptDt getDischargeDispositionElement() {
            if (this.myDischargeDisposition == null) {
                this.myDischargeDisposition = new CodeableConceptDt();
            }
            return this.myDischargeDisposition;
        }

        public Hospitalization setDischargeDisposition(CodeableConceptDt theValue) {
            this.myDischargeDisposition = theValue;
            return this;
        }

        public ResourceReferenceDt getDischargeDiagnosis() {
            if (this.myDischargeDiagnosis == null) {
                this.myDischargeDiagnosis = new ResourceReferenceDt();
            }
            return this.myDischargeDiagnosis;
        }

        public ResourceReferenceDt getDischargeDiagnosisElement() {
            if (this.myDischargeDiagnosis == null) {
                this.myDischargeDiagnosis = new ResourceReferenceDt();
            }
            return this.myDischargeDiagnosis;
        }

        public Hospitalization setDischargeDiagnosis(ResourceReferenceDt theValue) {
            this.myDischargeDiagnosis = theValue;
            return this;
        }

        public BooleanDt getReAdmission() {
            if (this.myReAdmission == null) {
                this.myReAdmission = new BooleanDt();
            }
            return this.myReAdmission;
        }

        public BooleanDt getReAdmissionElement() {
            if (this.myReAdmission == null) {
                this.myReAdmission = new BooleanDt();
            }
            return this.myReAdmission;
        }

        public Hospitalization setReAdmission(BooleanDt theValue) {
            this.myReAdmission = theValue;
            return this;
        }

        public Hospitalization setReAdmission(boolean theBoolean) {
            this.myReAdmission = new BooleanDt(theBoolean);
            return this;
        }
    }

    @Block
    public static class Participant
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="Role of participant in encounter", formalDefinition="")
        private List<BoundCodeableConceptDt<ParticipantTypeEnum>> myType;
        @Child(name="individual", order=1, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, RelatedPerson.class})
        @Description(shortDefinition="Persons involved in the encounter other than the patient", formalDefinition="")
        private ResourceReferenceDt myIndividual;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myIndividual});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myIndividual});
        }

        public List<BoundCodeableConceptDt<ParticipantTypeEnum>> getType() {
            if (this.myType == null) {
                this.myType = new ArrayList<BoundCodeableConceptDt<ParticipantTypeEnum>>();
            }
            return this.myType;
        }

        public List<BoundCodeableConceptDt<ParticipantTypeEnum>> getTypeElement() {
            if (this.myType == null) {
                this.myType = new ArrayList<BoundCodeableConceptDt<ParticipantTypeEnum>>();
            }
            return this.myType;
        }

        public Participant setType(List<BoundCodeableConceptDt<ParticipantTypeEnum>> theValue) {
            this.myType = theValue;
            return this;
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> addType(ParticipantTypeEnum theValue) {
            BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER, theValue);
            this.getType().add(retVal);
            return retVal;
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> getTypeFirstRep() {
            if (this.getType().size() == 0) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public BoundCodeableConceptDt<ParticipantTypeEnum> addType() {
            BoundCodeableConceptDt<ParticipantTypeEnum> retVal = new BoundCodeableConceptDt<ParticipantTypeEnum>(ParticipantTypeEnum.VALUESET_BINDER);
            this.getType().add(retVal);
            return retVal;
        }

        public Participant setType(ParticipantTypeEnum theValue) {
            this.getType().clear();
            this.addType(theValue);
            return this;
        }

        public ResourceReferenceDt getIndividual() {
            if (this.myIndividual == null) {
                this.myIndividual = new ResourceReferenceDt();
            }
            return this.myIndividual;
        }

        public ResourceReferenceDt getIndividualElement() {
            if (this.myIndividual == null) {
                this.myIndividual = new ResourceReferenceDt();
            }
            return this.myIndividual;
        }

        public Participant setIndividual(ResourceReferenceDt theValue) {
            this.myIndividual = theValue;
            return this;
        }
    }
}

