/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Group;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ListModeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="List", profile="http://hl7.org/fhir/profiles/List", id="list")
public class ListResource
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="source", path="List.source", description="", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("List.source");
    @SearchParamDefinition(name="item", path="List.entry.item", description="", type="reference")
    public static final String SP_ITEM = "item";
    public static final ReferenceClientParam ITEM = new ReferenceClientParam("item");
    public static final Include INCLUDE_ENTRY_ITEM = new Include("List.entry.item");
    @SearchParamDefinition(name="empty-reason", path="List.emptyReason", description="", type="token")
    public static final String SP_EMPTY_REASON = "empty-reason";
    public static final TokenClientParam EMPTY_REASON = new TokenClientParam("empty-reason");
    @SearchParamDefinition(name="date", path="List.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="code", path="List.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="subject", path="List.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("List.subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Business identifier", formalDefinition="Identifier for the List assigned for business purposes outside the context of FHIR.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="code", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="What the purpose of this list is", formalDefinition="This code defines the purpose of the list - why it was created")
    private CodeableConceptDt myCode;
    @Child(name="subject", order=2, min=0, max=1, summary=false, modifier=false, type={Patient.class, Group.class, Device.class, Location.class})
    @Description(shortDefinition="If all resources have the same subject", formalDefinition="The common subject (or patient) of the resources that are in the list, if there is one")
    private ResourceReferenceDt mySubject;
    @Child(name="source", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Patient.class, Device.class})
    @Description(shortDefinition="Who and/or what defined the list contents", formalDefinition="The entity responsible for deciding what the contents of the list were")
    private ResourceReferenceDt mySource;
    @Child(name="date", type={DateTimeDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="When the list was prepared", formalDefinition="The date that the list was prepared")
    private DateTimeDt myDate;
    @Child(name="ordered", type={BooleanDt.class}, order=5, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="Whether items in the list have a meaningful order", formalDefinition="Whether items in the list have a meaningful order")
    private BooleanDt myOrdered;
    @Child(name="mode", type={CodeDt.class}, order=6, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="working | snapshot | changes", formalDefinition="How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted")
    private BoundCodeDt<ListModeEnum> myMode;
    @Child(name="entry", order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Entries in the list", formalDefinition="Entries in this list")
    private List<Entry> myEntry;
    @Child(name="emptyReason", type={CodeableConceptDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Why list is empty", formalDefinition="If the list is empty, why the list is empty")
    private CodeableConceptDt myEmptyReason;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myCode, this.mySubject, this.mySource, this.myDate, this.myOrdered, this.myMode, this.myEntry, this.myEmptyReason});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCode, this.mySubject, this.mySource, this.myDate, this.myOrdered, this.myMode, this.myEntry, this.myEmptyReason});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public ListResource setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ListResource addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public ListResource addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public CodeableConceptDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public ListResource setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ListResource setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public ResourceReferenceDt getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public ListResource setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public DateTimeDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public ListResource setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public ListResource setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ListResource setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public BooleanDt getOrdered() {
        if (this.myOrdered == null) {
            this.myOrdered = new BooleanDt();
        }
        return this.myOrdered;
    }

    public BooleanDt getOrderedElement() {
        if (this.myOrdered == null) {
            this.myOrdered = new BooleanDt();
        }
        return this.myOrdered;
    }

    public ListResource setOrdered(BooleanDt theValue) {
        this.myOrdered = theValue;
        return this;
    }

    public ListResource setOrdered(boolean theBoolean) {
        this.myOrdered = new BooleanDt(theBoolean);
        return this;
    }

    public BoundCodeDt<ListModeEnum> getMode() {
        if (this.myMode == null) {
            this.myMode = new BoundCodeDt(ListModeEnum.VALUESET_BINDER);
        }
        return this.myMode;
    }

    public BoundCodeDt<ListModeEnum> getModeElement() {
        if (this.myMode == null) {
            this.myMode = new BoundCodeDt(ListModeEnum.VALUESET_BINDER);
        }
        return this.myMode;
    }

    public ListResource setMode(BoundCodeDt<ListModeEnum> theValue) {
        this.myMode = theValue;
        return this;
    }

    public ListResource setMode(ListModeEnum theValue) {
        this.getMode().setValueAsEnum((Enum)theValue);
        return this;
    }

    public List<Entry> getEntry() {
        if (this.myEntry == null) {
            this.myEntry = new ArrayList<Entry>();
        }
        return this.myEntry;
    }

    public List<Entry> getEntryElement() {
        if (this.myEntry == null) {
            this.myEntry = new ArrayList<Entry>();
        }
        return this.myEntry;
    }

    public ListResource setEntry(List<Entry> theValue) {
        this.myEntry = theValue;
        return this;
    }

    public Entry addEntry() {
        Entry newType = new Entry();
        this.getEntry().add(newType);
        return newType;
    }

    public Entry getEntryFirstRep() {
        if (this.getEntry().isEmpty()) {
            return this.addEntry();
        }
        return this.getEntry().get(0);
    }

    public CodeableConceptDt getEmptyReason() {
        if (this.myEmptyReason == null) {
            this.myEmptyReason = new CodeableConceptDt();
        }
        return this.myEmptyReason;
    }

    public CodeableConceptDt getEmptyReasonElement() {
        if (this.myEmptyReason == null) {
            this.myEmptyReason = new CodeableConceptDt();
        }
        return this.myEmptyReason;
    }

    public ListResource setEmptyReason(CodeableConceptDt theValue) {
        this.myEmptyReason = theValue;
        return this;
    }

    public String getResourceName() {
        return "List";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Entry
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="flag", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Workflow information about this item", formalDefinition="The flag allows the system constructing the list to make one or more statements about the role and significance of the item in the list")
        private List<CodeableConceptDt> myFlag;
        @Child(name="deleted", type={BooleanDt.class}, order=1, min=0, max=1, summary=false, modifier=true)
        @Description(shortDefinition="If this item is actually marked as deleted", formalDefinition="True if this item is marked as deleted in the list.")
        private BooleanDt myDeleted;
        @Child(name="date", type={DateTimeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="When item added to list", formalDefinition="When this item was added to the list")
        private DateTimeDt myDate;
        @Child(name="item", order=3, min=1, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="Actual entry", formalDefinition="A reference to the actual resource from which data was derived")
        private ResourceReferenceDt myItem;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myFlag, this.myDeleted, this.myDate, this.myItem});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myFlag, this.myDeleted, this.myDate, this.myItem});
        }

        public List<CodeableConceptDt> getFlag() {
            if (this.myFlag == null) {
                this.myFlag = new ArrayList<CodeableConceptDt>();
            }
            return this.myFlag;
        }

        public List<CodeableConceptDt> getFlagElement() {
            if (this.myFlag == null) {
                this.myFlag = new ArrayList<CodeableConceptDt>();
            }
            return this.myFlag;
        }

        public Entry setFlag(List<CodeableConceptDt> theValue) {
            this.myFlag = theValue;
            return this;
        }

        public CodeableConceptDt addFlag() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getFlag().add(newType);
            return newType;
        }

        public CodeableConceptDt getFlagFirstRep() {
            if (this.getFlag().isEmpty()) {
                return this.addFlag();
            }
            return this.getFlag().get(0);
        }

        public BooleanDt getDeleted() {
            if (this.myDeleted == null) {
                this.myDeleted = new BooleanDt();
            }
            return this.myDeleted;
        }

        public BooleanDt getDeletedElement() {
            if (this.myDeleted == null) {
                this.myDeleted = new BooleanDt();
            }
            return this.myDeleted;
        }

        public Entry setDeleted(BooleanDt theValue) {
            this.myDeleted = theValue;
            return this;
        }

        public Entry setDeleted(boolean theBoolean) {
            this.myDeleted = new BooleanDt(theBoolean);
            return this;
        }

        public DateTimeDt getDate() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public DateTimeDt getDateElement() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public Entry setDate(DateTimeDt theValue) {
            this.myDate = theValue;
            return this;
        }

        public Entry setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDate = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Entry setDateWithSecondsPrecision(Date theDate) {
            this.myDate = new DateTimeDt(theDate);
            return this;
        }

        public ResourceReferenceDt getItem() {
            if (this.myItem == null) {
                this.myItem = new ResourceReferenceDt();
            }
            return this.myItem;
        }

        public ResourceReferenceDt getItemElement() {
            if (this.myItem == null) {
                this.myItem = new ResourceReferenceDt();
            }
            return this.myItem;
        }

        public Entry setItem(ResourceReferenceDt theValue) {
            this.myItem = theValue;
            return this;
        }
    }
}

