/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.AdverseReaction;
import ca.uhn.fhir.model.dstu.resource.AllergyIntolerance;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.CarePlan;
import ca.uhn.fhir.model.dstu.resource.Condition;
import ca.uhn.fhir.model.dstu.resource.DeviceObservationReport;
import ca.uhn.fhir.model.dstu.resource.DiagnosticReport;
import ca.uhn.fhir.model.dstu.resource.Encounter;
import ca.uhn.fhir.model.dstu.resource.FamilyHistory;
import ca.uhn.fhir.model.dstu.resource.ImagingStudy;
import ca.uhn.fhir.model.dstu.resource.Immunization;
import ca.uhn.fhir.model.dstu.resource.ImmunizationRecommendation;
import ca.uhn.fhir.model.dstu.resource.MedicationAdministration;
import ca.uhn.fhir.model.dstu.resource.MedicationDispense;
import ca.uhn.fhir.model.dstu.resource.MedicationPrescription;
import ca.uhn.fhir.model.dstu.resource.MedicationStatement;
import ca.uhn.fhir.model.dstu.resource.Observation;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ProcedureRelationshipTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Procedure", profile="http://hl7.org/fhir/profiles/Procedure", id="procedure")
public class Procedure
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="Procedure.type", description="Type of procedure", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="subject", path="Procedure.subject", description="The identity of a patient to list procedures  for", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Procedure.subject");
    @SearchParamDefinition(name="date", path="Procedure.date", description="The date the procedure was performed on", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="External Ids for this procedure", formalDefinition="This records identifiers associated with this procedure that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=1, min=1, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="Who procedure was performed on", formalDefinition="The person on whom the procedure was performed")
    private ResourceReferenceDt mySubject;
    @Child(name="type", type={CodeableConceptDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Identification of the procedure", formalDefinition="The specific procedure that is performed. Use text if the exact nature of the procedure can't be coded")
    private CodeableConceptDt myType;
    @Child(name="bodySite", type={CodeableConceptDt.class}, order=3, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Precise location details", formalDefinition="Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion")
    private List<CodeableConceptDt> myBodySite;
    @Child(name="indication", type={CodeableConceptDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Reason procedure performed", formalDefinition="The reason why the procedure was performed. This may be due to a Condition, may be coded entity of some type, or may simply be present as text")
    private List<CodeableConceptDt> myIndication;
    @Child(name="performer", order=5, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="The people who performed the procedure", formalDefinition="Limited to 'real' people rather than equipment")
    private List<Performer> myPerformer;
    @Child(name="date", type={PeriodDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="The date the procedure was performed", formalDefinition="The dates over which the procedure was performed. Allows a period to support complex procedures that span more that one date, and also allows for the length of the procedure to be captured.")
    private PeriodDt myDate;
    @Child(name="encounter", order=7, min=0, max=1, summary=true, modifier=false, type={Encounter.class})
    @Description(shortDefinition="The encounter when procedure performed", formalDefinition="The encounter during which the procedure was performed")
    private ResourceReferenceDt myEncounter;
    @Child(name="outcome", type={StringDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="What was result of procedure?", formalDefinition="What was the outcome of the procedure - did it resolve reasons why the procedure was performed?")
    private StringDt myOutcome;
    @Child(name="report", order=9, min=0, max=-1, summary=false, modifier=false, type={DiagnosticReport.class})
    @Description(shortDefinition="Any report that results from the procedure", formalDefinition="This could be a histology result. There could potentially be multiple reports - e.g. if this was a procedure that made multiple biopsies")
    private List<ResourceReferenceDt> myReport;
    @Child(name="complication", type={CodeableConceptDt.class}, order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Complication following the procedure", formalDefinition="Any complications that occurred during the procedure, or in the immediate post-operative period. These are generally tracked separately from the notes, which typically will describe the procedure itself rather than any 'post procedure' issues")
    private List<CodeableConceptDt> myComplication;
    @Child(name="followUp", type={StringDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Instructions for follow up", formalDefinition="If the procedure required specific follow up - e.g. removal of sutures. The followup may be represented as a simple note, or potentially could be more complex in which case the CarePlan resource can be used")
    private StringDt myFollowUp;
    @Child(name="relatedItem", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="A procedure that is related to this one", formalDefinition="Procedures may be related to other items such as procedures or medications. For example treating wound dehiscence following a previous procedure")
    private List<RelatedItem> myRelatedItem;
    @Child(name="notes", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Additional information about procedure", formalDefinition="Any other notes about the procedure - e.g. the operative notes")
    private StringDt myNotes;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.mySubject, this.myType, this.myBodySite, this.myIndication, this.myPerformer, this.myDate, this.myEncounter, this.myOutcome, this.myReport, this.myComplication, this.myFollowUp, this.myRelatedItem, this.myNotes});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.mySubject, this.myType, this.myBodySite, this.myIndication, this.myPerformer, this.myDate, this.myEncounter, this.myOutcome, this.myReport, this.myComplication, this.myFollowUp, this.myRelatedItem, this.myNotes});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Procedure setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Procedure addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Procedure addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Procedure setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public CodeableConceptDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Procedure setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public List<CodeableConceptDt> getBodySite() {
        if (this.myBodySite == null) {
            this.myBodySite = new ArrayList<CodeableConceptDt>();
        }
        return this.myBodySite;
    }

    public List<CodeableConceptDt> getBodySiteElement() {
        if (this.myBodySite == null) {
            this.myBodySite = new ArrayList<CodeableConceptDt>();
        }
        return this.myBodySite;
    }

    public Procedure setBodySite(List<CodeableConceptDt> theValue) {
        this.myBodySite = theValue;
        return this;
    }

    public CodeableConceptDt addBodySite() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getBodySite().add(newType);
        return newType;
    }

    public CodeableConceptDt getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            return this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public List<CodeableConceptDt> getIndication() {
        if (this.myIndication == null) {
            this.myIndication = new ArrayList<CodeableConceptDt>();
        }
        return this.myIndication;
    }

    public List<CodeableConceptDt> getIndicationElement() {
        if (this.myIndication == null) {
            this.myIndication = new ArrayList<CodeableConceptDt>();
        }
        return this.myIndication;
    }

    public Procedure setIndication(List<CodeableConceptDt> theValue) {
        this.myIndication = theValue;
        return this;
    }

    public CodeableConceptDt addIndication() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getIndication().add(newType);
        return newType;
    }

    public CodeableConceptDt getIndicationFirstRep() {
        if (this.getIndication().isEmpty()) {
            return this.addIndication();
        }
        return this.getIndication().get(0);
    }

    public List<Performer> getPerformer() {
        if (this.myPerformer == null) {
            this.myPerformer = new ArrayList<Performer>();
        }
        return this.myPerformer;
    }

    public List<Performer> getPerformerElement() {
        if (this.myPerformer == null) {
            this.myPerformer = new ArrayList<Performer>();
        }
        return this.myPerformer;
    }

    public Procedure setPerformer(List<Performer> theValue) {
        this.myPerformer = theValue;
        return this;
    }

    public Performer addPerformer() {
        Performer newType = new Performer();
        this.getPerformer().add(newType);
        return newType;
    }

    public Performer getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            return this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public PeriodDt getDate() {
        if (this.myDate == null) {
            this.myDate = new PeriodDt();
        }
        return this.myDate;
    }

    public PeriodDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new PeriodDt();
        }
        return this.myDate;
    }

    public Procedure setDate(PeriodDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public ResourceReferenceDt getEncounterElement() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Procedure setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public StringDt getOutcome() {
        if (this.myOutcome == null) {
            this.myOutcome = new StringDt();
        }
        return this.myOutcome;
    }

    public StringDt getOutcomeElement() {
        if (this.myOutcome == null) {
            this.myOutcome = new StringDt();
        }
        return this.myOutcome;
    }

    public Procedure setOutcome(StringDt theValue) {
        this.myOutcome = theValue;
        return this;
    }

    public Procedure setOutcome(String theString) {
        this.myOutcome = new StringDt(theString);
        return this;
    }

    public List<ResourceReferenceDt> getReport() {
        if (this.myReport == null) {
            this.myReport = new ArrayList<ResourceReferenceDt>();
        }
        return this.myReport;
    }

    public List<ResourceReferenceDt> getReportElement() {
        if (this.myReport == null) {
            this.myReport = new ArrayList<ResourceReferenceDt>();
        }
        return this.myReport;
    }

    public Procedure setReport(List<ResourceReferenceDt> theValue) {
        this.myReport = theValue;
        return this;
    }

    public ResourceReferenceDt addReport() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getReport().add(newType);
        return newType;
    }

    public List<CodeableConceptDt> getComplication() {
        if (this.myComplication == null) {
            this.myComplication = new ArrayList<CodeableConceptDt>();
        }
        return this.myComplication;
    }

    public List<CodeableConceptDt> getComplicationElement() {
        if (this.myComplication == null) {
            this.myComplication = new ArrayList<CodeableConceptDt>();
        }
        return this.myComplication;
    }

    public Procedure setComplication(List<CodeableConceptDt> theValue) {
        this.myComplication = theValue;
        return this;
    }

    public CodeableConceptDt addComplication() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getComplication().add(newType);
        return newType;
    }

    public CodeableConceptDt getComplicationFirstRep() {
        if (this.getComplication().isEmpty()) {
            return this.addComplication();
        }
        return this.getComplication().get(0);
    }

    public StringDt getFollowUp() {
        if (this.myFollowUp == null) {
            this.myFollowUp = new StringDt();
        }
        return this.myFollowUp;
    }

    public StringDt getFollowUpElement() {
        if (this.myFollowUp == null) {
            this.myFollowUp = new StringDt();
        }
        return this.myFollowUp;
    }

    public Procedure setFollowUp(StringDt theValue) {
        this.myFollowUp = theValue;
        return this;
    }

    public Procedure setFollowUp(String theString) {
        this.myFollowUp = new StringDt(theString);
        return this;
    }

    public List<RelatedItem> getRelatedItem() {
        if (this.myRelatedItem == null) {
            this.myRelatedItem = new ArrayList<RelatedItem>();
        }
        return this.myRelatedItem;
    }

    public List<RelatedItem> getRelatedItemElement() {
        if (this.myRelatedItem == null) {
            this.myRelatedItem = new ArrayList<RelatedItem>();
        }
        return this.myRelatedItem;
    }

    public Procedure setRelatedItem(List<RelatedItem> theValue) {
        this.myRelatedItem = theValue;
        return this;
    }

    public RelatedItem addRelatedItem() {
        RelatedItem newType = new RelatedItem();
        this.getRelatedItem().add(newType);
        return newType;
    }

    public RelatedItem getRelatedItemFirstRep() {
        if (this.getRelatedItem().isEmpty()) {
            return this.addRelatedItem();
        }
        return this.getRelatedItem().get(0);
    }

    public StringDt getNotes() {
        if (this.myNotes == null) {
            this.myNotes = new StringDt();
        }
        return this.myNotes;
    }

    public StringDt getNotesElement() {
        if (this.myNotes == null) {
            this.myNotes = new StringDt();
        }
        return this.myNotes;
    }

    public Procedure setNotes(StringDt theValue) {
        this.myNotes = theValue;
        return this;
    }

    public Procedure setNotes(String theString) {
        this.myNotes = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "Procedure";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class RelatedItem
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="caused-by | because-of", formalDefinition="The nature of the relationship")
        private BoundCodeDt<ProcedureRelationshipTypeEnum> myType;
        @Child(name="target", order=1, min=0, max=1, summary=false, modifier=false, type={AdverseReaction.class, AllergyIntolerance.class, CarePlan.class, Condition.class, DeviceObservationReport.class, DiagnosticReport.class, FamilyHistory.class, ImagingStudy.class, Immunization.class, ImmunizationRecommendation.class, MedicationAdministration.class, MedicationDispense.class, MedicationPrescription.class, MedicationStatement.class, Observation.class, Procedure.class})
        @Description(shortDefinition="The related item - e.g. a procedure", formalDefinition="")
        private ResourceReferenceDt myTarget;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myTarget});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myTarget});
        }

        public BoundCodeDt<ProcedureRelationshipTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ProcedureRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<ProcedureRelationshipTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ProcedureRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public RelatedItem setType(BoundCodeDt<ProcedureRelationshipTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public RelatedItem setType(ProcedureRelationshipTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public ResourceReferenceDt getTargetElement() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public RelatedItem setTarget(ResourceReferenceDt theValue) {
            this.myTarget = theValue;
            return this;
        }
    }

    @Block
    public static class Performer
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="person", order=0, min=0, max=1, summary=true, modifier=false, type={Practitioner.class})
        @Description(shortDefinition="The reference to the practitioner", formalDefinition="The practitioner who was involved in the procedure")
        private ResourceReferenceDt myPerson;
        @Child(name="role", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="The role the person was in", formalDefinition="E.g. surgeon, anaethetist, endoscopist")
        private CodeableConceptDt myRole;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myPerson, this.myRole});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPerson, this.myRole});
        }

        public ResourceReferenceDt getPerson() {
            if (this.myPerson == null) {
                this.myPerson = new ResourceReferenceDt();
            }
            return this.myPerson;
        }

        public ResourceReferenceDt getPersonElement() {
            if (this.myPerson == null) {
                this.myPerson = new ResourceReferenceDt();
            }
            return this.myPerson;
        }

        public Performer setPerson(ResourceReferenceDt theValue) {
            this.myPerson = theValue;
            return this;
        }

        public CodeableConceptDt getRole() {
            if (this.myRole == null) {
                this.myRole = new CodeableConceptDt();
            }
            return this.myRole;
        }

        public CodeableConceptDt getRoleElement() {
            if (this.myRole == null) {
                this.myRole = new CodeableConceptDt();
            }
            return this.myRole;
        }

        public Performer setRole(CodeableConceptDt theValue) {
            this.myRole = theValue;
            return this;
        }
    }
}

