/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.base.resource.BaseSecurityEvent;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventActionEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectLifecycleEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectRoleEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventOutcomeEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventParticipantNetworkTypeEnum;
import ca.uhn.fhir.model.primitive.Base64BinaryDt;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="SecurityEvent", profile="http://hl7.org/fhir/profiles/SecurityEvent", id="securityevent")
public class SecurityEvent
extends BaseResource
implements BaseSecurityEvent {
    @SearchParamDefinition(name="type", path="SecurityEvent.event.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="action", path="SecurityEvent.event.action", description="", type="token")
    public static final String SP_ACTION = "action";
    public static final TokenClientParam ACTION = new TokenClientParam("action");
    @SearchParamDefinition(name="date", path="SecurityEvent.event.dateTime", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="subtype", path="SecurityEvent.event.subtype", description="", type="token")
    public static final String SP_SUBTYPE = "subtype";
    public static final TokenClientParam SUBTYPE = new TokenClientParam("subtype");
    @SearchParamDefinition(name="user", path="SecurityEvent.participant.userId", description="", type="token")
    public static final String SP_USER = "user";
    public static final TokenClientParam USER = new TokenClientParam("user");
    @SearchParamDefinition(name="name", path="SecurityEvent.participant.name", description="", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="address", path="SecurityEvent.participant.network.identifier", description="", type="token")
    public static final String SP_ADDRESS = "address";
    public static final TokenClientParam ADDRESS = new TokenClientParam("address");
    @SearchParamDefinition(name="source", path="SecurityEvent.source.identifier", description="", type="token")
    public static final String SP_SOURCE = "source";
    public static final TokenClientParam SOURCE = new TokenClientParam("source");
    @SearchParamDefinition(name="site", path="SecurityEvent.source.site", description="", type="token")
    public static final String SP_SITE = "site";
    public static final TokenClientParam SITE = new TokenClientParam("site");
    @SearchParamDefinition(name="object-type", path="SecurityEvent.object.type", description="", type="token")
    public static final String SP_OBJECT_TYPE = "object-type";
    public static final TokenClientParam OBJECT_TYPE = new TokenClientParam("object-type");
    @SearchParamDefinition(name="identity", path="SecurityEvent.object.identifier", description="", type="token")
    public static final String SP_IDENTITY = "identity";
    public static final TokenClientParam IDENTITY = new TokenClientParam("identity");
    @SearchParamDefinition(name="reference", path="SecurityEvent.object.reference", description="", type="reference")
    public static final String SP_REFERENCE = "reference";
    public static final ReferenceClientParam REFERENCE = new ReferenceClientParam("reference");
    public static final Include INCLUDE_OBJECT_REFERENCE = new Include("SecurityEvent.object.reference");
    @SearchParamDefinition(name="desc", path="SecurityEvent.object.name", description="", type="string")
    public static final String SP_DESC = "desc";
    public static final StringClientParam DESC = new StringClientParam("desc");
    @SearchParamDefinition(name="patientid", path="", description="The id of the patient (one of multiple kinds of participations)", type="token")
    public static final String SP_PATIENTID = "patientid";
    public static final TokenClientParam PATIENTID = new TokenClientParam("patientid");
    @SearchParamDefinition(name="altid", path="SecurityEvent.participant.altId", description="", type="token")
    public static final String SP_ALTID = "altid";
    public static final TokenClientParam ALTID = new TokenClientParam("altid");
    @Child(name="event", order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="What was done", formalDefinition="Identifies the name, action type, time, and disposition of the audited event")
    private Event myEvent;
    @Child(name="participant", order=1, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="A person, a hardware device or software process", formalDefinition="")
    private List<Participant> myParticipant;
    @Child(name="source", order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Application systems and processes", formalDefinition="")
    private Source mySource;
    @Child(name="object", order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Specific instances of data or objects that have been accessed", formalDefinition="Specific instances of data or objects that have been accessed")
    private List<ObjectElement> myObject;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myEvent, this.myParticipant, this.mySource, this.myObject});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEvent, this.myParticipant, this.mySource, this.myObject});
    }

    public Event getEvent() {
        if (this.myEvent == null) {
            this.myEvent = new Event();
        }
        return this.myEvent;
    }

    public Event getEventElement() {
        if (this.myEvent == null) {
            this.myEvent = new Event();
        }
        return this.myEvent;
    }

    public SecurityEvent setEvent(Event theValue) {
        this.myEvent = theValue;
        return this;
    }

    public List<Participant> getParticipant() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public List<Participant> getParticipantElement() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public SecurityEvent setParticipant(List<Participant> theValue) {
        this.myParticipant = theValue;
        return this;
    }

    public Participant addParticipant() {
        Participant newType = new Participant();
        this.getParticipant().add(newType);
        return newType;
    }

    public Participant getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            return this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public Source getSource() {
        if (this.mySource == null) {
            this.mySource = new Source();
        }
        return this.mySource;
    }

    public Source getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new Source();
        }
        return this.mySource;
    }

    public SecurityEvent setSource(Source theValue) {
        this.mySource = theValue;
        return this;
    }

    public List<ObjectElement> getObject() {
        if (this.myObject == null) {
            this.myObject = new ArrayList<ObjectElement>();
        }
        return this.myObject;
    }

    public List<ObjectElement> getObjectElement() {
        if (this.myObject == null) {
            this.myObject = new ArrayList<ObjectElement>();
        }
        return this.myObject;
    }

    public SecurityEvent setObject(List<ObjectElement> theValue) {
        this.myObject = theValue;
        return this;
    }

    public ObjectElement addObject() {
        ObjectElement newType = new ObjectElement();
        this.getObject().add(newType);
        return newType;
    }

    public ObjectElement getObjectFirstRep() {
        if (this.getObject().isEmpty()) {
            return this.addObject();
        }
        return this.getObject().get(0);
    }

    public String getResourceName() {
        return "SecurityEvent";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class ObjectDetail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name of the property", formalDefinition="")
        private StringDt myType;
        @Child(name="value", type={Base64BinaryDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Property value", formalDefinition="")
        private Base64BinaryDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myValue});
        }

        public StringDt getType() {
            if (this.myType == null) {
                this.myType = new StringDt();
            }
            return this.myType;
        }

        public StringDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new StringDt();
            }
            return this.myType;
        }

        public ObjectDetail setType(StringDt theValue) {
            this.myType = theValue;
            return this;
        }

        public ObjectDetail setType(String theString) {
            this.myType = new StringDt(theString);
            return this;
        }

        public Base64BinaryDt getValue() {
            if (this.myValue == null) {
                this.myValue = new Base64BinaryDt();
            }
            return this.myValue;
        }

        public Base64BinaryDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new Base64BinaryDt();
            }
            return this.myValue;
        }

        public ObjectDetail setValue(Base64BinaryDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public ObjectDetail setValue(byte[] theBytes) {
            this.myValue = new Base64BinaryDt(theBytes);
            return this;
        }
    }

    @Block
    public static class ObjectElement
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Specific instance of object (e.g. versioned)", formalDefinition="Identifies a specific instance of the participant object. The reference should always be version specific")
        private IdentifierDt myIdentifier;
        @Child(name="reference", order=1, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="Specific instance of resource (e.g. versioned)", formalDefinition="Identifies a specific instance of the participant object. The reference should always be version specific")
        private ResourceReferenceDt myReference;
        @Child(name="type", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Object type being audited", formalDefinition="Object type being audited")
        private BoundCodeDt<SecurityEventObjectTypeEnum> myType;
        @Child(name="role", type={CodeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Functional application role of Object", formalDefinition="Code representing the functional application role of Participant Object being audited")
        private BoundCodeDt<SecurityEventObjectRoleEnum> myRole;
        @Child(name="lifecycle", type={CodeDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Life-cycle stage for the object", formalDefinition="Identifier for the data life-cycle stage for the participant object")
        private BoundCodeDt<SecurityEventObjectLifecycleEnum> myLifecycle;
        @Child(name="sensitivity", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Policy-defined sensitivity for the object", formalDefinition="Denotes policy-defined sensitivity for the Participant Object ID such as VIP, HIV status, mental health status or similar topics")
        private CodeableConceptDt mySensitivity;
        @Child(name="name", type={StringDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Instance-specific descriptor for Object", formalDefinition="An instance-specific descriptor of the Participant Object ID audited, such as a person's name")
        private StringDt myName;
        @Child(name="description", type={StringDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Descriptive text", formalDefinition="Text that describes the object in more detail")
        private StringDt myDescription;
        @Child(name="query", type={Base64BinaryDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Actual query for object", formalDefinition="The actual query for a query-type participant object")
        private Base64BinaryDt myQuery;
        @Child(name="detail", order=9, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Additional Information about the Object", formalDefinition="")
        private List<ObjectDetail> myDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myReference, this.myType, this.myRole, this.myLifecycle, this.mySensitivity, this.myName, this.myDescription, this.myQuery, this.myDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myReference, this.myType, this.myRole, this.myLifecycle, this.mySensitivity, this.myName, this.myDescription, this.myQuery, this.myDetail});
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public IdentifierDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public ObjectElement setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public ObjectElement setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
            return this;
        }

        public ObjectElement setIdentifier(String theSystem, String theValue) {
            this.myIdentifier = new IdentifierDt(theSystem, theValue);
            return this;
        }

        public ResourceReferenceDt getReference() {
            if (this.myReference == null) {
                this.myReference = new ResourceReferenceDt();
            }
            return this.myReference;
        }

        public ResourceReferenceDt getReferenceElement() {
            if (this.myReference == null) {
                this.myReference = new ResourceReferenceDt();
            }
            return this.myReference;
        }

        public ObjectElement setReference(ResourceReferenceDt theValue) {
            this.myReference = theValue;
            return this;
        }

        public BoundCodeDt<SecurityEventObjectTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(SecurityEventObjectTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<SecurityEventObjectTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(SecurityEventObjectTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public ObjectElement setType(BoundCodeDt<SecurityEventObjectTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public ObjectElement setType(SecurityEventObjectTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BoundCodeDt<SecurityEventObjectRoleEnum> getRole() {
            if (this.myRole == null) {
                this.myRole = new BoundCodeDt(SecurityEventObjectRoleEnum.VALUESET_BINDER);
            }
            return this.myRole;
        }

        public BoundCodeDt<SecurityEventObjectRoleEnum> getRoleElement() {
            if (this.myRole == null) {
                this.myRole = new BoundCodeDt(SecurityEventObjectRoleEnum.VALUESET_BINDER);
            }
            return this.myRole;
        }

        public ObjectElement setRole(BoundCodeDt<SecurityEventObjectRoleEnum> theValue) {
            this.myRole = theValue;
            return this;
        }

        public ObjectElement setRole(SecurityEventObjectRoleEnum theValue) {
            this.getRole().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BoundCodeDt<SecurityEventObjectLifecycleEnum> getLifecycle() {
            if (this.myLifecycle == null) {
                this.myLifecycle = new BoundCodeDt(SecurityEventObjectLifecycleEnum.VALUESET_BINDER);
            }
            return this.myLifecycle;
        }

        public BoundCodeDt<SecurityEventObjectLifecycleEnum> getLifecycleElement() {
            if (this.myLifecycle == null) {
                this.myLifecycle = new BoundCodeDt(SecurityEventObjectLifecycleEnum.VALUESET_BINDER);
            }
            return this.myLifecycle;
        }

        public ObjectElement setLifecycle(BoundCodeDt<SecurityEventObjectLifecycleEnum> theValue) {
            this.myLifecycle = theValue;
            return this;
        }

        public ObjectElement setLifecycle(SecurityEventObjectLifecycleEnum theValue) {
            this.getLifecycle().setValueAsEnum((Enum)theValue);
            return this;
        }

        public CodeableConceptDt getSensitivity() {
            if (this.mySensitivity == null) {
                this.mySensitivity = new CodeableConceptDt();
            }
            return this.mySensitivity;
        }

        public CodeableConceptDt getSensitivityElement() {
            if (this.mySensitivity == null) {
                this.mySensitivity = new CodeableConceptDt();
            }
            return this.mySensitivity;
        }

        public ObjectElement setSensitivity(CodeableConceptDt theValue) {
            this.mySensitivity = theValue;
            return this;
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public ObjectElement setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public ObjectElement setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public ObjectElement setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public ObjectElement setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public Base64BinaryDt getQuery() {
            if (this.myQuery == null) {
                this.myQuery = new Base64BinaryDt();
            }
            return this.myQuery;
        }

        public Base64BinaryDt getQueryElement() {
            if (this.myQuery == null) {
                this.myQuery = new Base64BinaryDt();
            }
            return this.myQuery;
        }

        public ObjectElement setQuery(Base64BinaryDt theValue) {
            this.myQuery = theValue;
            return this;
        }

        public ObjectElement setQuery(byte[] theBytes) {
            this.myQuery = new Base64BinaryDt(theBytes);
            return this;
        }

        public List<ObjectDetail> getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ObjectDetail>();
            }
            return this.myDetail;
        }

        public List<ObjectDetail> getDetailElement() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ObjectDetail>();
            }
            return this.myDetail;
        }

        public ObjectElement setDetail(List<ObjectDetail> theValue) {
            this.myDetail = theValue;
            return this;
        }

        public ObjectDetail addDetail() {
            ObjectDetail newType = new ObjectDetail();
            this.getDetail().add(newType);
            return newType;
        }

        public ObjectDetail getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                return this.addDetail();
            }
            return this.getDetail().get(0);
        }
    }

    @Block
    public static class Source
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="site", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Logical source location within the enterprise", formalDefinition="Logical source location within the healthcare enterprise network")
        private StringDt mySite;
        @Child(name="identifier", type={StringDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The id of source where event originated", formalDefinition="Identifier of the source where the event originated")
        private StringDt myIdentifier;
        @Child(name="type", type={CodingDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="The type of source where event originated", formalDefinition="Code specifying the type of source where event originated")
        private List<CodingDt> myType;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySite, this.myIdentifier, this.myType});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySite, this.myIdentifier, this.myType});
        }

        public StringDt getSite() {
            if (this.mySite == null) {
                this.mySite = new StringDt();
            }
            return this.mySite;
        }

        public StringDt getSiteElement() {
            if (this.mySite == null) {
                this.mySite = new StringDt();
            }
            return this.mySite;
        }

        public Source setSite(StringDt theValue) {
            this.mySite = theValue;
            return this;
        }

        public Source setSite(String theString) {
            this.mySite = new StringDt(theString);
            return this;
        }

        public StringDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new StringDt();
            }
            return this.myIdentifier;
        }

        public StringDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new StringDt();
            }
            return this.myIdentifier;
        }

        public Source setIdentifier(StringDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Source setIdentifier(String theString) {
            this.myIdentifier = new StringDt(theString);
            return this;
        }

        public List<CodingDt> getType() {
            if (this.myType == null) {
                this.myType = new ArrayList<CodingDt>();
            }
            return this.myType;
        }

        public List<CodingDt> getTypeElement() {
            if (this.myType == null) {
                this.myType = new ArrayList<CodingDt>();
            }
            return this.myType;
        }

        public Source setType(List<CodingDt> theValue) {
            this.myType = theValue;
            return this;
        }

        public CodingDt addType() {
            CodingDt newType = new CodingDt();
            this.getType().add(newType);
            return newType;
        }

        public CodingDt getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                return this.addType();
            }
            return this.getType().get(0);
        }
    }

    @Block
    public static class ParticipantNetwork
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifier for the network access point of the user device", formalDefinition="An identifier for the network access point of the user device for the audit event")
        private StringDt myIdentifier;
        @Child(name="type", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The type of network access point", formalDefinition="An identifier for the type of network access point that originated the audit event")
        private BoundCodeDt<SecurityEventParticipantNetworkTypeEnum> myType;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentifier, this.myType});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myType});
        }

        public StringDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new StringDt();
            }
            return this.myIdentifier;
        }

        public StringDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new StringDt();
            }
            return this.myIdentifier;
        }

        public ParticipantNetwork setIdentifier(StringDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public ParticipantNetwork setIdentifier(String theString) {
            this.myIdentifier = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<SecurityEventParticipantNetworkTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(SecurityEventParticipantNetworkTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<SecurityEventParticipantNetworkTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(SecurityEventParticipantNetworkTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public ParticipantNetwork setType(BoundCodeDt<SecurityEventParticipantNetworkTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public ParticipantNetwork setType(SecurityEventParticipantNetworkTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }
    }

    @Block
    public static class Participant
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="role", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="User roles (e.g. local RBAC codes)", formalDefinition="Specification of the role(s) the user plays when performing the event. Usually the codes used in this element are local codes defined by the role-based access control security system used in the local context")
        private List<CodeableConceptDt> myRole;
        @Child(name="reference", order=1, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Patient.class, Device.class})
        @Description(shortDefinition="Direct reference to resource", formalDefinition="Direct reference to a resource that identifies the participant")
        private ResourceReferenceDt myReference;
        @Child(name="userId", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Unique identifier for the user", formalDefinition="Unique identifier for the user actively participating in the event")
        private StringDt myUserId;
        @Child(name="altId", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Alternative User id e.g. authentication", formalDefinition="Alternative Participant Identifier. For a human, this should be a user identifier text string from authentication system. This identifier would be one known to a common authentication system (e.g., single sign-on), if available")
        private StringDt myAltId;
        @Child(name="name", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Human-meaningful name for the user", formalDefinition="Human-meaningful name for the user")
        private StringDt myName;
        @Child(name="requestor", type={BooleanDt.class}, order=5, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Whether user is initiator", formalDefinition="Indicator that the user is or is not the requestor, or initiator, for the event being audited.")
        private BooleanDt myRequestor;
        @Child(name="media", type={CodingDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Type of media", formalDefinition="Type of media involved. Used when the event is about exporting/importing onto media")
        private CodingDt myMedia;
        @Child(name="network", order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Logical network location for application activity", formalDefinition="Logical network location for application activity, if the activity has a network location")
        private ParticipantNetwork myNetwork;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myRole, this.myReference, this.myUserId, this.myAltId, this.myName, this.myRequestor, this.myMedia, this.myNetwork});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRole, this.myReference, this.myUserId, this.myAltId, this.myName, this.myRequestor, this.myMedia, this.myNetwork});
        }

        public List<CodeableConceptDt> getRole() {
            if (this.myRole == null) {
                this.myRole = new ArrayList<CodeableConceptDt>();
            }
            return this.myRole;
        }

        public List<CodeableConceptDt> getRoleElement() {
            if (this.myRole == null) {
                this.myRole = new ArrayList<CodeableConceptDt>();
            }
            return this.myRole;
        }

        public Participant setRole(List<CodeableConceptDt> theValue) {
            this.myRole = theValue;
            return this;
        }

        public CodeableConceptDt addRole() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getRole().add(newType);
            return newType;
        }

        public CodeableConceptDt getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                return this.addRole();
            }
            return this.getRole().get(0);
        }

        public ResourceReferenceDt getReference() {
            if (this.myReference == null) {
                this.myReference = new ResourceReferenceDt();
            }
            return this.myReference;
        }

        public ResourceReferenceDt getReferenceElement() {
            if (this.myReference == null) {
                this.myReference = new ResourceReferenceDt();
            }
            return this.myReference;
        }

        public Participant setReference(ResourceReferenceDt theValue) {
            this.myReference = theValue;
            return this;
        }

        public StringDt getUserId() {
            if (this.myUserId == null) {
                this.myUserId = new StringDt();
            }
            return this.myUserId;
        }

        public StringDt getUserIdElement() {
            if (this.myUserId == null) {
                this.myUserId = new StringDt();
            }
            return this.myUserId;
        }

        public Participant setUserId(StringDt theValue) {
            this.myUserId = theValue;
            return this;
        }

        public Participant setUserId(String theString) {
            this.myUserId = new StringDt(theString);
            return this;
        }

        public StringDt getAltId() {
            if (this.myAltId == null) {
                this.myAltId = new StringDt();
            }
            return this.myAltId;
        }

        public StringDt getAltIdElement() {
            if (this.myAltId == null) {
                this.myAltId = new StringDt();
            }
            return this.myAltId;
        }

        public Participant setAltId(StringDt theValue) {
            this.myAltId = theValue;
            return this;
        }

        public Participant setAltId(String theString) {
            this.myAltId = new StringDt(theString);
            return this;
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public Participant setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Participant setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public BooleanDt getRequestor() {
            if (this.myRequestor == null) {
                this.myRequestor = new BooleanDt();
            }
            return this.myRequestor;
        }

        public BooleanDt getRequestorElement() {
            if (this.myRequestor == null) {
                this.myRequestor = new BooleanDt();
            }
            return this.myRequestor;
        }

        public Participant setRequestor(BooleanDt theValue) {
            this.myRequestor = theValue;
            return this;
        }

        public Participant setRequestor(boolean theBoolean) {
            this.myRequestor = new BooleanDt(theBoolean);
            return this;
        }

        public CodingDt getMedia() {
            if (this.myMedia == null) {
                this.myMedia = new CodingDt();
            }
            return this.myMedia;
        }

        public CodingDt getMediaElement() {
            if (this.myMedia == null) {
                this.myMedia = new CodingDt();
            }
            return this.myMedia;
        }

        public Participant setMedia(CodingDt theValue) {
            this.myMedia = theValue;
            return this;
        }

        public ParticipantNetwork getNetwork() {
            if (this.myNetwork == null) {
                this.myNetwork = new ParticipantNetwork();
            }
            return this.myNetwork;
        }

        public ParticipantNetwork getNetworkElement() {
            if (this.myNetwork == null) {
                this.myNetwork = new ParticipantNetwork();
            }
            return this.myNetwork;
        }

        public Participant setNetwork(ParticipantNetwork theValue) {
            this.myNetwork = theValue;
            return this;
        }
    }

    @Block
    public static class Event
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Type/identifier of event", formalDefinition="Identifier for a family of the event")
        private CodeableConceptDt myType;
        @Child(name="subtype", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="More specific type/id for the event", formalDefinition="Identifier for the category of event")
        private List<CodeableConceptDt> mySubtype;
        @Child(name="action", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Type of action performed during the event", formalDefinition="Indicator for type of action performed during the event that generated the audit")
        private BoundCodeDt<SecurityEventActionEnum> myAction;
        @Child(name="dateTime", type={InstantDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Time when the event occurred on source", formalDefinition="The time when the event occurred on the source")
        private InstantDt myDateTime;
        @Child(name="outcome", type={CodeDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Whether the event succeeded or failed", formalDefinition="Indicates whether the event succeeded or failed")
        private BoundCodeDt<SecurityEventOutcomeEnum> myOutcome;
        @Child(name="outcomeDesc", type={StringDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Description of the event outcome", formalDefinition="A free text description of the outcome of the event")
        private StringDt myOutcomeDesc;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.mySubtype, this.myAction, this.myDateTime, this.myOutcome, this.myOutcomeDesc});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.mySubtype, this.myAction, this.myDateTime, this.myOutcome, this.myOutcomeDesc});
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public CodeableConceptDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public Event setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public List<CodeableConceptDt> getSubtype() {
            if (this.mySubtype == null) {
                this.mySubtype = new ArrayList<CodeableConceptDt>();
            }
            return this.mySubtype;
        }

        public List<CodeableConceptDt> getSubtypeElement() {
            if (this.mySubtype == null) {
                this.mySubtype = new ArrayList<CodeableConceptDt>();
            }
            return this.mySubtype;
        }

        public Event setSubtype(List<CodeableConceptDt> theValue) {
            this.mySubtype = theValue;
            return this;
        }

        public CodeableConceptDt addSubtype() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getSubtype().add(newType);
            return newType;
        }

        public CodeableConceptDt getSubtypeFirstRep() {
            if (this.getSubtype().isEmpty()) {
                return this.addSubtype();
            }
            return this.getSubtype().get(0);
        }

        public BoundCodeDt<SecurityEventActionEnum> getAction() {
            if (this.myAction == null) {
                this.myAction = new BoundCodeDt(SecurityEventActionEnum.VALUESET_BINDER);
            }
            return this.myAction;
        }

        public BoundCodeDt<SecurityEventActionEnum> getActionElement() {
            if (this.myAction == null) {
                this.myAction = new BoundCodeDt(SecurityEventActionEnum.VALUESET_BINDER);
            }
            return this.myAction;
        }

        public Event setAction(BoundCodeDt<SecurityEventActionEnum> theValue) {
            this.myAction = theValue;
            return this;
        }

        public Event setAction(SecurityEventActionEnum theValue) {
            this.getAction().setValueAsEnum((Enum)theValue);
            return this;
        }

        public InstantDt getDateTime() {
            if (this.myDateTime == null) {
                this.myDateTime = new InstantDt();
            }
            return this.myDateTime;
        }

        public InstantDt getDateTimeElement() {
            if (this.myDateTime == null) {
                this.myDateTime = new InstantDt();
            }
            return this.myDateTime;
        }

        public Event setDateTime(InstantDt theValue) {
            this.myDateTime = theValue;
            return this;
        }

        public Event setDateTimeWithMillisPrecision(Date theDate) {
            this.myDateTime = new InstantDt(theDate);
            return this;
        }

        public Event setDateTime(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDateTime = new InstantDt(theDate, thePrecision);
            return this;
        }

        public BoundCodeDt<SecurityEventOutcomeEnum> getOutcome() {
            if (this.myOutcome == null) {
                this.myOutcome = new BoundCodeDt(SecurityEventOutcomeEnum.VALUESET_BINDER);
            }
            return this.myOutcome;
        }

        public BoundCodeDt<SecurityEventOutcomeEnum> getOutcomeElement() {
            if (this.myOutcome == null) {
                this.myOutcome = new BoundCodeDt(SecurityEventOutcomeEnum.VALUESET_BINDER);
            }
            return this.myOutcome;
        }

        public Event setOutcome(BoundCodeDt<SecurityEventOutcomeEnum> theValue) {
            this.myOutcome = theValue;
            return this;
        }

        public Event setOutcome(SecurityEventOutcomeEnum theValue) {
            this.getOutcome().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getOutcomeDesc() {
            if (this.myOutcomeDesc == null) {
                this.myOutcomeDesc = new StringDt();
            }
            return this.myOutcomeDesc;
        }

        public StringDt getOutcomeDescElement() {
            if (this.myOutcomeDesc == null) {
                this.myOutcomeDesc = new StringDt();
            }
            return this.myOutcomeDesc;
        }

        public Event setOutcomeDesc(StringDt theValue) {
            this.myOutcomeDesc = theValue;
            return this;
        }

        public Event setOutcomeDesc(String theString) {
            this.myOutcomeDesc = new StringDt(theString);
            return this;
        }
    }
}

