/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="User", profile="http://hl7.org/fhir/profiles/User", id="user")
public class User
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="name", path="User.name", description="", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="provider", path="User.provider", description="", type="token")
    public static final String SP_PROVIDER = "provider";
    public static final TokenClientParam PROVIDER = new TokenClientParam("provider");
    @SearchParamDefinition(name="login", path="User.login", description="", type="string")
    public static final String SP_LOGIN = "login";
    public static final StringClientParam LOGIN = new StringClientParam("login");
    @SearchParamDefinition(name="level", path="User.level", description="", type="token")
    public static final String SP_LEVEL = "level";
    public static final TokenClientParam LEVEL = new TokenClientParam("level");
    @SearchParamDefinition(name="patient", path="User.patient", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("User.patient");
    @Child(name="name", type={HumanNameDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The name of this user", formalDefinition="")
    private HumanNameDt myName;
    @Child(name="provider", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Which system authenticates the user. Blanks = internally authenticated", formalDefinition="")
    private UriDt myProvider;
    @Child(name="login", type={StringDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The login by which this user is known", formalDefinition="")
    private StringDt myLogin;
    @Child(name="password", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="If internal login, the password hash (SHA 256, Hex, lowercase)", formalDefinition="")
    private StringDt myPassword;
    @Child(name="level", type={CodeDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The level access for this user", formalDefinition="")
    private CodeDt myLevel;
    @Child(name="sessionLength", type={IntegerDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="How long a session lasts for", formalDefinition="")
    private IntegerDt mySessionLength;
    @Child(name="contact", type={ContactDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Contact details for the user", formalDefinition="")
    private List<ContactDt> myContact;
    @Child(name="patient", order=7, min=0, max=-1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Patient compartments the user has access to (if level is patient/family)", formalDefinition="")
    private List<ResourceReferenceDt> myPatient;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myProvider, this.myLogin, this.myPassword, this.myLevel, this.mySessionLength, this.myContact, this.myPatient});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myProvider, this.myLogin, this.myPassword, this.myLevel, this.mySessionLength, this.myContact, this.myPatient});
    }

    public HumanNameDt getName() {
        if (this.myName == null) {
            this.myName = new HumanNameDt();
        }
        return this.myName;
    }

    public HumanNameDt getNameElement() {
        if (this.myName == null) {
            this.myName = new HumanNameDt();
        }
        return this.myName;
    }

    public User setName(HumanNameDt theValue) {
        this.myName = theValue;
        return this;
    }

    public UriDt getProvider() {
        if (this.myProvider == null) {
            this.myProvider = new UriDt();
        }
        return this.myProvider;
    }

    public UriDt getProviderElement() {
        if (this.myProvider == null) {
            this.myProvider = new UriDt();
        }
        return this.myProvider;
    }

    public User setProvider(UriDt theValue) {
        this.myProvider = theValue;
        return this;
    }

    public User setProvider(String theUri) {
        this.myProvider = new UriDt(theUri);
        return this;
    }

    public StringDt getLogin() {
        if (this.myLogin == null) {
            this.myLogin = new StringDt();
        }
        return this.myLogin;
    }

    public StringDt getLoginElement() {
        if (this.myLogin == null) {
            this.myLogin = new StringDt();
        }
        return this.myLogin;
    }

    public User setLogin(StringDt theValue) {
        this.myLogin = theValue;
        return this;
    }

    public User setLogin(String theString) {
        this.myLogin = new StringDt(theString);
        return this;
    }

    public StringDt getPassword() {
        if (this.myPassword == null) {
            this.myPassword = new StringDt();
        }
        return this.myPassword;
    }

    public StringDt getPasswordElement() {
        if (this.myPassword == null) {
            this.myPassword = new StringDt();
        }
        return this.myPassword;
    }

    public User setPassword(StringDt theValue) {
        this.myPassword = theValue;
        return this;
    }

    public User setPassword(String theString) {
        this.myPassword = new StringDt(theString);
        return this;
    }

    public CodeDt getLevel() {
        if (this.myLevel == null) {
            this.myLevel = new CodeDt();
        }
        return this.myLevel;
    }

    public CodeDt getLevelElement() {
        if (this.myLevel == null) {
            this.myLevel = new CodeDt();
        }
        return this.myLevel;
    }

    public User setLevel(CodeDt theValue) {
        this.myLevel = theValue;
        return this;
    }

    public User setLevel(String theCode) {
        this.myLevel = new CodeDt(theCode);
        return this;
    }

    public IntegerDt getSessionLength() {
        if (this.mySessionLength == null) {
            this.mySessionLength = new IntegerDt();
        }
        return this.mySessionLength;
    }

    public IntegerDt getSessionLengthElement() {
        if (this.mySessionLength == null) {
            this.mySessionLength = new IntegerDt();
        }
        return this.mySessionLength;
    }

    public User setSessionLength(IntegerDt theValue) {
        this.mySessionLength = theValue;
        return this;
    }

    public User setSessionLength(int theInteger) {
        this.mySessionLength = new IntegerDt(theInteger);
        return this;
    }

    public List<ContactDt> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactDt>();
        }
        return this.myContact;
    }

    public List<ContactDt> getContactElement() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactDt>();
        }
        return this.myContact;
    }

    public User setContact(List<ContactDt> theValue) {
        this.myContact = theValue;
        return this;
    }

    public ContactDt addContact() {
        ContactDt newType = new ContactDt();
        this.getContact().add(newType);
        return newType;
    }

    public ContactDt getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public User addContact(ContactUseEnum theContactUse, String theValue) {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactDt>();
        }
        this.myContact.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public User addContact(String theValue) {
        if (this.myContact == null) {
            this.myContact = new ArrayList<ContactDt>();
        }
        this.myContact.add(new ContactDt(theValue));
        return this;
    }

    public List<ResourceReferenceDt> getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ArrayList<ResourceReferenceDt>();
        }
        return this.myPatient;
    }

    public List<ResourceReferenceDt> getPatientElement() {
        if (this.myPatient == null) {
            this.myPatient = new ArrayList<ResourceReferenceDt>();
        }
        return this.myPatient;
    }

    public User setPatient(List<ResourceReferenceDt> theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt addPatient() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getPatient().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "User";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

