/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum RestfulOperationTypeEnum {
    READ("read", "http://hl7.org/fhir/restful-operation"),
    VREAD("vread", "http://hl7.org/fhir/restful-operation"),
    UPDATE("update", "http://hl7.org/fhir/restful-operation"),
    DELETE("delete", "http://hl7.org/fhir/restful-operation"),
    HISTORY_INSTANCE("history-instance", "http://hl7.org/fhir/restful-operation"),
    VALIDATE("validate", "http://hl7.org/fhir/restful-operation"),
    HISTORY_TYPE("history-type", "http://hl7.org/fhir/restful-operation"),
    CREATE("create", "http://hl7.org/fhir/restful-operation"),
    SEARCH_TYPE("search-type", "http://hl7.org/fhir/restful-operation");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/type-restful-operation";
    public static final String VALUESET_NAME = "RestfulOperationType";
    private static Map<String, RestfulOperationTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, RestfulOperationTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<RestfulOperationTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static RestfulOperationTypeEnum forCode(String theCode) {
        RestfulOperationTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private RestfulOperationTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, RestfulOperationTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, RestfulOperationTypeEnum>>();
        for (RestfulOperationTypeEnum next : RestfulOperationTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<RestfulOperationTypeEnum>(){

            public String toCodeString(RestfulOperationTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(RestfulOperationTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public RestfulOperationTypeEnum fromCodeString(String theCodeString) {
                return (RestfulOperationTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public RestfulOperationTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (RestfulOperationTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

