/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.server.AddProfileTagEnum;
import ca.uhn.fhir.rest.server.BundleInclusionRule;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dstu1BundleFactory
implements IVersionSpecificBundleFactory {
    private static final Logger ourLog = LoggerFactory.getLogger(Dstu1BundleFactory.class);
    private Bundle myBundle;
    private FhirContext myContext;

    public Dstu1BundleFactory(FhirContext theContext) {
        this.myContext = theContext;
    }

    public void addResourcesToBundle(List<IBaseResource> theResult, BundleTypeEnum theBundleType, String theServerBase, BundleInclusionRule theBundleInclusionRule, Set<Include> theIncludes) {
        if (this.myBundle == null) {
            this.myBundle = new Bundle();
        }
        ArrayList includedResources = new ArrayList();
        HashSet<IdDt> addedResourceIds = new HashSet<IdDt>();
        for (IBaseResource next : theResult) {
            if (next.getIdElement().isEmpty()) continue;
            addedResourceIds.add((IdDt)next.getIdElement());
        }
        for (IBaseResource nextBaseRes : theResult) {
            IResource next = (IResource)nextBaseRes;
            HashSet<String> containedIds = new HashSet<String>();
            for (IResource nextContained : next.getContained().getContainedResources()) {
                if (nextContained.getId().isEmpty()) continue;
                containedIds.add(nextContained.getId().getValue());
            }
            if (this.myContext.getNarrativeGenerator() != null) {
                String title = this.myContext.getNarrativeGenerator().generateTitle((IBaseResource)next);
                ourLog.trace("Narrative generator created title: {}", (Object)title);
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    ResourceMetadataKeyEnum.TITLE.put(next, (Object)title);
                }
            } else {
                ourLog.trace("No narrative generator specified");
            }
            ArrayList references = this.myContext.newTerser().getAllResourceReferences((IBaseResource)next);
            do {
                ArrayList<IResource> addedResourcesThisPass = new ArrayList<IResource>();
                for (ResourceReferenceInfo nextRefInfo : references) {
                    IResource nextRes;
                    if (!theBundleInclusionRule.shouldIncludeReferencedResource(nextRefInfo, theIncludes) || (nextRes = (IResource)nextRefInfo.getResourceReference().getResource()) == null || !nextRes.getId().hasIdPart() || containedIds.contains(nextRes.getId().getValue())) continue;
                    IdDt id = nextRes.getId();
                    if (!id.hasResourceType()) {
                        String resName = this.myContext.getResourceDefinition((IBaseResource)nextRes).getName();
                        id = id.withResourceType(resName);
                    }
                    if (addedResourceIds.contains(id)) continue;
                    addedResourceIds.add(id);
                    addedResourcesThisPass.add(nextRes);
                }
                includedResources.addAll(addedResourcesThisPass);
                references = new ArrayList();
                for (IResource iResource : addedResourcesThisPass) {
                    List newReferences = this.myContext.newTerser().getAllResourceReferences((IBaseResource)iResource);
                    references.addAll(newReferences);
                }
            } while (!references.isEmpty());
            this.myBundle.addResource(next, this.myContext, theServerBase);
        }
        for (IBaseResource next : includedResources) {
            BundleEntry entry = this.myBundle.addResource((IResource)next, this.myContext, theServerBase);
            if (!this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1) || !entry.getSearchMode().isEmpty()) continue;
            entry.getSearchMode().setValueAsEnum((Enum)BundleEntrySearchModeEnum.INCLUDE);
        }
    }

    public void addRootPropertiesToBundle(String theAuthor, String theServerBase, String theCompleteUrl, Integer theTotalResults, BundleTypeEnum theBundleType, IPrimitiveType<Date> theLastUpdated) {
        if (this.myBundle.getAuthorName().isEmpty()) {
            this.myBundle.getAuthorName().setValue((Object)theAuthor);
        }
        if (this.myBundle.getUpdated().isEmpty() && StringUtils.isNotBlank((CharSequence)theLastUpdated.getValueAsString())) {
            this.myBundle.getUpdated().setValueAsString(theLastUpdated.getValueAsString());
        }
        if (this.myBundle.getBundleId().isEmpty()) {
            this.myBundle.getBundleId().setValue((Object)UUID.randomUUID().toString());
        }
        if (this.myBundle.getLinkBase().isEmpty()) {
            this.myBundle.getLinkBase().setValue((Object)theServerBase);
        }
        if (this.myBundle.getLinkSelf().isEmpty()) {
            this.myBundle.getLinkSelf().setValue((Object)theCompleteUrl);
        }
        if (theBundleType != null && this.myBundle.getType().isEmpty()) {
            this.myBundle.getType().setValueAsString(theBundleType.getCode());
        }
        if (this.myBundle.getTotalResults().isEmpty() && theTotalResults != null) {
            this.myBundle.getTotalResults().setValue((Object)theTotalResults);
        }
    }

    public Bundle getDstu1Bundle() {
        return this.myBundle;
    }

    public IResource getResourceBundle() {
        return null;
    }

    public void initializeBundleFromBundleProvider(RestfulServer theServer, IBundleProvider theResult, EncodingEnum theResponseEncoding, String theServerBase, String theCompleteUrl, boolean thePrettyPrint, int theOffset, Integer theLimit, String theSearchId, BundleTypeEnum theBundleType, Set<Include> theIncludes) {
        List resourceList;
        int numToReturn;
        String searchId = null;
        if (theServer.getPagingProvider() == null) {
            numToReturn = theResult.size();
            resourceList = theResult.getResources(0, numToReturn);
            RestfulServerUtils.validateResourceListNotNull((List)resourceList);
        } else {
            IPagingProvider pagingProvider = theServer.getPagingProvider();
            numToReturn = theLimit == null ? pagingProvider.getDefaultPageSize() : Math.min(pagingProvider.getMaximumPageSize(), theLimit);
            numToReturn = Math.min(numToReturn, theResult.size() - theOffset);
            resourceList = theResult.getResources(theOffset, numToReturn + theOffset);
            RestfulServerUtils.validateResourceListNotNull((List)resourceList);
            if (theSearchId != null) {
                searchId = theSearchId;
            } else if (theResult.size() > numToReturn) {
                searchId = pagingProvider.storeResultList(theResult);
                Validate.notNull((Object)searchId, (String)"Paging provider returned null searchId", (Object[])new Object[0]);
            }
        }
        for (IBaseResource next : resourceList) {
            if (next.getIdElement() != null && !next.getIdElement().isEmpty() || next instanceof BaseOperationOutcome) continue;
            throw new InternalErrorException("Server method returned resource of type[" + next.getClass().getSimpleName() + "] with no ID specified (IResource#setId(IdDt) must be called)");
        }
        if (theServer.getAddProfileTag() != AddProfileTagEnum.NEVER) {
            for (IBaseResource nextRes : resourceList) {
                RuntimeResourceDefinition def = theServer.getFhirContext().getResourceDefinition(nextRes);
                if (theServer.getAddProfileTag() != AddProfileTagEnum.ALWAYS && def.isStandardProfile()) continue;
                RestfulServerUtils.addProfileToBundleEntry((FhirContext)theServer.getFhirContext(), (IBaseResource)nextRes, (String)theServerBase);
            }
        }
        this.addResourcesToBundle(new ArrayList<IBaseResource>(resourceList), theBundleType, theServerBase, theServer.getBundleInclusionRule(), theIncludes);
        this.addRootPropertiesToBundle(null, theServerBase, theCompleteUrl, theResult.size(), theBundleType, (IPrimitiveType<Date>)theResult.getPublished());
        if (theServer.getPagingProvider() != null) {
            int limit = theLimit != null ? theLimit.intValue() : theServer.getPagingProvider().getDefaultPageSize();
            limit = Math.min(limit, theServer.getPagingProvider().getMaximumPageSize());
            if (searchId != null) {
                if (theOffset + numToReturn < theResult.size()) {
                    this.myBundle.getLinkNext().setValue((Object)RestfulServerUtils.createPagingLink(theIncludes, (String)theServerBase, (String)searchId, (int)(theOffset + numToReturn), (int)numToReturn, (EncodingEnum)theResponseEncoding, (boolean)thePrettyPrint, (BundleTypeEnum)theBundleType));
                }
                if (theOffset > 0) {
                    int start = Math.max(0, theOffset - limit);
                    this.myBundle.getLinkPrevious().setValue((Object)RestfulServerUtils.createPagingLink(theIncludes, (String)theServerBase, (String)searchId, (int)start, (int)limit, (EncodingEnum)theResponseEncoding, (boolean)thePrettyPrint, (BundleTypeEnum)theBundleType));
                }
            }
        }
    }

    public void initializeBundleFromResourceList(String theAuthor, List<? extends IBaseResource> theResult, String theServerBase, String theCompleteUrl, int theTotalResults, BundleTypeEnum theBundleType) {
        this.myBundle = new Bundle();
        this.myBundle.getAuthorName().setValue((Object)theAuthor);
        this.myBundle.getBundleId().setValue((Object)UUID.randomUUID().toString());
        this.myBundle.getLinkBase().setValue((Object)theServerBase);
        this.myBundle.getLinkSelf().setValue((Object)theCompleteUrl);
        this.myBundle.getType().setValueAsEnum((Enum)theBundleType);
        ArrayList includedResources = new ArrayList();
        HashSet<IIdType> addedResourceIds = new HashSet<IIdType>();
        for (IBaseResource iBaseResource : theResult) {
            if (iBaseResource.getIdElement().isEmpty()) continue;
            addedResourceIds.add(iBaseResource.getIdElement());
        }
        for (IBaseResource iBaseResource : theResult) {
            IResource next = (IResource)iBaseResource;
            HashSet<String> containedIds = new HashSet<String>();
            for (IResource nextContained : next.getContained().getContainedResources()) {
                if (nextContained.getId().isEmpty()) continue;
                containedIds.add(nextContained.getId().getValue());
            }
            if (this.myContext.getNarrativeGenerator() != null) {
                String title = this.myContext.getNarrativeGenerator().generateTitle((IBaseResource)next);
                ourLog.trace("Narrative generator created title: {}", (Object)title);
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    ResourceMetadataKeyEnum.TITLE.put(next, (Object)title);
                }
            } else {
                ourLog.trace("No narrative generator specified");
            }
            ArrayList references = this.myContext.newTerser().getAllPopulatedChildElementsOfType((IBaseResource)next, BaseResourceReferenceDt.class);
            do {
                ArrayList<IBaseResource> addedResourcesThisPass = new ArrayList<IBaseResource>();
                for (BaseResourceReferenceDt nextRef : references) {
                    IBaseResource nextRefRes = nextRef.getResource();
                    if (nextRefRes == null || !nextRefRes.getIdElement().hasIdPart() || containedIds.contains(nextRefRes.getIdElement().getValue())) continue;
                    IIdType id = nextRefRes.getIdElement();
                    if (!id.hasResourceType()) {
                        String resName = this.myContext.getResourceDefinition(nextRefRes).getName();
                        id = id.withResourceType(resName);
                    }
                    if (addedResourceIds.contains(id)) continue;
                    addedResourceIds.add(id);
                    addedResourcesThisPass.add(nextRefRes);
                }
                references = new ArrayList();
                for (IBaseResource iResource : addedResourcesThisPass) {
                    List newReferences = this.myContext.newTerser().getAllPopulatedChildElementsOfType(iResource, BaseResourceReferenceDt.class);
                    references.addAll(newReferences);
                }
                includedResources.addAll(addedResourcesThisPass);
            } while (!references.isEmpty());
            this.myBundle.addResource(next, this.myContext, theServerBase);
        }
        for (IBaseResource iBaseResource : includedResources) {
            BundleEntry entry = this.myBundle.addResource((IResource)iBaseResource, this.myContext, theServerBase);
            if (!this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1) || !entry.getSearchMode().isEmpty()) continue;
            entry.getSearchMode().setValueAsEnum((Enum)BundleEntrySearchModeEnum.INCLUDE);
        }
        this.myBundle.getTotalResults().setValue((Object)theTotalResults);
    }

    public void initializeWithBundleResource(IBaseResource theResource) {
        throw new UnsupportedOperationException("DSTU1 server doesn't support resource style bundles");
    }

    public List<IBaseResource> toListOfResources() {
        return new ArrayList<IBaseResource>(this.myBundle.toListOfResources());
    }
}

