/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.audit;

import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.resource.DiagnosticReport;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectTypeEnum;
import ca.uhn.fhir.rest.server.audit.IResourceAuditor;
import java.util.HashMap;
import java.util.Map;

public class DiagnosticReportAuditor
implements IResourceAuditor<DiagnosticReport> {
    DiagnosticReport myDiagnosticReport;

    public boolean isAuditable() {
        return this.myDiagnosticReport != null;
    }

    public String getName() {
        if (this.myDiagnosticReport != null) {
            return "Diagnostic Report: " + (String)this.myDiagnosticReport.getName().getText().getValue();
        }
        return null;
    }

    public IdentifierDt getIdentifier() {
        if (this.myDiagnosticReport != null) {
            return this.myDiagnosticReport.getIdentifier();
        }
        return null;
    }

    public SecurityEventObjectTypeEnum getType() {
        return SecurityEventObjectTypeEnum.OTHER;
    }

    public DiagnosticReport getResource() {
        return this.myDiagnosticReport;
    }

    public void setResource(DiagnosticReport theDiagnosticReport) {
        this.myDiagnosticReport = theDiagnosticReport;
    }

    public String getDescription() {
        return null;
    }

    public Map<String, String> getDetail() {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("dateIssued", this.myDiagnosticReport.getIssued().getValueAsString());
        details.put("version", this.myDiagnosticReport.getId().getVersionIdPart());
        details.put("subject", this.myDiagnosticReport.getSubject().getReference().getValue());
        return details;
    }

    public BaseCodingDt getSensitivity() {
        return null;
    }
}

