/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Availability", profile="http://hl7.org/fhir/profiles/Availability", id="availability")
public class Availability
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="individual", path="Availability.individual", description="The individual to find an availability for", type="reference")
    public static final String SP_INDIVIDUAL = "individual";
    public static final ReferenceClientParam INDIVIDUAL = new ReferenceClientParam("individual");
    public static final Include INCLUDE_INDIVIDUAL = new Include("Availability.individual");
    @SearchParamDefinition(name="slottype", path="Availability.type", description="The type of appointments that can be booked into associated slot(s)", type="token")
    public static final String SP_SLOTTYPE = "slottype";
    public static final TokenClientParam SLOTTYPE = new TokenClientParam("slottype");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="External Ids for this item", formalDefinition="")
    private List<IdentifierDt> myIdentifier;
    @Child(name="type", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The type of appointments that can be booked into slots attached to this availability resource (ideally this would be an identifiable service - which is at a location, rather than the location itself) - change to CodeableConcept", formalDefinition="")
    private CodeableConceptDt myType;
    @Child(name="individual", order=2, min=1, max=1, summary=false, modifier=false, type={Location.class, Practitioner.class, Device.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="The type of resource this availability resource is providing availability information for", formalDefinition="")
    private ResourceReferenceDt myIndividual;
    @Child(name="period", type={PeriodDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="The period of time that the slots that are attached to this availability resource cover (even if none exist)", formalDefinition="")
    private PeriodDt myPeriod;
    @Child(name="comment", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Comments on the availability to describe any extended information. Such as custom constraints on the slot(s) that may be associated", formalDefinition="")
    private StringDt myComment;
    @Child(name="author", order=5, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="Who authored the availability", formalDefinition="")
    private ResourceReferenceDt myAuthor;
    @Child(name="authorDate", type={DateTimeDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="When this availability was created, or last revised", formalDefinition="")
    private DateTimeDt myAuthorDate;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myType, this.myIndividual, this.myPeriod, this.myComment, this.myAuthor, this.myAuthorDate});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myType, this.myIndividual, this.myPeriod, this.myComment, this.myAuthor, this.myAuthorDate});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Availability setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Availability addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Availability addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public CodeableConceptDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Availability setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public ResourceReferenceDt getIndividual() {
        if (this.myIndividual == null) {
            this.myIndividual = new ResourceReferenceDt();
        }
        return this.myIndividual;
    }

    public ResourceReferenceDt getIndividualElement() {
        if (this.myIndividual == null) {
            this.myIndividual = new ResourceReferenceDt();
        }
        return this.myIndividual;
    }

    public Availability setIndividual(ResourceReferenceDt theValue) {
        this.myIndividual = theValue;
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PeriodDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public Availability setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public StringDt getComment() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public StringDt getCommentElement() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public Availability setComment(StringDt theValue) {
        this.myComment = theValue;
        return this;
    }

    public Availability setComment(String theString) {
        this.myComment = new StringDt(theString);
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public ResourceReferenceDt getAuthorElement() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public Availability setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public DateTimeDt getAuthorDate() {
        if (this.myAuthorDate == null) {
            this.myAuthorDate = new DateTimeDt();
        }
        return this.myAuthorDate;
    }

    public DateTimeDt getAuthorDateElement() {
        if (this.myAuthorDate == null) {
            this.myAuthorDate = new DateTimeDt();
        }
        return this.myAuthorDate;
    }

    public Availability setAuthorDate(DateTimeDt theValue) {
        this.myAuthorDate = theValue;
        return this;
    }

    public Availability setAuthorDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myAuthorDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Availability setAuthorDateWithSecondsPrecision(Date theDate) {
        this.myAuthorDate = new DateTimeDt(theDate);
        return this;
    }

    public String getResourceName() {
        return "Availability";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

