/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.RatioDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.composite.ScheduleDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Medication;
import ca.uhn.fhir.model.dstu.resource.MedicationPrescription;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.MedicationDispenseStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="MedicationDispense", profile="http://hl7.org/fhir/profiles/MedicationDispense", id="medicationdispense")
public class MedicationDispense
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="destination", path="MedicationDispense.dispense.destination", description="Return dispenses that should be sent to a secific destination", type="reference")
    public static final String SP_DESTINATION = "destination";
    public static final ReferenceClientParam DESTINATION = new ReferenceClientParam("destination");
    public static final Include INCLUDE_DISPENSE_DESTINATION = new Include("MedicationDispense.dispense.destination");
    @SearchParamDefinition(name="dispenser", path="MedicationDispense.dispenser", description="Return all dispenses performed by a specific indiividual", type="reference")
    public static final String SP_DISPENSER = "dispenser";
    public static final ReferenceClientParam DISPENSER = new ReferenceClientParam("dispenser");
    public static final Include INCLUDE_DISPENSER = new Include("MedicationDispense.dispenser");
    @SearchParamDefinition(name="identifier", path="MedicationDispense.identifier", description="Return dispenses with this external identity", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="medication", path="MedicationDispense.dispense.medication", description="Returns dispenses of this medicine", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_DISPENSE_MEDICATION = new Include("MedicationDispense.dispense.medication");
    @SearchParamDefinition(name="patient", path="MedicationDispense.patient", description="The identity of a patient to list dispenses  for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationDispense.patient");
    @SearchParamDefinition(name="prescription", path="MedicationDispense.authorizingPrescription", description="The identity of a prescription to list dispenses from", type="reference")
    public static final String SP_PRESCRIPTION = "prescription";
    public static final ReferenceClientParam PRESCRIPTION = new ReferenceClientParam("prescription");
    public static final Include INCLUDE_AUTHORIZINGPRESCRIPTION = new Include("MedicationDispense.authorizingPrescription");
    @SearchParamDefinition(name="responsibleparty", path="MedicationDispense.substitution.responsibleParty", description="Return all dispenses with the specified responsible party", type="reference")
    public static final String SP_RESPONSIBLEPARTY = "responsibleparty";
    public static final ReferenceClientParam RESPONSIBLEPARTY = new ReferenceClientParam("responsibleparty");
    public static final Include INCLUDE_SUBSTITUTION_RESPONSIBLEPARTY = new Include("MedicationDispense.substitution.responsibleParty");
    @SearchParamDefinition(name="status", path="MedicationDispense.dispense.status", description="Status of the dispense", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="type", path="MedicationDispense.dispense.type", description="Return all dispenses of a specific type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="whenhandedover", path="MedicationDispense.dispense.whenHandedOver", description="Date when medication handed over to patient (outpatient setting), or supplied to ward or clinic (inpatient setting)", type="date")
    public static final String SP_WHENHANDEDOVER = "whenhandedover";
    public static final DateClientParam WHENHANDEDOVER = new DateClientParam("whenhandedover");
    @SearchParamDefinition(name="whenprepared", path="MedicationDispense.dispense.whenPrepared", description="Date when medication prepared", type="date")
    public static final String SP_WHENPREPARED = "whenprepared";
    public static final DateClientParam WHENPREPARED = new DateClientParam("whenprepared");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="External identifier", formalDefinition="Identifier assigned by the dispensing facility - this is an identifier assigned outside FHIR.")
    private IdentifierDt myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="in progress | on hold | completed | entered in error | stopped", formalDefinition="A code specifying the state of the set of dispense events.")
    private BoundCodeDt<MedicationDispenseStatusEnum> myStatus;
    @Child(name="patient", order=2, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Who the dispense is for", formalDefinition="A link to a resource representing the person to whom the medication will be given.")
    private ResourceReferenceDt myPatient;
    @Child(name="dispenser", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Practitioner responsible for dispensing medication", formalDefinition="The individual responsible for dispensing the medication")
    private ResourceReferenceDt myDispenser;
    @Child(name="authorizingPrescription", order=4, min=0, max=-1, summary=false, modifier=false, type={MedicationPrescription.class})
    @Description(shortDefinition="Medication order that authorizes the dispense", formalDefinition="Indicates the medication order that is being dispensed against.")
    private List<ResourceReferenceDt> myAuthorizingPrescription;
    @Child(name="dispense", order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Details for individual dispensed medicationdetails", formalDefinition="Indicates the details of the dispense event such as the days supply and quantity of medication dispensed.")
    private List<Dispense> myDispense;
    @Child(name="substitution", order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Deals with substitution of one medicine for another", formalDefinition="Indicates whether or not substitution was made as part of the dispense.  In some cases substitution will be expected but doesn't happen, in other cases substitution is not expected but does happen.  This block explains what substitition did or did not happen and why.")
    private Substitution mySubstitution;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myPatient, this.myDispenser, this.myAuthorizingPrescription, this.myDispense, this.mySubstitution});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myPatient, this.myDispenser, this.myAuthorizingPrescription, this.myDispense, this.mySubstitution});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public IdentifierDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public MedicationDispense setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public MedicationDispense setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public MedicationDispense setIdentifier(String theSystem, String theValue) {
        this.myIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public BoundCodeDt<MedicationDispenseStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(MedicationDispenseStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<MedicationDispenseStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(MedicationDispenseStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public MedicationDispense setStatus(BoundCodeDt<MedicationDispenseStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public MedicationDispense setStatus(MedicationDispenseStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ResourceReferenceDt getPatientElement() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public MedicationDispense setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getDispenser() {
        if (this.myDispenser == null) {
            this.myDispenser = new ResourceReferenceDt();
        }
        return this.myDispenser;
    }

    public ResourceReferenceDt getDispenserElement() {
        if (this.myDispenser == null) {
            this.myDispenser = new ResourceReferenceDt();
        }
        return this.myDispenser;
    }

    public MedicationDispense setDispenser(ResourceReferenceDt theValue) {
        this.myDispenser = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getAuthorizingPrescription() {
        if (this.myAuthorizingPrescription == null) {
            this.myAuthorizingPrescription = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthorizingPrescription;
    }

    public List<ResourceReferenceDt> getAuthorizingPrescriptionElement() {
        if (this.myAuthorizingPrescription == null) {
            this.myAuthorizingPrescription = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthorizingPrescription;
    }

    public MedicationDispense setAuthorizingPrescription(List<ResourceReferenceDt> theValue) {
        this.myAuthorizingPrescription = theValue;
        return this;
    }

    public ResourceReferenceDt addAuthorizingPrescription() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAuthorizingPrescription().add(newType);
        return newType;
    }

    public List<Dispense> getDispense() {
        if (this.myDispense == null) {
            this.myDispense = new ArrayList<Dispense>();
        }
        return this.myDispense;
    }

    public List<Dispense> getDispenseElement() {
        if (this.myDispense == null) {
            this.myDispense = new ArrayList<Dispense>();
        }
        return this.myDispense;
    }

    public MedicationDispense setDispense(List<Dispense> theValue) {
        this.myDispense = theValue;
        return this;
    }

    public Dispense addDispense() {
        Dispense newType = new Dispense();
        this.getDispense().add(newType);
        return newType;
    }

    public Dispense getDispenseFirstRep() {
        if (this.getDispense().isEmpty()) {
            return this.addDispense();
        }
        return this.getDispense().get(0);
    }

    public Substitution getSubstitution() {
        if (this.mySubstitution == null) {
            this.mySubstitution = new Substitution();
        }
        return this.mySubstitution;
    }

    public Substitution getSubstitutionElement() {
        if (this.mySubstitution == null) {
            this.mySubstitution = new Substitution();
        }
        return this.mySubstitution;
    }

    public MedicationDispense setSubstitution(Substitution theValue) {
        this.mySubstitution = theValue;
        return this;
    }

    public String getResourceName() {
        return "MedicationDispense";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Substitution
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Type of substitiution", formalDefinition="A code signifying whether a different drug was dispensed from what was prescribed.")
        private CodeableConceptDt myType;
        @Child(name="reason", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Why was substitution made", formalDefinition="Indicates the reason for the substitution of (or lack of substitution) from what was prescribed.")
        private List<CodeableConceptDt> myReason;
        @Child(name="responsibleParty", order=2, min=0, max=-1, summary=false, modifier=false, type={Practitioner.class})
        @Description(shortDefinition="Who is responsible for the substitution", formalDefinition="The person or organization that has primary responsibility for the substitution")
        private List<ResourceReferenceDt> myResponsibleParty;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myReason, this.myResponsibleParty});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myReason, this.myResponsibleParty});
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public CodeableConceptDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public Substitution setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public List<CodeableConceptDt> getReason() {
            if (this.myReason == null) {
                this.myReason = new ArrayList<CodeableConceptDt>();
            }
            return this.myReason;
        }

        public List<CodeableConceptDt> getReasonElement() {
            if (this.myReason == null) {
                this.myReason = new ArrayList<CodeableConceptDt>();
            }
            return this.myReason;
        }

        public Substitution setReason(List<CodeableConceptDt> theValue) {
            this.myReason = theValue;
            return this;
        }

        public CodeableConceptDt addReason() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getReason().add(newType);
            return newType;
        }

        public CodeableConceptDt getReasonFirstRep() {
            if (this.getReason().isEmpty()) {
                return this.addReason();
            }
            return this.getReason().get(0);
        }

        public List<ResourceReferenceDt> getResponsibleParty() {
            if (this.myResponsibleParty == null) {
                this.myResponsibleParty = new ArrayList<ResourceReferenceDt>();
            }
            return this.myResponsibleParty;
        }

        public List<ResourceReferenceDt> getResponsiblePartyElement() {
            if (this.myResponsibleParty == null) {
                this.myResponsibleParty = new ArrayList<ResourceReferenceDt>();
            }
            return this.myResponsibleParty;
        }

        public Substitution setResponsibleParty(List<ResourceReferenceDt> theValue) {
            this.myResponsibleParty = theValue;
            return this;
        }

        public ResourceReferenceDt addResponsibleParty() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getResponsibleParty().add(newType);
            return newType;
        }
    }

    @Block
    public static class DispenseDosage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="additionalInstructions", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="E.g. \"Take with food\"", formalDefinition="Additional instructions such as \"Swallow with plenty of water\" which may or may not be coded.")
        private CodeableConceptDt myAdditionalInstructions;
        @Child(name="timing", order=1, min=0, max=1, summary=false, modifier=false, type={DateTimeDt.class, PeriodDt.class, ScheduleDt.class})
        @Description(shortDefinition="When medication should be administered", formalDefinition="The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions, for example.  \"Every  8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\";  \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\"")
        private IDatatype myTiming;
        @Child(name="asNeeded", order=2, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, CodeableConceptDt.class})
        @Description(shortDefinition="Take \"as needed\" f(or x)", formalDefinition="If set to true or if specified as a CodeableConcept, indicates that the medication is only taken when needed within the specified schedule rather than at every scheduled dose.  If a CodeableConcept is present, it indicates the pre-condition for taking the Medication")
        private IDatatype myAsNeeded;
        @Child(name="site", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Body site to administer to", formalDefinition="A coded specification of the anatomic site where the medication first enters the body")
        private CodeableConceptDt mySite;
        @Child(name="route", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="How drug should enter body", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a subject.")
        private CodeableConceptDt myRoute;
        @Child(name="method", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Technique for administering medication", formalDefinition="A coded value indicating the method by which the medication is introduced into or onto the body. Most commonly used for injections.  Examples:  Slow Push; Deep IV.Terminologies used often pre-coordinate this term with the route and or form of administration.")
        private CodeableConceptDt myMethod;
        @Child(name="quantity", type={QuantityDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Amount of medication per dose", formalDefinition="The amount of therapeutic or other substance given at one administration event.")
        private QuantityDt myQuantity;
        @Child(name="rate", type={RatioDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Amount of medication per unit of time", formalDefinition="Identifies the speed with which the substance is introduced into the subject. Typically the rate for an infusion. 200ml in 2 hours.")
        private RatioDt myRate;
        @Child(name="maxDosePerPeriod", type={RatioDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Upper limit on medication per unit of time", formalDefinition="The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time,  e.g. 1000mg in 24 hours.")
        private RatioDt myMaxDosePerPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myAdditionalInstructions, this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myQuantity, this.myRate, this.myMaxDosePerPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myAdditionalInstructions, this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myQuantity, this.myRate, this.myMaxDosePerPeriod});
        }

        public CodeableConceptDt getAdditionalInstructions() {
            if (this.myAdditionalInstructions == null) {
                this.myAdditionalInstructions = new CodeableConceptDt();
            }
            return this.myAdditionalInstructions;
        }

        public CodeableConceptDt getAdditionalInstructionsElement() {
            if (this.myAdditionalInstructions == null) {
                this.myAdditionalInstructions = new CodeableConceptDt();
            }
            return this.myAdditionalInstructions;
        }

        public DispenseDosage setAdditionalInstructions(CodeableConceptDt theValue) {
            this.myAdditionalInstructions = theValue;
            return this;
        }

        public IDatatype getTiming() {
            return this.myTiming;
        }

        public IDatatype getTimingElement() {
            return this.myTiming;
        }

        public DispenseDosage setTiming(IDatatype theValue) {
            this.myTiming = theValue;
            return this;
        }

        public IDatatype getAsNeeded() {
            return this.myAsNeeded;
        }

        public IDatatype getAsNeededElement() {
            return this.myAsNeeded;
        }

        public DispenseDosage setAsNeeded(IDatatype theValue) {
            this.myAsNeeded = theValue;
            return this;
        }

        public CodeableConceptDt getSite() {
            if (this.mySite == null) {
                this.mySite = new CodeableConceptDt();
            }
            return this.mySite;
        }

        public CodeableConceptDt getSiteElement() {
            if (this.mySite == null) {
                this.mySite = new CodeableConceptDt();
            }
            return this.mySite;
        }

        public DispenseDosage setSite(CodeableConceptDt theValue) {
            this.mySite = theValue;
            return this;
        }

        public CodeableConceptDt getRoute() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public CodeableConceptDt getRouteElement() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public DispenseDosage setRoute(CodeableConceptDt theValue) {
            this.myRoute = theValue;
            return this;
        }

        public CodeableConceptDt getMethod() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public CodeableConceptDt getMethodElement() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public DispenseDosage setMethod(CodeableConceptDt theValue) {
            this.myMethod = theValue;
            return this;
        }

        public QuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public QuantityDt getQuantityElement() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public DispenseDosage setQuantity(QuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public DispenseDosage setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public DispenseDosage setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public DispenseDosage setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public DispenseDosage setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public DispenseDosage setQuantity(double theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public DispenseDosage setQuantity(long theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public RatioDt getRate() {
            if (this.myRate == null) {
                this.myRate = new RatioDt();
            }
            return this.myRate;
        }

        public RatioDt getRateElement() {
            if (this.myRate == null) {
                this.myRate = new RatioDt();
            }
            return this.myRate;
        }

        public DispenseDosage setRate(RatioDt theValue) {
            this.myRate = theValue;
            return this;
        }

        public RatioDt getMaxDosePerPeriod() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public RatioDt getMaxDosePerPeriodElement() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public DispenseDosage setMaxDosePerPeriod(RatioDt theValue) {
            this.myMaxDosePerPeriod = theValue;
            return this;
        }
    }

    @Block
    public static class Dispense
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="External identifier for individual item", formalDefinition="Identifier assigned by the dispensing facility.   This is an identifier assigned outside FHIR.")
        private IdentifierDt myIdentifier;
        @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=true)
        @Description(shortDefinition="in progress | on hold | completed | entered in error | stopped", formalDefinition="A code specifying the state of the dispense event.")
        private BoundCodeDt<MedicationDispenseStatusEnum> myStatus;
        @Child(name="type", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Trial fill, partial fill, emergency fill, etc.", formalDefinition="Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.")
        private CodeableConceptDt myType;
        @Child(name="quantity", type={QuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Amount dispensed", formalDefinition="The amount of medication that has been dispensed. Includes unit of measure.")
        private QuantityDt myQuantity;
        @Child(name="medication", order=4, min=0, max=1, summary=false, modifier=false, type={Medication.class})
        @Description(shortDefinition="What medication was supplied", formalDefinition="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
        private ResourceReferenceDt myMedication;
        @Child(name="whenPrepared", type={DateTimeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Dispense processing time", formalDefinition="The time when the dispensed product was packaged and reviewed.")
        private DateTimeDt myWhenPrepared;
        @Child(name="whenHandedOver", type={DateTimeDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Handover time", formalDefinition="The time the dispensed product was provided to the patient or their representative.")
        private DateTimeDt myWhenHandedOver;
        @Child(name="destination", order=7, min=0, max=1, summary=false, modifier=false, type={Location.class})
        @Description(shortDefinition="Where the medication was sent", formalDefinition="Identification of the facility/location where the medication was shipped to, as part of the dispense event.")
        private ResourceReferenceDt myDestination;
        @Child(name="receiver", order=8, min=0, max=-1, summary=false, modifier=false, type={Patient.class, Practitioner.class})
        @Description(shortDefinition="Who collected the medication", formalDefinition="Identifies the person who picked up the medication.  This will usually be a patient or their carer, but some cases exist where it can be a healthcare professional")
        private List<ResourceReferenceDt> myReceiver;
        @Child(name="dosage", order=9, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Medicine administration instructions to the patient/carer", formalDefinition="Indicates how the medication is to be used by the patient")
        private List<DispenseDosage> myDosage;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myType, this.myQuantity, this.myMedication, this.myWhenPrepared, this.myWhenHandedOver, this.myDestination, this.myReceiver, this.myDosage});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myType, this.myQuantity, this.myMedication, this.myWhenPrepared, this.myWhenHandedOver, this.myDestination, this.myReceiver, this.myDosage});
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public IdentifierDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public Dispense setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Dispense setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
            return this;
        }

        public Dispense setIdentifier(String theSystem, String theValue) {
            this.myIdentifier = new IdentifierDt(theSystem, theValue);
            return this;
        }

        public BoundCodeDt<MedicationDispenseStatusEnum> getStatus() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(MedicationDispenseStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public BoundCodeDt<MedicationDispenseStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(MedicationDispenseStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public Dispense setStatus(BoundCodeDt<MedicationDispenseStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Dispense setStatus(MedicationDispenseStatusEnum theValue) {
            this.getStatus().setValueAsEnum((Enum)theValue);
            return this;
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public CodeableConceptDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public Dispense setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public QuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public QuantityDt getQuantityElement() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public Dispense setQuantity(QuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Dispense setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Dispense setQuantity(double theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Dispense setQuantity(long theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public ResourceReferenceDt getMedication() {
            if (this.myMedication == null) {
                this.myMedication = new ResourceReferenceDt();
            }
            return this.myMedication;
        }

        public ResourceReferenceDt getMedicationElement() {
            if (this.myMedication == null) {
                this.myMedication = new ResourceReferenceDt();
            }
            return this.myMedication;
        }

        public Dispense setMedication(ResourceReferenceDt theValue) {
            this.myMedication = theValue;
            return this;
        }

        public DateTimeDt getWhenPrepared() {
            if (this.myWhenPrepared == null) {
                this.myWhenPrepared = new DateTimeDt();
            }
            return this.myWhenPrepared;
        }

        public DateTimeDt getWhenPreparedElement() {
            if (this.myWhenPrepared == null) {
                this.myWhenPrepared = new DateTimeDt();
            }
            return this.myWhenPrepared;
        }

        public Dispense setWhenPrepared(DateTimeDt theValue) {
            this.myWhenPrepared = theValue;
            return this;
        }

        public Dispense setWhenPrepared(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myWhenPrepared = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Dispense setWhenPreparedWithSecondsPrecision(Date theDate) {
            this.myWhenPrepared = new DateTimeDt(theDate);
            return this;
        }

        public DateTimeDt getWhenHandedOver() {
            if (this.myWhenHandedOver == null) {
                this.myWhenHandedOver = new DateTimeDt();
            }
            return this.myWhenHandedOver;
        }

        public DateTimeDt getWhenHandedOverElement() {
            if (this.myWhenHandedOver == null) {
                this.myWhenHandedOver = new DateTimeDt();
            }
            return this.myWhenHandedOver;
        }

        public Dispense setWhenHandedOver(DateTimeDt theValue) {
            this.myWhenHandedOver = theValue;
            return this;
        }

        public Dispense setWhenHandedOver(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myWhenHandedOver = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Dispense setWhenHandedOverWithSecondsPrecision(Date theDate) {
            this.myWhenHandedOver = new DateTimeDt(theDate);
            return this;
        }

        public ResourceReferenceDt getDestination() {
            if (this.myDestination == null) {
                this.myDestination = new ResourceReferenceDt();
            }
            return this.myDestination;
        }

        public ResourceReferenceDt getDestinationElement() {
            if (this.myDestination == null) {
                this.myDestination = new ResourceReferenceDt();
            }
            return this.myDestination;
        }

        public Dispense setDestination(ResourceReferenceDt theValue) {
            this.myDestination = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getReceiver() {
            if (this.myReceiver == null) {
                this.myReceiver = new ArrayList<ResourceReferenceDt>();
            }
            return this.myReceiver;
        }

        public List<ResourceReferenceDt> getReceiverElement() {
            if (this.myReceiver == null) {
                this.myReceiver = new ArrayList<ResourceReferenceDt>();
            }
            return this.myReceiver;
        }

        public Dispense setReceiver(List<ResourceReferenceDt> theValue) {
            this.myReceiver = theValue;
            return this;
        }

        public ResourceReferenceDt addReceiver() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getReceiver().add(newType);
            return newType;
        }

        public List<DispenseDosage> getDosage() {
            if (this.myDosage == null) {
                this.myDosage = new ArrayList<DispenseDosage>();
            }
            return this.myDosage;
        }

        public List<DispenseDosage> getDosageElement() {
            if (this.myDosage == null) {
                this.myDosage = new ArrayList<DispenseDosage>();
            }
            return this.myDosage;
        }

        public Dispense setDosage(List<DispenseDosage> theValue) {
            this.myDosage = theValue;
            return this;
        }

        public DispenseDosage addDosage() {
            DispenseDosage newType = new DispenseDosage();
            this.getDosage().add(newType);
            return newType;
        }

        public DispenseDosage getDosageFirstRep() {
            if (this.getDosage().isEmpty()) {
                return this.addDosage();
            }
            return this.getDosage().get(0);
        }
    }
}

